/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.decode.DecodeHandlerFactory;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.designer.property.clientrules.RuleTriggerContainer;
import kd.bos.designer.property.formruleactiontypes.FieldTreeSearchUtil;
import kd.bos.designer.tree.BillListRuleTreeProcessor;
import kd.bos.designer.tree.DefaultRuleTreeProcessor;
import kd.bos.designer.tree.IRuleTreeProcessor;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextAreaEdit;
import kd.bos.form.func.FuncSettingHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.metadata.exception.CheckResultInfo;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.servicehelper.DBServiceHelper;

public class PreConditionEdit
extends AbstractFormPlugin
implements TreeNodeClickListener,
IBizRuleEditor,
SearchEnterListener {
    static final Map<String, String> operationCharacter = new HashMap<String, String>(){
        private static final long serialVersionUID = -6264470238648123248L;
        {
            this.put("plus", "+");
            this.put("subtract", "-");
            this.put("multiple", "*");
            this.put("divide", "/");
            this.put("equal", "=");
            this.put("less", "<");
            this.put("lessequal", "<=");
            this.put("leftparentheses", "(");
            this.put("greater", ">");
            this.put("greaterequal", ">=");
            this.put("squarebrackets", "<>");
            this.put("rightparentheses", ")");
            this.put("and", "and");
            this.put("in", "IN");
            this.put("notin", "NOT IN");
            this.put("not", "NOT");
            this.put("like", "LIKE");
            this.put("notlike", "NOT LIKE");
            this.put("or", "or");
            this.put("clr", "CLR");
            this.put("backspace", "Backspace");
        }
    };
    static final String Key_ExpressionText = "textareafield";
    static final String Key_btnFunction = "btnfunction";
    public static final String Key_FTranExpr = "ftranexpr";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String IN_CONTAINER = "InContainer";
    private static final String TEXT_AREA_FIELD = "TextAreaField";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String EXPRESSION = "Expression";
    private static final String CONDITION_DESCRIPT = "ConditionDescript";
    private static final String FIELD_TREE = "fieldTree";
    private static final String TYPE = "_Type_";
    private static final String CONTEXT = "context";
    private static final String FORM_META = "formmeta";
    private static final String SEARCH_AP = "searchap";

    public void initialize() {
        Button btn = null;
        for (Map.Entry<String, String> entry : operationCharacter.entrySet()) {
            String key = entry.getKey().toLowerCase();
            btn = (Button)this.getControl(key);
            btn.addClickListener((ClickListener)this);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && (RuleTriggerContainer.List.toString().equals(customParams.get("triggerContainer")) || RuleTriggerContainer.Card.toString().equals(customParams.get("triggerContainer")))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{Key_btnFunction});
        }
        this.addClickListeners(new String[]{Key_btnFunction, BTN_OK, BTN_CANCEL});
        TreeView tree = (TreeView)this.getView().getControl("TreeViewAp");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search searchEdit = (Search)this.getControl(SEARCH_AP);
        searchEdit.addEnterListener((SearchEnterListener)this);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if (BTN_OK.equalsIgnoreCase(key)) {
            this.closeAndReturn();
        } else if (BTN_CANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        } else if (Key_btnFunction.equalsIgnoreCase(key)) {
            this.showFuncSetting();
        } else if (key != null) {
            this.operation(key);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        DecodeHandlerFactory.sendRuleEncodingElements((String)"conditiondescript", (IClientViewProxy)clientViewProxy);
        DecodeHandlerFactory.sendRuleEncodingElements((String)Key_ExpressionText, (IClientViewProxy)clientViewProxy);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)Key_btnFunction)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            this.receiveFuncSetting((String)closedCallBackEvent.getReturnData());
        }
    }

    public void operation(String xx) {
        String character = operationCharacter.get(xx);
        if (character.equalsIgnoreCase("clr")) {
            this.getModel().setValue(Key_ExpressionText, (Object)"");
            FormulaEditHelper.setCursorIndex(this.getView(), Key_ExpressionText, 0);
        } else if ("backspace".equalsIgnoreCase(character)) {
            FormulaEditHelper.backSpaceExpression(this.getView(), xx, Key_ExpressionText);
        } else {
            FormulaEditHelper.insertExpression(this.getView(), xx, Key_ExpressionText, character);
        }
    }

    public void beforeClosed(BeforeClosedEvent close) {
        String inContainer = (String)this.getView().getFormShowParameter().getCustomParams().get(IN_CONTAINER);
        if (inContainer != null) {
            HashMap<String, String> expField = new HashMap<String, String>();
            String expression = this.getModel().getValue(TEXT_AREA_FIELD).toString();
            try {
                FormulaEngine.parseFormula((String)expression);
            }
            catch (Exception e) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bef\uff1a%s\u3002", (String)"PreConditionEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage()));
                return;
            }
            expField.put(EXPRESSION, expression);
            this.getView().returnDataToParent(expField);
        }
    }

    private void closeAndReturn() {
        HashMap<String, Object> textMap = new HashMap<String, Object>();
        String textAreaField = null;
        String conditionDescript = null;
        if (this.getView().getFormShowParameter().getCustomParams().get(IN_CONTAINER) != null) {
            return;
        }
        if (this.getModel().getValue(CONDITION_DESCRIPT) != null) {
            if (this.getModel().getValue(TEXT_AREA_FIELD) != null) {
                Object propName;
                textAreaField = this.getModel().getValue(TEXT_AREA_FIELD).toString().replaceAll(" +", " ").replaceAll("\n", "");
                if (StringUtils.isBlank((CharSequence)textAreaField)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PreConditionEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                String fieldTree = this.getPageCache().get(FIELD_TREE);
                if (fieldTree == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u5b57\u6bb5\u3002", (String)"PreConditionEdit_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)fieldTree, TreeNode.class);
                String formId = root.getId();
                conditionDescript = this.getModel().getValue(CONDITION_DESCRIPT).toString();
                textMap.put("Id", DBServiceHelper.genStringId());
                textMap.put(TYPE, "PreCondition");
                if (StringUtils.isBlank((CharSequence)conditionDescript)) {
                    conditionDescript = textAreaField;
                }
                textMap.put("RuleDescription", conditionDescript);
                textMap.put("RuleCondition", textAreaField);
                Object transExpr = this.getModel().getValue(Key_FTranExpr);
                if (transExpr != null) {
                    String result = this.checkTransExpr((String)transExpr);
                    if (StringUtils.isNotBlank((CharSequence)result)) {
                        this.getView().showTipNotification(result);
                        return;
                    }
                    textMap.put("RuleTransExpr", transExpr);
                }
                if ("MustInputCondition".equals(propName = this.getView().getFormShowParameter().getCustomParam("propertyName"))) {
                    Set dependencyFields = new BOSExpression(textAreaField).getVars();
                    List<Map<String, Object>> designerItems = this.getDesignItems();
                    ArrayList returnList = new ArrayList();
                    for (Map<String, Object> item : designerItems) {
                        for (String dependencyfield : dependencyFields) {
                            if (!dependencyfield.equals(item.get("Key"))) continue;
                            HashMap<String, Object> itemMap = new HashMap<String, Object>();
                            itemMap.put("itemId", item.get("Id"));
                            itemMap.put("metaType", FORM_META);
                            itemMap.put("propertyName", "FireUpdEvt");
                            itemMap.put("value", true);
                            returnList.add(itemMap);
                        }
                    }
                    HashMap data = new HashMap(9);
                    data.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
                    data.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
                    data.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
                    data.put("value", textMap);
                    if (returnList.size() != 0) {
                        returnList.add(data);
                        this.getView().returnDataToParent(returnList);
                    } else {
                        this.getView().returnDataToParent(data);
                    }
                } else {
                    this.getView().returnDataToParent(textMap);
                }
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PreConditionEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        } else if (this.getModel().getValue(TEXT_AREA_FIELD) == null) {
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PreConditionEdit_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        String ruleFormId;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String isLock = (String)params.get("isLock");
        if ("true".equals(isLock)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_OK});
        }
        Object triggerContainer = params.get("triggerContainer");
        String metaType = params.get("metaType") == null ? null : params.get("metaType").toString();
        String string = ruleFormId = params.get("ruleFormId") == null ? null : params.get("ruleFormId").toString();
        if (params.get(CONTEXT) == null || params.get("metaType") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PreConditionEdit_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object prop = params.get("propertyName");
        boolean isFromMustInputCondition = false;
        if (prop instanceof String && "MustInputCondition".equals((String)prop)) {
            isFromMustInputCondition = true;
        }
        IRuleTreeProcessor processor = RuleTriggerContainer.BillList.toString().equals(triggerContainer) && FORM_META.equalsIgnoreCase(metaType) && "ide_billlistclientrules".equals(ruleFormId) ? new BillListRuleTreeProcessor() : new DefaultRuleTreeProcessor();
        TreeNode root = processor.initTree(this.getView());
        TreeView tree = (TreeView)this.getView().getControl("TreeViewAp");
        root.setIsOpened(true);
        tree.addNode(root);
        this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
        Object valueOb = params.get("value");
        if (isFromMustInputCondition && valueOb instanceof String && StringUtils.isNotBlank(valueOb)) {
            valueOb = SerializationUtils.fromJsonString((String)((String)valueOb), Map.class);
        }
        if (StringUtils.isNotBlank(valueOb)) {
            boolean flag;
            Map value;
            String expre = "";
            String transExpr = "";
            if (params.get(IN_CONTAINER) != null) {
                value = (Map)SerializationUtils.fromJsonString((String)((String)valueOb), Map.class);
                if (value.containsKey(EXPRESSION)) {
                    String aString;
                    expre = aString = (String)value.get(EXPRESSION);
                }
            } else {
                value = (Map)valueOb;
                this.getModel().setValue(CONDITION_DESCRIPT, value.get("RuleDescription"));
                expre = (String)value.get("RuleCondition");
            }
            try {
                transExpr = this.tranExpression(expre);
            }
            catch (FormulaException exp) {
                transExpr = exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage();
            }
            this.getModel().setValue(TEXT_AREA_FIELD, (Object)expre);
            this.getModel().setValue(Key_FTranExpr, (Object)transExpr);
            Object clickAble = params.get("bdFieldClickAble");
            boolean bl = flag = clickAble instanceof Boolean && (Boolean)clickAble != false;
            if (flag) {
                TextAreaEdit expression = (TextAreaEdit)this.getControl(Key_ExpressionText);
                String content = String.format(ResManager.loadKDString((String)"1. \u5fc5\u5f55\u6761\u4ef6\u8bbe\u7f6e\u65f6\uff0c\u4f1a\u5c06\u8868\u8fbe\u5f0f\u4e2d\u5b57\u6bb5\u7684\u5373\u65f6\u66f4\u65b0\u81ea\u52a8\u5f00\u542f\uff0c\u8bf7\u52ff\u518d\u624b\u52a8\u5173\u95ed\u3002%s2. \u8d4b\u503c\u5bf9\u8c61\u4e0d\u5141\u8bb8\u643a\u5e26\u540e\u7f00\uff0c\u5982user.id = \u5f20\u4e09\uff0c\u6b63\u786e\u5199\u6cd5\u4e3auser = \u5f20\u4e09\u3002", (String)"PreConditionEdit_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "\r\n");
                Tips tips = new Tips("text", new LocaleString(""), new LocaleString(content), false, null);
                tips.setTriggerType("hover");
                expression.addTips(tips);
            }
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void treeNodeClick(TreeNodeEvent e) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        String ruleFormId = (String)this.getView().getFormShowParameter().getCustomParam("ruleFormId");
        if (e.getNodeId() != null && !"".equals(e.getNodeId().toString().trim())) {
            boolean clickAble;
            TreeNode node = root.getTreeNode((String)e.getNodeId(), 16);
            Object param = this.getView().getFormShowParameter().getCustomParam("bdFieldClickAble");
            boolean bl = clickAble = param instanceof Boolean && (Boolean)param != false;
            if (StringUtils.isBlank((Object)node.getChildren()) || clickAble && !node.getParentid().equalsIgnoreCase(root.getId())) {
                String character = e.getNodeId().toString();
                if ("ide_listclientrules".equals(ruleFormId) || "ide_clientrules".equals(ruleFormId)) {
                    character = character.replaceAll("\\.", "_");
                }
                FormulaEditHelper.insertExpression(this.getView(), "treeviewap", Key_ExpressionText, character);
            }
        }
    }

    public boolean checkConfig() {
        String expression = this.getModel().getValue(TEXT_AREA_FIELD).toString();
        try {
            FormulaEngine.parseFormula((String)expression);
        }
        catch (Exception e) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bef\uff1a%s\u3002", (String)"PreConditionEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage()));
            return false;
        }
        return true;
    }

    public String getOutConfig() {
        HashMap<String, String> expField = new HashMap<String, String>();
        String expression = this.getModel().getValue(TEXT_AREA_FIELD).toString();
        expField.put(EXPRESSION, expression);
        return SerializationUtils.toJsonString(expField);
    }

    private void showFuncSetting() {
        FunctionTypes functionTypes = FunctionTypes.get();
        String jsonNode = this.getPageCache().get(FIELD_TREE);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)jsonNode, TreeNode.class);
        List<Map<String, Object>> entityItems = this.getDesignItems();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, Key_btnFunction);
        FuncSettingHelper.show((FunctionTypes)functionTypes, entityItems, (TreeNode)root, null, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void receiveFuncSetting(String funcSetting) {
        FormulaEditHelper.insertExpression(this.getView(), Key_btnFunction, Key_ExpressionText, funcSetting);
    }

    private List<Map<String, Object>> getDesignItems() {
        PropertyEditHelper helper = new PropertyEditHelper();
        List items = helper.getEntityMeta(this.getView());
        boolean isProFormDesign = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("isproformdesign"));
        boolean isEntityDesign = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("isEntityDesign"));
        if (items == null) {
            items = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
            if (isProFormDesign) {
                String entityStr = (String)this.getView().getFormShowParameter().getCustomParam("proEntityStr");
                items = SerializationUtils.fromJsonStringToList((String)entityStr, Map.class);
            }
            if (isEntityDesign) {
                List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
                items = (List)context.get(0);
            }
        }
        return items;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equalsIgnoreCase(Key_ExpressionText)) {
            String expression = (String)this.getModel().getValue(Key_ExpressionText);
            String tranExpr = "";
            try {
                tranExpr = this.tranExpression(expression);
            }
            catch (FormulaException exp) {
                tranExpr = exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage();
            }
            catch (Exception exp) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"FormulaEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
        }
    }

    protected String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        String json = this.getPageCache().get(FIELD_TREE);
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        ArrayList<String> orderVars = new ArrayList<String>(10);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return o2.compareTo(o1);
            }
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null && (varCaption = node.getText()).lastIndexOf("(") != -1) {
                varCaption = varCaption.substring(0, varCaption.lastIndexOf("("));
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        FieldTreeSearchUtil.doSearch(searchText, rootNode, this.getView());
    }

    public CheckResultInfo checkConfigAndReturn() {
        String checkResult;
        Object transExpr = this.getModel().getValue(Key_FTranExpr);
        if (transExpr instanceof String && StringUtils.isNotBlank((CharSequence)(checkResult = this.checkTransExpr((String)transExpr)))) {
            ErrorInfo info = new ErrorInfo();
            info.setError(checkResult);
            return new CheckResultInfo(false, info);
        }
        return null;
    }

    private String checkTransExpr(String expr) {
        if (StringUtils.isNotBlank((CharSequence)expr) && (expr.contains("Error: could not match input") || expr.startsWith(ResManager.loadKDString((String)"\u8bed\u6cd5\u9519\u8bef:", (String)"PreConditionEdit_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])))) {
            return ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u8c03\u6574\u3002", (String)"PreConditionEdit_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        }
        return null;
    }
}

