/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.decode.DecodeHandlerFactory;
import kd.bos.designer.property.formruleactiontypes.KFlowSelectUtils;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.kflow.api.enums.TriggerTime;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.rule.BizRule;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryAp;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.rule.FormRuleActionType;
import kd.bos.metadata.form.rule.FormRuleActionTypeCache;
import kd.bos.metadata.kflow.enums.RuleType;
import kd.bos.metadata.list.CardRowPanelAp;
import kd.bos.metadata.list.ListCardViewAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.session.SystemPropertyUtils;

public class RulesPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(RulesPlugin.class);
    protected static final String entryKey = "entryentity";
    protected static final String trueEntryKey = "trueentryentity";
    static final String falseEntryKey = "falseentryentity";
    private static final String TRUE_ADD = "trueadd";
    private static final String TRUE_UPDATE = "trueupdate";
    private static final String FALSE_ADD = "falseadd";
    private static final String FALSE_UPDATE = "falseupdate";
    private static final String PRE_DESCRIPTION = "predescription";
    private static final String VALUE = "value";
    private static final String DESCRIPTION = "description";
    private static final String DESCRIPTION1 = "Description";
    private static final String PRECONDITION = "precondition";
    private static final String PRECONDITION1 = "PreCondition";
    private static final String PRE_DESCRIPTION1 = "PreDescription";
    private static final String ENABLED = "enabled";
    private static final String ENABLED1 = "Enabled";
    private static final String TRUE_ACTIONS = "trueactions";
    private static final String TRUE_ACTIONS1 = "TrueActions";
    private static final String FALSE_ACTIONS = "falseactions";
    private static final String FALSE_ACTIONS1 = "FalseActions";
    private static final String CONTEXT = "context";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String META_TYPE = "metaType";
    private static final String EXPRESSION = "Expression";
    private static final String TRUE_RULE_ID = "trueruleid";
    private static final String TRUE_RULE_NAME = "truerulename";
    private static final String TRUE_EXPRESSION = "trueexpression";
    private static final String TRUE_RAISE_EVENT_TYPE = "trueraiseeventtype";
    private static final String RAISE_EVENT_TYPE = "RaiseEventType";
    private static final String FALSE_RULE_NAME = "falserulename";
    private static final String FALSE_RULE_ID = "falseruleid";
    private static final String FALSE_RAISE_EVENT_TYPE = "falseraiseeventtype";
    private static final String FALSE_EXPRESSION = "falseexpression";
    private static final String IS_EXT = "2";
    private static final String LOCK_RULES_CACHE = "lockRules_cache";
    private static final String REF_KFLOW = "ref_kflow";
    private static final String KEY_RULE_TYPE = "rule_type";
    private static final String TIME_CREATE = "time_create";
    private static final String TIME_LOAD = "time_load";
    private static final String TIME_FIELD_CHANGED = "time_fieldchanged";
    private static final String KFLOW_ID = "kflow_iden";
    private static final String REFERENCE_SETTINGS = "referencesettings";
    private static final String FLOW_TRIGGER_TIME = "flowtriggertime";
    private static final String REFSETTING_AP = "refsettingap";
    private static final String TRUEORFALSE_FLEXAP = "flexpanelap1";
    private static final String KEY_EXT_PROPS = "ExtProps";
    private static final String META_TYPE_FORM = "formmeta";
    private static final String SEQ = "seq";
    private static final String SEQ1 = "Seq";
    private static final String ID = "id";
    private static final String ID1 = "Id";
    private static final String LOCK = "lock";
    private static final String HYPHEN = "-";
    private static final String TRACE_TYPE_RULES = "rules";
    private static final String TENANT_PARAM_KEY = "kflow.ref.entrance";
    private static final String[] FIELDS = new String[]{"kflow_iden", "time_create", "time_load", "time_fieldchanged"};
    private static final String[] ITEM_BUTTON = new String[]{"up", "down", "delete", "trueadd", "trueup", "truedown", "trueupdate", "truedelete", "falseadd", "falseupdate", "falseup", "falsedown", "falsedelete"};
    private int serviceType = 1;

    public int getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(int serviceType) {
        this.serviceType = serviceType;
    }

    private void addEntryGridRowClickListener(String entryKey) {
        EntryGrid falseEntryGrid = (EntryGrid)this.getControl(entryKey);
        falseEntryGrid.addRowClickListener((RowClickEventListener)this);
        if (entryKey.equals(entryKey)) {
            falseEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    private boolean isEntryGridExist(String entryKey) {
        EntryGrid falseEntryGrid = (EntryGrid)this.getControl(entryKey);
        return falseEntryGrid != null;
    }

    public void initialize() {
        this.addClickListeners(new String[]{"add", "update", "delete", "up", "down", "btnok", "detail", TRUE_ADD, "truedelete", TRUE_UPDATE, FALSE_ADD, "falsedelete", FALSE_UPDATE, PRE_DESCRIPTION});
        this.addEntryGridRowClickListener(entryKey);
        this.addEntryGridRowClickListener(trueEntryKey);
        if (this.isEntryGridExist(falseEntryKey)) {
            this.addEntryGridRowClickListener(falseEntryKey);
        }
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1", "advcontoolbarap2"});
        BasedataEdit kFlowId = (BasedataEdit)this.getControl(KFLOW_ID);
        if (kFlowId != null) {
            kFlowId.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.showKREntrance();
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (StringUtils.isBlank(value) || ((List)value).size() < 1) {
            return;
        }
        this.initExtensible();
        List allRules = (List)value;
        this.orderRules(allRules);
        this.renderRuleEntry(allRules);
        this.loadFirstRowData();
    }

    private void showKREntrance() {
        boolean showEntrance;
        Map ruleParams = this.getView().getFormShowParameter().getCustomParams();
        String itemId = (String)ruleParams.get("itemId");
        String metaType = (String)ruleParams.get(META_TYPE);
        String formId = this.getRootEntityId();
        String tenantParam = SystemPropertyUtils.getProptyByTenant((String)TENANT_PARAM_KEY, (String)RequestContext.get().getTenantId());
        boolean bl = showEntrance = StringUtils.isNotBlank((CharSequence)tenantParam) && Boolean.parseBoolean(tenantParam);
        if (showEntrance && this.getServiceType() == 1 && META_TYPE_FORM.equals(metaType) && StringUtils.isNotBlank((CharSequence)itemId) && itemId.equals(formId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{REF_KFLOW});
        }
    }

    private Map<String, Object> getLockRuleIds() {
        String lockRules = this.getPageCache().get(LOCK_RULES_CACHE);
        Map<String, Object> lockRuleIds = new HashMap<String, Object>(16);
        if (StringUtils.isNotBlank((CharSequence)lockRules)) {
            lockRuleIds = (Map)SerializationUtils.fromJsonString((String)lockRules, Map.class);
        }
        return lockRuleIds;
    }

    private void orderRules(List<Map<String, Object>> allRules) {
        Collections.sort(allRules, (o1, o2) -> {
            if (o1.containsKey(SEQ1) && o2.containsKey(SEQ1)) {
                Integer s1 = (Integer)o1.get(SEQ1);
                Integer s2 = (Integer)o2.get(SEQ1);
                return Integer.compare(s1, s2);
            }
            return 0;
        });
    }

    private void renderRuleEntry(List<Map<String, Object>> allRules) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACE_TYPE_RULES, (String)"RulesPlugin.renderRuleEntry");){
            DataEntityPropertyCollection props = this.getModel().getEntryEntity(entryKey).getDynamicObjectType().getProperties();
            Map<String, Object> lockRuleIds = this.getLockRuleIds();
            for (Map<String, Object> rule : allRules) {
                int serviceType;
                int rowKey = this.getModel().createNewEntryRow(entryKey);
                if (this.getModel().getProperty(ID) != null) {
                    this.renderId(rule, rowKey, lockRuleIds);
                }
                if (props.get((Object)DESCRIPTION) != null) {
                    this.getModel().setValue(DESCRIPTION, rule.get(DESCRIPTION1), rowKey);
                }
                this.getModel().setValue(PRE_DESCRIPTION, rule.get(PRE_DESCRIPTION1), rowKey);
                if (props.get((Object)ENABLED) != null) {
                    this.getModel().setValue(ENABLED, rule.get(ENABLED1) == null ? Boolean.valueOf(true) : rule.get(ENABLED1), rowKey);
                }
                if ((serviceType = this.getServiceType()) == 1) {
                    if (span.isRealtime()) {
                        span.addLocaleTag("serviceType", (Object)1);
                        span.addLocaleTag("plugin", (Object)((Object)((Object)this)).getClass().getName());
                    }
                    String ruleType = (String)rule.get("RuleType");
                    if (RuleType.KFlowRule.name().equals(ruleType)) {
                        this.renderKFlowRule(rule, rowKey);
                    } else {
                        ruleType = RuleType.FormRule.name();
                        this.renderFormRule(rule, rowKey);
                    }
                    this.getModel().setValue(KEY_RULE_TYPE, (Object)ruleType, rowKey);
                    continue;
                }
                if (span.isRealtime()) {
                    span.addLocaleTag("serviceType", (Object)serviceType);
                    span.addLocaleTag("plugin", (Object)((Object)((Object)this)).getClass().getName());
                }
                this.renderFormRule(rule, rowKey);
            }
        }
    }

    private void renderId(Map<String, Object> rule, int rowKey, Map<String, Object> lockRuleIds) {
        DynamicObjectCollection doc;
        boolean hasIsLockProp;
        String ruleId = (String)rule.get(ID1);
        this.getModel().setValue(ID, (Object)ruleId, rowKey);
        if (lockRuleIds.containsKey(ruleId) && (hasIsLockProp = (doc = this.getModel().getEntryEntity(entryKey)).getDynamicObjectType().getProperties().containsKey((Object)LOCK))) {
            if (LOCK.equals(lockRuleIds.get(ruleId))) {
                this.getModel().setValue(LOCK, (Object)true, rowKey);
            } else {
                this.getModel().setValue(LOCK, (Object)false, rowKey);
            }
        }
    }

    private void renderFormRule(Map<String, Object> rule, int rowKey) {
        this.getModel().setValue(PRECONDITION, rule.get(PRECONDITION1), rowKey);
        this.getModel().setValue(TRUE_ACTIONS, (Object)(rule.get(TRUE_ACTIONS1) == null ? "[]" : SerializationUtils.toJsonString((Object)rule.get(TRUE_ACTIONS1))), rowKey);
        if (this.getModel().getDataEntityType().getProperties().get((Object)falseEntryKey) != null) {
            this.getModel().setValue(FALSE_ACTIONS, (Object)(rule.get(FALSE_ACTIONS1) == null ? "[]" : SerializationUtils.toJsonString((Object)rule.get(FALSE_ACTIONS1))), rowKey);
        }
    }

    private void renderKFlowRule(Map<String, Object> rule, int rowKey) {
        Map extProps = (Map)rule.get(KEY_EXT_PROPS);
        if (!CollectionUtils.isEmpty((Map)extProps)) {
            HashMap<String, String> refSetting = new HashMap<String, String>(5);
            refSetting.put("KFId", extProps.get("KFId") == null ? "" : extProps.get("KFId"));
            refSetting.put("RefId", extProps.get("RefId") == null ? "" : extProps.get("RefId"));
            refSetting.put("TriggerTime", extProps.get("TriggerTime") == null ? "" : extProps.get("TriggerTime"));
            this.getModel().setValue(REFERENCE_SETTINGS, (Object)SerializationUtils.toJsonString(refSetting), rowKey);
            this.getModel().setValue(FLOW_TRIGGER_TIME, extProps.get("TriggerTime"), rowKey);
        }
        this.getView().setEnable(Boolean.FALSE, rowKey, new String[]{PRE_DESCRIPTION});
    }

    private void loadFirstRowData() {
        EntryGrid grid = (EntryGrid)this.getControl(entryKey);
        int currentRow = grid.getEntryState().getFocusRow();
        if (currentRow <= 0) {
            currentRow = 0;
        }
        IDataModel model = this.getModel();
        if (this.getServiceType() != 1) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(TRUE_ACTIONS1, model.getValue(TRUE_ACTIONS, currentRow));
            if (this.getModel().getDataEntityType().getProperties().get((Object)falseEntryKey) != null) {
                map.put(FALSE_ACTIONS1, model.getValue(FALSE_ACTIONS, currentRow));
            }
            this.createConditionData(map);
        } else {
            String ruleType = (String)model.getValue(KEY_RULE_TYPE, currentRow);
            if (StringUtils.isBlank((CharSequence)ruleType) || RuleType.FormRule.name().equals(ruleType)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(TRUE_ACTIONS1, model.getValue(TRUE_ACTIONS, currentRow));
                if (this.getModel().getDataEntityType().getProperties().get((Object)falseEntryKey) != null) {
                    map.put(FALSE_ACTIONS1, model.getValue(FALSE_ACTIONS, currentRow));
                }
                this.createConditionData(map);
            } else if (RuleType.KFlowRule.name().equals(ruleType)) {
                this.selectKFlow(currentRow);
            }
        }
    }

    public void afterBindData(EventObject e) {
        int[] selectRow;
        EntryGrid grid = (EntryGrid)this.getControl(entryKey);
        int currentRow = grid.getEntryState().getFocusRow();
        if (currentRow <= 0) {
            currentRow = 0;
            selectRow = new int[]{currentRow};
            grid.selectRows(selectRow, currentRow);
        } else {
            selectRow = new int[]{currentRow};
            grid.selectRows(selectRow, currentRow);
        }
        this.entryRowClick(new RowClickEvent((Object)grid, currentRow));
        this.initEntry();
        this.lockAddButton();
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        DecodeHandlerFactory.sendRuleEncodingElements((String)entryKey, (IClientViewProxy)clientViewProxy);
    }

    private void lockAddButton() {
        String metaType = (String)this.getView().getFormShowParameter().getCustomParam(META_TYPE);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null && (entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)(entityId = this.getRootEntityId()), (MetaCategory)MetaCategory.Entity)) == null) {
            return;
        }
        String addLockType = "";
        if ("entitymeta".equals(metaType)) {
            addLockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"BizRule", (String)entityMetadata.getModelType(), (String)entityMetadata.getMasterId(), (String)"").toString();
        } else if (META_TYPE_FORM.equals(metaType)) {
            String pkId = entityMetadata.getRootEntity().getPkId();
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
            addLockType = ExtensibleDao.getExtLockType((AbstractMetadata)formMetadata, (String)"FormRule", (String)formMetadata.getModelType(), (String)pkId, (String)"").toString();
        }
        if (LOCK.equals(addLockType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"add"});
        }
    }

    private void initExtensible() {
        AbstractMetadata metadata;
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (StringUtils.isBlank(value)) {
            return;
        }
        List ruleValues = (List)value;
        String metaType = (String)this.getView().getFormShowParameter().getCustomParam(META_TYPE);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        MetaCategory metaCategory = MetaCategory.Entity;
        if (META_TYPE_FORM.equals(metaType)) {
            metaCategory = MetaCategory.Form;
        }
        if ((metadata = MetadataDao.readMeta((String)entityId, (MetaCategory)metaCategory)) == null && (metadata = MetadataDao.readMeta((String)(entityId = this.getRootEntityId()), (MetaCategory)metaCategory)) == null) {
            return;
        }
        if (!IS_EXT.equals(metadata.getDevType())) {
            return;
        }
        List isvList = DesignerUtils.ISV_LIST;
        if ("entitymeta".equals(metaType)) {
            EntityMetadata oriEntityMetadata = (EntityMetadata)ExtensibleDao.getBaseMetadata((String)metadata.getParentId(), (MetaCategory)MetaCategory.Entity);
            List entityItems = oriEntityMetadata.getItems();
            ArrayList rules = new ArrayList(10);
            for (EntityItem entityItem : entityItems) {
                if (!(entityItem instanceof EntryEntity)) continue;
                rules.addAll(((EntryEntity)entityItem).getRules());
            }
            List rootEntityRules = oriEntityMetadata.getRootEntity().getRules();
            rules.addAll(rootEntityRules);
            HashMap<String, String> rulesLockType = new HashMap<String, String>(rules.size());
            for (BizRule rule : rules) {
                String ruleId = rule.getId();
                ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)metadata, (String)"BizRule", (String)metadata.getModelType(), (String)metadata.getParentId(), (String)ruleId);
                if (!isvList.contains(rule.getIsv()) || StringUtils.equals((CharSequence)metadata.getIsv(), (CharSequence)rule.getIsv())) continue;
                rulesLockType.put(ruleId, lockType.toString());
            }
            if (!rulesLockType.isEmpty()) {
                this.getPageCache().put(LOCK_RULES_CACHE, SerializationUtils.toJsonString(rulesLockType));
            }
        } else if (META_TYPE_FORM.equals(metaType)) {
            FormMetadata oriFormMetadata = (FormMetadata)ExtensibleDao.getBaseMetadata((String)metadata.getParentId(), (MetaCategory)MetaCategory.Form);
            ArrayList rules = new ArrayList(10);
            List formItems = oriFormMetadata.getItems();
            for (ControlAp formItem : formItems) {
                if (formItem instanceof EntryAp) {
                    rules.addAll(((EntryAp)formItem).getRules());
                    continue;
                }
                if (formItem instanceof ListGridViewAp) {
                    rules.addAll(((ListGridViewAp)formItem).getClientRules());
                    continue;
                }
                if (formItem instanceof CardEntryRowAp) {
                    rules.addAll(((CardEntryRowAp)formItem).getClientRules());
                    continue;
                }
                if (!(formItem instanceof CardRowPanelAp)) continue;
                rules.addAll(((CardRowPanelAp)formItem).getClientRules());
            }
            List rootFormRules = oriFormMetadata.getRootAp().getRules();
            rules.addAll(rootFormRules);
            FormMetadata extFormMetadata = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
            String elementId = "";
            elementId = StringUtils.isNotBlank((CharSequence)entityId) && entityId.equals(extFormMetadata.getEntityId()) ? ((FormMetadata)metadata).getRootAp().getPkId() : extFormMetadata.getParentId();
            HashMap<String, String> rulesLockType = new HashMap<String, String>(rules.size());
            for (BizRule ruleValue : rules) {
                String ruleId = ruleValue.getId();
                ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)extFormMetadata, (String)"FormRule", (String)extFormMetadata.getModelType(), (String)elementId, (String)ruleId);
                if (!isvList.contains(ruleValue.getIsv()) || StringUtils.equals((CharSequence)metadata.getIsv(), (CharSequence)ruleValue.getIsv())) continue;
                rulesLockType.put(ruleId, lockType.toString());
            }
            if (!rulesLockType.isEmpty()) {
                this.getPageCache().put(LOCK_RULES_CACHE, SerializationUtils.toJsonString(rulesLockType));
            }
        }
    }

    private void initEntry() {
        String lockRules = this.getPageCache().get(LOCK_RULES_CACHE);
        if (StringUtils.isNotBlank((CharSequence)lockRules)) {
            ArrayList<Integer> lockRows = new ArrayList<Integer>(10);
            Map lockRuleIds = (Map)SerializationUtils.fromJsonString((String)lockRules, Map.class);
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(entryKey);
            for (DynamicObject dynamicObject : dynamicObjects) {
                String ruleId = dynamicObject.getString(ID);
                Integer row = (Integer)dynamicObject.get(SEQ);
                for (String lockRuleId : lockRuleIds.keySet()) {
                    if (!lockRuleId.equals(ruleId) || !LOCK.equals(lockRuleIds.get(ruleId))) continue;
                    lockRows.add(row - 1);
                }
            }
            if (!lockRows.isEmpty()) {
                int[] rows;
                Integer[] integers = lockRows.toArray(new Integer[lockRows.size()]);
                for (int row : rows = Arrays.stream(integers).mapToInt(Integer::valueOf).toArray()) {
                    this.getView().setEnable(Boolean.FALSE, row, new String[]{DESCRIPTION, KEY_RULE_TYPE, ENABLED});
                }
                this.setEntryFieldSX(entryKey, PRE_DESCRIPTION);
            }
        }
    }

    private void setEntryFieldSX(String entryKey, String fldKey) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(entryKey, "setColEditorProp", new Object[]{fldKey, "sx", false});
    }

    protected void attachParameter(FormShowParameter parameter) {
        Object context = this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        List contextList = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        context = contextList.get(0);
        String controlId = ((Map)((List)contextList.get(contextList.size() - 1)).get(0)).get(ID1).toString();
        String clzName = ((Map)((List)contextList.get(contextList.size() - 1)).get(0)).get("_Type_").toString();
        parameter.setCustomParam("controlAp", (Object)clzName);
        parameter.setCustomParam(CONTEXT, context);
        String prefix = null;
        switch (clzName) {
            case "EntryAp": {
                prefix = "kd.bos.metadata.form.control.";
                break;
            }
            case "ListGridViewAp": 
            case "CardRowPanelAp": 
            case "ListCardViewAp": {
                prefix = "kd.bos.metadata.list.";
                break;
            }
            case "CardEntryRowAp": 
            case "CardEntryAp": 
            case "SubCardEntryAp": {
                prefix = "kd.bos.metadata.form.cardentry.";
                break;
            }
            default: {
                return;
            }
        }
        try {
            Class<?> clz = Class.forName(prefix + clzName);
            Object newInst = clz.newInstance();
            if (newInst instanceof EntryAp || newInst instanceof ListCardViewAp || newInst instanceof ListGridViewAp || newInst instanceof CardRowPanelAp || newInst instanceof CardEntryAp || newInst instanceof CardEntryRowAp) {
                parameter.setCustomParam("controlId", (Object)controlId);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89c4\u5219\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RulesPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void add() {
        int rowKey = this.addRule();
        if (this.getServiceType() == 1) {
            this.hideFlexAp(REFSETTING_AP);
            this.clearKFSetting();
            this.getModel().setValue(KEY_RULE_TYPE, (Object)RuleType.FormRule.name(), rowKey);
        }
    }

    private int addRule() {
        int rowKey = this.getModel().createNewEntryRow(entryKey);
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryKey);
        grid.getEntryState().selectRow(rowKey);
        grid.selectRows(rowKey);
        this.getModel().deleteEntryData(trueEntryKey);
        if (this.isEntryGridExist(falseEntryKey)) {
            this.getModel().deleteEntryData(falseEntryKey);
        }
        this.lockEntryRowAndDeleteBtn("", grid, rowKey);
        return rowKey;
    }

    private void clearKFSetting() {
        IDataModel model = this.getModel();
        model.beginInit();
        for (String field : FIELDS) {
            model.setValue(field, null);
            this.getView().setEnable(Boolean.TRUE, new String[]{field});
        }
        model.endInit();
        this.getView().updateView(REFSETTING_AP);
    }

    private void hideFlexAp(String hideApKey) {
        String hideAp = TRUEORFALSE_FLEXAP;
        String showAp = REFSETTING_AP;
        if (REFSETTING_AP.equals(hideApKey)) {
            hideAp = REFSETTING_AP;
            showAp = TRUEORFALSE_FLEXAP;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{hideAp});
        this.getView().setVisible(Boolean.TRUE, new String[]{showAp});
    }

    private void refKFlow() {
        int rowKey = this.addRule();
        this.hideFlexAp(TRUEORFALSE_FLEXAP);
        this.clearKFSetting();
        this.getModel().setValue(PRE_DESCRIPTION, (Object)HYPHEN, rowKey);
        this.getView().setEnable(Boolean.FALSE, rowKey, new String[]{PRE_DESCRIPTION});
        this.getModel().setValue(KEY_RULE_TYPE, (Object)RuleType.KFlowRule.name(), rowKey);
    }

    protected void ruleAdd(String key) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "ide_serviceedit");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        this.attachParameter(showParameter);
        showParameter.setCustomParam(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        showParameter.setCustomParam("serviceType", (Object)this.getServiceType());
        this.setFromTag(showParameter);
        this.getView().showForm(showParameter);
    }

    protected void setFromTag(FormShowParameter formShowParameter) {
    }

    protected void ruleUpdate(String update, String entryKey, String ruleName, String ruleId, String expression, String ret, String isLock) {
        HashMap<String, Object> currentRow = new HashMap<String, Object>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        if (grid == null) {
            return;
        }
        int selectRows = grid.getEntryState().getFocusRow();
        int count = this.getModel().getEntryRowCount(entryKey);
        if (selectRows > -1 && count > 0) {
            IDataModel rowData = this.getModel();
            if (rowData != null) {
                currentRow.put("RuleName", rowData.getValue(ruleName, selectRows));
                currentRow.put("RuleId", rowData.getValue(ruleId, selectRows));
                currentRow.put(EXPRESSION, rowData.getValue(expression, selectRows));
                currentRow.put("RET", rowData.getValue(ret, selectRows));
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("ide_serviceedit");
                parameter.setCustomParam(VALUE, currentRow);
                parameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, update + "&" + selectRows));
                this.attachParameter(parameter);
                parameter.setCustomParam(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
                parameter.setCustomParam("serviceType", (Object)this.getServiceType());
                this.setFromTag(parameter);
                if ("true".equals(isLock)) {
                    parameter.setCustomParam("isLock", (Object)isLock);
                }
                this.getView().showForm(parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RulesPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RulesPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    protected void delete() {
        int count;
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryKey);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (selectRows != null && selectRows.length > 0) {
            this.getModel().deleteEntryData(trueEntryKey);
            if (this.isEntryGridExist(falseEntryKey)) {
                this.getModel().deleteEntryData(falseEntryKey);
            }
            this.getModel().deleteEntryRows(entryKey, selectRows);
            if (this.getServiceType() == 1) {
                this.clearKFSetting();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RulesPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        if ((count = this.getModel().getEntryRowCount(entryKey)) > 0) {
            this.selectRowEvent(--count);
            int[] newSelectRows = grid.getEntryState().getSelectedRows();
            if (newSelectRows != null && newSelectRows.length != 0) {
                int index = newSelectRows[0];
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryKey);
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
                String currentRuleId = (String)dynamicObject.get(ID);
                this.lockEntryRowAndDeleteBtn(currentRuleId, grid, index);
            }
        }
    }

    protected void delete(String entryKey) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (selectRows != null && selectRows.length > 0) {
            this.getModel().deleteEntryRows(entryKey, selectRows);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RulesPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void up(String entryKey) {
        boolean canUp;
        DynamicObjectCollection doc;
        boolean hasIsLockProp;
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        if (grid == null) {
            return;
        }
        int[] rowsIndex = grid.getEntryState().getSelectedRows();
        if (rowsIndex.length < 1 || rowsIndex[0] < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RulesPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (rowsIndex.length > 0 && rowsIndex[0] == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u884c\u3002", (String)"RulesPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        if (entryKey.equals(entryKey) && (hasIsLockProp = (doc = this.getModel().getEntryEntity(entryKey)).getDynamicObjectType().getProperties().containsKey((Object)LOCK)) && (canUp = ((Boolean)this.getModel().getValue(LOCK, rowsIndex[0] - 1)).booleanValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4e00\u884c\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u4e0a\u79fb\u3002", (String)"RulesPlugin_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        this.getModel().moveEntryRowsUp(entryKey, rowsIndex);
    }

    private void down(String entryKey) {
        boolean canUp;
        DynamicObjectCollection doc;
        boolean hasIsLockProp;
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
        if (grid == null) {
            return;
        }
        int[] rowsIndex = grid.getEntryState().getSelectedRows();
        int rowLength = this.getModel().getEntryRowCount(entryKey);
        if (rowsIndex.length < 1 || rowLength <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RulesPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        if (rowsIndex.length > 0 && rowsIndex[0] == rowLength - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u884c\u3002", (String)"RulesPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        if (entryKey.equals(entryKey) && (hasIsLockProp = (doc = this.getModel().getEntryEntity(entryKey)).getDynamicObjectType().getProperties().containsKey((Object)LOCK)) && (canUp = ((Boolean)this.getModel().getValue(LOCK, rowsIndex[0] + 1)).booleanValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u4e00\u884c\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u4e0b\u79fb\u3002", (String)"RulesPlugin_17", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        this.getModel().moveEntryRowsDown(entryKey, rowsIndex);
    }

    protected FormShowParameter getFormShowParameter(String condition) {
        AbstractGrid entryGrid = (AbstractGrid)this.getView().getControl(entryKey);
        int entrySelRow = entryGrid.getEntryState().getFocusRow();
        Map clientParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, String> para = new HashMap<String, String>();
        HashMap<String, Object> currentPreDate = new HashMap<String, Object>();
        currentPreDate.put("RuleDescription", this.getModel().getValue(PRE_DESCRIPTION, entrySelRow));
        currentPreDate.put("RuleCondition", this.getModel().getValue(PRECONDITION, entrySelRow));
        para.put("formId", "ide_preconditiondesign");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, condition + "&" + entrySelRow));
        showParameter.setCustomParam(VALUE, currentPreDate);
        showParameter.setCustomParam(CONTEXT, clientParams.get(CONTEXT));
        showParameter.setCustomParam(META_TYPE, clientParams.get(META_TYPE));
        showParameter.setCustomParam("ruleFormId", (Object)this.getView().getFormShowParameter().getFormId());
        String isLockEntryRowDoubleClick = this.getPageCache().get("isLockEntryRowDoubleClick");
        showParameter.setCustomParam("isLock", (Object)isLockEntryRowDoubleClick);
        return showParameter;
    }

    protected void ruleCondition(String condition) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty("TextAreaField", "text", (Object)"");
        FormShowParameter showParameter = this.getFormShowParameter(condition);
        this.getView().showForm(showParameter);
    }

    private void createConditionData(Map<String, Object> ops) {
        if (ops != null && ops.size() > 0) {
            List falseList;
            List trueList = (List)SerializationUtils.fromJsonString((String)ops.get(TRUE_ACTIONS1).toString(), List.class);
            if (trueList != null && trueList.size() > 0) {
                this.initEntity(trueList, trueEntryKey, TRUE_RULE_ID, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
            }
            if (this.getModel().getDataEntityType().getProperties().get((Object)falseEntryKey) != null && (falseList = (List)SerializationUtils.fromJsonString((String)ops.get(FALSE_ACTIONS1).toString(), List.class)) != null && falseList.size() > 0) {
                this.initEntity(falseList, falseEntryKey, "FalseRuleId", "FalseRuleName", "FalseExpression", "falseRaiseEventType");
            }
        }
    }

    private void initEntity(List<Map<String, Object>> trueList, String entityName, String ruleId, String ruleName, String expName, String retName) {
        if (!this.isEntryGridExist(entityName)) {
            return;
        }
        boolean sortOrder = false;
        if (trueList != null && !trueList.isEmpty() && trueList.get(0) != null && this.supportSortActionBySeq() && this.isFormulaAction(trueList.get(0))) {
            sortOrder = true;
            Collections.sort(trueList, (o1, o2) -> {
                if (o1.containsKey(SEQ1) && o1.get(SEQ1) instanceof Number && o2.containsKey(SEQ1) && o1.get(SEQ1) instanceof Number) {
                    Integer s1 = (Integer)o1.get(SEQ1);
                    Integer s2 = (Integer)o2.get(SEQ1);
                    return Integer.compare(s1, s2);
                }
                return 0;
            });
        }
        if (trueList == null) {
            return;
        }
        for (int i = 0; i < trueList.size(); ++i) {
            int rowKey = this.getModel().createNewEntryRow(entityName);
            FormRuleActionType tempMetaData = FormRuleActionTypeCache.geFormRuleActionType((String)trueList.get(i).get("ActionType").toString());
            if (tempMetaData != null) {
                this.getModel().setValue(ruleId, (Object)tempMetaData.getId(), rowKey);
                this.getModel().setValue(ruleName, (Object)(trueList.get(i).get(DESCRIPTION1) == null ? "" : trueList.get(i).get(DESCRIPTION1).toString()), rowKey);
                if (sortOrder) {
                    trueList.get(i).put(SEQ1, i + 1);
                }
                this.getModel().setValue(retName, (Object)(trueList.get(i).get("RET") == null ? "" : trueList.get(i).get("RET").toString()), rowKey);
            }
            this.getModel().setValue(expName, (Object)SerializationUtils.toJsonString(trueList.get(i)), rowKey);
        }
    }

    private void selectKFlow(int selectRow) {
        IDataModel model = this.getModel();
        model.deleteEntryData(trueEntryKey);
        if (this.isEntryGridExist(falseEntryKey)) {
            model.deleteEntryData(falseEntryKey);
        }
        this.clearKFSetting();
        this.hideFlexAp(TRUEORFALSE_FLEXAP);
        String refStr = (String)this.getModel().getValue(REFERENCE_SETTINGS, selectRow);
        if (StringUtils.isNotBlank((CharSequence)refStr)) {
            Map refSetting = (Map)SerializationUtils.fromJsonString((String)refStr, Map.class);
            this.initKFRefSetting(refSetting, selectRow);
        } else if (model.getValue(FLOW_TRIGGER_TIME, selectRow) instanceof Integer) {
            model.beginInit();
            this.initTriggerTime(model, selectRow);
            model.endInit();
        }
        this.getView().updateView(REFSETTING_AP);
    }

    private void initTriggerTime(IDataModel model, int selectRow) {
        boolean isCreate;
        int triggerTime = (Integer)model.getValue(FLOW_TRIGGER_TIME, selectRow);
        boolean bl = isCreate = (triggerTime & TriggerTime.Create.getValue()) != 0;
        if (isCreate) {
            model.setValue(TIME_CREATE, (Object)Boolean.TRUE);
            this.getView().setEnable(Boolean.FALSE, new String[]{TIME_LOAD});
        } else if ((triggerTime & TriggerTime.Load.getValue()) != 0) {
            model.setValue(TIME_LOAD, (Object)Boolean.TRUE);
            this.getView().setEnable(Boolean.FALSE, new String[]{TIME_CREATE});
        }
        model.setValue(TIME_FIELD_CHANGED, (Object)((triggerTime & TriggerTime.FieldChanged.getValue()) != 0 ? 1 : 0));
    }

    private void initKFRefSetting(Map<String, Object> refSettingMap, int rowIndex) {
        IDataModel model = this.getModel();
        if (!CollectionUtils.isEmpty(refSettingMap)) {
            model.beginInit();
            model.setValue(KFLOW_ID, refSettingMap.get("KFId"));
            this.initTriggerTime(model, rowIndex);
            model.endInit();
            this.getView().updateView(REFSETTING_AP);
        }
    }

    protected void saveRulesData() {
        ArrayList<Map<String, Object>> ruleMapList = new ArrayList<Map<String, Object>>();
        if (!this.saveDataHelper(ruleMapList)) {
            return;
        }
        ArrayList<Map<String, Object>> paraList = new ArrayList<Map<String, Object>>(2);
        this.addRulePara(paraList, ruleMapList);
        this.getView().returnDataToParent(paraList);
        this.getView().close();
    }

    private boolean saveDataHelper(List<Map<String, Object>> ruleMapList) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entryKey);
        for (DynamicObject obj : collection) {
            DataEntityPropertyCollection props;
            Map<String, Boolean> checkMap = this.checkMustInput(obj, props = obj.getDataEntityType().getProperties());
            if (!checkMap.get("result").booleanValue()) {
                return Boolean.FALSE;
            }
            this.saveAllRules(obj, props, ruleMapList, checkMap.get("isKRule"));
        }
        return Boolean.TRUE;
    }

    private Map<String, Boolean> checkMustInput(DynamicObject obj, DataEntityPropertyCollection props) {
        HashMap<String, Boolean> checkMap = new HashMap<String, Boolean>(2);
        boolean result = this.generalCheck(obj, props);
        if (!result) {
            checkMap.put("result", Boolean.FALSE);
            return checkMap;
        }
        Map<String, Boolean> map1 = this.checkKR(obj);
        checkMap.put("result", map1.get("result"));
        checkMap.put("isKRule", map1.get("isKRule"));
        return checkMap;
    }

    private boolean generalCheck(DynamicObject obj, DataEntityPropertyCollection props) {
        String mustInputField = "";
        if (StringUtils.isBlank((Object)obj.get(PRE_DESCRIPTION))) {
            mustInputField = ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e", (String)"RulesPlugin_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        }
        if (props.get((Object)DESCRIPTION) != null && StringUtils.isBlank((Object)obj.get(DESCRIPTION))) {
            mustInputField = ResManager.loadKDString((String)"\u89c4\u5219\u63cf\u8ff0", (String)"RulesPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)mustInputField)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c%2$s\u201d\u5fc5\u586b\u3002", (String)"RulesPlugin_20", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), obj.getInt(SEQ), mustInputField), Integer.valueOf(2000));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Map<String, Boolean> checkKR(DynamicObject obj) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        boolean result = Boolean.TRUE;
        boolean isKRule = Boolean.FALSE;
        if (this.getServiceType() == 1 && obj.get(KEY_RULE_TYPE) != null && RuleType.KFlowRule.name().equals(obj.get(KEY_RULE_TYPE))) {
            isKRule = Boolean.TRUE;
            if (obj.get(FLOW_TRIGGER_TIME) != null && 0 == obj.getInt(FLOW_TRIGGER_TIME)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u7b2c%d\u884cK\u6d41\u5f15\u7528\u8bbe\u7f6e\u4e2d\u81f3\u5c11\u9009\u62e9\u4e00\u9879\u201c\u9009\u62e9\u89e6\u53d1\u65f6\u673a\u201d\u3002", (String)"RulesPlugin_19", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), obj.getInt(SEQ)));
                result = Boolean.FALSE;
            }
            if (result && StringUtils.isBlank((Object)obj.get(REFERENCE_SETTINGS))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884cK\u6d41\u5f15\u7528\u8bbe\u7f6e\u4e2d\uff0c\u201c\u9009\u62e9K\u6d41\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RulesPlugin_18", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), obj.getInt(SEQ)));
                result = Boolean.FALSE;
            }
        }
        map.put("isKRule", isKRule);
        map.put("result", result);
        return map;
    }

    private void saveAllRules(DynamicObject obj, DataEntityPropertyCollection props, List<Map<String, Object>> ruleMapList, boolean isKRule) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (this.getModel().getProperty(ID) != null) {
            String id = this.getOrCreateRuleId(obj);
            dataMap.put(ID1, id);
        }
        dataMap.put(SEQ1, obj.getInt(SEQ));
        if (props.get((Object)DESCRIPTION) != null) {
            dataMap.put(DESCRIPTION1, obj.get(DESCRIPTION));
        }
        if (props.get((Object)ENABLED1) != null) {
            dataMap.put(ENABLED1, obj.get(ENABLED) == null ? Boolean.valueOf(true) : obj.get(ENABLED));
        } else {
            dataMap.put(ENABLED1, true);
        }
        if (isKRule) {
            this.saveKRules(dataMap, obj);
        } else {
            this.saveFormRule(dataMap, obj, props);
        }
        ruleMapList.add(dataMap);
    }

    private String getOrCreateRuleId(DynamicObject obj) {
        String id = (String)obj.get(ID);
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = Uuid16.create().toString();
        }
        return id;
    }

    private void saveKRules(Map<String, Object> dataMap, DynamicObject obj) {
        if (StringUtils.isBlank((Object)obj.get(REFERENCE_SETTINGS))) {
            return;
        }
        HashMap extProps = new HashMap(8);
        Map settingMap = (Map)SerializationUtils.fromJsonString((String)((String)obj.get(REFERENCE_SETTINGS)), Map.class);
        extProps.put("KFId", settingMap.get("KFId"));
        extProps.put("RefId", settingMap.get("RefId"));
        extProps.put("TriggerTime", settingMap.get("TriggerTime"));
        extProps.put("Scene", "rule");
        if (StringUtils.isNotBlank((CharSequence)this.getRootEntityId())) {
            extProps.put("ObjectId", this.getRootEntityId());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBizAppId())) {
            extProps.put("BizAppId", this.getBizAppId());
        }
        dataMap.put(PRE_DESCRIPTION1, HYPHEN);
        dataMap.put("RuleType", RuleType.KFlowRule.name());
        dataMap.put(KEY_EXT_PROPS, extProps);
    }

    private void saveFormRule(Map<String, Object> dataMap, DynamicObject obj, DataEntityPropertyCollection props) {
        Object falseactions;
        dataMap.put(PRECONDITION1, obj.get(PRECONDITION));
        dataMap.put(PRE_DESCRIPTION1, obj.get(PRE_DESCRIPTION));
        dataMap.put("RuleType", RuleType.FormRule.name());
        Object trueactions = obj.get(TRUE_ACTIONS);
        if (!StringUtils.isBlank((Object)trueactions)) {
            dataMap.put(TRUE_ACTIONS1, SerializationUtils.fromJsonString((String)obj.get(TRUE_ACTIONS).toString(), List.class));
        }
        if (props.get((Object)FALSE_ACTIONS) != null && !StringUtils.isBlank((Object)(falseactions = obj.get(FALSE_ACTIONS)))) {
            dataMap.put(FALSE_ACTIONS1, SerializationUtils.fromJsonString((String)obj.get(FALSE_ACTIONS).toString(), List.class));
        }
    }

    private void addRulePara(List<Map<String, Object>> paraList, List<Map<String, Object>> ruleMapList) {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put(VALUE, ruleMapList);
        para.put("alias", this.getRuleAlias(ruleMapList).equals("") ? "\t" : this.getRuleAlias(ruleMapList));
        paraList.add(para);
    }

    private String getBizAppId() {
        return (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
    }

    protected Object getRuleAlias(List<Map<String, Object>> ruleMapList) {
        if (ruleMapList == null || ruleMapList.isEmpty()) {
            return "";
        }
        List<Map<String, Object>> ops = ruleMapList;
        StringBuilder alias = new StringBuilder();
        for (Map<String, Object> op : ops) {
            String description;
            boolean enabled = Boolean.parseBoolean(op.get(ENABLED1).toString());
            String string = description = op.get(DESCRIPTION1) == null ? op.get(PRE_DESCRIPTION1).toString() : op.get(DESCRIPTION1).toString();
            if (!enabled) continue;
            alias.append(alias.length() == 0 ? alias.toString() : "; ").append(description);
        }
        return alias.toString();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            this.saveRulesData();
        } else if (key.equals(PRE_DESCRIPTION)) {
            this.ruleCondition(PRE_DESCRIPTION);
        } else if (key.equals("detail")) {
            this.getView().showErrorNotification("sd");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().equals(KFLOW_ID)) {
            String appId = this.getBizAppId();
            KFlowSelectUtils.init(appId, evt);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        if (entryGrid == null) {
            return;
        }
        int entryIndex = entryGrid.getEntryState().getFocusRow();
        if (entryIndex <= 0) {
            entryIndex = 0;
        }
        if (KFLOW_ID.equals(propName)) {
            this.updateRef(this.getKFlowTriggerTime(), entryIndex);
        } else if (TIME_CREATE.equals(propName)) {
            this.disableTriggerTime(e, TIME_LOAD);
            this.updateTriggerTime(entryIndex);
        } else if (TIME_LOAD.equals(propName)) {
            this.disableTriggerTime(e, TIME_CREATE);
            this.updateTriggerTime(entryIndex);
        } else if (TIME_FIELD_CHANGED.equals(propName)) {
            this.updateTriggerTime(entryIndex);
        }
    }

    private void updateTriggerTime(int entryIndex) {
        int triggerTime = this.getKFlowTriggerTime();
        this.getModel().beginInit();
        this.getModel().setValue(FLOW_TRIGGER_TIME, (Object)triggerTime, entryIndex);
        this.getModel().endInit();
        this.updateRef(triggerTime, entryIndex);
    }

    private void disableTriggerTime(PropertyChangedArgs e, String time) {
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue instanceof Boolean) {
            this.getView().setEnable(Boolean.valueOf((Boolean)newValue == false), new String[]{time});
        }
    }

    private void updateRef(int triggerTime, int entryIndex) {
        DynamicObject kflow = (DynamicObject)this.getModel().getValue(KFLOW_ID);
        if (kflow == null) {
            return;
        }
        String kfId = String.valueOf(kflow.get(ID));
        this.updateRefHelper(kfId, triggerTime, entryIndex);
    }

    private void updateRefHelper(String kfId, int triggerTime, int entryIndex) {
        HashMap<String, Object> refSetting = new HashMap<String, Object>(5);
        refSetting.put("KFId", kfId);
        refSetting.put("TriggerTime", triggerTime);
        String refId = String.valueOf(DB.genLongId((String)"t_kf_reference"));
        refSetting.put("RefId", refId);
        this.getModel().beginInit();
        this.getModel().setValue(REFERENCE_SETTINGS, (Object)SerializationUtils.toJsonString(refSetting), entryIndex);
        this.getModel().endInit();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        Map ruleMap = (Map)e.getReturnData();
        if (this.getView().getControl(trueEntryKey) != null) {
            this.getView().updateView(trueEntryKey);
        }
        if (this.getView().getControl(falseEntryKey) != null) {
            this.getView().updateView(falseEntryKey);
        }
        if (e.getActionId().startsWith(PRE_DESCRIPTION)) {
            int rowKey = Integer.parseInt(e.getActionId().split("&")[1]);
            this.getModel().setValue(PRE_DESCRIPTION, ruleMap.get("RuleDescription"), rowKey);
            this.getModel().setValue(PRECONDITION, ruleMap.get("RuleCondition"), rowKey);
            return;
        }
        if (TRUE_ADD.equalsIgnoreCase(e.getActionId())) {
            int rowKey = this.getModel().createNewEntryRow(trueEntryKey);
            this.getModel().setValue(TRUE_RULE_NAME, ruleMap.get(DESCRIPTION1), rowKey);
            this.getModel().setValue(TRUE_RULE_ID, ruleMap.get(ID1), rowKey);
            this.getModel().setValue(TRUE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(TRUE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveColumnData(ruleMap);
            this.saveActions(e.getActionId(), trueEntryKey, ruleMap, TRUE_ACTIONS, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if (FALSE_ADD.equalsIgnoreCase(e.getActionId())) {
            int rowKey = this.getModel().createNewEntryRow(falseEntryKey);
            this.getModel().setValue(FALSE_RULE_NAME, ruleMap.get(DESCRIPTION1), rowKey);
            this.getModel().setValue(FALSE_RULE_ID, ruleMap.get(ID1), rowKey);
            this.getModel().setValue(FALSE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(FALSE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveColumnData(ruleMap);
            this.saveActions(e.getActionId(), falseEntryKey, ruleMap, FALSE_ACTIONS, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        } else if (e.getActionId().startsWith(TRUE_UPDATE)) {
            int rowKey = Integer.parseInt(e.getActionId().split("&")[1]);
            this.getModel().setValue(TRUE_RULE_NAME, ruleMap.get(DESCRIPTION1), rowKey);
            this.getModel().setValue(TRUE_RULE_ID, ruleMap.get(ID1), rowKey);
            this.getModel().setValue(TRUE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(TRUE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveActions(e.getActionId(), trueEntryKey, ruleMap, TRUE_ACTIONS, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if (e.getActionId().startsWith(FALSE_UPDATE)) {
            int rowKey = Integer.parseInt(e.getActionId().split("&")[1]);
            this.getModel().setValue(FALSE_RULE_NAME, ruleMap.get(DESCRIPTION1), rowKey);
            this.getModel().setValue(FALSE_RULE_ID, ruleMap.get(ID1), rowKey);
            this.getModel().setValue(FALSE_RAISE_EVENT_TYPE, ruleMap.get(RAISE_EVENT_TYPE), rowKey);
            this.getModel().setValue(FALSE_EXPRESSION, (Object)ruleMap.get(EXPRESSION).toString(), rowKey);
            this.saveActions(e.getActionId(), falseEntryKey, ruleMap, FALSE_ACTIONS, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        }
    }

    private int getKFlowTriggerTime() {
        int triggerTime = TriggerTime.NormalEvent.getValue();
        boolean isFieldChanged = (Boolean)this.getModel().getValue(TIME_FIELD_CHANGED);
        triggerTime = isFieldChanged ? triggerTime + TriggerTime.FieldChanged.getValue() : triggerTime;
        boolean isLoad = (Boolean)this.getModel().getValue(TIME_LOAD);
        triggerTime = isLoad ? triggerTime + TriggerTime.Load.getValue() : triggerTime;
        boolean isCreate = (Boolean)this.getModel().getValue(TIME_CREATE);
        triggerTime = isCreate ? triggerTime + TriggerTime.Create.getValue() : triggerTime;
        return triggerTime;
    }

    private String getRootEntityId() {
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (CollectionUtils.isEmpty((Collection)context) || CollectionUtils.isEmpty((Collection)((Collection)context.get(0))) || CollectionUtils.isEmpty((Map)((Map)((List)context.get(0)).get(0)))) {
            return null;
        }
        return (String)((Map)((List)context.get(0)).get(0)).get(ID1);
    }

    private Map<String, Object> saveColumnData(Map<String, Object> ruleMap) {
        Object actions = ruleMap.get(EXPRESSION);
        Map actionMap = null;
        if (!StringUtils.isBlank((Object)actions)) {
            actionMap = (Map)SerializationUtils.fromJsonString((String)actions.toString(), Map.class);
            if (!StringUtils.isBlank((Object)ruleMap.get(DESCRIPTION1))) {
                actionMap.put(DESCRIPTION1, ruleMap.get(DESCRIPTION1));
            }
            if (!StringUtils.isBlank((Object)ruleMap.get(RAISE_EVENT_TYPE))) {
                actionMap.put("RET", ruleMap.get(RAISE_EVENT_TYPE));
            }
        }
        return actionMap;
    }

    private boolean isFormulaAction(Map<String, Object> ruleMap) {
        if (ruleMap == null) {
            return false;
        }
        return "FormulaAction".equals(ruleMap.getOrDefault("_Type_", "").toString());
    }

    void saveActions(String key, String actionEntryKey, Map<String, Object> ruleMap, String actionKey, String ruleName, String expression, String ret) {
        ArrayList<Map> actionList = new ArrayList<Map>();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        if (entryGrid == null) {
            return;
        }
        boolean order = this.supportSortActionBySeq();
        int entryIndex = entryGrid.getEntryState().getFocusRow();
        int rowCount = this.getModel().getEntryRowCount(actionEntryKey);
        for (int i = 0; i < rowCount; ++i) {
            int rowKey;
            DynamicObject trueObj = this.getModel().getEntryRowEntity(actionEntryKey, i);
            if (key.split("&").length > 1 && i == (rowKey = Integer.parseInt(key.split("&")[1]))) {
                Map<String, Object> data = this.saveColumnData(ruleMap);
                if (order && this.isFormulaAction(data)) {
                    data.put(SEQ1, i + 1);
                }
                actionList.add(data);
                continue;
            }
            Object trueactions = trueObj.get(expression);
            if (StringUtils.isBlank((Object)trueactions)) continue;
            Map trueMap = (Map)SerializationUtils.fromJsonString((String)trueactions.toString(), Map.class);
            if (!StringUtils.isBlank((Object)trueObj.get(ruleName))) {
                trueMap.put(DESCRIPTION1, trueObj.get(ruleName));
            }
            if (!StringUtils.isBlank((Object)trueObj.get(ret))) {
                trueMap.put("RET", trueObj.get(ret));
            }
            if (order && this.isFormulaAction(trueMap)) {
                trueMap.put(SEQ1, i + 1);
            }
            actionList.add(trueMap);
        }
        this.getModel().setValue(actionKey, (Object)SerializationUtils.toJsonString(actionList), entryIndex);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int index = entryGrid.getEntryState().getFocusRow();
        int count = this.getModel().getEntryRowCount(entryKey);
        if (!("add".equals(key) || REF_KFLOW.equals(key) || count >= 1 && index >= 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RulesPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if ("add".equals(key)) {
            this.add();
        } else if (REF_KFLOW.equals(key)) {
            this.refKFlow();
        } else if (TRUE_ADD.equals(key) || FALSE_ADD.equals(key)) {
            this.ruleAdd(key);
        } else if ("delete".equals(key)) {
            this.delete();
        } else if ("truedelete".equals(key)) {
            this.delete(trueEntryKey);
            HashMap<String, Object> ruleMap = new HashMap<String, Object>();
            this.saveActions(key, trueEntryKey, ruleMap, TRUE_ACTIONS, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if ("falsedelete".equals(key)) {
            this.delete(falseEntryKey);
            HashMap<String, Object> ruleMap = new HashMap<String, Object>();
            this.saveActions(key, falseEntryKey, ruleMap, FALSE_ACTIONS, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        } else if (TRUE_UPDATE.equalsIgnoreCase(key)) {
            this.ruleUpdate(key, trueEntryKey, TRUE_RULE_NAME, TRUE_RULE_ID, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE, "false");
        } else if (FALSE_UPDATE.equalsIgnoreCase(key)) {
            this.ruleUpdate(key, falseEntryKey, FALSE_RULE_NAME, FALSE_RULE_ID, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE, "false");
        } else if ("up".equals(key)) {
            this.up(entryKey);
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
            int[] rowsIndex = grid.getEntryState().getSelectedRows();
            this.selectRowEvent(rowsIndex[0]);
        } else if ("trueup".equalsIgnoreCase(key)) {
            this.up(trueEntryKey);
        } else if ("falseup".equalsIgnoreCase(key)) {
            this.up(falseEntryKey);
        } else if ("down".equals(key)) {
            this.down(entryKey);
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryKey);
            int[] rowsIndex = grid.getEntryState().getSelectedRows();
            this.selectRowEvent(rowsIndex[0]);
        } else if ("truedown".equalsIgnoreCase(key)) {
            this.down(trueEntryKey);
        } else if ("falsedown".equalsIgnoreCase(key)) {
            this.down(falseEntryKey);
        }
    }

    protected boolean supportSortActionBySeq() {
        return "ide_rules".equals(this.getView().getFormShowParameter().getFormId());
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryDown(e);
        if (e.getEntryProp() == null || !this.supportSortActionBySeq()) {
            return;
        }
        if (trueEntryKey.equals(e.getEntryProp().getName())) {
            this.afterMoveActionEntry(trueEntryKey, TRUE_ACTIONS, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if (falseEntryKey.equals(e.getEntryProp().getName())) {
            this.afterMoveActionEntry(falseEntryKey, FALSE_ACTIONS, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        }
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        super.afterMoveEntryUp(e);
        if (e.getEntryProp() == null || !this.supportSortActionBySeq()) {
            return;
        }
        if (trueEntryKey.equals(e.getEntryProp().getName())) {
            this.afterMoveActionEntry(trueEntryKey, TRUE_ACTIONS, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        } else if (falseEntryKey.equals(e.getEntryProp().getName())) {
            this.afterMoveActionEntry(falseEntryKey, FALSE_ACTIONS, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
        }
    }

    private void afterMoveActionEntry(String actionEntryKey, String actionKey, String ruleName, String expression, String ret) {
        ArrayList<Map> actionList = new ArrayList<Map>();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        if (entryGrid == null) {
            return;
        }
        int entryIndex = entryGrid.getEntryState().getFocusRow();
        int rowCount = this.getModel().getEntryRowCount(actionEntryKey);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject trueObj = this.getModel().getEntryRowEntity(actionEntryKey, i);
            Object trueactions = trueObj.get(expression);
            if (StringUtils.isBlank((Object)trueactions)) continue;
            Map trueMap = (Map)SerializationUtils.fromJsonString((String)trueactions.toString(), Map.class);
            if (!StringUtils.isBlank((Object)trueObj.get(ruleName))) {
                trueMap.put(DESCRIPTION1, trueObj.get(ruleName));
            }
            if (!StringUtils.isBlank((Object)trueObj.get(ret))) {
                trueMap.put("RET", trueObj.get(ret));
            }
            if (this.isFormulaAction(trueMap)) {
                trueMap.put(SEQ1, i + 1);
            }
            actionList.add(trueMap);
        }
        this.getModel().setValue(actionKey, (Object)SerializationUtils.toJsonString(actionList), entryIndex);
    }

    private void selectRowEvent(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        if (this.getServiceType() == 1) {
            String ruleType = (String)this.getModel().getValue(KEY_RULE_TYPE, rowIndex);
            if (StringUtils.isBlank((CharSequence)ruleType) || RuleType.FormRule.name().equals(ruleType)) {
                this.selectRule(rowIndex);
            } else if (RuleType.KFlowRule.name().equals(ruleType)) {
                this.selectKFlow(rowIndex);
            }
        } else {
            this.selectRule(rowIndex);
        }
    }

    private void selectRule(int rowIndex) {
        List trueList;
        Object trueactions;
        IDataModel rowData = this.getModel();
        this.getModel().deleteEntryData(trueEntryKey);
        if (this.isEntryGridExist(falseEntryKey)) {
            List falseList;
            this.getModel().deleteEntryData(falseEntryKey);
            Object falseactions = rowData.getValue(FALSE_ACTIONS, rowIndex);
            if (falseactions == null || StringUtils.isBlank((Object)falseactions)) {
                falseactions = "[]";
            }
            if ((falseList = (List)SerializationUtils.fromJsonString((String)falseactions.toString(), List.class)) != null && falseList.size() > 0) {
                this.initEntity(falseList, falseEntryKey, FALSE_RULE_ID, FALSE_RULE_NAME, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE);
            }
        }
        if ((trueactions = rowData.getValue(TRUE_ACTIONS, rowIndex)) == null || StringUtils.isBlank((Object)trueactions)) {
            trueactions = "[]";
        }
        if ((trueList = (List)SerializationUtils.fromJsonString((String)trueactions.toString(), List.class)) != null && trueList.size() > 0) {
            this.initEntity(trueList, trueEntryKey, TRUE_RULE_ID, TRUE_RULE_NAME, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE);
        }
        if (this.getServiceType() == 1) {
            this.clearKFSetting();
            this.hideFlexAp(REFSETTING_AP);
        }
    }

    public void entryRowClick(RowClickEvent e) {
        EntryGrid entryGrid;
        if (e.getSource() != null && entryKey.equals((entryGrid = (EntryGrid)e.getSource()).getKey())) {
            int rowIndex = e.getRow();
            this.selectRowEvent(rowIndex);
            String ruleId = (String)this.getModel().getValue(ID, rowIndex);
            this.lockEntryRowAndDeleteBtn(ruleId, entryGrid, rowIndex);
        }
    }

    private void lockEntryRowAndDeleteBtn(String ruleId, EntryGrid entryGrid, int row) {
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            this.getView().setEnable(Boolean.TRUE, ITEM_BUTTON);
            this.getView().setEnable(Boolean.TRUE, new String[]{REFSETTING_AP});
            this.getPageCache().put("isLockEntryRowDoubleClick", "false");
            return;
        }
        String lockRules = this.getPageCache().get(LOCK_RULES_CACHE);
        if (StringUtils.isNotBlank((CharSequence)lockRules)) {
            Map lockRuleIds = (Map)SerializationUtils.fromJsonString((String)lockRules, Map.class);
            int[] rows = new int[]{row};
            if (lockRuleIds.containsKey(ruleId) && LOCK.equals(lockRuleIds.get(ruleId))) {
                this.getView().setEnable(Boolean.FALSE, ITEM_BUTTON);
                this.getView().setEnable(Boolean.FALSE, row, new String[]{DESCRIPTION, KEY_RULE_TYPE, ENABLED});
                this.getView().setEnable(Boolean.FALSE, new String[]{REFSETTING_AP});
                this.getPageCache().put("isLockEntryRowDoubleClick", "true");
            } else {
                this.getView().setEnable(Boolean.TRUE, ITEM_BUTTON);
                this.getView().setEnable(Boolean.TRUE, row, new String[]{DESCRIPTION, KEY_RULE_TYPE, ENABLED});
                this.getView().setEnable(Boolean.TRUE, new String[]{REFSETTING_AP});
                this.getPageCache().put("isLockEntryRowDoubleClick", "false");
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent e) {
        String isLockEntryRowDoubleClick = this.getPageCache().get("isLockEntryRowDoubleClick");
        if (e.getSource() != null) {
            EntryGrid entryGrid = (EntryGrid)e.getSource();
            if (entryKey.equals(entryGrid.getKey())) {
                this.selectRowEvent(e.getRow());
            } else if (trueEntryKey.equals(entryGrid.getKey())) {
                this.ruleUpdate(TRUE_UPDATE, trueEntryKey, TRUE_RULE_NAME, TRUE_RULE_ID, TRUE_EXPRESSION, TRUE_RAISE_EVENT_TYPE, isLockEntryRowDoubleClick);
            } else if (falseEntryKey.equals(entryGrid.getKey())) {
                this.ruleUpdate(FALSE_UPDATE, falseEntryKey, FALSE_RULE_NAME, FALSE_RULE_ID, FALSE_EXPRESSION, FALSE_RAISE_EVENT_TYPE, isLockEntryRowDoubleClick);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("rule_action");
    }
}

