/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.entity.rule.FillQtyAction;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.metadata.exception.CheckResultInfo;
import kd.bos.metadata.form.rule.FormRuleActionType;
import kd.bos.metadata.form.rule.FormRuleActionTypeCache;
import kd.bos.mvc.SessionManager;

public class ServiceEdit
extends AbstractFormPlugin {
    private static final String KEY_RAISE_EVENT_TYPE_FIELD_CHANGED = "fieldchanged";
    private static final String KEY_RAISE_EVENT_TYPE_INITIALIZED = "load";
    private static final String KEY_RAISE_EVENT_TYPE_ITEM_ADDED = "add";
    private static final String KEY_RAISE_EVENT_TYPE_ITEM_RESET = "itemreset";
    private static final String KEY_RAISE_EVENT_TYPE_ITEM_REMOVED = "remove";
    private static final String KEY_RAISE_EVENT_TYPE_RESET = "reset";
    private static final String KEY_RAISE_EVENT_TYPE_SELECT_ROW_CHANGED = "selectedrowchange";
    private static final String KEY_RULE_TYPE = "servicetype";
    private static final String KEY_RULE_DESCRIPTION = "servicedescription";
    private static final String KEY_EXPRESSION = "expression";
    private static final int ALL_RAISE_EVENT_TYPE = 255;
    private static final String META_TYPE = "metaType";
    private static final String SERVICE_TYPE = "serviceType";
    private static final String FORM_RULE_PANEL_PAGE_ID = "formrulepanel_pageid";
    private static final String FIELD_ACTION = "FieldAction";
    private static final String CONTROL_ACTION = "ControlAction";
    private static final String FIELD_DISPLAY_FMT_ACTION = "FieldDisplayfmtAction";
    protected static final String BD_FIELD_CLICKABLE = "bdFieldClickAble";

    public void initialize() {
        Object formulaType = this.getView().getFormShowParameter().getCustomParams().get("formulaType");
        if ("formulaColumn".equals(formulaType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"eventpanel", KEY_RULE_TYPE});
        }
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        String serviceDesc;
        List<FormRuleActionType> currentFormTypes;
        String ruleId = null;
        String expression = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String isLock = (String)customParams.get("isLock");
        if ("true".equals(isLock)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
        }
        String metaType = customParams.get(META_TYPE) == null ? "" : customParams.get(META_TYPE).toString();
        int serviceType = customParams.get(SERVICE_TYPE) == null ? 0 : Integer.parseInt(customParams.get(SERVICE_TYPE).toString());
        Map ruleMap = (Map)this.getView().getFormShowParameter().getCustomParams().get("value");
        if (ruleMap != null && ruleMap.size() > 0) {
            ruleId = ruleMap.get("RuleId").toString();
            expression = ruleMap.get("Expression").toString();
        }
        if ((currentFormTypes = this.initServiceTypeItems(metaType, serviceType)).isEmpty()) {
            return;
        }
        FormRuleActionType selectedMetaData = null;
        for (FormRuleActionType type : currentFormTypes) {
            if (!StringUtils.equals((CharSequence)type.getId(), (CharSequence)ruleId)) continue;
            selectedMetaData = type;
            break;
        }
        if (selectedMetaData == null) {
            selectedMetaData = currentFormTypes.get(0);
        }
        int raiseEventType = 255;
        if (ruleMap != null) {
            String string = serviceDesc = ruleMap.get("RuleName") == null ? "" : ruleMap.get("RuleName").toString();
            if (ruleMap.get("RET") != null) {
                raiseEventType = ruleMap.get("RET") == null ? 0 : (StringUtils.isEmpty((CharSequence)ruleMap.get("RET").toString()) ? 0 : Integer.parseInt(ruleMap.get("RET").toString()));
            }
        } else {
            raiseEventType = selectedMetaData.getRaiseEventType();
            serviceDesc = selectedMetaData.getDesc();
        }
        this.getModel().setValue(KEY_RULE_TYPE, (Object)selectedMetaData.getId());
        this.getModel().setValue(KEY_RULE_DESCRIPTION, (Object)serviceDesc);
        this.initRaiseEventValue(selectedMetaData, raiseEventType);
        this.showServiceForm(selectedMetaData.getFormid(), selectedMetaData.getId(), null, expression, selectedMetaData.getControlType());
    }

    public void afterBindData(EventObject e) {
        String ruleId = (String)this.getModel().getValue(KEY_RULE_TYPE);
        FormRuleActionType ruleType = FormRuleActionTypeCache.geFormRuleActionType((String)ruleId);
        if (ruleType != null) {
            this.initRaiseEventEnable(ruleType);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equalsIgnoreCase(KEY_RULE_TYPE)) {
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            FormRuleActionType selectedMetaData = FormRuleActionTypeCache.geFormRuleActionType((String)newValue);
            if (selectedMetaData != null) {
                this.initRaiseEventEnable(selectedMetaData);
                this.getModel().setValue(KEY_RULE_DESCRIPTION, (Object)selectedMetaData.getDesc());
                this.showServiceForm(selectedMetaData.getFormid(), newValue, oldValue, null, selectedMetaData.getControlType());
                this.initRaiseEventValue(selectedMetaData, 255);
            }
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("btnok".equalsIgnoreCase(btn.getKey())) {
            this.closeAndreturnData();
        } else if ("btncancel".equalsIgnoreCase(btn.getKey())) {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        Map expression = (Map)e.getReturnData();
        this.getPageCache().put(KEY_EXPRESSION, SerializationUtils.toJsonString((Object)expression));
    }

    private void closeAndreturnData() {
        String pageId = this.getPageCache().get(FORM_RULE_PANEL_PAGE_ID);
        String expStr = null;
        IBizRuleEditor ruleEditor = null;
        if (pageId != null) {
            IFormView view = this.getView().getView(pageId);
            ruleEditor = this.getBizRuleEditor(view);
            if (ruleEditor != null) {
                CheckResultInfo resultInfo = ruleEditor.checkConfigAndReturn();
                if (resultInfo != null && !resultInfo.isSuccess()) {
                    this.getView().showTipNotification(resultInfo.getInfo().getError());
                    return;
                }
                expStr = ruleEditor.getOutConfig();
            }
            view.close();
            IPageCache childViewPageCache = (IPageCache)view.getService(IPageCache.class);
            String closeFailed = childViewPageCache.get("closeFailed");
            if (StringUtils.isNotBlank((CharSequence)closeFailed)) {
                this.getView().showErrorNotification(closeFailed);
                return;
            }
        }
        String ruleType = this.getModel().getValue(KEY_RULE_TYPE).toString();
        FormRuleActionType tempMetaData = FormRuleActionTypeCache.geFormRuleActionType((String)ruleType);
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        if (tempMetaData != null) {
            HashMap para = new HashMap();
            if (expStr == null) {
                expStr = this.getPageCache().get(KEY_EXPRESSION);
            }
            if (StringUtils.isBlank((CharSequence)expStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5c06\u5df2\u9009\u62e9\u7684\u201c\u6e90\u5b57\u6bb5\u201d\u548c\u201c\u76ee\u6807\u5b57\u6bb5\u201d\u6dfb\u52a0\u5230\u8868\u683c\u4e2d\u3002", (String)"ServiceEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
                return;
            }
            Map expression = (Map)SerializationUtils.fromJsonString((String)expStr, Map.class);
            if ("FormulaAction".equalsIgnoreCase(ruleType) || "ClearValueAction".equalsIgnoreCase(ruleType) || FillQtyAction.class.getSimpleName().equalsIgnoreCase(ruleType)) {
                for (Map.Entry exp : expression.entrySet()) {
                    para.put(exp.getKey(), exp.getValue().toString());
                }
            } else {
                for (Map.Entry exp : expression.entrySet()) {
                    para.put(exp.getKey(), SerializationUtils.fromJsonString((String)exp.getValue().toString(), List.class));
                }
            }
            para.put("_Type_", tempMetaData.getMetaClass());
            para.put("ActionType", tempMetaData.getId());
            returnData.put("Id", tempMetaData.getId());
            returnData.put("Name", tempMetaData.getName());
            returnData.put("Description", this.getModel().getValue(KEY_RULE_DESCRIPTION));
            returnData.put("RaiseEventType", this.getRaiseEventValue(tempMetaData));
            returnData.put("Expression", SerializationUtils.toJsonString(para));
            this.getView().returnDataToParent(returnData);
        }
        this.getView().close();
    }

    private void showServiceForm(String formId, String serviceTypeId, String oldserviceTypeId, String expression, int controlType) {
        this.closeServiceForm(oldserviceTypeId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("formrulepanel");
        formShowParameter.setFormId(formId);
        if ("FormulaAction".equals(serviceTypeId)) {
            StyleCss css = new StyleCss();
            css.setHeight("360");
            formShowParameter.getOpenStyle().setInlineStyleCss(css);
        }
        formShowParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        formShowParameter.getCustomParams().put("controlType", controlType);
        formShowParameter.getCustomParams().put("serviceTypeId", serviceTypeId);
        formShowParameter.getCustomParams().put("value", expression);
        formShowParameter.getCustomParams().put("isEntityDesign", this.getView().getFormShowParameter().getCustomParam("isEntityDesign"));
        formShowParameter.getCustomParams().put("itemId", this.getView().getFormShowParameter().getCustomParam("itemId"));
        formShowParameter.getCustomParams().put("fromTag", this.getView().getFormShowParameter().getCustomParam("fromTag"));
        String selectedStatus = null;
        if (serviceTypeId.contains(FIELD_ACTION)) {
            selectedStatus = this.getPageCache().get(FIELD_ACTION);
        } else if (serviceTypeId.contains(CONTROL_ACTION)) {
            selectedStatus = this.getPageCache().get(CONTROL_ACTION);
        } else if (serviceTypeId.contains(FIELD_DISPLAY_FMT_ACTION)) {
            selectedStatus = this.getPageCache().get(FIELD_DISPLAY_FMT_ACTION);
        }
        formShowParameter.getCustomParams().put("selectedStatus", selectedStatus);
        formShowParameter.getCustomParams().put("InContainer", ShowType.InContainer);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "register"));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        formShowParameter.setCustomParam("context", customParams.get("context"));
        formShowParameter.setCustomParam("isReportForm", customParams.get("isReportForm"));
        formShowParameter.setCustomParam(META_TYPE, customParams.get(META_TYPE));
        formShowParameter.setCustomParam("controlId", customParams.get("controlId"));
        int serviceType = customParams.get(SERVICE_TYPE) == null ? 0 : Integer.parseInt(customParams.get(SERVICE_TYPE).toString());
        formShowParameter.setCustomParam(SERVICE_TYPE, (Object)serviceType);
        if ("ide_preconditiondesign".equalsIgnoreCase(formId)) {
            formShowParameter.setCustomParam(BD_FIELD_CLICKABLE, (Object)Boolean.TRUE);
        }
        this.getView().showForm(formShowParameter);
        this.getPageCache().put(FORM_RULE_PANEL_PAGE_ID, formShowParameter.getPageId());
    }

    private void closeServiceForm(String oldserviceTypeId) {
        String pageId = this.getPageCache().get(FORM_RULE_PANEL_PAGE_ID);
        if (pageId != null) {
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("pageId", pageId);
            if (!StringUtils.isBlank((CharSequence)oldserviceTypeId) && (oldserviceTypeId.contains(FIELD_ACTION) || oldserviceTypeId.contains(CONTROL_ACTION) || oldserviceTypeId.contains(FIELD_DISPLAY_FMT_ACTION))) {
                IFormView settingsFormView = SessionManager.getCurrent().getView(pageId);
                TreeView tree = (TreeView)settingsFormView.getControl("treeviewap");
                List selectedStatus = tree.getTreeState().getCheckedNodeIds();
                if (oldserviceTypeId.contains(FIELD_ACTION)) {
                    this.getPageCache().put(FIELD_ACTION, SerializationUtils.toJsonString((Object)selectedStatus));
                } else if (oldserviceTypeId.contains(CONTROL_ACTION)) {
                    this.getPageCache().put(CONTROL_ACTION, SerializationUtils.toJsonString((Object)selectedStatus));
                } else if (oldserviceTypeId.contains(FIELD_DISPLAY_FMT_ACTION)) {
                    this.getPageCache().put(FIELD_DISPLAY_FMT_ACTION, SerializationUtils.toJsonString((Object)selectedStatus));
                }
            }
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            this.getPageCache().remove(FORM_RULE_PANEL_PAGE_ID);
        }
    }

    private List<FormRuleActionType> initServiceTypeItems(String metaType, int serviceType) {
        List formRuleActionTypes = FormRuleActionTypeCache.getAllFormRuleActionTypes();
        ComboEdit comboField = (ComboEdit)this.getControl(KEY_RULE_TYPE);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        ArrayList<FormRuleActionType> currentFormTypes = new ArrayList<FormRuleActionType>(10);
        String controlAp = (String)this.getView().getFormShowParameter().getCustomParam("controlAp");
        for (FormRuleActionType metaData : formRuleActionTypes) {
            if ((serviceType & metaData.getServiceTypes()) == 0 || !metaType.equalsIgnoreCase(metaData.getMetaType())) continue;
            if ("EntryAp".equals(controlAp)) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(Lang.get().toString(), metaData.getDesc()));
                comboItem.setValue(metaData.getId());
                comboItems.add(comboItem);
                currentFormTypes.add(metaData);
                continue;
            }
            String id = metaData.getId();
            if ("SetFieldFmtAction".equals(id) || "DelFieldFmtAction".equals(id) || "SetRowFmtAction".equals(id) || "DelRowFmtAction".equals(id)) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(Lang.get().toString(), metaData.getDesc()));
            comboItem.setValue(metaData.getId());
            comboItems.add(comboItem);
            currentFormTypes.add(metaData);
        }
        comboField.setComboItems(comboItems);
        return currentFormTypes;
    }

    private void initRaiseEventEnable(FormRuleActionType type) {
        this.getView().setEnable(Boolean.valueOf(type.isSupportFieldChanged()), new String[]{KEY_RAISE_EVENT_TYPE_FIELD_CHANGED});
        this.getView().setEnable(Boolean.valueOf(type.isSupportInitialized()), new String[]{KEY_RAISE_EVENT_TYPE_INITIALIZED});
        this.getView().setEnable(Boolean.valueOf(type.isSupportItemAdded()), new String[]{KEY_RAISE_EVENT_TYPE_ITEM_ADDED});
        this.getView().setEnable(Boolean.valueOf(type.isSupportItemRemoved()), new String[]{KEY_RAISE_EVENT_TYPE_ITEM_REMOVED});
        this.getView().setEnable(Boolean.valueOf(type.isSupportItemReset()), new String[]{KEY_RAISE_EVENT_TYPE_ITEM_RESET});
        this.getView().setEnable(Boolean.valueOf(type.isSupportReset()), new String[]{KEY_RAISE_EVENT_TYPE_RESET});
        this.getView().setEnable(Boolean.valueOf(type.isSupportSelectRowChanged()), new String[]{KEY_RAISE_EVENT_TYPE_SELECT_ROW_CHANGED});
    }

    private void initRaiseEventValue(FormRuleActionType type, int raiseEventType) {
        this.getModel().setValue(KEY_RAISE_EVENT_TYPE_FIELD_CHANGED, (Object)(type.isSupportFieldChanged() && (raiseEventType & RaiseEventType.FieldChanged.getValue()) != 0 ? 1 : 0));
        this.getModel().setValue(KEY_RAISE_EVENT_TYPE_INITIALIZED, (Object)(type.isSupportInitialized() && (raiseEventType & RaiseEventType.Initialized.getValue()) != 0 ? 1 : 0));
        this.getModel().setValue(KEY_RAISE_EVENT_TYPE_ITEM_ADDED, (Object)(type.isSupportItemAdded() && (raiseEventType & RaiseEventType.ItemAdded.getValue()) != 0 ? 1 : 0));
        this.getModel().setValue(KEY_RAISE_EVENT_TYPE_ITEM_REMOVED, (Object)(type.isSupportItemRemoved() && (raiseEventType & RaiseEventType.ItemRemoved.getValue()) != 0 ? 1 : 0));
        this.getModel().setValue(KEY_RAISE_EVENT_TYPE_ITEM_RESET, (Object)(type.isSupportItemReset() && (raiseEventType & RaiseEventType.ItemReset.getValue()) != 0 ? 1 : 0));
        this.getModel().setValue(KEY_RAISE_EVENT_TYPE_RESET, (Object)(type.isSupportReset() && (raiseEventType & RaiseEventType.Reset.getValue()) != 0 ? 1 : 0));
        this.getModel().setValue(KEY_RAISE_EVENT_TYPE_SELECT_ROW_CHANGED, (Object)(type.isSupportSelectRowChanged() && (raiseEventType & RaiseEventType.SelectRowChanged.getValue()) != 0 ? 1 : 0));
    }

    private int getRaiseEventValue(FormRuleActionType type) {
        int raiseEventType = 255;
        boolean isFieldChanged = (Boolean)this.getModel().getValue(KEY_RAISE_EVENT_TYPE_FIELD_CHANGED);
        raiseEventType = type.isSupportFieldChanged() && isFieldChanged ? raiseEventType : raiseEventType - RaiseEventType.FieldChanged.getValue();
        boolean isLoad = (Boolean)this.getModel().getValue(KEY_RAISE_EVENT_TYPE_INITIALIZED);
        raiseEventType = type.isSupportInitialized() && isLoad ? raiseEventType : raiseEventType - RaiseEventType.Initialized.getValue();
        boolean isAdd = (Boolean)this.getModel().getValue(KEY_RAISE_EVENT_TYPE_ITEM_ADDED);
        raiseEventType = type.isSupportItemAdded() && isAdd ? raiseEventType : raiseEventType - RaiseEventType.ItemAdded.getValue();
        boolean isItemreset = (Boolean)this.getModel().getValue(KEY_RAISE_EVENT_TYPE_ITEM_RESET);
        raiseEventType = type.isSupportItemReset() && isItemreset ? raiseEventType : raiseEventType - RaiseEventType.ItemReset.getValue();
        boolean isRemove = (Boolean)this.getModel().getValue(KEY_RAISE_EVENT_TYPE_ITEM_REMOVED);
        raiseEventType = type.isSupportItemRemoved() && isRemove ? raiseEventType : raiseEventType - RaiseEventType.ItemRemoved.getValue();
        boolean isReset = (Boolean)this.getModel().getValue(KEY_RAISE_EVENT_TYPE_RESET);
        raiseEventType = type.isSupportReset() && isReset ? raiseEventType : raiseEventType - RaiseEventType.Reset.getValue();
        boolean isSelectedrowchange = (Boolean)this.getModel().getValue(KEY_RAISE_EVENT_TYPE_SELECT_ROW_CHANGED);
        raiseEventType = type.isSupportSelectRowChanged() && isSelectedrowchange ? raiseEventType : raiseEventType - RaiseEventType.SelectRowChanged.getValue();
        return raiseEventType;
    }

    private IBizRuleEditor getBizRuleEditor(IFormView editForm) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)editForm.getService(FormViewPluginProxy.class);
        IBizRuleEditor bizRuleEditor = null;
        for (IFormPlugin plugin : pluginProxy.getPlugIns()) {
            if (!(plugin instanceof IBizRuleEditor)) continue;
            bizRuleEditor = (IBizRuleEditor)plugin;
            break;
        }
        return bizRuleEditor;
    }
}

