/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class TakeValueActionPlugin
extends AbstractFormPlugin {
    private static final String ENTRYKEY = "entryentity";
    private static final String TARGET_FIELD = "targetfield";
    private static final String SRC_FIELD = "srcfield";
    private static final String IDE_SETEQUTION = "ide_seteqution";
    private static final String SRC_FIELD_NAME = "srcfieldname";
    private static final String TARGET_FIELD_NAME = "targetfieldname";
    private static final String EXPRESSION = "expression";
    private static final String CONTEXT = "context";
    private static final String REF_PRO = "refPro";
    private static final String IS_TARGET = "isTarget";
    private static final String SELECT_CALL_BACK = "selectCallBack";

    public void initialize() {
        this.addClickListeners(new String[]{"btnadd", "btndel", TARGET_FIELD, SRC_FIELD});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
        if (value != null) {
            Map map = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            List expression = (List)map.get("Expression");
            List fieldName = (List)map.get("FieldName");
            if (fieldName != null && !fieldName.isEmpty()) {
                if (IDE_SETEQUTION.equals(this.getView().getFormShowParameter().getFormId())) {
                    this.getModel().setValue("onlyemptyrow", ((Map)fieldName.get(0)).get("OnlyEmptyRow"));
                }
                IDataModel model = this.getModel();
                model.batchCreateNewEntryRow(ENTRYKEY, fieldName.size());
                int i = 0;
                for (Map list : fieldName) {
                    model.setValue(SRC_FIELD_NAME, list.get("SrcFieldName"), i);
                    model.setValue(TARGET_FIELD_NAME, list.get("TargetFieldName"), i);
                    ++i;
                }
            }
            if (expression != null && !expression.isEmpty()) {
                this.getModel().setValue(EXPRESSION, (Object)SerializationUtils.toJsonString((Object)expression));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("btnadd".equals(evt.getItemKey())) {
            this.addOperation();
        } else if ("btndel".equals(evt.getItemKey())) {
            this.deleteOperation();
        }
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "targetfield": {
                this.showTargetFieldForm();
                break;
            }
            case "srcfield": {
                this.showSrcFieldForm();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        ArrayList entryList = new ArrayList();
        DynamicObjectCollection col = this.getModel().getEntryEntity(ENTRYKEY);
        if (col == null || col.isEmpty()) {
            return;
        }
        for (DynamicObject entryMap : this.getModel().getEntryEntity(ENTRYKEY)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("TargetFieldName", entryMap.get(TARGET_FIELD_NAME));
            map.put("SrcFieldName", entryMap.get(SRC_FIELD_NAME));
            if (IDE_SETEQUTION.equals(this.getView().getFormShowParameter().getFormId())) {
                map.put("OnlyEmptyRow", this.getModel().getValue("onlyemptyrow"));
            }
            map.put("_Type_", "TakeValueId");
            entryList.add(map);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldName", SerializationUtils.toJsonString(entryList));
        map.put("Expression", this.getModel().getValue(EXPRESSION));
        this.getView().returnDataToParent(map);
    }

    private void showSrcFieldForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_takevalueshowfield");
        parameter.setCustomParam(CONTEXT, this.getView().getFormShowParameter().getCustomParam(CONTEXT));
        parameter.setCustomParam("itemId", this.getView().getFormShowParameter().getCustomParam("itemId"));
        parameter.setCustomParam("isEntityDesign", this.getView().getFormShowParameter().getCustomParam("isEntityDesign"));
        if (IDE_SETEQUTION.equals(this.getView().getFormShowParameter().getFormId())) {
            parameter.setCustomParam(REF_PRO, (Object)false);
        } else {
            parameter.setCustomParam(REF_PRO, (Object)true);
        }
        parameter.setCustomParam(IS_TARGET, (Object)false);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, SELECT_CALL_BACK);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void showTargetFieldForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_takevalueshowfield");
        parameter.setCustomParam(CONTEXT, this.getView().getFormShowParameter().getCustomParam(CONTEXT));
        parameter.setCustomParam(REF_PRO, (Object)false);
        parameter.setCustomParam(IS_TARGET, (Object)true);
        parameter.setCustomParam("itemId", this.getView().getFormShowParameter().getCustomParam("itemId"));
        parameter.setCustomParam("isEntityDesign", this.getView().getFormShowParameter().getCustomParam("isEntityDesign"));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, SELECT_CALL_BACK);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void deleteOperation() {
        int i = this.getModel().getEntryCurrentRowIndex(ENTRYKEY);
        if (i == -1) {
            return;
        }
        this.getModel().deleteEntryRow(ENTRYKEY, i);
        String expression = (String)this.getModel().getValue(EXPRESSION);
        if (StringUtils.isBlank((CharSequence)expression)) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TakeValueActionPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        List list = (List)SerializationUtils.fromJsonString((String)expression, List.class);
        list.remove(i);
        this.getModel().setValue(EXPRESSION, (Object)SerializationUtils.toJsonString((Object)list));
    }

    private void addOperation() {
        String targetfield = (String)this.getModel().getValue(TARGET_FIELD);
        String referfield = (String)this.getModel().getValue(SRC_FIELD);
        if (StringUtils.isBlank((CharSequence)targetfield) || StringUtils.isBlank((CharSequence)referfield)) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u5b57\u6bb5\u548c\u76ee\u6807\u5b57\u6bb5\u5747\u9700\u9009\u503c\u3002", (String)"TakeValueActionPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        int i = this.getModel().createNewEntryRow(ENTRYKEY);
        this.getModel().setValue(TARGET_FIELD_NAME, (Object)targetfield, i);
        this.getModel().setValue(SRC_FIELD_NAME, (Object)referfield, i);
        List list = StringUtils.isBlank((Object)this.getModel().getValue(EXPRESSION)) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)((String)this.getModel().getValue(EXPRESSION)), List.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("_Type_", "TakeValueId");
        map.put("TargetField", this.getPageCache().get(TARGET_FIELD));
        map.put("SrcField", this.getPageCache().get(SRC_FIELD));
        list.add(map);
        this.getModel().setValue(EXPRESSION, (Object)SerializationUtils.toJsonString(list));
        this.getModel().setValue(SRC_FIELD, null);
        this.getModel().setValue(TARGET_FIELD, null);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (SELECT_CALL_BACK.equals(e.getActionId()) && e.getReturnData() != null) {
            Map nodeMap = (Map)e.getReturnData();
            boolean isTarget = (Boolean)nodeMap.get(IS_TARGET);
            if (isTarget) {
                this.getModel().setValue(TARGET_FIELD, nodeMap.get("text"));
                this.getPageCache().put(TARGET_FIELD, (String)nodeMap.get("id"));
            } else {
                this.getModel().setValue(SRC_FIELD, nodeMap.get("text"));
                this.getPageCache().put(SRC_FIELD, (String)nodeMap.get("id"));
            }
        }
    }
}

