/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

public class TakeValueShowFieldPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String F_FIELD_TREE = "FFieldTree";
    private static final String REF_PRO = "refPro";
    private static final String NODE_MAP = "nodeMap";
    private static final String IS_TARGET = "isTarget";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        TreeView tree = (TreeView)this.getView().getControl(F_FIELD_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        boolean isRefPro = (Boolean)this.getView().getFormShowParameter().getCustomParam(REF_PRO);
        PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        List<Object> context = new ArrayList(10);
        String itemId = "";
        boolean isEntityDesign = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("isEntityDesign"));
        if (isEntityDesign) {
            itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
            context = (List)this.getView().getFormShowParameter().getCustomParam("context");
        } else {
            itemId = propertyEditHelper.getItemId(this.getView());
            context = propertyEditHelper.getEntityMeta(this.getView());
        }
        EntityMetadata entityMeta = FormTreeBuilder.deserializeEntityMetadata(context);
        EntityItem item = entityMeta.getItemById(itemId);
        if (item instanceof MainEntity) {
            option.setOnlyBillHead(true);
        } else {
            option.setCurrentEntity(itemId);
            option.setIncludeParentEntity(false);
            option.setIncludeChildEntity(false);
        }
        if (!isRefPro) {
            option.setIncludeBDRefProp(false);
            option.addInvalidClassTypes(BasedataPropField.class);
            TreeNode root = FormTreeBuilder.buildEntityFieldsTree((EntityMetadata)entityMeta, (EntityFieldTreeBuildOption)option);
            root.setIsOpened(true);
            Map parameter = (Map)this.getView().getFormShowParameter().getCustomParams().get("Parameter");
            Map fields = null;
            if (parameter != null) {
                fields = (Map)parameter.get("Fields");
            }
            TreeView tree = (TreeView)this.getView().getControl(F_FIELD_TREE);
            tree.addNode(root);
            if (fields != null && !fields.isEmpty()) {
                List fieldList = (List)fields.get("fields");
                ArrayList checkNodes = new ArrayList();
                fieldList.forEach(id -> checkNodes.add(root.getTreeNode(id, 16)));
                tree.checkNodes(checkNodes);
            }
            this.getPageCache().put(F_FIELD_TREE, SerializationUtils.toJsonString((Object)root));
        } else {
            option.addMatchedClassTypes(BasedataField.class);
            option.setIncludeBDRefProp(true);
            option.addMatchedClassTypes(DynamicProperty.class);
            TreeNode root = FormTreeBuilder.buildEntityFieldsTree((EntityMetadata)entityMeta, (EntityFieldTreeBuildOption)option);
            TreeView tree = (TreeView)this.getView().getControl(F_FIELD_TREE);
            tree.addNode(root);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.close();
                break;
            }
            case "btncancel": {
                this.cancel();
                break;
            }
        }
    }

    private void close() {
        if (this.getPageCache().get(NODE_MAP) != null) {
            this.getView().returnDataToParent(SerializationUtils.fromJsonString((String)this.getPageCache().get(NODE_MAP), Map.class));
        }
        this.getView().close();
    }

    private void cancel() {
        this.getView().close();
    }

    public void treeNodeClick(TreeNodeEvent event) {
        if (StringUtils.isNotBlank((Object)event.getNodeId())) {
            TreeView tree = (TreeView)this.getView().getControl(F_FIELD_TREE);
            Map nodeMap = tree.getTreeState().getFocusNode();
            nodeMap.put("isRefPro", this.getView().getFormShowParameter().getCustomParam(REF_PRO));
            nodeMap.put(IS_TARGET, this.getView().getFormShowParameter().getCustomParam(IS_TARGET));
            this.getPageCache().put(NODE_MAP, SerializationUtils.toJsonString((Object)nodeMap));
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent event) {
        if (StringUtils.isNotBlank((Object)event.getNodeId())) {
            TreeView tree = (TreeView)this.getView().getControl(F_FIELD_TREE);
            Map nodeMap = tree.getTreeState().getFocusNode();
            nodeMap.put("isRefPro", this.getView().getFormShowParameter().getCustomParam(REF_PRO));
            nodeMap.put(IS_TARGET, this.getView().getFormShowParameter().getCustomParam(IS_TARGET));
            this.getView().returnDataToParent((Object)nodeMap);
            this.getView().close();
        }
    }
}

