/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.list.BillListAp;
import kd.bos.metadata.list.DecimalListColumnAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListColumnGroupAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.metadata.list.MergeListColumnAp;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

public class MulCurrencySetPlugin
extends AbstractPropertyPlugin {
    private static final String GRIDVIEW = "gridview";
    private static final String CONTEXT = "context";
    private static final String ENTRYENTITY = "entryEntity";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        PropertyEditHelper helper = new PropertyEditHelper();
        List<ControlAp<?>> billListColumnAps = this.getBillListColumnAp(helper);
        List context = (List)helper.getParamValue(this.getView(), CONTEXT);
        Object entityId = ((Map)((List)context.get(0)).get(0)).get("EntityId");
        if (StringUtils.isBlank(entityId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed1\u5b9a\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MulCurrencySetPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)((String)entityId), (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            entityMetadata = FormTreeBuilder.deserializeEntityMetadata(helper.getEntityMeta(this.getView()));
        }
        List<ControlAp<?>> controlAps = this.filterField(billListColumnAps, entityMetadata);
        this.createEntryEntity(controlAps, entityMetadata);
    }

    private void createEntryEntity(List<ControlAp<?>> controlAps, EntityMetadata entityMetadata) {
        Map valueMap;
        List mulCurrencyFields;
        if (controlAps.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, controlAps.size());
        HashMap<String, Boolean> fieldNamesMap = new HashMap<String, Boolean>(16);
        if (this.getView().getFormShowParameter().getCustomParams().get(VALUE) != null && (mulCurrencyFields = (List)(valueMap = (Map)this.getView().getFormShowParameter().getCustomParams().get(VALUE)).get("MulCurrencyFields")) != null) {
            for (Map mulCurrencyField : mulCurrencyFields) {
                fieldNamesMap.put(mulCurrencyField.get("FieldName").toString(), mulCurrencyField.get("Enabled") != null ? Boolean.parseBoolean(mulCurrencyField.get("Enabled").toString()) : false);
            }
        }
        int i = 0;
        for (ControlAp<?> controlAp : controlAps) {
            if (!(controlAp instanceof DecimalListColumnAp)) continue;
            Field filed = entityMetadata.getFieldByKey(((DecimalListColumnAp)controlAp).getListFieldId());
            this.getModel().setValue("fieldkey", (Object)filed.getKey(), i);
            this.getModel().setValue("fieldname", (Object)String.format("%s(%s)", filed.getName(), filed.getKey()), i);
            this.getModel().setValue("entityname", (Object)(StringUtils.isBlank((CharSequence)filed.getParentId()) ? ResManager.loadKDString((String)"\u8868\u5934", (String)"MulCurrencySetPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]) : (entityMetadata.getItemById(filed.getParentId()) instanceof BillEntity ? ResManager.loadKDString((String)"\u8868\u5934", (String)"MulCurrencySetPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]) : entityMetadata.getItemById(filed.getParentId()).getName())), i);
            Boolean checkedObj = (Boolean)fieldNamesMap.get(filed.getKey());
            boolean checked = fieldNamesMap.isEmpty() ? true : (checkedObj == null ? true : checkedObj);
            this.getModel().setValue("checked", (Object)checked, i);
            ++i;
        }
    }

    private List<ControlAp<?>> getBillListColumnAp(PropertyEditHelper helper) {
        List context = (List)helper.getParamValue(this.getView(), CONTEXT);
        ArrayList billListColumnAp = new ArrayList();
        if (context != null) {
            FormMetadata listMetadata = FormTreeBuilder.deserialzeFormMetadata((List)((List)context.get(1)));
            listMetadata.createIndex();
            List billlistapitem = (List)context.get(0);
            BillListAp billListAp = (BillListAp)listMetadata.getItem(((Map)billlistapitem.get(0)).get("Id").toString());
            String gridviewId = null;
            for (ControlAp item : billListAp.getItems()) {
                if (!(item instanceof ListGridViewAp)) continue;
                gridviewId = ((ControlAp)billListAp.getItems().get(0)).getId();
            }
            for (ControlAp item : listMetadata.getItems()) {
                if (!item.getParentId().equals(gridviewId)) continue;
                billListColumnAp.add(item);
            }
        }
        return billListColumnAp;
    }

    private List<ControlAp<?>> filterField(List<ControlAp<?>> billListColumnAps, EntityMetadata entityMetadata) {
        ArrayList amountFields = new ArrayList();
        for (ControlAp<?> ap : billListColumnAps) {
            if (ap instanceof MergeListColumnAp || ap instanceof ListColumnGroupAp) {
                this.traverseGetSubControlAp(ap, amountFields);
                continue;
            }
            if (!(ap instanceof DecimalListColumnAp) || !(entityMetadata.getFieldByKey(((DecimalListColumnAp)ap).getListFieldId()) instanceof AmountField)) continue;
            amountFields.removeIf(item -> ((ListColumnAp)ap).getListFieldId().equals(((ListColumnAp)item).getListFieldId()));
            amountFields.add(ap);
        }
        return amountFields;
    }

    private void traverseGetSubControlAp(ControlAp<?> ap, List<ControlAp<?>> canSortField) {
        List subControlAps = ((ContainerAp)ap).getItems();
        for (ControlAp subControlAp : subControlAps) {
            if (subControlAp instanceof MergeListColumnAp || subControlAp instanceof ListColumnGroupAp) {
                this.traverseGetSubControlAp(subControlAp, canSortField);
                continue;
            }
            if (!(subControlAp instanceof DecimalListColumnAp)) continue;
            canSortField.removeIf(item -> ((ListColumnAp)subControlAp).getListFieldId().equals(((ListColumnAp)item).getListFieldId()));
            canSortField.add(subControlAp);
        }
    }

    private Map<String, Object> createSummaryFieldIds() {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
        valueMap.put("_Type_", "MulCurrencyFields");
        ArrayList summaryFieldIdList = new ArrayList(10);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            HashMap<String, Object> subValueMap = new HashMap<String, Object>(16);
            subValueMap.put("_Type_", "MulCurrencyField");
            subValueMap.put("FieldName", dynamicObject.get("fieldkey"));
            subValueMap.put("Enabled", dynamicObject.getBoolean("checked"));
            summaryFieldIdList.add(subValueMap);
        }
        valueMap.put("MulCurrencyFields", summaryFieldIdList);
        return valueMap;
    }

    private Map<String, Object> getReturnPara() {
        HashMap<String, Object> para = new HashMap<String, Object>(4);
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
        return para;
    }

    @Override
    protected void returnData() {
        Map<String, Object> returnPara = this.getReturnPara();
        returnPara.put(VALUE, this.createSummaryFieldIds());
        this.getView().returnDataToParent(returnPara);
        this.getView().close();
    }
}

