/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.opbizrule;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.bizrule.OpBizRuleType;
import kd.bos.entity.operate.bizrule.OpBizRuleTypeLoader;
import kd.bos.entity.operate.bizrule.OpBizRuleTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.operation.IOpBizRuleParameterEdit;
import kd.bos.metadata.entity.operation.OpBizRuleElement;

public class OpBizRuleEditPlugin
extends AbstractFormPlugin {
    private static final String SERVICE_TYPE = "fruletype";
    private static final String SERVICE_TYPENAME = "fruletypename";
    private static final String SERVICE_KEY = "frulekey";
    private static final String SERVICE_NAME = "frulename";
    private static final String SERVICE_PRECON = "fprecondition";
    private static final String SERVICE_PRECON_DESC = "fpreconditiondesc";
    private static final String SERVICE_DESC = "fdesc";
    private static final String BTN_OK = "btnok";
    private static final String OPEN_FORM_ZONE = "frulepanel";
    private static final String LIST_FORMID = "ide_opbizruleselectlist";
    private static final String SET_PAGE_ID = "ServiceType_PageId";
    private static final String CLEAR_PRECONDITION = "btnclearprecond";
    private static final String SERVICE = "service";
    private static final String META_CONTEXT = "MetaContext";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private Map<String, OpBizRuleType> opBizRuleTypes = null;

    private Map<String, OpBizRuleType> getOpBizRuleTypes() {
        if (this.opBizRuleTypes == null) {
            this.opBizRuleTypes = new HashMap<String, OpBizRuleType>(16);
            OpBizRuleTypes types = OpBizRuleTypeLoader.load();
            for (OpBizRuleType type : types.getRuleTypes()) {
                this.opBizRuleTypes.put(type.getId(), type);
            }
        }
        return this.opBizRuleTypes;
    }

    private OpBizRuleElement getOriOpBizRule() {
        Object serviceObj = this.getView().getFormShowParameter().getCustomParam(SERVICE);
        if (serviceObj == null) {
            return null;
        }
        Map ruleValues = (Map)SerializationUtils.fromJsonString((String)serviceObj.toString(), Map.class);
        if (ruleValues == null) {
            return null;
        }
        OpBizRuleElement opBizRule = new OpBizRuleElement();
        opBizRule.setId((String)ruleValues.get("Id"));
        opBizRule.setRuleType((String)ruleValues.get("RuleType"));
        opBizRule.setKey((String)ruleValues.get("Key"));
        opBizRule.setName(new LocaleString((String)ruleValues.get("Name")));
        opBizRule.setPrecondition((String)ruleValues.get("Precondition"));
        opBizRule.setPreconditionDesc(new LocaleString((String)ruleValues.get("PreconditionDesc")));
        opBizRule.setParameter((String)ruleValues.get("Parameter"));
        return opBizRule;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{SERVICE_TYPENAME, SERVICE_PRECON_DESC, BTN_OK, CLEAR_PRECONDITION});
    }

    public void afterCreateNewData(EventObject evt) {
        OpBizRuleElement opBizRule;
        String isLock = (String)this.getView().getFormShowParameter().getCustomParam("isLock");
        if ("true".equals(isLock)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_OK});
        }
        if ((opBizRule = this.getOriOpBizRule()) == null) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(StringUtils.isBlank((CharSequence)opBizRule.getRuleType())), new String[]{SERVICE_TYPENAME});
        IDataModel model = this.getModel();
        String ruleTypeId = opBizRule.getRuleType();
        OpBizRuleType ruleType = null;
        if (StringUtils.isNotBlank((CharSequence)ruleTypeId)) {
            ruleType = this.getOpBizRuleTypes().get(ruleTypeId);
        }
        model.setValue(SERVICE_TYPE, (Object)ruleTypeId);
        model.setValue(SERVICE_TYPENAME, (Object)(ruleType == null || ruleType.getName() == null ? ruleTypeId : ruleType.getName().toString()));
        model.setValue(SERVICE_DESC, (Object)(ruleType == null || ruleType.getDesc() == null ? ruleTypeId : ruleType.getDesc().toString()));
        model.setValue(SERVICE_KEY, (Object)opBizRule.getKey());
        model.setValue(SERVICE_NAME, (Object)(opBizRule.getName() == null ? "" : opBizRule.getName().toString()));
        String preCondition = opBizRule.getPrecondition();
        if (StringUtils.isBlank((Object)preCondition)) {
            model.setValue(SERVICE_PRECON, (Object)"");
            model.setValue(SERVICE_PRECON_DESC, (Object)"");
        } else {
            Map preCondMap = (Map)SerializationUtils.fromJsonString((String)preCondition, Map.class);
            model.setValue(SERVICE_PRECON, (Object)preCondition);
            model.setValue(SERVICE_PRECON_DESC, preCondMap.get("RuleDescription"));
        }
        if (ruleType != null) {
            this.showServiceOption(ruleType.getSettingFormId(), opBizRule.getParameter());
        }
    }

    public void afterBindData(EventObject e) {
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        switch (ctl.getKey()) {
            case "fruletypename": {
                FormShowParameter param = new FormShowParameter();
                param.setFormId(LIST_FORMID);
                param.getOpenStyle().setShowType(ShowType.Modal);
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectOpService"));
                param.setCustomParam("RuleTypeId", this.getModel().getValue(SERVICE_TYPE));
                this.getView().showForm(param);
                break;
            }
            case "fpreconditiondesc": {
                FormShowParameter showPreConditionPara = new FormShowParameter();
                showPreConditionPara.getOpenStyle().setShowType(ShowType.Modal);
                showPreConditionPara.setFormId("ide_preconditiondesign");
                List context = (List)this.getView().getFormShowParameter().getCustomParams().get(META_CONTEXT);
                showPreConditionPara.setCustomParam("context", (Object)context);
                Object preCondition = this.getModel().getValue("FPreCondition");
                showPreConditionPara.setCustomParam("value", StringUtils.isNotBlank((Object)preCondition) ? SerializationUtils.fromJsonString((String)((String)preCondition), Map.class) : new HashMap());
                showPreConditionPara.setCustomParam("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
                showPreConditionPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setPreCondition"));
                this.getView().showForm(showPreConditionPara);
                break;
            }
            case "btnok": {
                this.returnData();
                break;
            }
            case "btnclearprecond": {
                this.getModel().setValue(SERVICE_PRECON, (Object)"");
                this.getModel().setValue(SERVICE_PRECON_DESC, (Object)"");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        Object data = e.getReturnData();
        IDataModel model = this.getModel();
        if (data instanceof OpBizRuleType) {
            OpBizRuleType type = (OpBizRuleType)data;
            model.setValue(SERVICE_TYPE, (Object)type.getId());
            model.setValue(SERVICE_TYPENAME, (Object)type.getName());
            model.setValue(SERVICE_KEY, (Object)type.getId());
            model.setValue(SERVICE_NAME, (Object)type.getName());
            model.setValue(SERVICE_DESC, (Object)type.getDesc().getLocaleValue());
            this.showServiceOption(type.getSettingFormId(), null);
        } else {
            Map rule = (Map)data;
            model.setValue(SERVICE_PRECON, (Object)SerializationUtils.toJsonString((Object)data));
            model.setValue(SERVICE_PRECON_DESC, rule.get("RuleDescription"));
        }
    }

    private void showServiceOption(String formId, Object parameter) {
        String pageId = this.getPageCache().get(SET_PAGE_ID);
        if (pageId != null) {
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("pageId", pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            this.getPageCache().remove(SET_PAGE_ID);
        }
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get(META_CONTEXT);
            FormShowParameter paraSettings = new FormShowParameter();
            paraSettings.getOpenStyle().setShowType(ShowType.InContainer);
            paraSettings.getOpenStyle().setTargetKey(OPEN_FORM_ZONE);
            paraSettings.setFormId(formId);
            paraSettings.setCustomParam(META_CONTEXT, (Object)formContext);
            paraSettings.setCustomParam("Parameter", parameter);
            paraSettings.setCustomParam(SERVICE, this.getView().getFormShowParameter().getCustomParam(SERVICE));
            this.getView().showForm(paraSettings);
            this.getPageCache().put(SET_PAGE_ID, paraSettings.getPageId());
        }
    }

    private void returnData() {
        if (this.getModel().getValue(SERVICE_TYPE) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u670d\u52a1\u7c7b\u578b\u3002", (String)"OpBizRuleEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (this.getModel().getValue(SERVICE_NAME) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OpBizRuleEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        OpBizRuleElement opBizRule = this.getOriOpBizRule();
        if (opBizRule == null) {
            opBizRule = new OpBizRuleElement();
        }
        if (StringUtils.isBlank((CharSequence)opBizRule.getId())) {
            opBizRule.setId(Uuid16.create().toString());
        }
        opBizRule.setRuleType((String)this.getModel().getValue(SERVICE_TYPE));
        opBizRule.setKey((String)this.getModel().getValue(SERVICE_KEY));
        opBizRule.setName(new LocaleString((String)this.getModel().getValue(SERVICE_NAME)));
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null && StringUtils.equalsIgnoreCase((CharSequence)parentView.getEntityId(), (CharSequence)"ide_opbizrulelist")) {
            DynamicObjectCollection ruleRows = parentView.getModel().getEntryEntity("entryentity");
            for (DynamicObject ruleRow : ruleRows) {
                String service;
                String key = ruleRow.getString("fkey");
                if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)opBizRule.getKey()) || !StringUtils.isNotBlank((CharSequence)(service = ruleRow.getString("fservice")))) continue;
                Map ruleValues = (Map)SerializationUtils.fromJsonString((String)service, Map.class);
                if (StringUtils.equalsIgnoreCase((CharSequence)opBizRule.getId(), (CharSequence)((String)ruleValues.get("Id")))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u6807\u8bc6\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"OpBizRuleEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        opBizRule.setPrecondition((String)this.getModel().getValue(SERVICE_PRECON));
        opBizRule.setPreconditionDesc(new LocaleString((String)this.getModel().getValue(SERVICE_PRECON_DESC)));
        String pageId = this.getPageCache().get(SET_PAGE_ID);
        String parameter = null;
        if (pageId != null) {
            IFormView settingsFormView = this.getView().getView(pageId);
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)settingsFormView.getService(FormViewPluginProxy.class);
            for (IFormPlugin plugin : pluginProxy.getPlugIns()) {
                if (!(plugin instanceof IOpBizRuleParameterEdit)) continue;
                IOpBizRuleParameterEdit edit = (IOpBizRuleParameterEdit)plugin;
                if (!edit.checkParameter()) {
                    this.getView().sendFormAction(settingsFormView);
                    return;
                }
                parameter = edit.getParameter();
            }
        }
        opBizRule.setParameter(parameter);
        this.getView().returnDataToParent((Object)opBizRule);
        this.getView().close();
    }
}

