/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.opbizrule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.operation.OpBizRuleElement;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;

public class OpBizRuleListPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_KEY = "EntryEntity";
    private static final String TOOL_BAR_KEY = "advcontoolbarap";
    private static final String BTN_OK = "btnok";
    private static final String BTN_ADD = "btnadd";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndel";
    private static final String RULE_TYPE = "ruletypeid";
    private static final String RULE_KEY = "fkey";
    private static final String RULE_NAME = "fname";
    private static final String RULE = "fservice";
    private static final String RULE_ENABLE = "fenabled";
    private static final String META_TYPE = "metaType";
    private static final String META_CONTEXT = "MetaContext";
    private static final String ENTRY_IS_INHERIT = "isinherit";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, BTN_ADD, BTN_EDIT, BTN_DELETE});
        this.addItemClickListeners(new String[]{TOOL_BAR_KEY});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String lockType = this.getWebServiceRulesExtensible();
        if ("lock".equals(lockType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_ADD, BTN_EDIT, BTN_DELETE});
        } else if ("speciallock".equals(lockType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_EDIT, BTN_DELETE});
        }
        Object rulesObj = this.getView().getFormShowParameter().getCustomParam("OpBizRules");
        if (StringUtils.isNotBlank((Object)rulesObj)) {
            List isvList = DesignerUtils.ISV_LIST;
            List rules = SerializationUtils.fromJsonStringToList((String)rulesObj.toString(), Map.class);
            if (rules != null && rules.size() > 0) {
                IDataModel model = this.getModel();
                int[] rowKeys = model.batchCreateNewEntryRow(ENTRY_KEY, rules.size());
                int i = 0;
                for (Map rule : rules) {
                    model.setValue(RULE_ENABLE, rule.get("Enable"), rowKeys[i]);
                    model.setValue(RULE_TYPE, rule.get("RuleType"), rowKeys[i]);
                    model.setValue(RULE_KEY, rule.get("Key"), rowKeys[i]);
                    model.setValue(RULE_NAME, rule.get("Name"), rowKeys[i]);
                    model.setValue(RULE, (Object)SerializationUtils.toJsonString((Object)rule), rowKeys[i]);
                    DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
                    boolean hasIsInheritProp = doc.getDynamicObjectType().getProperties().containsKey((Object)ENTRY_IS_INHERIT);
                    if (hasIsInheritProp) {
                        Object obj = rule.get("IsvFlag");
                        if (obj != null) {
                            String ruleIsv = String.valueOf(obj);
                            String billIsv = (String)this.getView().getFormShowParameter().getCustomParam("billIsv");
                            boolean inherit = isvList.contains(ruleIsv) && !StringUtils.equals((CharSequence)ruleIsv, (CharSequence)billIsv);
                            model.setValue(ENTRY_IS_INHERIT, (Object)inherit, rowKeys[i]);
                            if (inherit && ("lock".equals(lockType) || "speciallock".equals(lockType))) {
                                this.getView().setEnable(Boolean.FALSE, rowKeys[i], new String[]{RULE_ENABLE});
                            }
                        } else {
                            model.setValue(ENTRY_IS_INHERIT, (Object)false, rowKeys[i]);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowKey = grid.getEntryState().getFocusRow();
        switch (key) {
            case "btnadd": {
                FormShowParameter param = new FormShowParameter();
                param.getOpenStyle().setShowType(ShowType.Modal);
                param.setFormId("ide_opbizruleedit");
                param.setCustomParam(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
                param.setCustomParam(META_CONTEXT, (Object)((List)this.getView().getFormShowParameter().getCustomParams().get(META_CONTEXT)));
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newOpRule"));
                this.getView().showForm(param);
                break;
            }
            case "btnedit": {
                this.editOpBizRule(rowKey, "");
                break;
            }
            case "btndel": {
                if (rowKey >= 0) {
                    this.getModel().deleteEntryRow(ENTRY_KEY, rowKey);
                    if (rowKey - 1 < 0) break;
                    RowClickEvent rowClickEvent = new RowClickEvent((Object)this, rowKey - 1);
                    this.entryRowClick(rowClickEvent);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u79cd\u670d\u52a1\u3002", (String)"OpBizRuleListPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        if (ctl.getKey().equals(BTN_OK)) {
            this.returnData();
        }
    }

    private void returnData() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRY_KEY);
        ArrayList<Map> rules = new ArrayList<Map>();
        for (DynamicObject row : rows) {
            Map rule = (Map)SerializationUtils.fromJsonString((String)((String)row.get(RULE)), Map.class);
            rule.put("Enable", row.get(RULE_ENABLE));
            rules.add(rule);
        }
        this.getView().returnDataToParent(rules);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        OpBizRuleElement rule = (OpBizRuleElement)e.getReturnData();
        IDataModel model = this.getModel();
        int rowKey = -1;
        if ("newOpRule".equals(e.getActionId())) {
            rowKey = model.createNewEntryRow(ENTRY_KEY);
        } else if ("editOpRule".equals(e.getActionId())) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
            rowKey = grid.getEntryState().getFocusRow();
        }
        if (rowKey >= 0) {
            model.setValue(RULE_TYPE, (Object)rule.getRuleType(), rowKey);
            model.setValue(RULE_KEY, (Object)rule.getKey(), rowKey);
            model.setValue(RULE_NAME, (Object)rule.getName(), rowKey);
            model.setValue(RULE, (Object)new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, new ArrayList())).serializeToString((Object)rule, null), rowKey);
            model.setValue(ENTRY_IS_INHERIT, (Object)false, rowKey);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        boolean a;
        if (evt.getRow() < 0) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_ADD, BTN_EDIT, BTN_DELETE});
        int index = evt.getRow();
        Object value = this.getModel().getValue(ENTRY_IS_INHERIT, index);
        boolean bl = a = value != null && (Boolean)value != false;
        if (a) {
            String lockType = this.getWebServiceRulesExtensible();
            if ("speciallock".equals(lockType)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_EDIT, BTN_DELETE});
            } else if ("lock".equals(lockType)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ADD, BTN_EDIT, BTN_DELETE});
            }
        }
    }

    private String getWebServiceRulesExtensible() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        String opId = (String)this.getView().getFormShowParameter().getCustomParam("opId");
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return "";
        }
        ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((String)entityId, (String)"Operation", (String)modelType, (String)opId, (String)"serverservice");
        return lockType.toString();
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        String lockType;
        int index = evt.getRow();
        Object value = this.getModel().getValue(ENTRY_IS_INHERIT, index);
        boolean a = value != null && (Boolean)value != false;
        String isLock = "false";
        if (a && ("speciallock".equals(lockType = this.getWebServiceRulesExtensible()) || "lock".equals(lockType))) {
            isLock = "true";
        }
        this.editOpBizRule(index, isLock);
    }

    private void editOpBizRule(int rowKey, String isLock) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("ide_opbizruleedit");
        if (rowKey >= 0) {
            IDataModel model = this.getModel();
            param.setCustomParam("service", (Object)model.getValue(RULE, rowKey).toString());
            param.setCustomParam(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            param.setCustomParam(META_CONTEXT, (Object)((List)this.getView().getFormShowParameter().getCustomParams().get(META_CONTEXT)));
            param.setCustomParam("isLock", (Object)isLock);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editOpRule"));
            this.getView().showForm(param);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u79cd\u670d\u52a1\u3002", (String)"OpBizRuleListPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }
}

