/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.opbizrule;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.bizrule.OpBizRuleType;
import kd.bos.entity.operate.bizrule.OpBizRuleTypeLoader;
import kd.bos.entity.operate.bizrule.OpBizRuleTypes;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class OpBizRuleSelectListPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRYKEY = "EntryEntity";
    private static final String BTN_OK = "btnok";
    private static final String F_ACTION_ID = "factionid";
    private EntityMetadata entityMetadata;

    private EntityMetadata getBillEntityMetadata() {
        PropertyEditHelper editHelper;
        List<Map<String, Object>> metaMap;
        if (this.entityMetadata == null && (metaMap = (editHelper = new PropertyEditHelper()).getEntityMeta(this.getView())) != null && !metaMap.isEmpty()) {
            this.entityMetadata = EntityMetadataUtil.getEntityMetadata(metaMap);
        }
        return this.entityMetadata;
    }

    private String getBizAppId() {
        PropertyEditHelper editHelper = new PropertyEditHelper();
        return editHelper.getBizAppId(this.getView());
    }

    private String getBizAppMasterNumber() {
        String bizAppId = this.getBizAppId();
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            String number = this.getNumber();
            if (StringUtils.isBlank((CharSequence)number)) {
                return null;
            }
            return number;
        }
        Object[] sqlParas = new SqlParameter[]{new SqlParameter("FID", 12, (Object)bizAppId)};
        String sql = "select a.fid, a.fnumber, b.fid as fmasterid, b.fnumber as fmasternumber from t_meta_bizapp a left join t_meta_bizapp b on (a.fmasterid = b.fid) where a.fid = ? ";
        String appNumber = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParas, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String appnumber = null;
                String masternumber = null;
                while (rs.next()) {
                    appnumber = rs.getString("fnumber");
                    masternumber = rs.getString("fmasternumber");
                }
                if (StringUtils.isBlank(masternumber)) {
                    return appnumber;
                }
                return masternumber;
            }
        });
        return appNumber;
    }

    private String getNumber() {
        String rootPageId = this.getView().getFormShowParameter().getRootPageId();
        IFormView view = this.getView().getView(rootPageId);
        String formId = view.getFormShowParameter().getFormId();
        String id = null;
        if ("bos_devpn_businessobj".equalsIgnoreCase(formId)) {
            id = (String)view.getFormShowParameter().getCustomParam("entityId");
        } else if ("bos_devpn_formdesign".equalsIgnoreCase(formId)) {
            id = view.getPageCache().get("id");
        }
        DynamicObject bizApp = BizAppServiceHelp.getBizAppByFormID((String)id);
        return bizApp == null ? null : bizApp.getString("number");
    }

    private String getEntityNumber() {
        EntityMetadata entityMetadata = this.getBillEntityMetadata();
        if (entityMetadata == null) {
            return null;
        }
        String id = entityMetadata.getRootEntity().getId();
        String masterId = MetadataDao.getMasterId((String)id);
        if (StringUtils.isBlank((CharSequence)masterId) || StringUtils.equals((CharSequence)id, (CharSequence)masterId)) {
            return entityMetadata.getRootEntity().getKey();
        }
        return MetadataDao.getEntityNumberById((String)masterId);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYKEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        String appNumber = this.getBizAppMasterNumber();
        String entityNumber = this.getEntityNumber();
        OpBizRuleTypes opBizRuleTypes = OpBizRuleTypeLoader.load();
        List types = opBizRuleTypes.filterRuleTypes(appNumber, entityNumber, null);
        if (types.size() > 0) {
            IDataModel model = this.getModel();
            int i = 0;
            for (OpBizRuleType type : types) {
                if (type.isDisable() || type.isDesignForbid()) continue;
                model.createNewEntryRow(ENTRYKEY);
                model.setValue(F_ACTION_ID, (Object)type.getId(), i);
                model.setValue("fname", (Object)type.getName().getLocaleValue(), i);
                model.setValue("fdesc", (Object)type.getDesc().getLocaleValue(), i);
                model.setValue("fformid", (Object)type.getSettingFormId(), i);
                ++i;
            }
        }
    }

    public void afterBindData(EventObject e) {
        String runClass = (String)this.getView().getFormShowParameter().getCustomParam("RuleTypeId");
        int rows = this.getModel().getEntryRowCount(ENTRYKEY);
        for (int i = 0; i < rows; ++i) {
            if (!this.getModel().getValue(F_ACTION_ID, i).equals(runClass)) continue;
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYKEY);
            grid.selectRows(new int[]{i}, i);
        }
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        if (ctl.getKey().equals(BTN_OK)) {
            this.returnData();
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        if (ENTRYKEY.equalsIgnoreCase(((Control)evt.getSource()).getKey())) {
            this.returnData();
        }
    }

    private void returnData() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        int rowKey = grid.getEntryState().getFocusRow();
        if (rowKey >= 0) {
            OpBizRuleType type = new OpBizRuleType();
            IDataModel model = this.getModel();
            type.setId((String)model.getValue(F_ACTION_ID, rowKey));
            type.setName(new LocaleString((String)model.getValue("fname", rowKey)));
            type.setDesc(new LocaleString((String)model.getValue("fdesc", rowKey)));
            type.setSettingFormId((String)model.getValue("fformid", rowKey));
            this.getView().returnDataToParent((Object)type);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u79cd\u670d\u52a1\u3002", (String)"OpBizRuleSelectListPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }
}

