/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.opbizrule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.operate.bizrule.OpBizRuleType;
import kd.bos.entity.operate.bizrule.OpBizRuleTypeLoader;
import kd.bos.entity.operate.bizrule.OpBizRuleTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;

public class OpBizRuleSetEdit
extends AbstractBillPlugIn
implements F7SelectedListRemoveListener,
TreeNodeCheckListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_OPBIZRULE = "opbizrule";
    private static final String KEY_OBJECTTYPE = "objecttype";
    private static final String KEY_OPERATIONKEY = "operationkey";
    private static final String KEY_TREEVIEW = "optree";
    private static final String KEY_SELECTEDLIST = "selectedoperations";
    private static final String CACHE_ROOTNODE = "rootnode";
    private static final String CACHE_SELECTEDOPS = "selectedops";
    private TreeNode rootNode = null;
    private String rootNodeName = ResManager.loadKDString((String)"\u542f\u7528\u670d\u52a1\u7684\u64cd\u4f5c", (String)"OpBizRuleSetEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(KEY_SELECTEDLIST);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String ruleType = (String)this.getView().getFormShowParameter().getCustomParam("ruletype");
        if (StringUtils.isNotBlank((CharSequence)ruleType)) {
            this.getModel().setValue(KEY_OPBIZRULE, (Object)ruleType);
        }
    }

    public void afterBindData(EventObject e) {
        this.initOpBizRules();
        this.initOpTree(true);
        this.syncSelectedOpsList();
        this.lockRuleType();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        AbstractOperate operate = (AbstractOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operate.getOperateKey())) {
            this.syncEntryRows();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        AbstractOperate operate = (AbstractOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operate.getOperateKey()) && e.getOperationResult() != null && e.getOperationResult().getSuccessPkIds() != null && !e.getOperationResult().getSuccessPkIds().isEmpty()) {
            OpBizRuleSetServiceHelper.clearCache();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)KEY_OBJECTTYPE)) {
            this.initOpTree(false);
            this.syncSelectedOpsList();
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        this.selectTreeNode(e.getChecked());
    }

    public void RemoveClick(F7SelectedListRemoveEvent e) {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        if (e.getParam() != null) {
            tree.uncheckNode(e.getParam().toString());
        } else {
            tree.uncheckNodes(tree.getTreeState().getCheckedNodeIds());
        }
        this.getPageCache().put(CACHE_SELECTEDOPS, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    private void initOpBizRules() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        OpBizRuleTypes opBizRuleTypes = OpBizRuleTypeLoader.load();
        List rules = opBizRuleTypes.getRuleTypes();
        for (OpBizRuleType rule : rules) {
            ComboItem item = new ComboItem(rule.getName(), rule.getId());
            items.add(item);
        }
        ComboEdit edit = (ComboEdit)this.getView().getControl(KEY_OPBIZRULE);
        edit.setComboItems(items);
    }

    private void lockRuleType() {
        String ruleType = (String)this.getView().getFormShowParameter().getCustomParam("ruletype");
        if (StringUtils.isNotBlank((CharSequence)ruleType)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_OPBIZRULE});
        }
    }

    private void initOpTree(boolean isInit) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        TreeNode root = new TreeNode("", "0", this.rootNodeName);
        root.setExpend(true);
        root.setIsOpened(true);
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(KEY_OBJECTTYPE);
        if (objectType != null) {
            String entityNumber = (String)objectType.getPkValue();
            List ops = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
            for (Map op : ops) {
                String opTypeId = (String)op.get("type");
                if (!OperationTypeCache.isEntityOperation((String)opTypeId)) continue;
                String opKey = (String)op.get("key");
                Map mapLocaleString = (Map)op.get("name");
                String opName = opKey;
                if (mapLocaleString != null) {
                    opName = LocaleString.fromMap((Map)mapLocaleString).toString() + "(" + opKey + ")";
                }
                TreeNode node = new TreeNode("0", opKey, opName);
                root.addChild(node);
            }
        }
        if (isInit) {
            treeView.addNode(root);
        } else {
            treeView.updateNode(root);
        }
        treeView.setMulti(true);
        this.rootNode = root;
        String str = SerializationUtils.toJsonString((Object)root);
        this.getPageCache().put(CACHE_ROOTNODE, str);
    }

    private void syncSelectedOpsList() {
        DynamicObjectCollection entryrows = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        TreeNode rootNode = this.getCacheRootNode();
        ArrayList<TreeNode> selectedOpNodes = new ArrayList<TreeNode>();
        ArrayList<String> selectedOpKeys = new ArrayList<String>();
        for (DynamicObject entryRow : entryrows) {
            String opKey = entryRow.getString(KEY_OPERATIONKEY);
            TreeNode node = rootNode.getTreeNode(opKey, 3);
            if (node == null) continue;
            selectedOpNodes.add(node);
            selectedOpKeys.add(node.getId());
        }
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(KEY_SELECTEDLIST);
        f7SelectedList.removeAllItems();
        if (!selectedOpNodes.isEmpty()) {
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            treeView.checkNodes(selectedOpNodes);
            this.addSelectedOps(selectedOpNodes);
        }
        this.getPageCache().put(CACHE_SELECTEDOPS, SerializationUtils.toJsonString(selectedOpKeys));
    }

    private void syncEntryRows() {
        int i;
        DynamicObject headObj = this.getModel().getDataEntity(true);
        List<String> selectedOps = this.getCacheChecks();
        DynamicObjectCollection entryRows = headObj.getDynamicObjectCollection(KEY_ENTRYENTITY);
        for (i = entryRows.size() - 1; i >= 0; --i) {
            String opKey = ((DynamicObject)entryRows.get(i)).getString(KEY_OPERATIONKEY);
            if (selectedOps.remove(opKey)) continue;
            entryRows.remove(i);
        }
        if (!selectedOps.isEmpty()) {
            EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY);
            for (String opKey : selectedOps) {
                DynamicObject entryRow = new DynamicObject((DynamicObjectType)entryType);
                entryRow.set(KEY_OPERATIONKEY, (Object)opKey);
                entryRows.add((Object)entryRow);
            }
        }
        for (i = 0; i < entryRows.size(); ++i) {
            ((DynamicObject)entryRows.get(i)).set("seq", (Object)(i + 1));
        }
    }

    private void addSelectedOps(List<TreeNode> opNodes) {
        ArrayList<ValueTextItem> listValue = new ArrayList<ValueTextItem>(10);
        for (TreeNode node : opNodes) {
            listValue.add(new ValueTextItem(node.getId(), node.getText()));
        }
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(KEY_SELECTEDLIST);
        f7SelectedList.addItems(listValue);
    }

    private void selectTreeNode(boolean select) {
        List checkedNodeIds;
        TreeView tree;
        block6: {
            List<String> cacheChecks;
            List currChecks;
            TreeNode root;
            block5: {
                root = this.getCacheRootNode();
                tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
                currChecks = tree.getTreeState().getCheckedNodeIds();
                cacheChecks = this.getCacheChecks();
                ArrayList selList = new ArrayList();
                selList.addAll(currChecks);
                if (!select) break block5;
                if (!cacheChecks.isEmpty() && !selList.removeAll(cacheChecks)) break block6;
                ArrayList<TreeNode> addList = new ArrayList<TreeNode>();
                for (String id : currChecks) {
                    TreeNode node = root.getTreeNode(id, 3);
                    if (node == null || node.getChildren() != null || "0".equals(node.getId())) continue;
                    addList.add(node);
                }
                if (addList.isEmpty()) break block6;
                this.addSelectedOps(addList);
                break block6;
            }
            if (currChecks.isEmpty() || cacheChecks.removeAll(currChecks)) {
                for (int i = 0; i < cacheChecks.size(); ++i) {
                    TreeNode node = root.getTreeNode(cacheChecks.get(i), 3);
                    if (node == null || node.getChildren() == null) continue;
                    cacheChecks.remove(i);
                }
                F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(KEY_SELECTEDLIST);
                for (String value : cacheChecks) {
                    f7SelectedList.removeItem((Object)value);
                }
            }
        }
        if (!(checkedNodeIds = tree.getTreeState().getCheckedNodeIds()).isEmpty()) {
            checkedNodeIds.remove("0");
        }
        this.getPageCache().put(CACHE_SELECTEDOPS, SerializationUtils.toJsonString((Object)checkedNodeIds));
    }

    private TreeNode getCacheRootNode() {
        if (this.rootNode == null) {
            String str = this.getPageCache().get(CACHE_ROOTNODE);
            this.rootNode = StringUtils.isBlank((CharSequence)str) ? new TreeNode("", "0", this.rootNodeName) : (TreeNode)SerializationUtils.fromJsonString((String)str, TreeNode.class);
        }
        return this.rootNode;
    }

    private List<String> getCacheChecks() {
        String str = this.getPageCache().get(CACHE_SELECTEDOPS);
        if (StringUtils.isBlank((CharSequence)str)) {
            return new ArrayList<String>();
        }
        return (List)SerializationUtils.fromJsonString((String)str, List.class);
    }

    private void testSaveOpBizRuleSet() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        String entityNumber = obj.getString("objecttype_id");
        String opBizRule = obj.getString(KEY_OPBIZRULE);
        DynamicObjectCollection rows = obj.getDynamicObjectCollection(KEY_ENTRYENTITY);
        ArrayList<String> opKeys = new ArrayList<String>();
        for (DynamicObject row : rows) {
            String opKey = row.getString(KEY_OPERATIONKEY);
            if (!StringUtils.isNotBlank((CharSequence)opKey)) continue;
            opKeys.add(opKey);
        }
        opKeys.add("delete");
        OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entityNumber, (String)opBizRule, opKeys);
    }
}

