/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.opbizrule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.opbizrule.OpBizRuleDataProvider;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class OpBizRuleSetList
extends AbstractTreeListPlugin {
    public static final String PARAM_RULETYPE = "ruletype";
    private static final String KEY_BIZAPP = "objecttype.bizappid";
    private static final String KEY_OPBIZRULE = "opbizrule";
    private static final String PNL_TREEBTNLIST = "flexpanel_treebtn";
    private static final String CACHE_APPNODES = "appnodes";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs e) {
        e.setListDataProvider((IListDataProvider)new OpBizRuleDataProvider());
    }

    public void setFilter(SetFilterEvent e) {
        String ruleType = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_RULETYPE);
        if (StringUtils.isNotBlank((CharSequence)ruleType)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter(KEY_OPBIZRULE, "=", (Object)ruleType));
            e.setQFilters(qFilters);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String ruleType = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_RULETYPE);
        if (StringUtils.isNotBlank((CharSequence)ruleType)) {
            e.getParameter().getCustomParams().put(PARAM_RULETYPE, ruleType);
        }
    }

    public void initTreeToolbar(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PNL_TREEBTNLIST});
    }

    public void refreshNode(RefreshNodeEvent e) {
        List<TreeNode> nodes = OpBizRuleSetList.getCacheTreeNodes((AbstractFormPlugin)this, CACHE_APPNODES);
        TreeNode currNode = null;
        String nodeId = (String)e.getNodeId();
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            for (TreeNode node : nodes) {
                if (StringUtils.equals((CharSequence)node.getId(), (CharSequence)nodeId)) {
                    currNode = node;
                    break;
                }
                TreeNode childNode = node.getTreeNode(nodeId, 5);
                if (childNode == null) continue;
                currNode = childNode;
                break;
            }
        }
        if (currNode == null) {
            e.setChildNodes(nodes);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        QFilter qFilter = this.buildAppQFilter((String)e.getNodeId(), CACHE_APPNODES);
        e.addQFilter(qFilter);
        e.setCancel(true);
    }

    public static List<TreeNode> getCacheTreeNodes(AbstractFormPlugin plugin, String cacheKey) {
        List treeNodes;
        String json = plugin.getPageCache().get(cacheKey);
        if (StringUtils.isBlank((CharSequence)json)) {
            treeNodes = OpBizRuleSetList.loadAppNodes();
            OpBizRuleSetList.setCacheTreeNodes(plugin, cacheKey, treeNodes);
        } else {
            treeNodes = SerializationUtils.fromJsonStringToList((String)json, TreeNode.class);
        }
        return treeNodes;
    }

    public static void setCacheTreeNodes(AbstractFormPlugin plugin, String cacheKey, List<TreeNode> treeNodes) {
        String json = SerializationUtils.toJsonString(treeNodes);
        plugin.getPageCache().put(cacheKey, json);
    }

    public static List<TreeNode> loadAppNodes() {
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(16);
        List<TreeNode> cloudNode4 = OpBizRuleSetList.getCloudData();
        for (TreeNode node : cloudNode4) {
            allNodes.put(node.getId(), node);
        }
        List<TreeNode> appNode4 = OpBizRuleSetList.getAppData();
        for (TreeNode node : appNode4) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return cloudNode4;
    }

    private static List<TreeNode> getCloudData() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        DynamicObjectCollection clouds = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject cloud : clouds) {
            TreeNode node = new TreeNode();
            String nodeID = "cloud/" + cloud.getString("id");
            node.setText(cloud.getString("name"));
            node.setParentid("0");
            node.setId(nodeID);
            cloudNode.add(node);
        }
        return cloudNode;
    }

    private static List<TreeNode> getAppData() {
        ArrayList<TreeNode> appNode = new ArrayList<TreeNode>();
        DynamicObjectCollection apps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : apps) {
            TreeNode node = new TreeNode();
            String parentId = "cloud/" + app.getString("bizcloud");
            String nodeID = app.getString("id");
            node.setId(nodeID);
            node.setParentid(parentId);
            node.setText(app.getString("name"));
            appNode.add(node);
        }
        return appNode;
    }

    public QFilter buildAppQFilter(String nodeId, String nodesCacheKey) {
        ArrayList<String> appIds = new ArrayList<String>();
        List<TreeNode> bizCloudNodes = OpBizRuleSetList.getCacheTreeNodes((AbstractFormPlugin)this, nodesCacheKey);
        for (TreeNode bizCloudNode : bizCloudNodes) {
            if (this.searchBizNode(bizCloudNode, nodeId, appIds)) break;
        }
        if (appIds.isEmpty()) {
            return null;
        }
        if (appIds.size() == 1) {
            return new QFilter(KEY_BIZAPP, "=", appIds.get(0));
        }
        return new QFilter(KEY_BIZAPP, "in", (Object)appIds.toArray(new String[appIds.size()]));
    }

    private boolean searchBizNode(TreeNode bizCloudNode, String nodeId, List<String> appIds) {
        if (!StringUtils.equals((CharSequence)nodeId, (CharSequence)bizCloudNode.getId())) {
            if (this.searchAppNode(bizCloudNode, nodeId)) {
                appIds.add(nodeId);
                return true;
            }
        } else {
            if (bizCloudNode.getChildren() != null) {
                for (TreeNode appNode : bizCloudNode.getChildren()) {
                    appIds.add(appNode.getId());
                }
            }
            if (appIds.isEmpty()) {
                appIds.add(nodeId);
            }
            return true;
        }
        return false;
    }

    private boolean searchAppNode(TreeNode bizCloudNode, String nodeId) {
        if (bizCloudNode.getChildren() != null) {
            for (TreeNode appNode : bizCloudNode.getChildren()) {
                if (!StringUtils.equals((CharSequence)appNode.getId(), (CharSequence)nodeId)) continue;
                return true;
            }
        }
        return false;
    }
}

