/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.opbizrule;

import java.util.EventObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.operate.OperationTypes;
import kd.bos.entity.operate.bizrule.OpBizRuleType;
import kd.bos.entity.operate.bizrule.OpBizRuleTypeLoader;
import kd.bos.entity.operate.bizrule.OpBizRuleTypes;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.validation.ValidationType;
import kd.bos.metadata.entity.validation.ValidationTypeLoader;
import kd.bos.metadata.entity.validation.ValidationTypes;

public class OperationDefinitionListPlugin
extends AbstractFormPlugin {
    private static final String KEY_RANGE = "range";
    private static final String RANGE_ALL = "all";
    private static final String RANGE_OPTYPE = "optype";
    private static final String RANGE_OPBIZRULE = "opbizrule";
    private static final String RANGE_VALIDATOR = "validator";

    public void afterCreateNewData(EventObject e) {
        OperationTypes types = OperationTypeCache.loadAll();
        this.getModel().batchCreateNewEntryRow("optypeentry", types.getOpTypes().size());
        int i = 0;
        for (Object type : types.getOpTypes()) {
            this.getModel().setValue("op_number", (Object)type.getId(), i);
            this.getModel().setValue("op_name", (Object)type.getName(), i);
            this.getModel().setValue("op_desc", (Object)type.getDesc(), i);
            this.getModel().setValue("op_app", (Object)type.getSrcApp(), i);
            this.getModel().setValue("op_ds", (Object)type.getSrcType(), i);
            ++i;
        }
        OpBizRuleTypes ruleTypes = OpBizRuleTypeLoader.load();
        this.getModel().batchCreateNewEntryRow("bizruleentry", ruleTypes.getRuleTypes().size());
        i = 0;
        for (OpBizRuleType ruleType : ruleTypes.getRuleTypes()) {
            this.getModel().setValue("bizrule_number", (Object)ruleType.getId(), i);
            this.getModel().setValue("bizrule_name", (Object)ruleType.getName(), i);
            this.getModel().setValue("bizrule_desc", (Object)ruleType.getDesc(), i);
            this.getModel().setValue("bizrule_app", (Object)ruleType.getSrcApp(), i);
            this.getModel().setValue("bizrule_ds", (Object)ruleType.getSrcType(), i);
            ++i;
        }
        ValidationTypes validationTypes = ValidationTypeLoader.load();
        this.getModel().batchCreateNewEntryRow("validatorentry", validationTypes.getTypes().size());
        i = 0;
        for (ValidationType validationType : validationTypes.getTypes()) {
            this.getModel().setValue("valid_number", (Object)validationType.getId(), i);
            this.getModel().setValue("valid_name", (Object)validationType.getName(), i);
            this.getModel().setValue("valid_desc", (Object)validationType.getDesc(), i);
            this.getModel().setValue("valid_app", (Object)validationType.getSrcApp(), i);
            this.getModel().setValue("valid_ds", (Object)validationType.getSrcType(), i);
            ++i;
        }
    }

    public void afterBindData(EventObject e) {
        this.refresh(String.valueOf(this.getModel().getValue(KEY_RANGE)));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!KEY_RANGE.equals(e.getProperty().getName())) {
            return;
        }
        String type = String.valueOf(e.getChangeSet()[0].getNewValue());
        this.refresh(type);
    }

    private void refresh(String type) {
        switch (type) {
            case "all": {
                this.showOpType(true);
                this.showOpbizrule(true);
                this.showValidator(true);
                break;
            }
            case "opbizrule": {
                this.showOpType(false);
                this.showOpbizrule(true);
                this.showValidator(false);
                break;
            }
            case "validator": {
                this.showOpType(false);
                this.showOpbizrule(false);
                this.showValidator(true);
                break;
            }
            case "optype": {
                this.showOpType(true);
                this.showOpbizrule(false);
                this.showValidator(false);
                break;
            }
            default: {
                this.showOpType(false);
                this.showOpbizrule(false);
                this.showValidator(false);
            }
        }
    }

    private void showOpType(boolean v) {
        this.getView().setVisible(Boolean.valueOf(v), new String[]{"optypepanel"});
    }

    private void showOpbizrule(boolean v) {
        this.getView().setVisible(Boolean.valueOf(v), new String[]{"bizrulepanel"});
    }

    private void showValidator(boolean v) {
        this.getView().setVisible(Boolean.valueOf(v), new String[]{"validatorpanel"});
    }
}

