/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.org;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.org.OrgServiceHelper;

public class IdeOrgRelationTypePlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String ENTRY_KEY = "entry";
    private static final String VALUE_KEY = "value";
    private static final String NUMBER = "number";
    private static final String TO_TYPE = "totype";
    private static final String TO_TYPE_NAME = "totypename";
    private static final String FROM_TYPE = "fromtype";
    private static final String FROM_TYPE_NAME = "fromtypename";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void afterCreateNewData(EventObject e) {
        List<Map<String, String>> lstFields = this.getOrgRelationTypes();
        if (lstFields != null && lstFields.size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTRY_KEY, lstFields.size());
            int i = 0;
            for (Map<String, String> form : lstFields) {
                model.setValue(NUMBER, (Object)form.get(NUMBER), i);
                model.setValue("name", (Object)form.get("name"), i);
                model.setValue(TO_TYPE, (Object)form.get(TO_TYPE), i);
                model.setValue(TO_TYPE_NAME, (Object)form.get(TO_TYPE_NAME), i);
                model.setValue(FROM_TYPE, (Object)form.get(FROM_TYPE), i);
                model.setValue(FROM_TYPE_NAME, (Object)form.get(FROM_TYPE_NAME), i);
                ++i;
            }
        }
    }

    private List<Map<String, String>> getOrgRelationTypes() {
        List lstTypes = OrgServiceHelper.getAllOrgRelationType();
        return lstTypes;
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        if (src instanceof Button) {
            Button btn = (Button)src;
            switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
                case "btnok": {
                    this.returnData();
                    break;
                }
                case "btncancel": {
                    this.cancel();
                    break;
                }
            }
        }
    }

    private void cancel() {
        this.getView().close();
    }

    private void returnData() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int row = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_KEY) > 0 && row >= 0) {
            HashMap<String, String> OrgRelationType = new HashMap<String, String>();
            OrgRelationType.put("Number", (String)this.getModel().getValue(NUMBER, row));
            OrgRelationType.put("Name", (String)this.getModel().getValue("name", row));
            OrgRelationType.put("Totype", (String)this.getModel().getValue(TO_TYPE, row));
            OrgRelationType.put("Totypename", (String)this.getModel().getValue(TO_TYPE_NAME, row));
            OrgRelationType.put("Fromtype", (String)this.getModel().getValue(FROM_TYPE, row));
            OrgRelationType.put("Fromtypename", (String)this.getModel().getValue(FROM_TYPE_NAME, row));
            this.getView().returnDataToParent(OrgRelationType);
        } else {
            this.getView().returnDataToParent((Object)0);
        }
        this.getView().close();
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.returnData();
    }
}

