/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.org;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.property.alias.OrgViewSchemePropertyConverter;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class IdeOrgViewSchemePlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String ENTRY_KEY = "entry";
    private static final String ITEM_ID = "itemId";
    private static final String NUMBER = "number";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map mapCustom;
        String orgItemId;
        PropertyEditHelper helper = new PropertyEditHelper();
        List<Map<String, Object>> entityitems = helper.getEntityMeta(this.getView());
        EntityMetadata entityMeta = EntityMetadataUtil.getEntityMetadata(entityitems);
        OrgField orgCurrent = (OrgField)entityMeta.getItemById(orgItemId = (String)(mapCustom = this.getView().getFormShowParameter().getCustomParams()).get(ITEM_ID));
        String orgFuns = orgCurrent.getOrgFuncs();
        List<Map<String, Object>> schemes = this.getViewSchemes(orgFuns);
        if (schemes != null && schemes.size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTRY_KEY, schemes.size());
            int i = 0;
            for (Map<String, Object> scheme : schemes) {
                model.setValue(NUMBER, scheme.get(NUMBER), i);
                model.setValue("name", scheme.get("name"), i);
                model.setValue("id", scheme.get("id"), i);
                ++i;
            }
        }
    }

    private List<Map<String, Object>> getViewSchemes(String type) {
        List schemes = OrgUnitServiceHelper.getViewSchemaByType((String)type);
        return schemes;
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        if (src instanceof Button) {
            Button btn = (Button)src;
            switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
                case "btnok": {
                    this.close();
                    break;
                }
                case "btncancel": {
                    this.cancel();
                    break;
                }
            }
        }
    }

    private void cancel() {
        this.getView().close();
    }

    private void close() {
        HashMap<String, String> viewScheme = new HashMap<String, String>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int row = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_KEY) > 0 && row >= 0) {
            viewScheme = new HashMap();
            viewScheme.put("Number", (String)this.getModel().getValue(NUMBER, row));
            viewScheme.put("Name", (String)this.getModel().getValue("name", row));
            viewScheme.put("Id", (String)this.getModel().getValue("id", row));
            viewScheme.put("_Type_", "OrgViewScheme");
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", viewScheme);
        para.put("alias", new OrgViewSchemePropertyConverter().convert(viewScheme));
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.close();
    }
}

