/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.org;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.property.alias.OrgRelationPropertyConverter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.OrgField;

public class OrgRelationCnfListPlugin
extends AbstractFormPlugin
implements ClickListener,
HyperLinkClickListener {
    private static final String ENTRY_NUMBER = "entryentity";
    private static final String KEY_ORG_KEY = "orgkey";
    private static final String KEY_ORG_NAME = "orgname";
    private static final String KEY_ORG_ID = "orgid";
    private static final String KEY_RELATION_TYPE = "relationtype";
    private static final String KEY_RELATION_TYPE2 = "relationtype2";
    private static final String KEY_RELATION_DIRECT = "relationdirect";
    private static final String KEY_RELATION_DIRECT2 = "relationdirect2";
    private static final String KEY_RELATION_ORG = "relationorg";
    private static final String KEY_RELATION_ORG2 = "relationorg2";
    private static final String CHANGE_ROWS = "changeRows";
    private static final String TYPE = "_Type_";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String ORG_RELATION = "OrgRelation";
    private static final String DIRECT = "Direct";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", KEY_RELATION_TYPE, KEY_RELATION_ORG});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_NUMBER);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String changeRows = this.getPageCache().get(CHANGE_ROWS);
        HashSet<Integer> changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (HashSet<Integer>)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        if (changeRowsSet == null) {
            changeRowsSet = new HashSet<Integer>();
        }
        changeRowsSet.add(rowIndex);
        this.getPageCache().put(CHANGE_ROWS, SerializationUtils.toJsonString(changeRowsSet));
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        OrgField mainOrg;
        PropertyEditHelper helper = new PropertyEditHelper();
        List<Map<String, Object>> entityitems = helper.getEntityMeta(this.getView());
        EntityMetadata entityMeta = EntityMetadataUtil.getEntityMetadata(entityitems);
        int integerField = 1;
        String mainOrgKey = "";
        String mainOrgId = entityMeta.getRootEntity().getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrgId) && (mainOrg = (OrgField)entityMeta.getItemById(entityMeta.getRootEntity().getMainOrg())) != null) {
            mainOrgKey = mainOrg.getKey();
        }
        for (Map<String, Object> item : entityitems) {
            List orgRelation;
            String orgDisplayName;
            EntityItem itemctl;
            String parentid = (String)item.get("ParentId");
            String key = (String)item.get("Key");
            String id = (String)item.get("Id");
            if (StringUtils.equals((CharSequence)key, (CharSequence)mainOrgKey) || !((itemctl = entityMeta.getItemById(id)) instanceof OrgField)) continue;
            EntityItem parentctl = entityMeta.getItemById(parentid);
            if (parentctl == null || parentctl instanceof BillEntity) {
                orgDisplayName = String.format(ResManager.loadKDString((String)"\u5355\u5934\u00b7%s", (String)"OrgRelationCnfListPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), item.get("Name"));
                orgRelation = (List)item.get(ORG_RELATION);
                this.fieldRule(id, orgDisplayName, key, integerField, orgRelation);
                ++integerField;
                continue;
            }
            if (parentctl instanceof SubEntryEntity) {
                orgDisplayName = String.format(ResManager.loadKDString((String)"\u5b50\u5355\u4f53\u00b7%s", (String)"OrgRelationCnfListPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), item.get("Name"));
                orgRelation = (List)item.get(ORG_RELATION);
                this.fieldRule(id, orgDisplayName, key, integerField, orgRelation);
                ++integerField;
                continue;
            }
            if (!(parentctl instanceof EntryEntity)) continue;
            orgDisplayName = String.format(ResManager.loadKDString((String)"\u5355\u4f53\u00b7%s", (String)"OrgRelationCnfListPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), item.get("Name"));
            orgRelation = (List)item.get(ORG_RELATION);
            this.fieldRule(id, orgDisplayName, key, integerField, orgRelation);
            ++integerField;
        }
    }

    public Boolean getOrgRelation(List<Map<String, Object>> listValue, String id) {
        Boolean mustInput = false;
        for (Map<String, Object> map : listValue) {
            Object mustInputObj;
            Object object = mustInputObj = map.get("MustInput") != null ? map.get("MustInput") : map.get("EntryMustInput");
            if (!id.equals(map.get("Id"))) continue;
            if ("BasedataPropField".equals(map.get(TYPE)) || "UserAvatarField".equals(map.get(TYPE))) {
                mustInput = null;
                continue;
            }
            if (!StringUtils.isNotBlank((Object)mustInputObj)) continue;
            mustInput = (Boolean)mustInputObj;
            break;
        }
        return mustInput;
    }

    public void fieldRule(String id, String name, String key, int integerField, List<Map<String, Object>> orgRelation) {
        int rowIndex = this.getModel().createNewEntryRow(ENTRY_NUMBER);
        this.getModel().setValue(KEY_ORG_ID, (Object)id, rowIndex);
        this.getModel().setValue(KEY_ORG_NAME, (Object)name, rowIndex);
        this.getModel().setValue(KEY_ORG_KEY, (Object)key, rowIndex);
        if (orgRelation != null && !orgRelation.isEmpty()) {
            Map<String, Object> relationItem = orgRelation.get(orgRelation.size() - 1);
            this.getModel().setValue(KEY_RELATION_TYPE, ((Map)relationItem.get("Type")).get("Name"), rowIndex);
            this.getModel().setValue(KEY_RELATION_TYPE2, (Object)SerializationUtils.toJsonString((Object)relationItem.get("Type")), rowIndex);
            this.getModel().setValue(KEY_RELATION_DIRECT, ((Map)relationItem.get(DIRECT)).get("Index"), rowIndex);
            this.getModel().setValue(KEY_RELATION_DIRECT2, (Object)SerializationUtils.toJsonString((Object)relationItem.get(DIRECT)), rowIndex);
            String keyrelationorg = (String)((Map)relationItem.get("Org")).get("Name") + "(" + ((Map)relationItem.get("Org")).get("Number") + ")";
            this.getModel().setValue(KEY_RELATION_ORG, (Object)keyrelationorg, rowIndex);
            this.getModel().setValue(KEY_RELATION_ORG2, (Object)SerializationUtils.toJsonString((Object)relationItem.get("Org")), rowIndex);
        }
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        if (src instanceof Button) {
            Button btn = (Button)src;
            switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
                case "btnok": {
                    this.close();
                    break;
                }
                case "btncancel": {
                    this.cancel();
                    break;
                }
            }
        } else if (src instanceof TextEdit) {
            Control ctl = (Control)src;
            switch (ctl.getKey()) {
                case "relationtype": {
                    this.openSelectTypeForm();
                    break;
                }
                case "relationorg": {
                    this.openSelectFieldForm();
                    break;
                }
            }
        }
    }

    private void openSelectTypeForm() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ide_org_relation_type");
        fsp.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u534f\u4f5c\u7c7b\u578b\u3002", (String)"OrgRelationCnfListPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectRelationType"));
        this.getView().showForm(fsp);
    }

    private void openSelectFieldForm() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ide_field_single_select");
        fsp.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u7ec4\u7ec7\u5b57\u6bb5", (String)"OrgRelationCnfListPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectOrgField"));
        fsp.setCustomParam("value", this.getSelectFormValue());
        this.getView().showForm(fsp);
    }

    private List<Map<String, Object>> getSelectFormValue() {
        List context = (List)this.getView().getFormShowParameter().getCustomParam("context");
        List lstFields = (List)context.get(0);
        ArrayList<Map<String, Object>> lstOrgFields = new ArrayList<Map<String, Object>>();
        int index = this.getModel().getEntryCurrentRowIndex(ENTRY_NUMBER);
        String currentorgid = (String)this.getModel().getValue(KEY_ORG_ID, index);
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        for (Map field : lstFields) {
            if (!field.get(TYPE).equals("OrgField") || field.get("Id").equals(currentorgid)) continue;
            lstOrgFields.add(field);
        }
        return lstOrgFields;
    }

    private void cancel() {
        this.getView().close();
    }

    private void close() {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", "OrgRelationList");
        List<Map<String, Object>> orgRelationLists = this.getOrgRelationLists();
        para.put("value", orgRelationLists);
        para.put("alias", new OrgRelationPropertyConverter().convert(orgRelationLists));
        ArrayList<Map<String, Object>> propDatas = new ArrayList<Map<String, Object>>();
        propDatas.add(para);
        propDatas.addAll(this.getOrgFieldsAction());
        this.getView().returnDataToParent(propDatas);
        this.getView().close();
    }

    private List<Map<String, Object>> getOrgRelationLists() {
        ArrayList<Map<String, Object>> orgRelationLists = new ArrayList<Map<String, Object>>();
        String changeRows = this.getPageCache().get(CHANGE_ROWS);
        HashSet<Integer> changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (HashSet<Integer>)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        } else {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_NUMBER);
            if (this.getModel().getEntryRowCount(ENTRY_NUMBER) > 0 && rowIndex >= 0) {
                changeRowsSet = new HashSet<Integer>();
                changeRowsSet.add(rowIndex);
                this.getPageCache().put(CHANGE_ROWS, SerializationUtils.toJsonString(changeRowsSet));
            }
        }
        if (changeRowsSet != null) {
            for (Integer rowIndex : changeRowsSet) {
                DynamicObject obj = this.getModel().getEntryRowEntity(ENTRY_NUMBER, rowIndex.intValue());
                Map<String, Object> orgRelationList = this.buildProperty(obj);
                orgRelationLists.add(orgRelationList);
            }
        }
        return orgRelationLists;
    }

    private List<Map<String, Object>> getOrgFieldsAction() {
        ArrayList<Map<String, Object>> orgRelationLists = new ArrayList<Map<String, Object>>();
        String changeRows = this.getPageCache().get(CHANGE_ROWS);
        Set changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (Set)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        if (changeRowsSet != null) {
            for (Integer rowIndex : changeRowsSet) {
                DynamicObject obj = this.getModel().getEntryRowEntity(ENTRY_NUMBER, rowIndex.intValue());
                HashMap<String, Object> orgRelation = new HashMap<String, Object>(10);
                Object relationtype = obj.get(KEY_RELATION_TYPE2);
                Object orgfield = obj.get(KEY_RELATION_ORG2);
                Object direct = obj.get(KEY_RELATION_DIRECT);
                orgRelation.put(TYPE, "OrgRelationItem");
                if (!StringUtils.isNotBlank((Object)relationtype)) continue;
                orgRelation.put("Type", SerializationUtils.fromJsonString((String)((String)relationtype), Map.class));
                if (!StringUtils.isNotBlank((Object)orgfield)) continue;
                orgRelation.put("Org", SerializationUtils.fromJsonString((String)((String)orgfield), Map.class));
                if (!StringUtils.isNotBlank((Object)direct)) continue;
                HashMap<String, String> OrgRelationDirect = new HashMap<String, String>();
                String oord = direct.toString();
                if (StringUtils.isNotBlank((Object)oord)) {
                    OrgRelationDirect.put("Index", oord);
                    if (StringUtils.equals((CharSequence)"toorg", (CharSequence)oord.toString())) {
                        OrgRelationDirect.put("Display", ResManager.loadKDString((String)"\u672c\u7ec4\u7ec7\u662f\u53d7\u6258\u65b9", (String)"OrgRelationCnfListPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    } else {
                        OrgRelationDirect.put("Display", ResManager.loadKDString((String)"\u672c\u7ec4\u7ec7\u662f\u59d4\u6258\u65b9\u3002", (String)"OrgRelationCnfListPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    }
                    orgRelation.put(DIRECT, OrgRelationDirect);
                }
                HashMap<String, Object> para = new HashMap<String, Object>();
                para.put("itemId", obj.get(KEY_ORG_ID));
                para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
                para.put("propertyName", ORG_RELATION);
                ArrayList<HashMap<String, Object>> orgRelations = new ArrayList<HashMap<String, Object>>();
                orgRelations.add(orgRelation);
                para.put("value", orgRelations);
                orgRelationLists.add(para);
            }
        }
        return orgRelationLists;
    }

    private Map<String, Object> buildProperty(DynamicObject propEditRow) {
        HashMap<String, Object> OrgRelationList = new HashMap<String, Object>();
        Object relationtype = propEditRow.get(KEY_RELATION_TYPE2);
        Object relationorg = propEditRow.get(KEY_RELATION_ORG2);
        Object relationdirect = propEditRow.get(KEY_RELATION_DIRECT);
        if (StringUtils.isNotBlank((Object)relationtype) && StringUtils.isNotBlank((Object)relationorg) && StringUtils.isNotBlank((Object)relationdirect)) {
            OrgRelationList.put(TYPE, "OrgRelationConfig");
            if (StringUtils.isNotBlank((Object)relationtype)) {
                OrgRelationList.put("Type", SerializationUtils.fromJsonString((String)((String)relationtype), Map.class));
            }
            if (StringUtils.isNotBlank((Object)relationorg)) {
                OrgRelationList.put("Org", SerializationUtils.fromJsonString((String)((String)relationorg), Map.class));
            }
            if (StringUtils.isNotBlank((Object)relationdirect)) {
                HashMap<String, Object> OrgRelationDirect = new HashMap<String, Object>();
                if (StringUtils.isNotBlank((Object)relationdirect)) {
                    OrgRelationDirect.put("Index", relationdirect);
                    if (relationdirect.equals("toorg")) {
                        OrgRelationDirect.put("Display", ResManager.loadKDString((String)"\u672c\u7ec4\u7ec7\u662f\u53d7\u6258\u65b9", (String)"OrgRelationCnfListPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    } else {
                        OrgRelationDirect.put("Display", ResManager.loadKDString((String)"\u672c\u7ec4\u7ec7\u662f\u59d4\u6258\u65b9\u3002", (String)"OrgRelationCnfListPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    }
                    OrgRelationList.put(DIRECT, OrgRelationDirect);
                }
            }
        }
        return OrgRelationList;
    }

    public void afterBindData(EventObject e) {
        EntryGrid Grid = (EntryGrid)this.getView().getControl(ENTRY_NUMBER);
        Grid.setColumnProperty(KEY_ORG_NAME, "isFixed", (Object)true);
        Grid.setColumnProperty(KEY_ORG_KEY, "isFixed", (Object)true);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object rd;
        String actionId = evt.getActionId();
        int index = this.getModel().getEntryCurrentRowIndex(ENTRY_NUMBER);
        if ("selectOrgField".equalsIgnoreCase(actionId)) {
            Object rd2 = evt.getReturnData();
            if (rd2 != null) {
                if (evt.getReturnData() instanceof Integer) {
                    this.getModel().setValue(KEY_RELATION_ORG, null);
                } else {
                    this.getModel().setValue(KEY_RELATION_ORG2, (Object)SerializationUtils.toJsonString((Object)rd2), index);
                    String keyrelationorg = (String)((Map)rd2).get("Name") + "(" + ((Map)rd2).get("Number") + ")";
                    this.getModel().setValue(KEY_RELATION_ORG, (Object)keyrelationorg, index);
                }
            }
        } else if ("selectRelationType".equalsIgnoreCase(actionId) && (rd = evt.getReturnData()) != null) {
            if (evt.getReturnData() instanceof Integer) {
                this.getModel().setValue(KEY_RELATION_TYPE, null);
            } else {
                this.getModel().setValue(KEY_RELATION_TYPE2, (Object)SerializationUtils.toJsonString((Object)rd), index);
                this.getModel().setValue(KEY_RELATION_TYPE, ((Map)rd).get("Name"), index);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent paramHyperLinkClickEvent) {
        String key = paramHyperLinkClickEvent.getFieldName();
        if (key.equals("reset")) {
            int rowIndex = paramHyperLinkClickEvent.getRowIndex();
            this.getModel().setValue(KEY_RELATION_TYPE, null, rowIndex);
            this.getModel().setValue(KEY_RELATION_TYPE2, null, rowIndex);
            this.getModel().setValue(KEY_RELATION_DIRECT, null, rowIndex);
            this.getModel().setValue(KEY_RELATION_DIRECT2, null, rowIndex);
            this.getModel().setValue(KEY_RELATION_ORG, null, rowIndex);
            this.getModel().setValue(KEY_RELATION_ORG2, null, rowIndex);
        }
    }
}

