/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.org;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class OrgRelationCnfPlugin
extends AbstractFormPlugin
implements ClickListener {
    public static final String entryStatusControlKey = "entrystatuscontrol";
    private static final String RELATIONDIRECTION = "relationdirection";
    private static final String ORGFIELD = "orgfield2";
    private static final String RELATION_TYPE_2 = "relationtype2";
    private static final String PRINCIPAL_ORG_2 = "principalorg2";
    private static final String TRUSTEE_ORG_2 = "trusteeorg2";
    private static final String RELATION_TYPE = "relationtype";
    private static final String PRINCIPAL = "Principal";
    private static final String PRINCIPAL_ORG = "principalorg";
    private static final String TRUSTEE = "Trustee";
    private static final String TRUSTEE_ORG = "trusteeorg";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String TYPE = "_Type_";
    private static final String NUMBER = "Number";
    private static final String TO_ORG = "toorg";

    public void initialize() {
        this.addClickListeners(new String[]{RELATION_TYPE_2, PRINCIPAL_ORG_2, TRUSTEE_ORG_2, "btnok", "btncancel"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(RELATIONDIRECTION)) {
            String org = (String)this.getModel().getValue(RELATIONDIRECTION);
            this.updateOrgFieldCaption(org);
        }
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParam("value");
        if (value != null) {
            Map item = (Map)SerializationUtils.fromJsonString((String)((String)value), Map.class);
            if (item.get("Type") != null) {
                this.getModel().setValue(RELATION_TYPE, (Object)SerializationUtils.toJsonString(item.get("Type")));
                this.getModel().setValue(RELATION_TYPE_2, ((Map)item.get("Type")).get("Name"));
            }
            if (item.get(PRINCIPAL) != null) {
                this.getModel().setValue(PRINCIPAL_ORG, (Object)SerializationUtils.toJsonString(item.get(PRINCIPAL)));
                this.getModel().setValue(PRINCIPAL_ORG_2, ((Map)item.get(PRINCIPAL)).get("Name"));
            }
            if (item.get(TRUSTEE) != null) {
                this.getModel().setValue(TRUSTEE_ORG, (Object)SerializationUtils.toJsonString(item.get(TRUSTEE)));
                this.getModel().setValue(TRUSTEE_ORG_2, ((Map)item.get(TRUSTEE)).get("Name"));
            }
        }
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        if (src instanceof Button) {
            Button btn = (Button)src;
            switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
                case "btnok": {
                    this.close();
                    break;
                }
                case "btncancel": {
                    this.cancel();
                    break;
                }
            }
        } else {
            Control ctrl = (Control)src;
            switch (ctrl.getKey().toLowerCase(Locale.ENGLISH)) {
                case "relationtype2": {
                    this.openSelectTypeForm();
                    break;
                }
                case "principalorg2": {
                    this.openSelectFieldForm(PRINCIPAL_ORG);
                    break;
                }
                case "trusteeorg2": {
                    this.openSelectFieldForm(TRUSTEE_ORG);
                    break;
                }
            }
        }
    }

    private void openSelectTypeForm() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ide_org_relation_type");
        fsp.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u534f\u4f5c\u7c7b\u578b\u3002", (String)"OrgRelationCnfPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectRelationType"));
        this.getView().showForm(fsp);
    }

    private void openSelectFieldForm(String type) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ide_field_single_select");
        fsp.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u7ec4\u7ec7\u5b57\u6bb5", (String)"OrgRelationCnfPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, type));
        fsp.setCustomParam("value", this.getSelectFormValue());
        this.getView().showForm(fsp);
    }

    private List<Map<String, Object>> getSelectFormValue() {
        List context = (List)this.getView().getFormShowParameter().getCustomParam("context");
        ArrayList<Map<String, Object>> lstOrgFields = new ArrayList<Map<String, Object>>();
        if (context == null || context.size() == 0) {
            return lstOrgFields;
        }
        List lstFields = (List)context.get(0);
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        for (Map field : lstFields) {
            if (!field.get(TYPE).equals("OrgField") || field.get("Id").equals(itemId)) continue;
            lstOrgFields.add(field);
        }
        return lstOrgFields;
    }

    private void cancel() {
        this.getView().close();
    }

    private boolean checkInput() {
        boolean ret = true;
        Object relationtype2 = this.getModel().getValue(RELATION_TYPE_2);
        Object principalorg2 = this.getModel().getValue(PRINCIPAL_ORG_2);
        Object trusteeorg2 = this.getModel().getValue(TRUSTEE_ORG_2);
        if (!(StringUtils.isBlank((Object)relationtype2) && StringUtils.isBlank((Object)principalorg2) && StringUtils.isBlank((Object)trusteeorg2))) {
            if (StringUtils.isBlank((Object)relationtype2)) {
                ret = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u534f\u4f5c\u7c7b\u578b\u3002", (String)"OrgRelationCnfPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (StringUtils.isBlank((Object)principalorg2)) {
                ret = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u59d4\u6258\u7ec4\u7ec7\u3002", (String)"OrgRelationCnfPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (StringUtils.isBlank((Object)trusteeorg2)) {
                ret = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d7\u6258\u7ec4\u7ec7\u3002", (String)"OrgRelationCnfPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        }
        return ret;
    }

    private void close() {
        if (!this.checkInput()) {
            return;
        }
        Object relationtype2 = this.getModel().getValue(RELATION_TYPE_2);
        Object principalorg2 = this.getModel().getValue(PRINCIPAL_ORG_2);
        Object trusteeorg2 = this.getModel().getValue(TRUSTEE_ORG_2);
        Object relationtype = this.getModel().getValue(RELATION_TYPE);
        Object principalorg = this.getModel().getValue(PRINCIPAL_ORG);
        Object trusteeorg = this.getModel().getValue(TRUSTEE_ORG);
        if (!(StringUtils.isBlank((Object)relationtype2) && StringUtils.isBlank((Object)principalorg2) && StringUtils.isBlank((Object)trusteeorg2))) {
            if (principalorg.equals(trusteeorg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u59d4\u6258\u65b9\u548c\u53d7\u6258\u65b9\u4e0d\u53ef\u4e3a\u540c\u4e00\u7ec4\u7ec7\u3002", (String)"OrgRelationCnfPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String principalorgnumber = (String)((HashMap)SerializationUtils.fromJsonString((String)((String)principalorg), Map.class)).get(NUMBER);
            String principalorgname = (String)((HashMap)SerializationUtils.fromJsonString((String)((String)principalorg), Map.class)).get("Name");
            String trusteeorgnumber = (String)((HashMap)SerializationUtils.fromJsonString((String)((String)trusteeorg), Map.class)).get(NUMBER);
            String trusteeorgname = (String)((HashMap)SerializationUtils.fromJsonString((String)((String)trusteeorg), Map.class)).get("Name");
            String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
            String optype = this.getView().getFormShowParameter().getCloseCallBack().getActionId();
            JSONArray relations = (JSONArray)this.getView().getFormShowParameter().getCustomParam("relations");
            if (optype.equals("addrelation")) {
                for (Object relation : relations) {
                    String detail = (String)((Map)relation).get("detail");
                    Map cnf = (Map)SerializationUtils.fromJsonString((String)detail, Map.class);
                    String trusteenumber = (String)((Map)cnf.get(TRUSTEE)).get(NUMBER);
                    String principalnumber = (String)((Map)cnf.get(PRINCIPAL)).get(NUMBER);
                    if (trusteenumber.equals(trusteeorgnumber)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s \u5df2\u5b58\u5728\u53d7\u6258\u5173\u7cfb\u3002", (String)"OrgRelationCnfPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), trusteeorgname));
                        return;
                    }
                    if (!trusteenumber.equals(principalorgnumber) || !principalnumber.equals(trusteeorgnumber)) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s \u5df2\u59d4\u6258\u3002 %2$s\uff0c\u4e0d\u80fd\u76f8\u4e92\u59d4\u6258", (String)"OrgRelationCnfPlugin_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), trusteeorgname, principalorgname));
                    return;
                }
            } else if (optype.equals("modifyrelation")) {
                int index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
                int i = 0;
                for (Object relation : relations) {
                    String detail = (String)((Map)relation).get("detail");
                    Map cnf = (Map)SerializationUtils.fromJsonString((String)detail, Map.class);
                    String trusteenumber = (String)((Map)cnf.get(TRUSTEE)).get(NUMBER);
                    String principalnumber = (String)((Map)cnf.get(PRINCIPAL)).get(NUMBER);
                    if (trusteenumber.equals(trusteeorgnumber) && i != index) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s \u5df2\u5b58\u5728\u53d7\u6258\u5173\u7cfb\u3002", (String)"OrgRelationCnfPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), trusteeorgname));
                        return;
                    }
                    if (trusteenumber.equals(principalorgnumber) && i != index && principalnumber.equals(trusteeorgnumber)) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s \u5df2\u59d4\u6258\u3002 %2$s\uff0c\u4e0d\u80fd\u76f8\u4e92\u59d4\u6258", (String)"OrgRelationCnfPlugin_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), trusteeorgname, principalorgname));
                        return;
                    }
                    ++i;
                }
            }
            HashMap<String, Object> OrgRelationConfig = new HashMap<String, Object>();
            if (StringUtils.isBlank((Object)relationtype2)) {
                this.getModel().setValue(RELATION_TYPE, null);
            }
            if (StringUtils.isBlank((Object)principalorg2)) {
                this.getModel().setValue(PRINCIPAL_ORG, null);
            }
            if (StringUtils.isBlank((Object)trusteeorg2)) {
                this.getModel().setValue(TRUSTEE_ORG, null);
            }
            OrgRelationConfig.put(TYPE, "OrgRelationConfig");
            if (StringUtils.isNotBlank((Object)relationtype)) {
                OrgRelationConfig.put("Type", SerializationUtils.fromJsonString((String)((String)this.getModel().getValue(RELATION_TYPE)), Map.class));
            }
            if (StringUtils.isNotBlank((Object)principalorg)) {
                OrgRelationConfig.put(PRINCIPAL, SerializationUtils.fromJsonString((String)((String)this.getModel().getValue(PRINCIPAL_ORG)), Map.class));
            }
            if (StringUtils.isNotBlank((Object)trusteeorg)) {
                OrgRelationConfig.put(TRUSTEE, SerializationUtils.fromJsonString((String)((String)this.getModel().getValue(TRUSTEE_ORG)), Map.class));
                HashMap<String, String> mapDirect = new HashMap<String, String>();
                mapDirect.put("Index", TO_ORG);
                mapDirect.put("Display", ResManager.loadKDString((String)"\u672c\u7ec4\u7ec7\u662f\u53d7\u6258\u7ec4\u7ec7\u3002", (String)"OrgRelationCnfPlugin_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                mapDirect.put(TYPE, "OrgRelationItemDirect");
                OrgRelationConfig.put("Direct", mapDirect);
            }
            this.getView().returnDataToParent(OrgRelationConfig);
        }
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object rd;
        String actionId = evt.getActionId();
        if (PRINCIPAL_ORG.equalsIgnoreCase(actionId)) {
            Object rd2 = evt.getReturnData();
            if (rd2 != null) {
                if (evt.getReturnData() instanceof Integer) {
                    this.getModel().setValue(PRINCIPAL_ORG, null);
                } else {
                    this.getModel().setValue(PRINCIPAL_ORG, (Object)SerializationUtils.toJsonString((Object)rd2));
                    this.getModel().setValue(PRINCIPAL_ORG_2, ((Map)rd2).get("Name"));
                }
            }
        } else if ("selectRelationType".equalsIgnoreCase(actionId)) {
            Object rd3 = evt.getReturnData();
            if (rd3 != null) {
                if (evt.getReturnData() instanceof Integer) {
                    this.getModel().setValue(RELATION_TYPE, null);
                } else {
                    this.getModel().setValue(RELATION_TYPE, (Object)SerializationUtils.toJsonString((Object)rd3));
                    this.getModel().setValue(RELATION_TYPE_2, ((Map)rd3).get("Name"));
                }
            }
        } else if (TRUSTEE_ORG.equalsIgnoreCase(actionId) && (rd = evt.getReturnData()) != null) {
            if (evt.getReturnData() instanceof Integer) {
                this.getModel().setValue(TRUSTEE_ORG, null);
            } else {
                this.getModel().setValue(TRUSTEE_ORG, (Object)SerializationUtils.toJsonString((Object)rd));
                this.getModel().setValue(TRUSTEE_ORG_2, ((Map)rd).get("Name"));
            }
        }
    }

    private void updateOrgFieldCaption(String directIndex) {
        TextEdit orgCaption = (TextEdit)this.getView().getControl(ORGFIELD);
        if (StringUtils.isBlank((CharSequence)directIndex) || directIndex.equalsIgnoreCase(TO_ORG)) {
            orgCaption.setCaption(new LocaleString(ResManager.loadKDString((String)"\u59d4\u6258\u65b9\u7ec4\u7ec7\u5b57\u6bb5", (String)"OrgRelationCnfPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        } else if (directIndex.equalsIgnoreCase("fromorg")) {
            orgCaption.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53d7\u6258\u65b9\u7ec4\u7ec7\u5b57\u6bb5", (String)"OrgRelationCnfPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        }
    }

    private void showOrgNofication(String directIndex) {
        if (StringUtils.isBlank((CharSequence)directIndex) || directIndex.equalsIgnoreCase(TO_ORG)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u59d4\u6258\u65b9\u7ec4\u7ec7\u5b57\u6bb5\u3002", (String)"OrgRelationCnfPlugin_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        } else if (directIndex.equalsIgnoreCase("fromorg")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d7\u6258\u65b9\u7ec4\u7ec7\u5b57\u6bb5\u3002", (String)"OrgRelationCnfPlugin_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }
}

