/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.org;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.property.alias.OrgRelationPropertyConverter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.servicehelper.org.OrgServiceHelper;

public class OrgRelationConfigPlugin
extends AbstractFormPlugin
implements ClickListener {
    public static final String entryStatusControlKey = "entrystatuscontrol";
    private static final String RELATIONDIRECTION = "relationdirection";
    private static final String ORGFIELD = "orgfield2";
    private static final String RELATION_TYPE_2 = "relationtype2";
    private static final String VALUE = "value";
    private static final String RELATION_TYPE = "relationtype";
    private static final String ORG_FIELD1 = "orgfield";
    private static final String NUMBER = "Number";
    private static final String DIRECT = "Direct";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String ITEM_ID = "itemId";

    public void initialize() {
        this.addClickListeners(new String[]{RELATION_TYPE_2, ORGFIELD, "btnok", "btncancel"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(RELATIONDIRECTION)) {
            String org = (String)this.getModel().getValue(RELATIONDIRECTION);
            this.updateOrgFieldCaption(org);
        }
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParam(VALUE);
        List orgRelationList = null;
        if (value != null) {
            orgRelationList = (List)SerializationUtils.fromJsonString((String)value.toString(), List.class);
        }
        if (orgRelationList != null && orgRelationList.size() > 0) {
            Map item = (Map)orgRelationList.get(orgRelationList.size() - 1);
            if (item.get("Type") != null) {
                this.getModel().setValue(RELATION_TYPE, (Object)SerializationUtils.toJsonString(item.get("Type")));
                Map typeInfo = (Map)item.get("Type");
                String typeNumber = (String)typeInfo.get(NUMBER);
                String realTypeName = this.getRelationItemTypeName(typeNumber);
                if (StringUtils.isBlank((Object)realTypeName)) {
                    realTypeName = ((Map)item.get("Type")).get("Name");
                }
                this.getModel().setValue(RELATION_TYPE_2, (Object)realTypeName);
            }
            if (item.get("Org") != null) {
                this.getModel().setValue(ORG_FIELD1, (Object)SerializationUtils.toJsonString(item.get("Org")));
                String fieldKey = (String)((Map)item.get("Org")).get(NUMBER);
                String originName = (String)((Map)item.get("Org")).get("Name");
                String realName = this.getOrgFieldName(fieldKey);
                if (StringUtils.isBlank((CharSequence)realName)) {
                    realName = originName;
                }
                String orgfield2 = realName + "(" + fieldKey + ")";
                this.getModel().setValue(ORGFIELD, (Object)orgfield2);
            }
            if (item.get(DIRECT) != null) {
                String index = (String)((Map)item.get(DIRECT)).get("Index");
                this.getModel().setValue(RELATIONDIRECTION, (Object)index);
                this.updateOrgFieldCaption(index);
            }
        }
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        if (src instanceof Button) {
            Button btn = (Button)src;
            switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
                case "btnok": {
                    this.close();
                    break;
                }
                case "btncancel": {
                    this.cancel();
                    break;
                }
            }
        } else {
            Control ctrl = (Control)src;
            switch (ctrl.getKey().toLowerCase(Locale.ENGLISH)) {
                case "relationtype2": {
                    this.openSelectTypeForm();
                    break;
                }
                case "orgfield2": {
                    this.openSelectFieldForm();
                    break;
                }
            }
        }
    }

    private void openSelectTypeForm() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ide_org_relation_type");
        fsp.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u534f\u4f5c\u7c7b\u578b\u3002", (String)"OrgRelationConfigPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectRelationType"));
        this.getView().showForm(fsp);
    }

    private void openSelectFieldForm() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ide_field_single_select");
        fsp.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u7ec4\u7ec7\u5b57\u6bb5", (String)"OrgRelationConfigPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectOrgField"));
        fsp.setCustomParam(VALUE, this.getSelectFormValue());
        this.getView().showForm(fsp);
    }

    private List<Map<String, Object>> getSelectFormValue() {
        List context = (List)this.getView().getFormShowParameter().getCustomParam("context");
        List lstFields = (List)context.get(0);
        ArrayList<Map<String, Object>> lstOrgFields = new ArrayList<Map<String, Object>>();
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam(ITEM_ID);
        for (Map field : lstFields) {
            if (!field.get("_Type_").equals("OrgField") || field.get("Id").equals(itemId)) continue;
            lstOrgFields.add(field);
        }
        return lstOrgFields;
    }

    private String getOrgFieldName(String fieldKey) {
        List<Map<String, Object>> orgList = this.getSelectFormValue();
        if (orgList.isEmpty()) {
            return "";
        }
        for (Map<String, Object> org : orgList) {
            if (!StringUtils.equals((CharSequence)fieldKey, (CharSequence)String.valueOf(org.get("Key")))) continue;
            return org.getOrDefault("Name", "").toString();
        }
        return "";
    }

    private String getRelationItemTypeName(String typeNumber) {
        if (typeNumber == null) {
            return "";
        }
        List allType = OrgServiceHelper.getAllOrgRelationType();
        for (Map it : allType) {
            if (!StringUtils.equals((CharSequence)typeNumber, (CharSequence)it.getOrDefault("number", ""))) continue;
            return it.getOrDefault("name", "");
        }
        return typeNumber;
    }

    private void cancel() {
        this.getView().close();
    }

    private boolean checkInput() {
        boolean ret = true;
        Object relationtype2 = this.getModel().getValue(RELATION_TYPE_2);
        Object orgfield2 = this.getModel().getValue(ORGFIELD);
        Object relationdirection = this.getModel().getValue(RELATIONDIRECTION);
        if (!(StringUtils.isBlank((Object)relationtype2) && StringUtils.isBlank((Object)orgfield2) && StringUtils.isBlank((Object)relationdirection))) {
            if (StringUtils.isBlank((Object)relationtype2)) {
                ret = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u534f\u4f5c\u7c7b\u578b\u3002", (String)"OrgRelationConfigPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (StringUtils.isBlank((Object)relationdirection)) {
                ret = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u534f\u4f5c\u5173\u7cfb\u65b9\u5411\u3002", (String)"OrgRelationConfigPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (StringUtils.isBlank((Object)orgfield2)) {
                ret = false;
                String directIndex = (String)this.getModel().getValue(RELATIONDIRECTION);
                this.showOrgNofication(directIndex);
            }
        }
        return ret;
    }

    private void close() {
        if (!this.checkInput()) {
            return;
        }
        Object relationtype2 = this.getModel().getValue(RELATION_TYPE_2);
        Object orgfield2 = this.getModel().getValue(ORGFIELD);
        Object relationdirection = this.getModel().getValue(RELATIONDIRECTION);
        if (StringUtils.isNotBlank((Object)relationtype2) && StringUtils.isNotBlank((Object)orgfield2) && StringUtils.isNotBlank((Object)relationdirection)) {
            Object org;
            String orgD;
            OrgField mainOrg;
            String number = this.getView().getFormShowParameter().getParentFormId();
            String currentFieldId = (String)this.getView().getFormShowParameter().getCustomParam(ITEM_ID);
            List temp = (List)this.getView().getFormShowParameter().getCustomParam("context");
            PropertyEditHelper helper = new PropertyEditHelper();
            List<Map<String, Object>> entityitems = helper.getEntityMeta(this.getView());
            EntityMetadata entityMeta = EntityMetadataUtil.getEntityMetadata(entityitems);
            String mainOrgKey = "";
            String mainOrgId = entityMeta.getRootEntity().getMainOrg();
            if (StringUtils.isNotBlank((CharSequence)mainOrgId) && (mainOrg = (OrgField)entityMeta.getItemById(entityMeta.getRootEntity().getMainOrg())) != null) {
                mainOrgKey = mainOrg.getKey();
            }
            List lstMapControl = (List)temp.get(0);
            HashMap<String, Map> mapCtls = new HashMap<String, Map>(16);
            for (Map mapControl : lstMapControl) {
                mapCtls.put((String)mapControl.get("Id"), mapControl);
            }
            Map currentCtl = (Map)mapCtls.get(currentFieldId);
            String currentFieldKey = (String)currentCtl.get("Key");
            String currentFieldName = (String)currentCtl.get("Name");
            if (StringUtils.isNotBlank((CharSequence)mainOrgKey) && StringUtils.isNotBlank((CharSequence)currentFieldKey) && mainOrgKey.equalsIgnoreCase(currentFieldKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u914d\u7f6e\u59d4\u6258\u5173\u7cfb\u3002", (String)"OrgRelationConfigPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            Map mapOrgDes = (Map)SerializationUtils.fromJsonString((String)((String)this.getModel().getValue(ORG_FIELD1)), Map.class);
            String orgDes = (String)mapOrgDes.get(NUMBER);
            String orgDesName = (String)mapOrgDes.get("Name");
            String orgDesId = (String)mapOrgDes.get("Id");
            Map orgDesCtl = (Map)mapCtls.get(orgDesId);
            List lstROP = (List)orgDesCtl.get("OrgRelation");
            if (lstROP != null && lstROP.size() > 0 && StringUtils.isNotBlank((CharSequence)(orgD = ((JSONObject)(org = ((JSONObject)lstROP.get(0)).get((Object)"Org"))).getString(NUMBER))) && StringUtils.isNotBlank((CharSequence)currentFieldKey) && currentFieldKey.equalsIgnoreCase(orgD)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u4e2d\u5df2\u914d%3$s(%4$s)\u7684\u59d4\u6258\u5173\u7cfb,\u7981\u6b62\u7ec4\u7ec7\u76f8\u4e92\u914d\u7f6e\u59d4\u6258\u5173\u7cfb", (String)"OrgRelationConfigPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), orgDesName, orgDes, currentFieldName, currentFieldKey));
                return;
            }
        }
        ArrayList<HashMap<String, Object>> OrgRelationList = null;
        HashMap<String, Object> OrgRelation = new HashMap<String, Object>();
        if (StringUtils.isBlank((Object)relationtype2)) {
            this.getModel().setValue(RELATION_TYPE, null);
        }
        if (StringUtils.isBlank((Object)orgfield2)) {
            this.getModel().setValue(ORG_FIELD1, null);
        }
        Object relationtype = this.getModel().getValue(RELATION_TYPE);
        Object orgfield = this.getModel().getValue(ORG_FIELD1);
        OrgRelation.put("_Type_", "OrgRelationItem");
        if (StringUtils.isNotBlank((Object)relationtype)) {
            OrgRelation.put("Type", SerializationUtils.fromJsonString((String)((String)this.getModel().getValue(RELATION_TYPE)), Map.class));
        }
        if (StringUtils.isNotBlank((Object)orgfield)) {
            OrgRelation.put("Org", SerializationUtils.fromJsonString((String)((String)this.getModel().getValue(ORG_FIELD1)), Map.class));
        }
        if (StringUtils.isNotBlank((Object)relationdirection)) {
            HashMap<String, Object> OrgRelationDirect = new HashMap<String, Object>();
            Object oord = this.getModel().getValue(RELATIONDIRECTION);
            if (StringUtils.isNotBlank((Object)oord)) {
                OrgRelationDirect.put("Index", oord);
                ComboProp ord = (ComboProp)this.getModel().getDataEntityType().getProperty(RELATIONDIRECTION);
                String ordDisplay = ord.getItemByName((String)oord);
                OrgRelationDirect.put("Display", ordDisplay);
                OrgRelation.put(DIRECT, OrgRelationDirect);
            }
        }
        if (!(StringUtils.isBlank((Object)relationtype) && StringUtils.isBlank((Object)orgfield) && StringUtils.isBlank((Object)relationdirection))) {
            OrgRelationList = new ArrayList<HashMap<String, Object>>();
            OrgRelationList.add(OrgRelation);
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put(VALUE, OrgRelationList);
        ArrayList aliasConvertData = new ArrayList();
        if (OrgRelationList != null && OrgRelationList.size() > 0) {
            aliasConvertData.add(OrgRelationList.get(OrgRelationList.size() - 1));
        }
        para.put("alias", new OrgRelationPropertyConverter().convert(aliasConvertData));
        ArrayList<HashMap<String, Object>> paras = new ArrayList<HashMap<String, Object>>();
        paras.add(para);
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object rd;
        String actionId = evt.getActionId();
        if ("selectOrgField".equalsIgnoreCase(actionId)) {
            Object rd2 = evt.getReturnData();
            if (rd2 != null) {
                if (evt.getReturnData() instanceof Integer) {
                    this.getModel().setValue(ORG_FIELD1, null);
                } else {
                    this.getModel().setValue(ORG_FIELD1, (Object)SerializationUtils.toJsonString((Object)rd2));
                    String orgfield2 = (String)((Map)rd2).get("Name") + "(" + ((Map)rd2).get(NUMBER) + ")";
                    this.getModel().setValue(ORGFIELD, (Object)orgfield2);
                }
            }
        } else if ("selectRelationType".equalsIgnoreCase(actionId) && (rd = evt.getReturnData()) != null) {
            if (evt.getReturnData() instanceof Integer) {
                this.getModel().setValue(RELATION_TYPE, null);
            } else {
                this.getModel().setValue(RELATION_TYPE, (Object)SerializationUtils.toJsonString((Object)rd));
                this.getModel().setValue(RELATION_TYPE_2, ((Map)rd).get("Name"));
            }
        }
    }

    private void updateOrgFieldCaption(String directIndex) {
        TextEdit orgCaption = (TextEdit)this.getView().getControl(ORGFIELD);
        if (StringUtils.isBlank((CharSequence)directIndex) || directIndex.equalsIgnoreCase("toorg")) {
            orgCaption.setCaption(new LocaleString(ResManager.loadKDString((String)"\u59d4\u6258\u65b9\u7ec4\u7ec7\u5b57\u6bb5", (String)"OrgRelationConfigPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        } else if (directIndex.equalsIgnoreCase("fromorg")) {
            orgCaption.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53d7\u6258\u65b9\u7ec4\u7ec7\u5b57\u6bb5", (String)"OrgRelationConfigPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        }
    }

    private void showOrgNofication(String directIndex) {
        if (StringUtils.isBlank((CharSequence)directIndex) || directIndex.equalsIgnoreCase("toorg")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u59d4\u6258\u65b9\u7ec4\u7ec7\u5b57\u6bb5\u3002", (String)"OrgRelationConfigPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        } else if (directIndex.equalsIgnoreCase("fromorg")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d7\u6258\u65b9\u7ec4\u7ec7\u5b57\u6bb5\u3002", (String)"OrgRelationConfigPlugin_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }
}

