/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.parameter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.ImportParameter;
import kd.bos.metadata.entity.operation.ImportPreInsFile;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.upload.UploadOption;

public class ImportDataParaEditPlugin
extends AbstractFormPlugin
implements UploadListener,
RowClickEventListener {
    private static final String PLUGINS = "plugins";
    private static final String UPLOAD_CALLBACK = "upload_callback";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String PREINS_FILE = "preinsfile";
    private static final String ENABLED = "enabled";
    private static final String LOCK_CACHE = "lockImportPreInsFile_cache";
    private static final Log LOG = LogFactory.getLog(ImportDataParaEditPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{PLUGINS});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        Label label = (Label)this.getControl(UPLOAD_CALLBACK);
        label.addUploadListener((UploadListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map parameter = (Map)this.getView().getFormShowParameter().getCustomParams().get("Parameter");
        if (StringUtils.isNotBlank((Object)parameter)) {
            EntityMetadata entityMetadata = null;
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
            if (StringUtils.isNotBlank((CharSequence)entityId)) {
                entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            }
            IDataModel model = this.getModel();
            String plugins = parameter.get("Plugins") == null ? "[]" : parameter.get("Plugins").toString();
            plugins = this.revisePluginInherit(plugins, entityMetadata);
            model.setValue(PLUGINS, (Object)plugins);
            List preInsFiles = (List)parameter.get("PreInsFiles");
            if (preInsFiles != null) {
                int[] rows = model.batchCreateNewEntryRow(ENTRY_ENTITY, preInsFiles.size());
                for (int i = 0; i < rows.length; ++i) {
                    model.setValue(PREINS_FILE, ((Map)preInsFiles.get(i)).get("Url"), rows[i]);
                    model.setValue(ENABLED, ((Map)preInsFiles.get(i)).get("Enabled"), rows[i]);
                }
            }
            this.lockPropertyByBusExt();
        }
    }

    private void lockPropertyByBusExt() {
        try {
            HashSet<String> lockImportPreInsFile = new HashSet<String>(10);
            String lockType = (String)this.getView().getFormShowParameter().getCustomParam("lockType");
            if ("speciallock".equals(lockType)) {
                List operations;
                EntityMetadata entityMetadata;
                List isvList = DesignerUtils.ISV_LIST;
                String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
                if (StringUtils.isNotBlank((CharSequence)entityId) && (entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity)) != null && (operations = entityMetadata.getRootEntity().getOperations()) != null && !operations.isEmpty()) {
                    List preInsFiles;
                    Operation operation;
                    ImportParameter parameter;
                    String opId = (String)this.getView().getFormShowParameter().getCustomParam("opId");
                    Optional<Operation> first = operations.stream().filter(op -> opId.equals(op.getId())).findFirst();
                    if (first.isPresent() && (parameter = (ImportParameter)(operation = first.get()).getParameter()) != null && (preInsFiles = parameter.getPreInsFiles()) != null && !preInsFiles.isEmpty()) {
                        for (ImportPreInsFile preInsFile : preInsFiles) {
                            if (!isvList.contains(preInsFile.getIsv()) || StringUtils.equals((CharSequence)preInsFile.getIsv(), (CharSequence)entityMetadata.getIsv()) || !"2".equals(entityMetadata.getDevType())) continue;
                            lockImportPreInsFile.add(preInsFile.getUrl());
                        }
                    }
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                for (int i = 0; i < entryEntity.getRowCount(); ++i) {
                    String url = ((DynamicObject)entryEntity.get(i)).getString(PREINS_FILE);
                    if (!lockImportPreInsFile.contains(url)) continue;
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{PREINS_FILE, ENABLED});
                }
            }
            this.getPageCache().put(LOCK_CACHE, SerializationUtils.toJsonString(lockImportPreInsFile));
        }
        catch (Exception e) {
            LOG.info("lockPropertyByBusExt error", (Object)e);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Set lockImportPreInsFile;
        super.entryRowClick(evt);
        if (evt.getRow() < 0) {
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"btndel"});
        String s = this.getPageCache().get(LOCK_CACHE);
        if (StringUtils.isNotBlank((CharSequence)s) && (lockImportPreInsFile = (Set)SerializationUtils.fromJsonString((String)s, Set.class)) != null && !lockImportPreInsFile.isEmpty()) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            String url = (String)this.getModel().getValue(PREINS_FILE, evt.getRow());
            if (lockImportPreInsFile.contains(url)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btndel"});
            }
        }
    }

    private String revisePluginInherit(String plugins, EntityMetadata entityMetadata) {
        if (entityMetadata == null || !"2".equals(entityMetadata.getDevType()) || StringUtils.isBlank((CharSequence)plugins)) {
            return plugins;
        }
        EntityMetadata parentMeta = (EntityMetadata)MetadataDao.readMeta((String)entityMetadata.getParentId(), (MetaCategory)MetaCategory.Entity);
        if (parentMeta != null) {
            String opId = (String)this.getView().getFormShowParameter().getCustomParam("opId");
            List operations = parentMeta.getRootEntity().getOperations();
            String parentFormOpPlugin = "[]";
            if (!operations.isEmpty()) {
                for (Operation op : operations) {
                    if (!opId.equals(op.getId())) continue;
                    parentFormOpPlugin = ((ImportParameter)op.getParameter()).getPlugins();
                }
            }
            List parentPluginList = (List)SerializationUtils.fromJsonString((String)(StringUtils.isBlank((CharSequence)parentFormOpPlugin) ? "[]" : parentFormOpPlugin), List.class);
            List pluginList = (List)SerializationUtils.fromJsonString((String)plugins, List.class);
            Set sourceClassName = parentPluginList.stream().map(m -> (String)m.get("ClassName")).collect(Collectors.toSet());
            pluginList.forEach(map -> {
                String className = (String)map.get("ClassName");
                if (sourceClassName.contains(className)) {
                    map.put("Inherit", true);
                }
            });
            this.deleteTextClearButton(PLUGINS);
            return SerializationUtils.toJsonString((Object)pluginList);
        }
        return plugins;
    }

    private void deleteTextClearButton(String buttonKey) {
        HashMap<String, Boolean> editor = new HashMap<String, Boolean>();
        HashMap<String, HashMap<String, Boolean>> item = new HashMap<String, HashMap<String, Boolean>>();
        editor.put("showClearButton", false);
        item.put("item", editor);
        this.getView().updateControlMetadata(buttonKey, item);
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "plugins": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("ide_plugins");
                Object plugins = this.getModel().getValue(PLUGINS);
                parameter.setCustomParam("value", plugins == null || StringUtils.isBlank((CharSequence)plugins.toString()) ? new ArrayList() : SerializationUtils.fromJsonStringToList((String)plugins.toString(), Map.class));
                parameter.setCustomParam("formId", this.getView().getFormShowParameter().getCustomParam("formId"));
                parameter.setCustomParam("showeventtab", (Object)Boolean.FALSE);
                parameter.setCustomParam("scriptfiltertype", (Object)"importData");
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectServicePlugins"));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "btnupload": {
                UploadOption opt = new UploadOption();
                opt.setMultiple(true);
                opt.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6", (String)"ImportDataParaEditPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
                opt.setSuffix(".xlsx");
                this.getView().showUpload(opt, UPLOAD_CALLBACK);
                break;
            }
        }
    }

    public void upload(UploadEvent evt) {
        if (UPLOAD_CALLBACK.equals(((Control)evt.getSource()).getKey())) {
            Object[] urls = evt.getUrls();
            IDataModel model = this.getModel();
            int[] rows = model.batchCreateNewEntryRow(ENTRY_ENTITY, urls.length);
            for (int i = 0; i < rows.length; ++i) {
                model.setValue(PREINS_FILE, ((Map)urls[i]).get("url"), rows[i]);
                model.setValue(ENABLED, (Object)true, rows[i]);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        if ("selectServicePlugins".equalsIgnoreCase(actionId)) {
            Map ret = (Map)evt.getReturnData();
            List plugins = (List)ret.get("value");
            this.getModel().setValue(PLUGINS, (Object)SerializationUtils.toJsonString((Object)plugins));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("deleteentry".equals(e.getOperateKey())) {
            String cache = this.getPageCache().get(LOCK_CACHE);
            Set set = StringUtils.isNotBlank((CharSequence)cache) ? (Set)SerializationUtils.fromJsonString((String)cache, Set.class) : new HashSet(10);
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length > 0) {
                int currentRow = selectRows[0];
                String id = (String)this.getModel().getValue(PREINS_FILE, currentRow);
                if (set.contains(id)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"btndel"});
                }
            }
        }
    }
}

