/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.parameter;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;

public class OpenFormParaEditPlugin
extends AbstractFormPlugin {
    private static final String TARGET_KEY = "targetkey";
    private static final String SHOW_TYPE = "ShowType";
    private static final String MODEL_TYPE = "modeltype";
    private static final String MODEL_TYPE1 = "ModelType";
    private static final String SHOW_TYPE1 = "showtype";
    private static final String CURRENT_TYPE = "currentType";
    private static final String BILL_FORM_MODEL = "BillFormModel";
    private static final String BASE_FORM_MODEL = "BaseFormModel";
    private static final String LIST = "list";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void afterCreateNewData(EventObject e) {
        Map parameter = (Map)this.getView().getFormShowParameter().getCustomParam("Parameter");
        if (parameter == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TARGET_KEY});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(this.isShowTargetKey(parameter.get(SHOW_TYPE))), new String[]{TARGET_KEY});
        this.getModel().setValue("form", parameter.get("Form"));
        this.getModel().setValue(MODEL_TYPE, parameter.get(MODEL_TYPE1));
        this.getModel().setValue(SHOW_TYPE1, parameter.get(SHOW_TYPE));
        this.getModel().setValue(TARGET_KEY, parameter.get("TargetKey"));
        this.setMobileBillNumberValue(parameter);
        String currentType = "type_" + parameter.get(SHOW_TYPE);
        this.getPageCache().put(CURRENT_TYPE, currentType);
        this.getPageCache().put(currentType, (String)parameter.get("TargetKey"));
        JSONArray metaContext = (JSONArray)this.getView().getFormShowParameter().getCustomParam("MetaContext");
        if (metaContext == null) {
            return;
        }
        this.setFormFilter((String)parameter.get(MODEL_TYPE1));
        this.updateComboEdit((String)parameter.get(MODEL_TYPE1));
    }

    private void setFormFilterMobile() {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("form");
        basedataEdit.setQFilter(new QFilter(MODEL_TYPE, "in", (Object)new Object[]{"MobileFormModel"}));
    }

    private void setFormFilterPC() {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("form");
        basedataEdit.setQFilter(new QFilter(MODEL_TYPE, "in", (Object)new Object[]{"DynamicFormModel"}));
    }

    private void setFormFilter(Object[] modelTypes) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("form");
        basedataEdit.setQFilter(new QFilter(MODEL_TYPE, "in", (Object)modelTypes));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (TARGET_KEY.equals(e.getProperty().getName())) {
            String currentType = this.getPageCache().get(CURRENT_TYPE);
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.getPageCache().remove(currentType);
            } else {
                this.getPageCache().put(currentType, newValue.toString());
            }
            return;
        }
        if (SHOW_TYPE1.equals(e.getProperty().getName())) {
            String string = e.getChangeSet()[0].getNewValue().toString();
            int value = -1;
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                value = Integer.parseInt(e.getChangeSet()[0].getNewValue().toString());
            }
            Boolean isShowTargetKey = this.isShowTargetKey(value);
            this.getView().setVisible(isShowTargetKey, new String[]{TARGET_KEY});
            String currentType = "type_" + value;
            this.getPageCache().put(CURRENT_TYPE, currentType);
            String currentTypeTargetKey = this.getPageCache().get(currentType);
            this.getModel().setValue(TARGET_KEY, (Object)currentTypeTargetKey);
            return;
        }
        if (MODEL_TYPE.equals(e.getProperty().getName())) {
            String modelType = e.getChangeSet()[0].getNewValue().toString();
            this.setFormFilter(modelType);
            this.getModel().setValue("form", null);
            this.getModel().setValue(SHOW_TYPE1, (Object)"");
            this.getModel().setValue("mobilebillnumber", null);
            this.updateComboEdit(modelType);
        }
        if ("form".equals(e.getProperty().getName())) {
            this.setMobileBillNumberValue((Map)this.getView().getFormShowParameter().getCustomParam("Parameter"));
        }
    }

    private void updateComboEdit(String modelType) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(SHOW_TYPE1);
        List<ComboItem> comboItems = this.getComboItems(modelType);
        comboEdit.setComboItems(comboItems);
    }

    private List<ComboItem> getComboItems(String value) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        comboItems.add(new ComboItem(null, new LocaleString(ResManager.loadKDString((String)"\u65b0\u9875\u7b7e", (String)"OpenFormParaEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "1", true));
        comboItems.add(new ComboItem(null, new LocaleString(ResManager.loadKDString((String)"\u5305\u542b", (String)"OpenFormParaEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "3", true));
        comboItems.add(new ComboItem(null, new LocaleString(ResManager.loadKDString((String)"\u6d6e\u52a8", (String)"OpenFormParaEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "4", true));
        comboItems.add(new ComboItem(null, new LocaleString(ResManager.loadKDString((String)"\u975e\u6a21\u6001", (String)"OpenFormParaEditPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "5", false));
        comboItems.add(new ComboItem(null, new LocaleString(ResManager.loadKDString((String)"\u6a21\u6001\u663e\u793a", (String)"OpenFormParaEditPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "6", true));
        comboItems.add(new ComboItem(null, new LocaleString(ResManager.loadKDString((String)"\u65b0\u6d4f\u89c8\u5668\u7a97\u53e3", (String)"OpenFormParaEditPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "10", true));
        comboItems.add(new ComboItem(null, new LocaleString("IFrame"), "11", false));
        comboItems.add(new ComboItem(null, new LocaleString(ResManager.loadKDString((String)"\u4e3b\u754c\u9762\u65b0\u9875\u7b7e", (String)"OpenFormParaEditPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "7", false));
        if (StringUtils.isBlank((CharSequence)value)) {
            return comboItems;
        }
        if (value.startsWith("mobile")) {
            ((ComboItem)comboItems.get(0)).setItemVisible(false);
        } else {
            ((ComboItem)comboItems.get(2)).setItemVisible(false);
            if (LIST.equals(value)) {
                ((ComboItem)comboItems.get(7)).setItemVisible(true);
            }
        }
        return comboItems;
    }

    private void setFormFilter(String modelType) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>(16);
        map.put("form", new Object[]{"DynamicFormModel"});
        map.put("bill", new Object[]{BILL_FORM_MODEL});
        map.put("base", new Object[]{BASE_FORM_MODEL});
        map.put(LIST, new Object[]{BILL_FORM_MODEL, BASE_FORM_MODEL});
        map.put("mobileform", new Object[]{"MobileFormModel"});
        map.put("mobilebill", new Object[]{"MobileBillFormModel", BILL_FORM_MODEL});
        map.put("mobilelist", new Object[]{"MobileBillFormModel", BILL_FORM_MODEL, BASE_FORM_MODEL});
        this.setFormFilter((Object[])map.getOrDefault(modelType, null));
    }

    private boolean isShowTargetKey(Object value) {
        if (StringUtils.isBlank((Object)value)) {
            return false;
        }
        return this.isShowTargetKey(Integer.parseInt(value.toString()));
    }

    private boolean isShowTargetKey(int value) {
        return value == ShowType.NewTabPage.getValue() || value == ShowType.InContainer.getValue() || value == ShowType.IFrame.getValue();
    }

    private void setMobileBillNumberValue(Map<String, Object> parameter) {
        Object obj;
        if (parameter != null && (obj = this.getModel().getValue("form")) instanceof DynamicObject && "mobilebill".equals(parameter.get(MODEL_TYPE1))) {
            String number = String.valueOf(((DynamicObject)obj).get("number"));
            String modeltype = String.valueOf(((DynamicObject)obj).get(MODEL_TYPE));
            if (StringUtils.equals((CharSequence)BILL_FORM_MODEL, (CharSequence)modeltype)) {
                this.getModel().setValue("mobilebillnumber", (Object)(number + "_mob"));
            } else {
                this.getModel().setValue("mobilebillnumber", (Object)number);
            }
        }
    }
}

