/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.CultureInfoUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

public class OperationParaEditPlugin
extends AbstractFormPlugin {
    private static final String AFTER_OPERATION = "AfterOperation";
    private static final String OPERATE_STATUS = "operatestatus";

    public void afterCreateNewData(EventObject e) {
        List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get("MetaContext");
        Map parameter = (Map)this.getView().getFormShowParameter().getCustomParams().get("Parameter");
        this.updateComboItems((List)formContext.get(0), parameter);
        this.setSaveAndSubmitCombo(parameter);
        this.setCheckDataCombo(parameter);
        this.lockPropertyByBusExt();
    }

    private void lockPropertyByBusExt() {
        String lockType = (String)this.getView().getFormShowParameter().getCustomParam("lockType");
        if ("speciallock".equals(lockType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"operatestatusfield", "relateoperate", "checkdataversion"});
        }
    }

    private void setSaveAndSubmitCombo(Map<String, Object> parameter) {
        IFormView parentView = this.getView().getParentView();
        FormShowParameter parentParam = parentView.getFormShowParameter();
        Map op = (Map)parentParam.getCustomParam("op");
        Object type = parentView.getModel().getValue("ftype");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"saveop"});
        if (!CollectionUtils.isEmpty((Map)op) && "submit".equals(op.get("OperationType")) || "submit".equals(type)) {
            ComboEdit combo = (ComboEdit)this.getView().getControl("saveop");
            if (combo != null) {
                ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                ArrayList<String> saveKeys = new ArrayList<String>();
                List ops = (List)parentParam.getCustomParam("Ops");
                if (!CollectionUtils.isEmpty((Collection)ops)) {
                    for (Map operate : ops) {
                        Object opType = operate.get("OperationType");
                        if (!"save".equals(opType)) continue;
                        LocaleString caption = new LocaleString(operate.get("Name").toString());
                        String value = operate.get("Key").toString();
                        items.add(new ComboItem(caption, value));
                        saveKeys.add(value);
                    }
                    combo.setComboItems(items);
                    this.getView().getPageCache().put("saveOpKeys", SerializationUtils.toJsonString(saveKeys));
                }
                if (parameter != null && parameter.get("SaveOpSetting") != null) {
                    Map saveOpSetting = (Map)parameter.get("SaveOpSetting");
                    String saveOp = saveOpSetting.get("key").toString();
                    if (saveOpSetting.get("isSave") == null) {
                        if (StringUtils.isNotBlank((CharSequence)saveOp)) {
                            this.getModel().setValue("issave", (Object)true);
                        }
                    } else {
                        this.getModel().setValue("issave", saveOpSetting.get("isSave"));
                    }
                    if (saveKeys.isEmpty()) {
                        saveOp = "";
                    } else if (!saveKeys.contains(saveOp)) {
                        saveOp = (String)saveKeys.get(0);
                    }
                    this.getModel().setValue("saveop", (Object)saveOp);
                }
                if (this.getModel().getValue("issave") != null && ((Boolean)this.getModel().getValue("issave")).booleanValue() && items.size() > 1) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"saveop"});
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"issavepanel"});
        }
    }

    private void setCheckDataCombo(Map<String, Object> parameter) {
        List<String> enableOps = Arrays.asList("save", "submit", "audit");
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object opType = params.getOrDefault("OpType", null);
        if (opType == null || !enableOps.contains(opType.toString())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"checkdataversion"});
        } else {
            Boolean checkDataVersion = parameter != null ? parameter.getOrDefault("CheckDataVersion", false) : Boolean.valueOf(false);
            this.getView().getModel().setValue("checkdataversion", (Object)checkDataVersion);
        }
    }

    private void updateComboItems(List<Map<String, Object>> formContext, Map<String, Object> parameter) {
        ArrayList<ComboItem> statusFieldItems = new ArrayList<ComboItem>();
        HashMap<String, List> statusItems = new HashMap<String, List>();
        ArrayList relateOperate = new ArrayList();
        if (formContext != null) {
            for (Map<String, Object> field : formContext) {
                String fieldType = field.get("_Type_").toString();
                String fieldId = field.get("Id").toString();
                if (!fieldType.equalsIgnoreCase("BillStatusField")) continue;
                statusFieldItems.add(new ComboItem(new LocaleString(CultureInfoUtils.getDefaultLCId(), field.get("Name").toString()), fieldId));
                Object itemsObj = field.get("StatusItems");
                List items = itemsObj instanceof List ? (List)itemsObj : new ArrayList();
                statusItems.put(fieldId, items);
            }
            this.getPageCache().put("statusItems", SerializationUtils.toJsonString(statusItems));
            ComboEdit combo = (ComboEdit)this.getView().getControl("OperateStatusField");
            combo.setComboItems(statusFieldItems);
            combo = (ComboEdit)this.getView().getControl("RelateOperate");
            combo.setComboItems(relateOperate);
        }
        if (statusFieldItems.size() > 0) {
            String statusFieldId = parameter != null && parameter.containsKey("StatusFieldId") ? parameter.get("StatusFieldId").toString() : ((ComboItem)statusFieldItems.get(0)).getValue();
            this.getModel().setValue("OperateStatusField", (Object)statusFieldId);
            ComboEdit statusCombo = (ComboEdit)this.getView().getControl("OperateStatus");
            if (statusCombo != null) {
                List<ComboItem> statusComboItems = this.getComboItemsFromMaps((List)statusItems.get(statusFieldId));
                statusCombo.setComboItems(statusComboItems);
                if (statusComboItems.size() > 0) {
                    this.getModel().setValue("OperateStatus", parameter != null && parameter.containsKey("Value") ? parameter.get("Value") : statusComboItems.get(0).getValue());
                }
            }
        }
        if (parameter != null && parameter.containsKey(AFTER_OPERATION)) {
            this.getModel().setValue(AFTER_OPERATION, parameter.get(AFTER_OPERATION));
        }
    }

    public List<ComboItem> getComboItemsFromMaps(List<Map<String, Object>> list) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (list != null) {
            for (Map<String, Object> map : list) {
                items.add(new ComboItem(new LocaleString(map.get("statusname").toString()), map.get("statuskey").toString()));
            }
        }
        return items;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equalsIgnoreCase("operatestatusfield")) {
            String value = e.getChangeSet()[0].getNewValue().toString();
            if (this.getView().getControl(OPERATE_STATUS) != null) {
                ComboEdit combo = (ComboEdit)this.getView().getControl(OPERATE_STATUS);
                Map statusItems = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("statusItems"), Map.class);
                List<ComboItem> statusComboItems = this.getComboItemsFromMaps((List)statusItems.get(value));
                combo.setComboItems(statusComboItems);
                if (statusComboItems.size() > 0) {
                    this.getModel().setValue(OPERATE_STATUS, (Object)statusComboItems.get(0).getValue());
                }
            }
        } else if (e.getProperty().getName().equalsIgnoreCase("afteroperation")) {
            String value = e.getChangeSet()[0].getNewValue().toString();
            this.getModel().setValue("afteroperation", (Object)value);
        } else if (e.getProperty().getName().equalsIgnoreCase("issave")) {
            Boolean isSave = (Boolean)e.getChangeSet()[0].getNewValue();
            if (isSave.booleanValue()) {
                String str = this.getView().getPageCache().get("saveOpKeys");
                if (StringUtils.isNotBlank((CharSequence)str)) {
                    List saveOpKeys = SerializationUtils.fromJsonStringToList((String)str, String.class);
                    String saveOpValue = "";
                    if (!saveOpKeys.isEmpty()) {
                        String saveOpKey;
                        Object saveOp;
                        if (saveOpKeys.size() > 1) {
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"saveop"});
                        }
                        saveOpValue = (saveOp = this.getModel().getValue("saveop")) != null ? (StringUtils.isBlank((CharSequence)(saveOpKey = saveOp.toString())) ? (String)saveOpKeys.get(0) : (!saveOpKeys.contains(saveOpKey) ? (String)saveOpKeys.get(0) : saveOpKey)) : (String)saveOpKeys.get(0);
                    }
                    this.getModel().setValue("saveop", (Object)saveOpValue);
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"saveop"});
            }
        }
    }
}

