/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.parameter;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.billstatusfield.StatusItem;
import kd.bos.metadata.entity.operation.AbstractOpParameterPlugin;
import kd.bos.metadata.entity.operation.RowStatusConvertParameter;

public class RowStatusConvertParaEditPlugin
extends AbstractOpParameterPlugin<RowStatusConvertParameter> {
    private static final String KEY_ISFULLBILLOPERATE = "isfullbilloperate";
    private static final String KEY_STATUSFIELDID = "statusfieldid";
    private static final String KEY_STATUS = "status";

    public boolean check(StringBuilder sbMsg) {
        String statusFieldId = (String)this.getModel().getValue(KEY_STATUSFIELDID);
        String status = (String)this.getModel().getValue(KEY_STATUS);
        if (StringUtils.isBlank((CharSequence)statusFieldId)) {
            sbMsg.append(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u72b6\u6001\u5b57\u6bb5\u3002", (String)"RowStatusConvertParaEditPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)status)) {
            sbMsg.append(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u72b6\u6001\u503c\u3002", (String)"RowStatusConvertParaEditPlugin_2", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected RowStatusConvertParameter createNewOpParameter() {
        return new RowStatusConvertParameter();
    }

    protected IDataEntityType getDataEntityType() {
        return DataEntityType.getDataEntityType(RowStatusConvertParameter.class);
    }

    protected void showParameter(RowStatusConvertParameter v) {
        this.getModel().setValue(KEY_ISFULLBILLOPERATE, (Object)v.isFullBillOperate());
        this.getModel().setValue(KEY_STATUSFIELDID, (Object)v.getStatusFieldId());
        this.getModel().setValue(KEY_STATUS, (Object)v.getValue());
    }

    protected void returnParameter(RowStatusConvertParameter v) {
        v.setFullBillOperate(((Boolean)this.getModel().getValue(KEY_ISFULLBILLOPERATE)).booleanValue());
        v.setStatusFieldId((String)this.getModel().getValue(KEY_STATUSFIELDID));
        v.setValue((String)this.getModel().getValue(KEY_STATUS));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillStatusFieldCombo();
        this.fillStatusValueCombo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)KEY_STATUSFIELDID, (CharSequence)e.getProperty().getName())) {
            this.fillStatusValueCombo();
        }
    }

    private void fillStatusFieldCombo() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        ArrayList<ComboItem> statusFieldComboItems = new ArrayList<ComboItem>();
        for (EntityItem item : entityMetadata.getItems()) {
            if (!(item instanceof BillStatusField)) continue;
            ComboItem comboItem = new ComboItem(item.getName(), item.getId());
            statusFieldComboItems.add(comboItem);
        }
        if (statusFieldComboItems != null) {
            ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_STATUSFIELDID);
            billEditor.setComboItems(statusFieldComboItems);
        }
    }

    private void fillStatusValueCombo() {
        BillStatusField field;
        EntityMetadata entityMetadata = this.getEntityMetadata();
        String statusFieldId = (String)this.getModel().getValue(KEY_STATUSFIELDID);
        ArrayList<ComboItem> statusValueComboItems = new ArrayList<ComboItem>();
        if (StringUtils.isNotBlank((CharSequence)statusFieldId) && (field = (BillStatusField)entityMetadata.getItemById(statusFieldId)) != null) {
            for (StatusItem statusItem : field.getStatusItems()) {
                ComboItem comboItem = new ComboItem(statusItem.getStatusName(), statusItem.getStatusKey());
                statusValueComboItems.add(comboItem);
            }
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_STATUS);
        billEditor.setComboItems(statusValueComboItems);
    }
}

