/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.annotation.Plugin;
import kd.bos.entity.plugin.annotation.ResolveKey;
import kd.bos.entity.plugin.manager.EventMethod;
import kd.bos.entity.plugin.manager.EventMethodTypes;
import kd.bos.entity.plugin.manager.IConditionEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

@Plugin(description="Add or edit disabled events to allow businesses to add overrideIgnore and disable it")
public class AddEventPlugin
extends AbstractFormPlugin {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String OK = "ok";
    private static final String PLUGIN_CLASS_NAME = "ClassName";
    private static final String PLUGIN_TYPE_NAME = "Type";
    private static final String PLUGIN_EVENT_ID = "Id";
    private static final String PLUGIN_EVENT_REMARK = "Remark";
    private static final String PLUGIN_EVENT_PARAM_CONDITION = "ParamCondition";
    private static final String PLUGIN_EVENT_SIMPLE_EXPR = "SimpleExpr";
    private static final String PLUGIN_EVENT_EXPRESSION = "Expression";
    private static final String ENTRY_EVENT_CLASS_NAME = "classnamecombo";
    private static final String ENTRY_EVENT_NAME = "eventname";
    private static final String ENTRY_EVENT_ID = "eventid";
    private static final String ENTRY_EVENT_SIMPLE_EXPR = "simpleexpr";
    private static final String ENTRY_EVENT_EXPRESSION = "expression";
    private static final String ENTRY_EVENT_REMARK = "remark";
    private static final String SIMPLE_EXPR_VISIBLE = "simpleExprVisible";
    private static final String defaultReplaceExpr = "#{resolveKey} in (#{simpleExpr})";
    private static final String STRING_EMPTY = "";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{OK, ENTRY_EVENT_NAME});
    }

    public void afterCreateNewData(EventObject e) {
        List plugins = (List)this.getView().getFormShowParameter().getCustomParam("plugins");
        LinkedHashSet<ComboItem> comboItems = new LinkedHashSet<ComboItem>();
        if (Objects.nonNull(plugins) && !plugins.isEmpty()) {
            for (Map mapPlugin : plugins) {
                if (mapPlugin.get(PLUGIN_TYPE_NAME) == null || (Integer)mapPlugin.get(PLUGIN_TYPE_NAME) != 0 || !StringUtils.isNotBlank(mapPlugin.get(PLUGIN_CLASS_NAME))) continue;
                String classname = (String)mapPlugin.get(PLUGIN_CLASS_NAME);
                ComboItem classItem = new ComboItem(new LocaleString(classname), classname);
                comboItems.add(classItem);
            }
        }
        if (!comboItems.isEmpty()) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(ENTRY_EVENT_CLASS_NAME);
            comboEdit.setComboItems(new ArrayList(comboItems));
        }
        this.setSimpleExprVisible(false);
        Object curevent = this.getView().getFormShowParameter().getCustomParam("curevent");
        if (curevent instanceof Map) {
            Map eventMap = (Map)curevent;
            this.getModel().setValue(ENTRY_EVENT_CLASS_NAME, eventMap.get(ENTRY_EVENT_CLASS_NAME));
            this.getModel().setValue(ENTRY_EVENT_NAME, eventMap.get(ENTRY_EVENT_NAME));
            this.getModel().setValue(ENTRY_EVENT_ID, eventMap.get(PLUGIN_EVENT_ID));
            if (Objects.nonNull(eventMap.get(PLUGIN_EVENT_PARAM_CONDITION))) {
                Map paramMap = (Map)eventMap.get(PLUGIN_EVENT_PARAM_CONDITION);
                this.getModel().setValue(ENTRY_EVENT_SIMPLE_EXPR, paramMap.get(PLUGIN_EVENT_SIMPLE_EXPR));
                this.getModel().setValue(ENTRY_EVENT_EXPRESSION, paramMap.get(PLUGIN_EVENT_EXPRESSION));
                if (StringUtils.isNotBlank(paramMap.get(PLUGIN_EVENT_SIMPLE_EXPR)) && StringUtils.isNotBlank((CharSequence)PLUGIN_EVENT_EXPRESSION)) {
                    this.setSimpleExprVisible(true);
                }
            }
            this.getModel().setValue(ENTRY_EVENT_REMARK, eventMap.get(PLUGIN_EVENT_REMARK));
        }
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        if (ENTRY_EVENT_NAME.equals(ctl.getKey())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_selectevent");
            parameter.setCustomParam("id", this.getView().getFormShowParameter().getCustomParam("id"));
            parameter.setCustomParam("curplugin", this.getModel().getValue(ENTRY_EVENT_CLASS_NAME));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectEvent"));
            this.getView().showForm(parameter);
        }
        if (OK.equalsIgnoreCase(ctl.getKey())) {
            String pluginClassName = (String)this.getModel().getValue(ENTRY_EVENT_CLASS_NAME);
            String eventName = (String)this.getModel().getValue(ENTRY_EVENT_NAME);
            String eventId = (String)this.getModel().getValue(ENTRY_EVENT_ID);
            String simpleExpr = (String)this.getModel().getValue(ENTRY_EVENT_SIMPLE_EXPR);
            String remark = (String)this.getModel().getValue(ENTRY_EVENT_REMARK);
            if (StringUtils.isBlank((CharSequence)pluginClassName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddEventPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)eventName) || StringUtils.isBlank((CharSequence)eventId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8b\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddEventPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)remark)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddEventPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)simpleExpr) && this.getSimpleExprVisible()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddEventPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(this.getEventMap());
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        if ("selectEvent".equals(e.getActionId())) {
            Map eventMap = (Map)e.getReturnData();
            this.getModel().setValue(ENTRY_EVENT_ID, eventMap.get(ENTRY_EVENT_ID));
            this.getModel().setValue(ENTRY_EVENT_NAME, eventMap.get(ENTRY_EVENT_NAME));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equalsIgnoreCase((CharSequence)ENTRY_EVENT_ID, (CharSequence)e.getProperty().getName())) {
            String eventId = String.valueOf(e.getChangeSet()[0].getNewValue());
            if (Objects.nonNull(this.getConditionEvent(eventId))) {
                this.setSimpleExprVisible(true);
            } else {
                this.setSimpleExprVisible(false);
            }
            this.getModel().beginInit();
            this.getModel().setValue(ENTRY_EVENT_SIMPLE_EXPR, (Object)STRING_EMPTY);
            this.getModel().setValue(ENTRY_EVENT_EXPRESSION, (Object)STRING_EMPTY);
            this.getView().updateView(ENTRY_EVENT_SIMPLE_EXPR);
            this.getView().updateView(ENTRY_EVENT_EXPRESSION);
            this.getModel().endInit();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ENTRY_EVENT_SIMPLE_EXPR, (CharSequence)e.getProperty().getName())) {
            Object eventId = this.getModel().getValue(ENTRY_EVENT_ID);
            String simpleExpr = String.valueOf(e.getChangeSet()[0].getNewValue());
            Class<? extends IConditionEvent> conditionEvent = this.getConditionEvent(String.valueOf(eventId));
            if (Objects.nonNull(conditionEvent)) {
                Object[] splitKey = StringUtils.split((String)simpleExpr, (String)",");
                for (int i = 0; i < splitKey.length; ++i) {
                    splitKey[i] = "'" + splitKey[i] + "'";
                }
                String expression = StringUtils.replaceEach((String)defaultReplaceExpr, (String[])new String[]{"#{resolveKey}", "#{simpleExpr}"}, (String[])new String[]{conditionEvent.getAnnotation(ResolveKey.class).value(), StringUtils.join((Object[])splitKey, (String)",")});
                this.getModel().setValue(ENTRY_EVENT_EXPRESSION, (Object)expression);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ENTRY_EVENT_CLASS_NAME, (CharSequence)e.getProperty().getName())) {
            this.setSimpleExprVisible(false);
            this.getModel().beginInit();
            this.getModel().setValue(ENTRY_EVENT_ID, (Object)STRING_EMPTY);
            this.getModel().setValue(ENTRY_EVENT_NAME, (Object)STRING_EMPTY);
            this.getModel().setValue(ENTRY_EVENT_SIMPLE_EXPR, (Object)STRING_EMPTY);
            this.getModel().setValue(ENTRY_EVENT_EXPRESSION, (Object)STRING_EMPTY);
            this.getView().updateView(ENTRY_EVENT_ID);
            this.getView().updateView(ENTRY_EVENT_NAME);
            this.getView().updateView(ENTRY_EVENT_SIMPLE_EXPR);
            this.getView().updateView(ENTRY_EVENT_EXPRESSION);
            this.getModel().endInit();
        }
    }

    private Map<String, Object> getEventMap() {
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        eventMap.put(ENTRY_EVENT_CLASS_NAME, this.getModel().getValue(ENTRY_EVENT_CLASS_NAME));
        eventMap.put(ENTRY_EVENT_NAME, this.getModel().getValue(ENTRY_EVENT_NAME));
        eventMap.put(ENTRY_EVENT_ID, this.getModel().getValue(ENTRY_EVENT_ID));
        eventMap.put(ENTRY_EVENT_REMARK, this.getModel().getValue(ENTRY_EVENT_REMARK));
        eventMap.put(ENTRY_EVENT_SIMPLE_EXPR, this.getModel().getValue(ENTRY_EVENT_SIMPLE_EXPR));
        eventMap.put(ENTRY_EVENT_EXPRESSION, this.getModel().getValue(ENTRY_EVENT_EXPRESSION));
        return eventMap;
    }

    private void setSimpleExprVisible(boolean visible) {
        this.getPageCache().put(SIMPLE_EXPR_VISIBLE, Boolean.toString(visible));
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{ENTRY_EVENT_SIMPLE_EXPR});
    }

    private boolean getSimpleExprVisible() {
        return Boolean.parseBoolean(this.getPageCache().get(SIMPLE_EXPR_VISIBLE));
    }

    private Class<? extends IConditionEvent> getConditionEvent(String eventId) {
        Class clazz;
        EventMethod eventMethod = EventMethodTypes.getEventMethod((String)eventId);
        String[] params = eventMethod.getParams();
        if (params != null && params.length == 1 && IConditionEvent.class.isAssignableFrom(clazz = TypesContainer.getOrRegister((String)params[0]))) {
            return clazz;
        }
        return null;
    }
}

