/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.dao.DesignerData;
import kd.bos.entity.plugin.annotation.AnnotatedPlugin;
import kd.bos.entity.plugin.manager.EventMethod;
import kd.bos.entity.plugin.manager.EventMethodTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.GenericServiceResult;
import kd.bos.service.ResultCodeEnum;
import kd.bos.servicehelper.DispatchServiceHelper;

public class SelectEventPlugin
extends AbstractFormPlugin {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String OK = "ok";
    private static final String ENTRY_EVENT_NAME = "eventname";
    private static final String ENTRY_EVENT_ID = "eventid";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{OK});
    }

    public void afterCreateNewData(EventObject e) {
        String curplugin = (String)this.getView().getFormShowParameter().getCustomParam("curplugin");
        Map<String, EventMethod> annotatedEventMethods = this.getOverrideMethods(curplugin);
        for (Map.Entry<String, EventMethod> entry : annotatedEventMethods.entrySet()) {
            int i = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue(ENTRY_EVENT_ID, (Object)entry.getKey(), i);
            this.getModel().setValue(ENTRY_EVENT_NAME, (Object)entry.getValue().getMethodName(), i);
            this.getModel().setValue("classname", (Object)entry.getValue().getEventClassName(), i);
            this.getModel().setValue("description", (Object)EventMethodTypes.getDescByEventId((String)entry.getKey()), i);
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if (OK.equalsIgnoreCase(btn.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"SelectEventPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> eventMap = new HashMap<String, Object>();
            eventMap.put(ENTRY_EVENT_ID, this.getModel().getValue(ENTRY_EVENT_ID, selectRows[0]));
            eventMap.put(ENTRY_EVENT_NAME, this.getModel().getValue(ENTRY_EVENT_NAME, selectRows[0]));
            this.getView().returnDataToParent(eventMap);
            this.getView().close();
        }
    }

    private Map<String, EventMethod> getOverrideMethods(String pluginClassName) {
        Map<String, Object> overrideMethods = new LinkedHashMap<String, EventMethod>();
        try {
            String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
            String formId = DesignerData.getNumberById(DesignerData.getMasterId(id));
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("formId", formId);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            String appId = showParameter.getServiceAppId();
            Object resultObj = DispatchServiceHelper.invokeBOSService((String)appId, (String)"PluginFormService", (String)"getAnnotatedPlugin", (Object[])new Object[]{pluginClassName});
            GenericServiceResult result = (GenericServiceResult)resultObj;
            if (result.getSuccess().booleanValue()) {
                AnnotatedPlugin annotatedPlugin = (AnnotatedPlugin)result.getData();
                overrideMethods = annotatedPlugin.getOverrideMethods();
            } else if (ResultCodeEnum.CLASS_NOT_FOUND_EXCEPTION.getCode().equals(result.getCode())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u672a\u90e8\u7f72\u3002", (String)"RegisterPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return overrideMethods;
    }
}

