/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class DSCondEdit
extends AbstractFormPlugin {
    private static final String FILTER_FIELD = "filterfield";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        this.initFilterField();
    }

    private void initFilterField() {
        String filerStr = (String)this.getView().getFormShowParameter().getCustomParam("filterfields");
        List its = SerializationUtils.fromJsonStringToList((String)filerStr, ComboItem.class);
        ComboEdit edit = (ComboEdit)this.getControl(FILTER_FIELD);
        edit.setComboItems(its);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String filterValue = (String)this.getView().getFormShowParameter().getCustomParam("filterValue");
        if (!StringUtils.isEmpty((String)filterValue)) {
            model.setValue("filterval", (Object)"1");
            model.setValue(FILTER_FIELD, (Object)filterValue.substring(1));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            this.returnData();
        } else {
            this.getView().close();
        }
    }

    private void returnData() {
        IDataModel model = this.getModel();
        IDataModel parentModel = this.getView().getParentView().getModel();
        int rowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowIndex");
        String fieldName = (String)model.getValue(FILTER_FIELD);
        parentModel.setValue("condition", (Object)fieldName, rowIndex);
        this.getView().close();
    }
}

