/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.designer.property.report.DSTypeEdit;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;

public class DSEditHelper {
    protected static DynamicObject toDynamicObject(String value, MainEntityType entityType) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return (DynamicObject)jser.deserializeFromString(value, null);
    }

    protected static String toDynamicObjectJson(DynamicObject obj) {
        DynamicObjectType type = obj.getDynamicObjectType();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        binder.setOnlyDbProperty(false);
        return jser.serializeToString((Object)obj, null);
    }

    protected static TreeNode getFieldTree(IFormView view, String dsNumber) {
        Map<String, String> ds = DSEditHelper.getDS(view, dsNumber);
        if (ds == null) {
            return null;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)DSTypeEdit.getEntityId(ds.get("type")));
        DynamicObject data = DSEditHelper.toDynamicObject(ds.get("data"), type);
        DynamicObjectCollection selectEntry = data.getDynamicObjectCollection("selectentry");
        TreeNode dsNode = new TreeNode();
        dsNode.setId(data.getString("number"));
        dsNode.setText(data.getString("name"));
        dsNode.setIsOpened(true);
        for (DynamicObject sel : selectEntry) {
            TreeNode node = new TreeNode();
            node.setId(sel.getString("fieldname"));
            node.setText(sel.getString("displayname"));
            node.setParentid(dsNode.getId());
            dsNode.addChild(node);
        }
        return dsNode;
    }

    private static Map<String, String> getDS(IFormView view, String dsNumber) {
        if (dsNumber == null) {
            return null;
        }
        FormShowParameter showParameter = view.getFormShowParameter();
        List dsList = (List)showParameter.getCustomParam("ds");
        for (Map ds : dsList) {
            if (!((String)ds.get("number")).equals(dsNumber)) continue;
            return ds;
        }
        return null;
    }
}

