/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.report.DSEditHelper;
import kd.bos.designer.property.report.ReportDesignerTool;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.JSONUtils;

public class DSList
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String DS_ENTRY = "dsentry";
    private static final String VALUE = "value";
    private static final String ROW_INDEX = "rowIndex";
    private static final String META_TYPE = "metaType";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"dsop"});
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        EntryGrid dsentry = (EntryGrid)this.getControl(DS_ENTRY);
        dsentry.addRowClickListener((RowClickEventListener)this);
        dsentry.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent e) {
                String fieldKey = e.getFieldKey();
                int row = e.getRow();
                if (row >= 0 && "condition".equals(fieldKey)) {
                    DSList.this.showDSCondEdit(fieldKey, row);
                }
            }

            public void cellDoubleClick(CellClickEvent e) {
            }
        });
    }

    private String getAppId() {
        String bizAppId = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("bizappid");
        if (kd.bos.util.StringUtils.isEmpty((String)bizAppId)) {
            String appId = this.getView().getParentView().getFormShowParameter().getAppId();
            bizAppId = BizAppServiceHelp.getAppIdByAppNumber((String)appId);
        }
        return bizAppId;
    }

    public void itemClick(ItemClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("dsop")) {
            if ("addds".equals(evt.getItemKey())) {
                if (!"kingdee".equals(BizAppServiceHelp.getAppIsvByAppId((String)this.getAppId()))) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u529f\u80fd\u4e0d\u5141\u8bb8\u6269\u5c55\u4fee\u6539\u3002", (String)"DSList_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
                    return;
                }
                this.addDSEntry();
            } else if ("deleteds".equals(evt.getItemKey())) {
                this.delDSEntry();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid dsentry = (EntryGrid)this.getControl(DS_ENTRY);
        int rowCount = this.getModel().getEntryRowCount(DS_ENTRY);
        if (rowCount > 0) {
            dsentry.selectRows(0);
            this.showDSForm(0);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (StringUtils.isBlank(value)) {
            return;
        }
        MainEntityType entityType = this.getModel().getDataEntityType();
        DynamicObject dataSource = DSEditHelper.toDynamicObject((String)value, entityType);
        dataSource.set("importfield", (Object)false);
        e.setDataEntity((Object)dataSource);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            IDataModel model = this.getModel();
            this.updateDSList(model, false);
            this.returnData(model);
        } else {
            this.getView().close();
        }
    }

    private void showDSCondEdit(String fieldKey, int rowIndex) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_formula");
        parameter.setCustomParam("fieldKey", (Object)fieldKey);
        parameter.setCustomParam(ROW_INDEX, (Object)rowIndex);
        parameter.setCustomParam(VALUE, this.getModel().getValue(fieldKey, rowIndex));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        try {
            parameter.setCustomParam("hideRootNode", (Object)Boolean.TRUE.toString());
            parameter.setCustomParam("treeNode", (Object)JSONUtils.toString((Object)this.getFilterEntity()));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        Object metaType = this.getView().getFormShowParameter().getCustomParams().get(META_TYPE);
        parameter.setCustomParam(META_TYPE, metaType);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map ret;
        super.closedCallBack(evt);
        if ("ide_dsedit".equals(evt.getActionId()) && (ret = (Map)evt.getReturnData()) != null) {
            String fieldKey = (String)ret.get("fieldKey");
            Integer rowIndex = (Integer)ret.get(ROW_INDEX);
            Object value = ret.get(VALUE);
            if (fieldKey != null && rowIndex != null) {
                this.getModel().setValue(fieldKey, value, rowIndex.intValue());
            }
        }
    }

    private void returnData(IDataModel model) {
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put(VALUE, DSEditHelper.toDynamicObjectJson(model.getDataEntity(true)));
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private void addDSEntry() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_dstype");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        parameter.setCustomParam("ds", this.getDSList());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }

    private void delDSEntry() {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex(DS_ENTRY);
        if (rowIndex > -1) {
            model.deleteEntryRow(DS_ENTRY, rowIndex);
        }
        if (rowIndex - 1 >= 0) {
            rowIndex = model.getEntryCurrentRowIndex(DS_ENTRY);
            EntryGrid dsentry = (EntryGrid)this.getControl(DS_ENTRY);
            dsentry.entryRowClick(Integer.valueOf(rowIndex));
        }
    }

    public void entryRowClick(RowClickEvent e) {
        this.showDSForm(e.getRow());
    }

    private void showDSForm(int rowIndex) {
        IDataModel model = this.getModel();
        this.updateDSList(model, true);
        if (rowIndex >= 0) {
            String type = (String)model.getValue("dstype", rowIndex);
            String data = (String)model.getValue("data", rowIndex);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("dsdata", (Object)data);
            parameter.setCustomParam(ROW_INDEX, (Object)rowIndex);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("dspanel");
            try {
                parameter.setCustomParam("filterFieldTree", (Object)JSONUtils.toString((Object)this.getFilterEntity()));
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
            if ("1".equals(type)) {
                parameter.setFormId("ide_entityds");
            } else if ("2".equals(type)) {
                parameter.setCustomParam("ds", this.getDSList());
                parameter.setFormId("ide_joinds");
            } else if ("3".equals(type)) {
                parameter.setCustomParam("ds", this.getDSList());
                parameter.setFormId("ide_unionds");
            } else if ("4".equals(type)) {
                parameter.setCustomParam("ds", this.getDSList());
                parameter.setFormId("ide_sortds");
            }
            IPageCache pageCache = this.getPageCache();
            pageCache.put("dspage", parameter.getPageId());
            this.getView().showForm(parameter);
        }
    }

    private TreeNode getFilterEntity() {
        List ctx = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        return ReportDesignerTool.getFilterEntity(ctx);
    }

    private List<Map<String, String>> getDSList() {
        DynamicObjectCollection dynObjColl = this.getModel().getEntryEntity(DS_ENTRY);
        ArrayList<Map<String, String>> dsList = new ArrayList<Map<String, String>>(10);
        for (DynamicObject obj : dynObjColl) {
            HashMap<String, String> ds = new HashMap<String, String>(6);
            ds.put("number", obj.getString("dsnumber"));
            ds.put("name", obj.getString("dsname"));
            ds.put("type", obj.getString("dstype"));
            ds.put("data", obj.getString("data"));
            dsList.add(ds);
        }
        return dsList;
    }

    private void updateDSList(IDataModel model, boolean closeSubView) {
        IPageCache pageCache = this.getPageCache();
        String dsPageId = pageCache.get("dspage");
        if (dsPageId == null) {
            return;
        }
        IFormView dsView = SessionManager.getCurrent().getView(dsPageId);
        if (dsView != null) {
            dsView.close();
            if (closeSubView) {
                HashMap<String, String> arg = new HashMap<String, String>();
                arg.put("pageId", dsPageId);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
    }
}

