/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.designer.property.report.DSEditHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;

public class DSTypeEdit
extends AbstractFormPlugin {
    protected static final String TYPE_ENTITY = "1";
    protected static final String TYPE_JOIN = "2";
    protected static final String TYPE_UNION = "3";
    protected static final String TYPE_SORT = "4";
    private static final String NUMBER = "number";
    private static final String CLIENT_DS = "clientds";
    private static final String SUPPLIERDS = "supplierds";
    protected static Map<String, String> types = new HashMap<String, String>(6);

    protected static String getEntityId(String type) {
        return types.get(type);
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
        this.initDSCombo();
    }

    private void initDSCombo() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List dsList = (List)parameter.getCustomParam("ds");
        if (dsList == null) {
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (Map ds : dsList) {
            ComboItem it = new ComboItem();
            it.setValue((String)ds.get(NUMBER));
            it.setCaption(new LocaleString((String)ds.get("name")));
            items.add(it);
        }
        ComboEdit clientDSEdit = (ComboEdit)this.getControl(CLIENT_DS);
        ComboEdit supplierDSDS = (ComboEdit)this.getControl(SUPPLIERDS);
        ComboEdit dsEdit = (ComboEdit)this.getControl("ds");
        clientDSEdit.setComboItems(items);
        supplierDSDS.setComboItems(items);
        dsEdit.setComboItems(items);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                IDataModel model = this.getModel();
                IDataModel parentModel = parentView.getModel();
                int rowIndex = parentModel.createNewEntryRow("dsentry");
                String number = DBServiceHelper.genStringId();
                String name = (String)model.getValue("name");
                String type = (String)model.getValue("type");
                parentModel.setValue("dsnumber", (Object)number, rowIndex);
                parentModel.setValue("dsname", (Object)name, rowIndex);
                parentModel.setValue("dstype", (Object)type, rowIndex);
                String json = this.getData(model, number, name, type);
                parentModel.setValue("data", (Object)json, rowIndex);
                EntryGrid dsentry = (EntryGrid)parentView.getControl("dsentry");
                dsentry.entryRowClick(Integer.valueOf(rowIndex));
            }
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    private String getData(IDataModel model, String number, String name, String type) {
        DynamicObject obj = null;
        if (TYPE_ENTITY.equals(type)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ide_entityds");
            obj = new DynamicObject((DynamicObjectType)entityType);
            obj.set(NUMBER, (Object)number);
            obj.set("name", (Object)name);
            DynamicObject entity = (DynamicObject)model.getValue("srcentity");
            obj.set("entity", (Object)entity);
        } else if (TYPE_JOIN.equals(type)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ide_joinds");
            obj = new DynamicObject((DynamicObjectType)entityType);
            obj.set(NUMBER, (Object)number);
            obj.set("name", (Object)name);
            obj.set(CLIENT_DS, model.getValue(CLIENT_DS));
            obj.set(SUPPLIERDS, model.getValue(SUPPLIERDS));
        } else if (TYPE_UNION.equals(type)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ide_unionds");
            obj = new DynamicObject((DynamicObjectType)entityType);
            obj.set(NUMBER, (Object)number);
            obj.set("name", (Object)name);
        } else if (TYPE_SORT.equals(type)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ide_sortds");
            obj = new DynamicObject((DynamicObjectType)entityType);
            obj.set(NUMBER, (Object)number);
            obj.set("name", (Object)name);
            obj.set("ds", model.getValue("ds"));
        }
        return DSEditHelper.toDynamicObjectJson(obj);
    }

    static {
        types.put(TYPE_ENTITY, "ide_entityds");
        types.put(TYPE_JOIN, "ide_joinds");
        types.put(TYPE_UNION, "ide_unionds");
        types.put(TYPE_SORT, "ide_sortds");
    }
}

