/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.designer.property.report.DSEdit;
import kd.bos.designer.property.report.DSEditHelper;
import kd.bos.designer.property.report.DSField;
import kd.bos.designer.property.report.ReportDesignerTool;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.JSONUtils;

public class EntityDSEdit
extends DSEdit {
    private static final String SELECTENTRY = "selectentry";
    private static final String QUERY_FIELD = "queryfield";
    private static final String FIELD_KEY = "fieldKey";
    private static final String ROW_INDEX = "rowIndex";
    private static final String VALUE = "value";
    private static final String FILTER_FIELD_TREE = "filterFieldTree";
    private static final String FILTER_ENTRY = "filterentry";
    private static final String IMPORT_SF = "importsf";
    private static final String IMPORT_FF = "importff";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarsf", "toolbarff"});
        this.addQueryFieldClickListener();
        this.addFilterFieldClickListener();
    }

    private void addQueryFieldClickListener() {
        EntryGrid selectentry = (EntryGrid)this.getControl(SELECTENTRY);
        selectentry.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent e) {
                String fieldKey = e.getFieldKey();
                int row = e.getRow();
                if (row < 0) {
                    return;
                }
                if (EntityDSEdit.QUERY_FIELD.equals(fieldKey)) {
                    EntityDSEdit.this.showQueryFieldEdit(fieldKey, row);
                } else if ("scond".equals(fieldKey)) {
                    EntityDSEdit.this.showCondEdit(fieldKey, row);
                }
            }

            public void cellDoubleClick(CellClickEvent e) {
            }
        });
    }

    private void showCondEdit(String fieldKey, int rowIndex) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_formula");
        parameter.setCustomParam(FIELD_KEY, (Object)fieldKey);
        parameter.setCustomParam(ROW_INDEX, (Object)rowIndex);
        parameter.setCustomParam(VALUE, this.getModel().getValue(fieldKey, rowIndex));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("hideRootNode", (Object)Boolean.TRUE.toString());
        parameter.setCustomParam("treeNode", this.getView().getFormShowParameter().getCustomParam(FILTER_FIELD_TREE));
        Object metaType = this.getView().getFormShowParameter().getCustomParams().get("metaType");
        parameter.setCustomParam("metaType", metaType);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }

    private void addFilterFieldClickListener() {
        EntryGrid filterentry = (EntryGrid)this.getControl(FILTER_ENTRY);
        filterentry.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent e) {
                String fieldKey = e.getFieldKey();
                int row = e.getRow();
                if (row < 0) {
                    return;
                }
                if ("filtervalue".equals(fieldKey)) {
                    EntityDSEdit.this.showFilterValueEdit(fieldKey, row);
                } else if ("fcond".equals(fieldKey)) {
                    EntityDSEdit.this.showCondEdit(fieldKey, row);
                }
            }

            public void cellDoubleClick(CellClickEvent e) {
            }
        });
    }

    private void showQueryFieldEdit(String fieldKey, int rowIndex) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_fieldedit");
        parameter.setCustomParam(FIELD_KEY, (Object)fieldKey);
        parameter.setCustomParam(ROW_INDEX, (Object)rowIndex);
        IDataModel model = this.getModel();
        String filterValue = (String)model.getValue(fieldKey, rowIndex);
        parameter.setCustomParam(VALUE, (Object)filterValue);
        DynamicObject entity = (DynamicObject)model.getValue("entity");
        String entityId = (String)entity.getPkValue();
        TreeNode tree = ReportDesignerTool.getFieldTreeNode(entityId);
        try {
            parameter.setCustomParam("treeNode", (Object)JSONUtils.toString((Object)tree));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }

    private void showFilterValueEdit(String fieldKey, int rowIndex) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_filtervalueedit");
        parameter.setCustomParam(ROW_INDEX, (Object)rowIndex);
        String filterValue = (String)this.getModel().getValue(fieldKey, rowIndex);
        parameter.setCustomParam("filterValue", (Object)filterValue);
        parameter.setCustomParam(FILTER_FIELD_TREE, this.getView().getFormShowParameter().getCustomParam(FILTER_FIELD_TREE));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IDataModel model = this.getModel();
        if (IMPORT_SF.equals(key) || IMPORT_FF.equals(key)) {
            this.importField(key, model);
        } else if ("addnew".equals(key)) {
            this.getModel().createNewEntryRow(SELECTENTRY);
        } else if ("deletesf".equals(key)) {
            EntryGrid dsentry = (EntryGrid)this.getControl(SELECTENTRY);
            int[] rowIndexs = dsentry.getEntryState().getSelectedRows();
            if (rowIndexs != null && rowIndexs.length > 0) {
                model.deleteEntryRows(SELECTENTRY, rowIndexs);
            }
        } else if ("deleteff".equals(key)) {
            EntryGrid dsentry = (EntryGrid)this.getControl(FILTER_ENTRY);
            int[] rowIndexs = dsentry.getEntryState().getSelectedRows();
            model.deleteEntryRows(FILTER_ENTRY, rowIndexs);
        }
    }

    private void importField(String key, IDataModel model) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_selectfield");
        parameter.setCustomParam("dsType", (Object)"1");
        DynamicObject entity = (DynamicObject)model.getValue("entity");
        if (entity != null) {
            parameter.setCustomParam("funckey", (Object)key);
            parameter.setCustomParam("entityid", entity.getPkValue());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
            this.getView().showForm(parameter);
        }
    }

    @Override
    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String data = (String)showParameter.getCustomParam("dsdata");
        MainEntityType entityType = this.getModel().getDataEntityType();
        if (data != null) {
            DynamicObject obj = DSEditHelper.toDynamicObject(data, entityType);
            BusinessDataReader.loadRefence((Object[])new DynamicObject[]{obj}, (IDataEntityType)entityType);
            e.setDataEntity((Object)obj);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (!"ide_entityds".equals(evt.getActionId()) || !(evt.getReturnData() instanceof Map)) {
            return;
        }
        Map ret = (Map)evt.getReturnData();
        if (ret.get(IMPORT_SF) instanceof List) {
            this.importQueryFields((List)ret.get(IMPORT_SF));
        } else if (ret.get(IMPORT_FF) instanceof List) {
            this.importFilterFields((List)ret.get(IMPORT_FF));
        } else if (ret != null) {
            String fieldKey = (String)ret.get(FIELD_KEY);
            Integer rowIndex = (Integer)ret.get(ROW_INDEX);
            Object value = ret.get(VALUE);
            if (fieldKey != null && rowIndex != null) {
                this.getModel().setValue(fieldKey, value, rowIndex.intValue());
            }
        }
    }

    private void importFilterFields(List<DSField> list) {
        IDataModel model = this.getModel();
        for (DSField field : list) {
            int rowIndex = model.createNewEntryRow(FILTER_ENTRY);
            model.setValue("filterfield", (Object)field.getFieldKey(), rowIndex);
            model.setValue("compare", (Object)"1", rowIndex);
        }
    }

    private void importQueryFields(List<DSField> list) {
        IDataModel model = this.getModel();
        for (DSField field : list) {
            LocaleString nodeName = field.getFieldName();
            if (this.existQueryField(field.getFieldKey(), model)) continue;
            int rowIndex = model.createNewEntryRow(SELECTENTRY);
            model.setValue(QUERY_FIELD, (Object)field.getFieldKey(), rowIndex);
            model.setValue("fieldname", (Object)field.getFieldKey().replace(".", "_"), rowIndex);
            model.setValue("displayname", (Object)nodeName, rowIndex);
            model.setValue("datatype", (Object)field.getDataType(), rowIndex);
        }
    }

    private boolean existQueryField(String fieldName, IDataModel parentModel) {
        int rowCount = parentModel.getEntryRowCount(SELECTENTRY);
        for (int i = 0; i < rowCount; ++i) {
            String f = (String)parentModel.getValue(QUERY_FIELD, i);
            if (!fieldName.equals(f)) continue;
            return true;
        }
        return false;
    }
}

