/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class FieldEdit
extends AbstractFormPlugin
implements TreeNodeClickListener,
IBizRuleEditor {
    private static final String formulatxt = "formulatxt";
    private static final String[] OPERATOR = new String[]{"=", "+", "-", "*", "/", "<", ">"};
    private static final String BACK_SPACE = "backspace";
    static final Map<String, String> operationCharacter = new HashMap<String, String>(){
        private static final long serialVersionUID = 5019172825162636084L;
        {
            this.put("plus", "+");
            this.put("subtract", "-");
            this.put("multiple", "*");
            this.put("divide", "/");
            this.put("equal", "=");
            this.put("less", "<");
            this.put("greater", ">");
            this.put("lessequal", "<=");
            this.put("greaterequal", ">=");
            this.put("squarebrackets", "<>");
            this.put("leftparentheses", "(");
            this.put("rightparentheses", ")");
            this.put("and", "AND");
            this.put("or", "OR");
            this.put("if", "IF(,,)");
            this.put("clr", "CLR");
            this.put(FieldEdit.BACK_SPACE, "Backspace");
        }
    };

    public void initialize() {
        String[] operKeys = operationCharacter.keySet().toArray(new String[0]);
        this.addClickListeners(operKeys);
        this.addClickListeners(new String[]{"btnok", "btncancel", "currrow", "lastrow"});
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode entity = null;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String treeNode = (String)showParameter.getCustomParam("treeNode");
        try {
            entity = (TreeNode)JSONUtils.cast((String)treeNode, TreeNode.class);
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        entity.setIsOpened(true);
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        entity.setParentid("");
        tree.addNode(entity);
        String formula = this.getInputConfig();
        this.getModel().setValue(formulatxt, (Object)formula);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.closeAndReturn();
        } else if ("btncancel".equalsIgnoreCase(key)) {
            this.getView().close();
        } else if ("currrow".equalsIgnoreCase(key) || "lastrow".equalsIgnoreCase(key)) {
            this.selectedCurrDSField(key);
        } else if (key != null) {
            this.operation(key);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (e.getNodeId() != null && !StringUtils.isEmpty((String)e.getNodeId().toString()) && !StringUtils.isEmpty((String)e.getParentNodeId().toString())) {
            String character = e.getNodeId().toString();
            if (this.getModel().getValue(formulatxt) != null) {
                character = this.getModel().getValue(formulatxt).toString() + " " + character + " ";
            }
            this.getModel().setValue(formulatxt, (Object)character);
        }
    }

    public boolean checkConfig() {
        Object formula = this.getModel().getValue(formulatxt);
        if (StringUtils.isEmpty((String)((String)formula))) {
            String expression = ((String)formula).trim();
            try {
                FormulaEngine.parseFormula((String)expression);
            }
            catch (Exception e) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bef:%s", (String)"FieldEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]), e.getMessage()));
                return false;
            }
        }
        return true;
    }

    public String getOutConfig() {
        return (String)this.getModel().getValue(formulatxt);
    }

    public void operation(String xx) {
        String character = operationCharacter.get(xx);
        if (character.equalsIgnoreCase("clr")) {
            this.getModel().setValue(formulatxt, (Object)"");
            return;
        }
        String currentText = null;
        if (this.getModel().getValue(formulatxt) != null && this.getModel().getValue(formulatxt).toString().length() > 0) {
            if (BACK_SPACE.equalsIgnoreCase(character)) {
                String field;
                String deleteField = field = this.getModel().getValue(formulatxt).toString();
                for (String str : OPERATOR) {
                    if (field.lastIndexOf(str) <= 0 || !"".equals((deleteField = field.substring(field.lastIndexOf(str) + 1)).trim())) continue;
                    deleteField = str;
                }
                String[] fieldList = deleteField.split(" ");
                for (int i = fieldList.length - 1; i >= 0; --i) {
                    if ("".equals(fieldList[i].trim())) continue;
                    deleteField = fieldList[i];
                    break;
                }
                currentText = field.substring(0, field.lastIndexOf(deleteField));
            } else {
                currentText = this.getModel().getValue(formulatxt) + " " + character + " ";
            }
        } else {
            currentText = BACK_SPACE.equalsIgnoreCase(character) ? "" : character;
        }
        this.getModel().setValue(formulatxt, (Object)currentText);
    }

    private void selectedCurrDSField(String funckey) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_selectfield");
        String treeNode = (String)showParameter.getCustomParam("currDS");
        parameter.setCustomParam("funckey", (Object)funckey);
        parameter.setCustomParam("treeNode", (Object)treeNode);
        parameter.setCustomParam("singleSelect", (Object)true);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }

    private void closeAndReturn() {
        Object formula = this.getModel().getValue(formulatxt);
        if (!StringUtils.isEmpty((String)((String)formula))) {
            String expression = ((String)formula).trim();
            HashMap<String, Object> para = new HashMap<String, Object>();
            FormShowParameter parameter = this.getView().getFormShowParameter();
            para.put("itemId", parameter.getCustomParam("itemId"));
            para.put("metaType", parameter.getCustomParam("metaType"));
            para.put("propertyName", parameter.getCustomParam("propertyName"));
            para.put("rowIndex", parameter.getCustomParam("rowIndex"));
            para.put("fieldKey", parameter.getCustomParam("fieldKey"));
            para.put("value", expression);
            this.getView().returnDataToParent(para);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FieldEdit_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Map ret = (Map)evt.getReturnData();
        if (ret == null) {
            return;
        }
        String value = (String)ret.get("value");
        String funckey = (String)ret.get("funckey");
        String currentText = this.getModel().getValue(formulatxt) + " " + funckey + "(" + value + ") ";
        this.getModel().setValue(formulatxt, (Object)currentText);
    }
}

