/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.designer.property.report.DSEditHelper;
import kd.bos.designer.property.report.DSTypeEdit;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.CityProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.metadata.entity.businessfield.I18nNameField;
import kd.bos.ext.metadata.entity.property.I18nNameProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BillTypeField;
import kd.bos.metadata.entity.businessfield.CityField;
import kd.bos.metadata.entity.businessfield.CurrencyField;
import kd.bos.metadata.entity.businessfield.MaterielField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.PriceField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.businessfield.UnitField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.entity.report.QueryDataSource;
import kd.bos.util.StringUtils;

public class FieldMapper
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String DS_FIELD = "dsfield";
    private static final String FIELD_NAME = "fieldname";
    private static final String DATA_TYPE = "datatype";
    private static final String DISPLAY_NAME = "displayname";
    private static final String VALUE = "value";

    public void initialize() {
        super.initialize();
        EntryGrid dsentry = (EntryGrid)this.getControl(DS_FIELD);
        dsentry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            EntryGrid dsentry = (EntryGrid)this.getControl(DS_FIELD);
            int[] selectedRows = dsentry.getEntryState().getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                this.returnData(selectedRows[0]);
            }
        } else {
            this.getView().close();
        }
    }

    public void entryRowDoubleClick(RowClickEvent e) {
        this.returnData(e.getRow());
    }

    public void entryRowClick(RowClickEvent e) {
    }

    private void returnData(int rowIndex) {
        IDataModel model = this.getModel();
        String fieldName = (String)model.getValue(FIELD_NAME, rowIndex);
        HashMap para = new HashMap(6);
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put(VALUE, fieldName);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getDataSourceField();
    }

    public void afterBindData(EventObject e) {
        String selectedKey = null;
        if (this.getView().getFormShowParameter().getCustomParams().get(VALUE) != null) {
            selectedKey = this.getView().getFormShowParameter().getCustomParams().get(VALUE).toString();
        }
        int rows = this.getModel().getEntryRowCount(DS_FIELD);
        for (int i = 0; i < rows; ++i) {
            if (!this.getModel().getValue(FIELD_NAME, i).equals(selectedKey)) continue;
            this.focusRow(i);
        }
    }

    private Object getFieldProp(List<List<Map<String, Object>>> context) {
        if (context != null && context.size() > 2) {
            Object key = context.get(0).get(0).get("Key");
            EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata(context.get(1));
            List entityItems = entityMetadata.getItems();
            for (EntityItem item : entityItems) {
                if (key == null || !key.equals(item.getKey())) continue;
                try {
                    Class<?> clazz = item.getClass();
                    Method method = EntityItem.class.getDeclaredMethod("createDynamicProperty", new Class[0]);
                    method.setAccessible(true);
                    Object obj = clazz.newInstance();
                    if (obj instanceof CurrencyField) {
                        return new CurrencyProp();
                    }
                    if (obj instanceof BillTypeField) {
                        return new BillTypeProp();
                    }
                    if (obj instanceof AssistantField) {
                        return new AssistantProp();
                    }
                    if (obj instanceof MaterielField) {
                        return new MaterielProp();
                    }
                    if (obj instanceof UnitField) {
                        return new UnitProp();
                    }
                    if (obj instanceof PriceField) {
                        return new PriceProp();
                    }
                    if (obj instanceof QtyField) {
                        return new QtyProp();
                    }
                    if (obj instanceof AmountField) {
                        return new AmountProp();
                    }
                    if (obj instanceof AdminDivisionField) {
                        return new AdminDivisionProp();
                    }
                    if (obj instanceof OrgField) {
                        return new OrgProp();
                    }
                    if (obj instanceof CityField) {
                        return new CityProp();
                    }
                    if (obj instanceof BasedataField) {
                        return new BasedataProp();
                    }
                    if (obj instanceof MulBasedataField) {
                        return new MulBasedataProp();
                    }
                    if (obj instanceof I18nNameField) {
                        return new I18nNameProp();
                    }
                    return method.invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                }
            }
        }
        return null;
    }

    private void getDataSourceField() {
        Map<String, Object> ctx = null;
        List<List<Map<String, Object>>> context = this.getContext();
        if (context == null) {
            return;
        }
        Object fieldProp = this.getFieldProp(context);
        if (context != null && context.size() > 2) {
            if (context.get(2) != null && !context.get(2).isEmpty()) {
                ctx = context.get(2).get(0);
            }
        } else if (context.get(0) != null && !context.get(0).isEmpty()) {
            ctx = context.get(0).get(0);
        }
        if (ctx == null) {
            return;
        }
        Object QueryDataSource2 = ctx.get("QueryDataSource");
        if (QueryDataSource2 == null) {
            Object value = ctx.get("DataSource");
            this.addOldField(value.toString());
        } else {
            QueryDataSource queryDataSource = this.deSerializeQueryDataSource(QueryDataSource2.toString());
            if (queryDataSource != null && queryDataSource.getDataSourceId() != null) {
                this.addField(queryDataSource.getDataSourceId(), fieldProp);
            }
        }
    }

    private QueryDataSource deSerializeQueryDataSource(String jsonString) {
        List<IDataEntityType> dataEntityTypes = this.getDataEntityType();
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return (QueryDataSource)dcJsonSerializer.deserializeFromString(jsonString, null);
    }

    private List<IDataEntityType> getDataEntityType() {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(QueryDataSource.class));
        return dataEntityTypes;
    }

    private void addOldField(String oldDataSource) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"dsname"});
        ArrayList<DynamicObject> fields = new ArrayList<DynamicObject>();
        HashMap<String, DynamicObject> fieldMap = new HashMap<String, DynamicObject>();
        if (oldDataSource == null) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"ide_dsedit");
        DynamicObject obj = DSEditHelper.toDynamicObject(oldDataSource, type);
        DynamicObjectCollection dsColl = obj.getDynamicObjectCollection("dsentry");
        for (DynamicObject ds : dsColl) {
            String data;
            if (!ds.getBoolean("enable") || StringUtils.isEmpty((String)(data = ds.getString("data")))) continue;
            String dsType = ds.getString("dsType");
            String entityId = DSTypeEdit.getEntityId(dsType);
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityId);
            DynamicObject dsData = DSEditHelper.toDynamicObject(data, entity);
            DynamicObjectCollection fieldColl = dsData.getDynamicObjectCollection("selectentry");
            for (int i = 0; i < fieldColl.size(); ++i) {
                DynamicObject field = (DynamicObject)fieldColl.get(i);
                String fieldName = field.getString(FIELD_NAME);
                if (fieldMap.containsKey(fieldName)) continue;
                if (i < fields.size()) {
                    fields.add(i, field);
                } else {
                    fields.add(field);
                }
                fieldMap.put(fieldName, field);
            }
        }
        this.createFieldEntry(fields);
    }

    private void addField(String dataSourceId, Object fieldProp) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{DATA_TYPE});
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)dataSourceId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        MetadataReader reader = new MetadataReader(false);
        EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(dataSourceId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
        QueryEntity rootEntiry = (QueryEntity)entityMetadata.getRootEntity();
        List mainSelectFields = rootEntiry.getSelectFields();
        IDataModel model = this.getModel();
        for (QuerySelectField querySelectField : mainSelectFields) {
            String fieldName = querySelectField.getAlias();
            FilterField filterField = FilterField.create((MainEntityType)dataEntityType, (String)fieldName);
            if (filterField != null && (filterField.getLatestParent() instanceof MulBasedataProp || filterField.getSrcFieldProp() instanceof MulBasedataProp || filterField.getRefProp1() instanceof MulBasedataProp)) continue;
            IDataEntityProperty selectFieldProp = this.getFieldProperty(querySelectField, properties, rootEntiry);
            boolean isSameType = fieldProp != null && selectFieldProp != null && fieldProp.getClass().isAssignableFrom(selectFieldProp.getClass());
            if (!isSameType) continue;
            int rowIndex = model.createNewEntryRow(DS_FIELD);
            model.setValue(FIELD_NAME, (Object)querySelectField.getAlias(), rowIndex);
            model.setValue(DISPLAY_NAME, (Object)querySelectField.getDisplayName(), rowIndex);
            model.setValue("dsname", (Object)dataEntityType.getDisplayName(), rowIndex);
        }
    }

    public IDataEntityProperty getFieldProperty(QuerySelectField querySelectField, DataEntityPropertyCollection properties, QueryEntity rootEntiry) {
        String fieldName = querySelectField.getAlias();
        IDataEntityProperty selectFieldProp = (IDataEntityProperty)properties.get((Object)fieldName);
        if (selectFieldProp != null) {
            return selectFieldProp;
        }
        String entityAlias = "";
        if (fieldName.indexOf(46) != -1) {
            entityAlias = fieldName.substring(0, fieldName.indexOf("."));
        }
        boolean hasAlias = false;
        String entityName = null;
        if (entityAlias != null && !"".equals(entityAlias)) {
            for (JoinEntity joinEntity : rootEntiry.getJoinEntitys()) {
                if (!entityAlias.equals(joinEntity.getAlias())) continue;
                hasAlias = true;
                entityName = joinEntity.getEntityName();
                break;
            }
            if (hasAlias) {
                String[] fields = (fieldName = fieldName.substring(querySelectField.getAlias().indexOf(".") + 1)).split("\\.");
                if (fields.length == 1) {
                    return EntityMetadataCache.getDataEntityType((String)entityName).getProperty(fieldName);
                }
                DynamicProperty property = EntityMetadataCache.getDataEntityType((String)entityName).getProperty(fields[0]);
                if (property instanceof EntryProp) {
                    EntryProp prop = (EntryProp)property;
                    DynamicObjectType entyrType = prop.getDynamicCollectionItemPropertyType();
                    DataEntityPropertyCollection entryProperties = entyrType.getProperties();
                    fieldName = fieldName.substring(fieldName.indexOf(".") + 1);
                    return (IDataEntityProperty)entryProperties.get((Object)fieldName);
                }
                IBasedataField baseDataProp = (IBasedataField)property;
                String entityId = baseDataProp.getBaseEntityId();
                return EntityMetadataCache.getDataEntityType((String)entityId).getProperty(fields[1]);
            }
            if (properties.get((Object)entityAlias) instanceof EntryProp) {
                EntryProp prop = (EntryProp)properties.get((Object)entityAlias);
                DynamicObjectType entyrType = prop.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProperties = entyrType.getProperties();
                fieldName = fieldName.substring(querySelectField.getAlias().indexOf(".") + 1);
                return (IDataEntityProperty)entryProperties.get((Object)fieldName);
            }
            fieldName = fieldName.substring(querySelectField.getAlias().indexOf(".") + 1);
            IBasedataField entityProp = (IBasedataField)properties.get((Object)entityAlias);
            return ((DynamicObjectType)entityProp.getComplexType()).getProperty(fieldName);
        }
        return null;
    }

    private void createFieldEntry(List<DynamicObject> fields) {
        IDataModel model = this.getModel();
        for (DynamicObject f : fields) {
            int rowIndex = model.createNewEntryRow(DS_FIELD);
            model.setValue(FIELD_NAME, f.get(FIELD_NAME), rowIndex);
            model.setValue(DISPLAY_NAME, f.get(DISPLAY_NAME), rowIndex);
            model.setValue(DATA_TYPE, f.get(DATA_TYPE), rowIndex);
        }
    }

    private List<List<Map<String, Object>>> getContext() {
        List context = (List)this.getView().getFormShowParameter().getCustomParam("context");
        if (context.isEmpty() || ((List)context.get(0)).isEmpty()) {
            return null;
        }
        return context;
    }

    private void focusRow(int i) {
        EntryGrid grid = (EntryGrid)this.getControl(DS_FIELD);
        grid.selectRows(new int[]{i}, i);
    }
}

