/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.report.QueryDataSource;
import kd.bos.metadata.filter.CustomBaseDataFilterColumnAp;
import kd.bos.metadata.filter.CustomDateFilterColumnAp;
import kd.bos.metadata.filter.CustomEnumFilterColumnAp;
import kd.bos.metadata.filter.CustomFastFilterColumnAp;
import kd.bos.metadata.filter.CustomNumberFilterColumnAp;
import kd.bos.metadata.filter.CustomTxtFilterColumnAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.report.ReportListAp;

public class FilterFieldNamePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String DS_FIELD = "dsfield";
    private static final String FIELD_NAME = "fieldname";
    private static final String DISPLAY_NAME = "displayname";
    private static final String DS_Name = "dsname";
    private static final String VALUE = "value";

    public void initialize() {
        super.initialize();
        EntryGrid dsentry = (EntryGrid)this.getControl(DS_FIELD);
        dsentry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            EntryGrid dsentry = (EntryGrid)this.getControl(DS_FIELD);
            int[] selectedRows = dsentry.getEntryState().getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                this.returnData(selectedRows[0]);
            }
        } else {
            this.getView().close();
        }
    }

    public void entryRowDoubleClick(RowClickEvent e) {
        this.returnData(e.getRow());
    }

    public void entryRowClick(RowClickEvent e) {
    }

    private void returnData(int rowIndex) {
        IDataModel model = this.getModel();
        String fieldName = (String)model.getValue(FIELD_NAME, rowIndex);
        HashMap para = new HashMap(6);
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put(VALUE, fieldName);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getDataSourceField();
    }

    public void afterBindData(EventObject e) {
        Object selectedKey = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (selectedKey != null) {
            String selectedFieldName = (String)selectedKey;
            int rows = this.getModel().getEntryRowCount(DS_FIELD);
            for (int i = 0; i < rows; ++i) {
                String fieldName = (String)this.getModel().getValue(FIELD_NAME, i);
                if (!fieldName.equals(selectedFieldName)) continue;
                this.focusRow(i);
                break;
            }
        }
    }

    private void getDataSourceField() {
        PropertyEditHelper helper = new PropertyEditHelper();
        FormMetadata formMetadata = FormMetadataUtil.getFormMetadata(helper.getFormMeta(this.getView()));
        if (formMetadata != null) {
            QueryDataSource queryDataSource;
            formMetadata.createIndex();
            ReportListAp reportList = null;
            for (ControlAp item : formMetadata.getItems()) {
                if (!(item instanceof ReportListAp)) continue;
                reportList = (ReportListAp)item;
                break;
            }
            if (reportList != null && (queryDataSource = reportList.getQueryDataSource()) != null && StringUtils.isNotEmpty((CharSequence)queryDataSource.getDataSourceId())) {
                this.addField(queryDataSource.getDataSourceId(), formMetadata, helper);
            }
        }
    }

    private void addField(String dataSourceId, FormMetadata formMetadata, PropertyEditHelper helper) {
        MetadataReader reader = new MetadataReader(false);
        EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(dataSourceId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
        if (entityMetadata == null) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)dataSourceId);
        Map<String, Object> item = helper.getItem(this.getView());
        ControlAp currentControl = formMetadata.getItem((String)item.get("Id"));
        QueryEntity rootEntiry = (QueryEntity)entityMetadata.getRootEntity();
        List querySelectFields = rootEntiry.getSelectFields();
        IDataModel model = this.getModel();
        if (!querySelectFields.isEmpty()) {
            for (QuerySelectField querySelectField : querySelectFields) {
                IDataEntityProperty querySelectFieldPro;
                String fieldName = querySelectField.getAlias();
                FilterField filterField = FilterField.create((MainEntityType)dataEntityType, (String)fieldName);
                if (filterField != null && (filterField.getLatestParent() instanceof MulBasedataProp || filterField.getSrcFieldProp() instanceof MulBasedataProp || filterField.getRefProp1() instanceof MulBasedataProp) || (querySelectFieldPro = this.findProperty(querySelectField.getAlias(), dataEntityType)) == null) continue;
                if (currentControl instanceof CustomNumberFilterColumnAp && querySelectFieldPro instanceof DecimalProp) {
                    this.createNewEntryRow(model, querySelectField, dataEntityType);
                    continue;
                }
                if (currentControl instanceof CustomTxtFilterColumnAp && querySelectFieldPro instanceof TextProp) {
                    this.createNewEntryRow(model, querySelectField, dataEntityType);
                    continue;
                }
                if (currentControl instanceof CustomDateFilterColumnAp && querySelectFieldPro instanceof DateTimeProp) {
                    this.createNewEntryRow(model, querySelectField, dataEntityType);
                    continue;
                }
                if (currentControl instanceof CustomBaseDataFilterColumnAp && querySelectFieldPro instanceof BasedataProp && !(querySelectFieldPro instanceof FlexProp)) {
                    this.createNewEntryRow(model, querySelectField, dataEntityType, querySelectFieldPro);
                    continue;
                }
                if (currentControl instanceof CustomEnumFilterColumnAp && !(querySelectFieldPro instanceof BasedataProp)) {
                    this.createNewEntryRow(model, querySelectField, dataEntityType);
                    continue;
                }
                if (currentControl instanceof CustomFastFilterColumnAp && querySelectFieldPro instanceof FieldProp && StringUtils.equalsIgnoreCase((CharSequence)((FieldProp)querySelectFieldPro).getFilterControlType(), (CharSequence)"text") && !this.isMulBasedata(querySelectField.getAlias(), dataEntityType).booleanValue()) {
                    this.createNewEntryRow(model, querySelectField, dataEntityType);
                    continue;
                }
                if (!(currentControl instanceof CustomBaseDataFilterColumnAp) || !(querySelectFieldPro instanceof MulBasedataProp)) continue;
                this.createNewEntryRowForMul(model, querySelectField, dataEntityType, querySelectFieldPro);
            }
        }
    }

    private Boolean isMulBasedata(String alias, MainEntityType dataEntityType) {
        String[] aliasArr = alias.split("\\.");
        IDataEntityProperty head = dataEntityType.findProperty(aliasArr[0]);
        if (head instanceof EntryProp) {
            head = dataEntityType.findProperty(aliasArr[1]);
        }
        if (head instanceof MulBasedataProp) {
            return true;
        }
        return false;
    }

    private void createNewEntryRow(IDataModel model, QuerySelectField querySelectField, MainEntityType dataEntityType, IDataEntityProperty querySelectFieldPro) {
        BasedataProp basedataProp = (BasedataProp)querySelectFieldPro;
        BasedataEntityType basedataEntityType = (BasedataEntityType)basedataProp.getComplexType();
        if (basedataEntityType != null) {
            QuerySelectField fieldWithNumberProp;
            String number = basedataEntityType.getNumberProperty();
            String name = basedataEntityType.getNameProperty();
            if (StringUtils.isNotEmpty((CharSequence)number)) {
                fieldWithNumberProp = this.baseDataFieldWithRefProp(basedataEntityType, querySelectField, number);
                this.createNewEntryRow(model, fieldWithNumberProp, dataEntityType);
            }
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                fieldWithNumberProp = this.baseDataFieldWithRefProp(basedataEntityType, querySelectField, name);
                this.createNewEntryRow(model, fieldWithNumberProp, dataEntityType);
            }
        }
    }

    private void createNewEntryRowForMul(IDataModel model, QuerySelectField querySelectField, MainEntityType dataEntityType, IDataEntityProperty querySelectFieldPro) {
        MulBasedataProp basedataProp = (MulBasedataProp)querySelectFieldPro;
        BasedataEntityType basedataEntityType = (BasedataEntityType)basedataProp.getComplexType();
        if (basedataEntityType != null) {
            QuerySelectField fieldWithNumberProp;
            String number = basedataEntityType.getNumberProperty();
            String name = basedataEntityType.getNameProperty();
            if (StringUtils.isNotEmpty((CharSequence)number)) {
                fieldWithNumberProp = this.baseDataFieldWithRefProp(basedataEntityType, querySelectField, number);
                this.createNewEntryRow(model, fieldWithNumberProp, dataEntityType);
            }
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                fieldWithNumberProp = this.baseDataFieldWithRefProp(basedataEntityType, querySelectField, name);
                this.createNewEntryRow(model, fieldWithNumberProp, dataEntityType);
            }
        }
    }

    private QuerySelectField baseDataFieldWithRefProp(BasedataEntityType basedataEntityType, QuerySelectField querySelectField, String refPropKey) {
        QuerySelectField fieldWithRefProp = new QuerySelectField();
        fieldWithRefProp.setId(querySelectField.getId());
        StringBuilder builder = new StringBuilder(querySelectField.getAlias());
        builder.append(".").append(refPropKey);
        fieldWithRefProp.setAlias(builder.toString());
        builder = new StringBuilder(querySelectField.getDisplayName());
        builder.append(".").append(basedataEntityType.findProperty(refPropKey).getDisplayName());
        fieldWithRefProp.setDisplayName(builder.toString());
        return fieldWithRefProp;
    }

    private void createNewEntryRow(IDataModel model, QuerySelectField querySelectField, MainEntityType dataEntityType) {
        int newRowIndex = model.createNewEntryRow(DS_FIELD);
        model.setValue(FIELD_NAME, (Object)querySelectField.getAlias(), newRowIndex);
        model.setValue(DISPLAY_NAME, (Object)querySelectField.getDisplayName(), newRowIndex);
        model.setValue(DS_Name, (Object)dataEntityType.getName(), newRowIndex);
    }

    private IDataEntityProperty findProperty(String alias, MainEntityType dataEntityType) {
        String[] aliasArr = alias.split("\\.");
        IDataEntityProperty parentProperty = dataEntityType.findProperty(aliasArr[0]);
        if (aliasArr.length == 1) {
            return parentProperty;
        }
        if (parentProperty instanceof JoinProperty) {
            return this.findPropertyFromJoinEntity(parentProperty, alias);
        }
        if (parentProperty instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)parentProperty;
            EntryType entryType = (EntryType)entryProp.getDynamicCollectionItemPropertyType();
            IDataEntityProperty entryProperty = entryType.findProperty(aliasArr[1]);
            if (aliasArr.length == 2) {
                return entryProperty;
            }
            if (entryProperty instanceof IBasedataField) {
                IBasedataField entityProp = (IBasedataField)entryProperty;
                return ((DynamicObjectType)entityProp.getComplexType()).getProperty(aliasArr[2]);
            }
            return null;
        }
        if (parentProperty instanceof IBasedataField) {
            IBasedataField entityProp = (IBasedataField)parentProperty;
            return ((DynamicObjectType)entityProp.getComplexType()).getProperty(aliasArr[1]);
        }
        return null;
    }

    private IDataEntityProperty findPropertyFromJoinEntity(IDataEntityProperty parentProperty, String alias) {
        JoinProperty joinProperty = (JoinProperty)parentProperty;
        String joinEntityFieldName = alias.substring(alias.indexOf(".") + 1);
        String[] joinEntityFields = joinEntityFieldName.split("\\.");
        MainEntityType dynamicComplexPropertyType = (MainEntityType)joinProperty.getDynamicComplexPropertyType();
        IDataEntityProperty joinEntityPro = dynamicComplexPropertyType.findProperty(joinEntityFields[0]);
        if (joinEntityFields.length == 1) {
            return joinEntityPro;
        }
        if (joinEntityPro instanceof EntryProp) {
            EntryProp joinEntityEntryProp = (EntryProp)joinEntityPro;
            EntryType joinEntityEntryType = (EntryType)joinEntityEntryProp.getDynamicCollectionItemPropertyType();
            IDataEntityProperty joinEntryProperty = joinEntityEntryType.findProperty(joinEntityFields[1]);
            if (joinEntityFields.length == 2) {
                return joinEntryProperty;
            }
            if (joinEntryProperty instanceof IBasedataField) {
                IBasedataField entityProp = (IBasedataField)joinEntryProperty;
                return ((DynamicObjectType)entityProp.getComplexType()).getProperty(joinEntityFields[2]);
            }
            return null;
        }
        if (joinEntityPro instanceof IBasedataField) {
            IBasedataField entityProp = (IBasedataField)joinEntityPro;
            return ((DynamicObjectType)entityProp.getComplexType()).getProperty(joinEntityFields[1]);
        }
        return null;
    }

    private void focusRow(int i) {
        EntryGrid grid = (EntryGrid)this.getControl(DS_FIELD);
        grid.selectRows(new int[]{i}, i);
    }
}

