/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.io.IOException;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class FilterValueEdit
extends AbstractFormPlugin
implements TreeNodeClickListener,
IBizRuleEditor {
    private static final String FORMULATXT = "formulatxt";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.setRootVisible(false);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String filterFieldTree = (String)this.getView().getFormShowParameter().getCustomParam("filterFieldTree");
        try {
            TreeNode root = (TreeNode)JSONUtils.cast((String)filterFieldTree, TreeNode.class);
            root.setIsOpened(true);
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            tree.addNode(root);
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        String formula = this.getInputConfig();
        this.getModel().setValue(FORMULATXT, (Object)formula);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.closeAndReturn();
        } else {
            this.getView().close();
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (!StringUtils.isEmpty((String)((String)e.getNodeId()))) {
            String character = e.getNodeId().toString();
            if (this.getModel().getValue(FORMULATXT) != null) {
                character = this.getModel().getValue(FORMULATXT).toString() + " " + character + " ";
            }
            this.getModel().setValue(FORMULATXT, (Object)character);
        }
    }

    private void closeAndReturn() {
        IDataModel model = this.getModel();
        Object formula = model.getValue(FORMULATXT);
        if (StringUtils.isEmpty((String)((String)formula))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8fc7\u6ee4\u503c", (String)"FilterValueEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        String expression = ((String)formula).trim();
        IDataModel parentModel = this.getView().getParentView().getModel();
        int rowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowIndex");
        parentModel.setValue("filtervalue", (Object)expression, rowIndex);
        this.getView().close();
    }

    public String getOutConfig() {
        return (String)this.getModel().getValue(FORMULATXT);
    }
}

