/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.report.DSEdit;
import kd.bos.designer.property.report.DSEditHelper;
import kd.bos.designer.property.report.DSTypeEdit;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.JSONUtils;

public class JoinDSEdit
extends DSEdit {
    private static final String CLIENT_DS = "clientds";
    private static final String SUPPLIERDS = "supplierds";
    private static final String NUMBER = "number";
    private static final String JOIN_ENTRY = "joinentry";
    private static final String SELECT_ENTRY = "selectentry";
    private static final String FIELD_KEY = "fieldKey";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"selectbar", "joinbar"});
        this.initDSCombo();
        this.initJoinEntry();
        this.addQueryFieldClickListener();
    }

    private void initDSCombo() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List dsList = (List)parameter.getCustomParam("ds");
        ComboEdit clientds = (ComboEdit)this.getControl(CLIENT_DS);
        ComboEdit supplierds = (ComboEdit)this.getControl(SUPPLIERDS);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (Map ds : dsList) {
            ComboItem it = new ComboItem();
            it.setValue((String)ds.get(NUMBER));
            it.setCaption(new LocaleString((String)ds.get("name")));
            items.add(it);
        }
        clientds.setComboItems(items);
        supplierds.setComboItems(items);
    }

    private void initJoinEntry() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String data = (String)showParameter.getCustomParam("dsdata");
        MainEntityType entityType = this.getModel().getDataEntityType();
        DynamicObject obj = DSEditHelper.toDynamicObject(data, entityType);
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{obj}, (IDataEntityType)entityType);
        EntryGrid jentry = (EntryGrid)this.getView().getControl(JOIN_ENTRY);
        List dsList = (List)showParameter.getCustomParam("ds");
        for (Control ctrl : jentry.getItems()) {
            if (!(ctrl instanceof ComboEdit)) continue;
            String ds = null;
            if ("clientfield".equals(ctrl.getKey())) {
                ds = CLIENT_DS;
            } else if ("supplierfield".equals(ctrl.getKey())) {
                ds = SUPPLIERDS;
            }
            if (ds == null) continue;
            this.initJoinFields(ctrl.getKey(), (ComboEdit)ctrl, obj.getString(ds), dsList);
        }
        EntryGrid sentry = (EntryGrid)this.getView().getControl(SELECT_ENTRY);
        for (Control ctrl : sentry.getItems()) {
            if (!"queryds".equals(ctrl.getKey())) continue;
            this.initJoinDS(ctrl.getKey(), (ComboEdit)ctrl, dsList);
        }
    }

    private void initJoinDS(String field, ComboEdit editor, List<Map<String, String>> dsList) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (Map<String, String> it : dsList) {
            String dsnumber = it.get(NUMBER);
            String dsname = it.get("name");
            ComboItem item = new ComboItem();
            item.setValue(dsnumber);
            item.setCaption(new LocaleString(dsname));
            items.add(item);
        }
        editor.setComboItems(items);
    }

    private void initJoinFields(String field, ComboEdit editor, String ds, List<Map<String, String>> dsList) {
        for (Map<String, String> it : dsList) {
            String dsnumber = it.get(NUMBER);
            if (!dsnumber.equals(ds)) continue;
            String dsJson = it.get("data");
            String dsType = it.get("type");
            this.initJoinField(editor, dsType, dsJson);
            break;
        }
    }

    private void initJoinField(ComboEdit editor, String dsType, String dsJson) {
        if (StringUtils.isEmpty((CharSequence)dsJson)) {
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        DynamicObject ds = this.getDS(dsType, dsJson);
        if ("1".equals(dsType) || "2".equals(dsType)) {
            DynamicObjectCollection fieldColl = ds.getDynamicObjectCollection(SELECT_ENTRY);
            for (DynamicObject obj : fieldColl) {
                String dataType = obj.getString("datatype");
                if (!this.isJoinField(dataType)) continue;
                ComboItem item = new ComboItem();
                item.setValue(obj.getString("fieldname"));
                item.setCaption(new LocaleString(obj.getString("displayname")));
                items.add(item);
            }
        }
        editor.setComboItems(items);
    }

    private void addQueryFieldClickListener() {
        EntryGrid selectentry = (EntryGrid)this.getControl(SELECT_ENTRY);
        selectentry.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent e) {
                String fieldKey = e.getFieldKey();
                int row = e.getRow();
                if (row < 0) {
                    return;
                }
                if ("queryfield".equals(fieldKey)) {
                    JoinDSEdit.this.showSelectEdit(fieldKey, row);
                }
            }

            public void cellDoubleClick(CellClickEvent e) {
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (!"ide_joinds".equals(evt.getActionId()) || !(evt.getReturnData() instanceof Map)) {
            return;
        }
        Map ret = (Map)evt.getReturnData();
        if ("queryfield".equals(ret.get(FIELD_KEY))) {
            int rowIndex = (Integer)ret.get("rowIndex");
            String fieldKey = (String)ret.get(FIELD_KEY);
            String value = (String)ret.get("value");
            this.getModel().setValue(fieldKey, (Object)value, rowIndex);
        }
    }

    private void showSelectEdit(String fieldKey, int rowIndex) {
        IDataModel model = this.getModel();
        try {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_formula");
            parameter.setCustomParam("rowIndex", (Object)rowIndex);
            parameter.setCustomParam(FIELD_KEY, (Object)fieldKey);
            parameter.setCustomParam("value", model.getValue(fieldKey, rowIndex));
            String dsNumber = (String)model.getValue("queryds", rowIndex);
            TreeNode root = DSEditHelper.getFieldTree(this.getView(), dsNumber);
            parameter.setCustomParam("treeNode", (Object)JSONUtils.toString((Object)root));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
            this.getView().showForm(parameter);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private boolean isJoinField(String dataType) {
        return "basedata".equals(dataType) || "user".equals(dataType) || "currency".equals(dataType) || "integer".equals(dataType) || "text".equals(dataType);
    }

    private DynamicObject getDS(String dsType, String dsJson) {
        String clientdsEntityId = DSTypeEdit.getEntityId(dsType);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)clientdsEntityId);
        return DSEditHelper.toDynamicObject(dsJson, entityType);
    }

    @Override
    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String data = (String)showParameter.getCustomParam("dsdata");
        MainEntityType entityType = this.getModel().getDataEntityType();
        if (data != null) {
            DynamicObject obj = DSEditHelper.toDynamicObject(data, entityType);
            BusinessDataReader.loadRefence((Object[])new DynamicObject[]{obj}, (IDataEntityType)entityType);
            e.setDataEntity((Object)obj);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("importsf".equals(key)) {
            this.importField();
        } else if ("deletesf".equals(key)) {
            this.deleteRow(SELECT_ENTRY);
        } else if ("deleteref".equals(key)) {
            this.deleteRow(JOIN_ENTRY);
        } else if ("addref".equals(key)) {
            this.getModel().createNewEntryRow(JOIN_ENTRY);
        }
    }

    private void deleteRow(String entry) {
        IDataModel model = this.getModel();
        EntryGrid dsentry = (EntryGrid)this.getControl(entry);
        int[] rowIndexs = dsentry.getEntryState().getSelectedRows();
        if (rowIndexs != null && rowIndexs.length > 0) {
            model.deleteEntryRows(entry, rowIndexs);
        }
    }

    private void importField() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List dsList = (List)showParameter.getCustomParam("ds");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("dsType", (Object)"2");
        parameter.setFormId("ide_selectfield");
        IDataModel model = this.getModel();
        Object clientds = model.getValue(CLIENT_DS);
        Object supplierds = model.getValue(SUPPLIERDS);
        for (Map ds : dsList) {
            String dsnumber = (String)ds.get(NUMBER);
            if (dsnumber.equals(clientds)) {
                parameter.setCustomParam(CLIENT_DS, ds.get("data"));
                parameter.setCustomParam("clientdstype", ds.get("type"));
                continue;
            }
            if (!dsnumber.equals(supplierds)) continue;
            parameter.setCustomParam(SUPPLIERDS, ds.get("data"));
            parameter.setCustomParam("supplierdstype", ds.get("type"));
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }
}

