/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.filter.FilterColumnAp;
import kd.bos.metadata.filter.FilterContainerAp;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.report.ReportFilterAp;
import kd.bos.metadata.report.ReportTreeAp;

public class ReportDesignerTool {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    protected static TreeNode getFieldTreeNode(String entityId) {
        String id = MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
        EntityMetadataUtil entityMetadataUtil = new EntityMetadataUtil();
        TreeNode root = entityMetadataUtil.getFieldList(entityMeta, entityMeta.getName().getLocaleValue());
        root.setParentid(null);
        root.setExpend(true);
        return root;
    }

    protected static TreeNode getFilterEntity(List<List<Map<String, Object>>> ctx) {
        FormMetadata meta = FormMetadataUtil.getFormMetadata(ctx.get(1));
        meta.createIndex();
        List<ComboItem> its = ReportDesignerTool.getFilterFieldItems(meta);
        HashSet<String> filterFields = new HashSet<String>(16);
        for (ComboItem it : its) {
            filterFields.add(it.getValue());
        }
        ArrayList<Map<String, Object>> fieldFields = new ArrayList<Map<String, Object>>(10);
        List<Map<String, Object>> entityMeta = ctx.get(0);
        fieldFields.add(entityMeta.get(0));
        for (Map<String, Object> entityItem : entityMeta) {
            String key = (String)entityItem.get("Key");
            if (!filterFields.contains(key)) continue;
            fieldFields.add(entityItem);
        }
        EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata(fieldFields);
        entityMetadata.createIndex();
        EntityMetadataUtil entityMetadataUtil = new EntityMetadataUtil();
        TreeNode root = new TreeNode();
        root.setId("");
        TreeNode filterFieldNode = entityMetadataUtil.getHeadTreeNode(entityMetadata, entityMetadata.getName().getLocaleValue());
        filterFieldNode.setText(ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5", (String)"ReportDesignerTool_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        filterFieldNode.setParentid(null);
        filterFieldNode.setExpend(true);
        filterFieldNode.setIsOpened(true);
        root.addChild(filterFieldNode);
        ControlAp<?> joinEntity = ReportDesignerTool.getJoinControlAp(meta);
        if (joinEntity != null) {
            TreeNode joinNode = new TreeNode();
            joinNode.setId("JOIN_NODE");
            joinNode.setText(ResManager.loadKDString((String)"\u5173\u8054\u5b57\u6bb5", (String)"ReportDesignerTool_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            joinNode.setExpend(true);
            joinNode.setIsOpened(true);
            TreeNode joinFieldNode = new TreeNode();
            joinFieldNode.setId("$SELECTED_NODE");
            joinFieldNode.setText(ResManager.loadKDString((String)"\u9009\u4e2d\u8282\u70b9", (String)"ReportDesignerTool_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            joinNode.addChild(joinFieldNode);
            root.addChild(joinNode);
        }
        return root;
    }

    private static ControlAp<?> getJoinControlAp(FormMetadata meta) {
        for (ControlAp ap : meta.getItems()) {
            if (!(ap instanceof ReportTreeAp)) continue;
            return ap;
        }
        return null;
    }

    protected static List<ComboItem> getFilterFieldItems(FormMetadata meta) {
        ContainerAp<?> filterAp = ReportDesignerTool.getReportFilterAp(meta.getItems());
        ArrayList<ComboItem> fieldList = new ArrayList<ComboItem>();
        if (filterAp != null) {
            ReportDesignerTool.findFilterFieldAp(filterAp, fieldList);
        }
        return fieldList;
    }

    private static void findFilterFieldAp(ContainerAp<?> contAp, List<ComboItem> fieldList) {
        for (ControlAp ap : contAp.getItems()) {
            if (ap instanceof FieldAp || ap instanceof FilterColumnAp) {
                ComboItem it = new ComboItem();
                it.setValue(ap.getKey());
                it.setCaption(ap.getName());
                fieldList.add(it);
                continue;
            }
            if (!(ap instanceof ContainerAp)) continue;
            ReportDesignerTool.findFilterFieldAp((ContainerAp)ap, fieldList);
        }
    }

    private static ContainerAp<?> getReportFilterAp(List<ControlAp<?>> apList) {
        for (ControlAp<?> ap : apList) {
            if (ap instanceof ReportFilterAp || ap instanceof FilterContainerAp) {
                return (ContainerAp)ap;
            }
            if (!(ap instanceof ContainerAp)) continue;
            ReportDesignerTool.getReportFilterAp(((ContainerAp)ap).getItems());
        }
        return null;
    }
}

