/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.entity.report.ReportFilterDefaultField;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConChildPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.report.ReportCommFilterPanelAp;
import kd.bos.metadata.report.ReportMoreFilterPanelAp;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.util.CollectionUtils;

public class ReportInitialFieldPlugin
extends AbstractFormPlugin {
    private static final String NAME = "name";
    private static final String USER_HIDE = "userhide";
    private static final String INITIAL_HIDE = "initialhide";
    private static final String CONTEXT = "context";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_KEY = "fieldkey";
    private static final String VALUE = "value";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        this.addClickListeners(new String[]{BTN_CANCEL});
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.returnDataToParentAndClose();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        EntityMetadata entityMetadata;
        PropertyEditHelper helper = new PropertyEditHelper();
        List context = (List)helper.getParamValue(this.getView(), CONTEXT);
        if (context == null) {
            return;
        }
        FormMetadata listMetadata = FormTreeBuilder.deserialzeFormMetadata((List)((List)context.get(0)));
        Map<String, LocaleString> canSetFields = this.canSetFields(listMetadata, entityMetadata = FormTreeBuilder.deserializeEntityMetadata((List)((List)context.get(1))));
        if (CollectionUtils.isEmpty(canSetFields)) {
            return;
        }
        List defaultFields = (List)helper.getParamValue(this.getView(), VALUE);
        Map defaultFieldsMap = null;
        if (!CollectionUtils.isEmpty((Collection)defaultFields)) {
            defaultFieldsMap = defaultFields.stream().collect(Collectors.toMap(item -> item.get("fieldKey").toString(), Function.identity()));
        }
        this.getModel().clearNoDataRow();
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, canSetFields.size());
        int i = 0;
        for (Map.Entry<String, LocaleString> field : canSetFields.entrySet()) {
            String fieldKey = field.getKey();
            this.getModel().setValue(FIELD_KEY, (Object)fieldKey, i);
            this.getModel().setValue(NAME, (Object)field.getValue(), i);
            if (entityMetadata.getFieldByKey(fieldKey).isMustInput()) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{INITIAL_HIDE, USER_HIDE});
            } else if (!CollectionUtils.isEmpty((Collection)defaultFields)) {
                Map oldFieldSet;
                Map map = oldFieldSet = defaultFieldsMap == null ? null : (Map)defaultFieldsMap.get(fieldKey);
                if (oldFieldSet != null && !CollectionUtils.isEmpty((Map)oldFieldSet)) {
                    this.getModel().setValue(INITIAL_HIDE, (Object)oldFieldSet.getOrDefault("initialHide", false), i);
                    this.getModel().setValue(USER_HIDE, (Object)oldFieldSet.getOrDefault("userHide", false), i);
                }
            }
            ++i;
        }
        super.afterCreateNewData(e);
    }

    private Map<String, LocaleString> canSetFields(FormMetadata listMetadata, EntityMetadata entityMetadata) {
        List<ControlAp<?>> commonFilterColumnAps = this.getCommonFilterColumnAp(listMetadata);
        LinkedHashMap<String, LocaleString> canSetField = new LinkedHashMap<String, LocaleString>(16);
        HashMap<String, String> radioGroupField = new HashMap<String, String>(16);
        this.getFieldList(commonFilterColumnAps, entityMetadata, canSetField, radioGroupField);
        return canSetField;
    }

    private void getFieldList(List<ControlAp<?>> commonFilterColumnAps, EntityMetadata entityMetadata, Map<String, LocaleString> canSetField, Map<String, String> radioGroupField) {
        for (ControlAp<?> ap : commonFilterColumnAps) {
            if (ap instanceof FlexPanelAp || ap instanceof AdvConAp || ap instanceof AdvConChildPanelAp) {
                this.getFieldList(((ContainerAp)ap).getItems(), entityMetadata, canSetField, radioGroupField);
                continue;
            }
            if (!(ap instanceof FieldAp)) continue;
            FieldAp fieldAp = (FieldAp)ap;
            Field field = entityMetadata.getFieldByKey(fieldAp.getKey());
            if (field instanceof RadioGroupField) {
                radioGroupField.put(fieldAp.getId(), fieldAp.getKey());
            } else if (field instanceof RadioField && canSetField.containsKey(radioGroupField.get(((RadioField)field).getGroup()))) continue;
            canSetField.put(fieldAp.getKey(), fieldAp.getName());
        }
    }

    private List<ControlAp<?>> getCommonFilterColumnAp(FormMetadata listMetadata) {
        ArrayList controlAps = new ArrayList(10);
        listMetadata.createIndex();
        for (ControlAp item : listMetadata.getItems()) {
            if (item instanceof ReportCommFilterPanelAp) {
                controlAps.addAll(((ReportCommFilterPanelAp)item).getItems());
            }
            if (!(item instanceof ReportMoreFilterPanelAp)) continue;
            controlAps.addAll(((ReportMoreFilterPanelAp)item).getItems());
        }
        return controlAps;
    }

    private void returnDataToParentAndClose() {
        HashMap<String, Object> para = new HashMap<String, Object>(16);
        StringBuilder sortAlias = new StringBuilder();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList value = new ArrayList(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String field = dynamicObject.getString(FIELD_KEY);
            if (StringUtils.isEmpty((CharSequence)field)) continue;
            boolean initialHide = dynamicObject.getBoolean(INITIAL_HIDE);
            boolean userHide = dynamicObject.getBoolean(USER_HIDE);
            if (!initialHide) {
                sortAlias.append(dynamicObject.get(NAME).toString()).append(";");
            }
            if (!userHide) continue;
            HashMap<String, Object> defaultShowFieldValue = new HashMap<String, Object>(4);
            defaultShowFieldValue.put("fieldKey", field);
            defaultShowFieldValue.put("_Type_", ReportFilterDefaultField.class.getSimpleName());
            defaultShowFieldValue.put("initialHide", dynamicObject.getBoolean(INITIAL_HIDE));
            defaultShowFieldValue.put("userHide", dynamicObject.getBoolean(USER_HIDE));
            value.add(defaultShowFieldValue);
        }
        para.put(VALUE, value);
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
        para.put("alias", sortAlias.toString());
        this.getView().returnDataToParent(para);
        this.getView().close();
    }
}

