/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.devportal.common.kingscript.TSShowFormUtil;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;

public class ReportRegisterPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String BTN_REGISTER = "register";
    private static final String BTN_REGISTERJS = "registerjs";
    private static final String BTN_REGISTERTS = "registerts";
    private static final String BTN_SELECTTS = "selectts";
    private static final String BTN_EDIT = "edit";
    private static final String BTN_UNREGISTER = "unregister";
    private static final String[] ITEMS = new String[]{"edit", "unregister"};
    private static final String VALUE = "value";
    private static final String ROW_KEY_NAME = "RowKey";
    private static final String PARAM_ITEM_ID = "itemId";
    private static final String ENTRY_KEY = "entryentity";
    private static final String PLUGIN_CLASS_NAME = "ClassName";
    private static final String PLUGIN_ENABLE_NAME = "Enabled";
    private static final String PLUGIN_DESCRIPTION_NAME = "Description";
    private static final String PLUGIN_DISPLAYNAME_NAME = "DisplayName";
    private static final String PLUGIN_TYPE_NAME = "Type";
    private static final String PLUGIN_FPK_NAME = "FPK";
    private static final String PLUGIN_BIZAPPID_NAME = "BizAppId";
    private static final String ENTRY_CLASS_NAME = "classname";
    private static final String ENTRY_ENABLE_NAME = "enabled";
    private static final String ENTRY_DESCRIPTION_NAME = "description";
    private static final String ENTRY_DISPLAYNAME_NAME = "displayname";
    private static final String ENTRY_TYPE_NAME = "type";
    private static final String ENTRY_FPK_NAME = "fpk";
    private static final String ENTRY_BIZAPPID_NAME = "bizappid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_REGISTER, BTN_EDIT, BTN_UNREGISTER, "ok", "exit"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String reportPlugin;
        ArrayList<Object> valJson = new ArrayList();
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List list = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        if ("[]".equals(value) && list.isEmpty()) {
            return;
        }
        if (value != null && !StringUtils.isEmpty((CharSequence)value.toString())) {
            valJson = value;
        }
        if (!(valJson instanceof List)) {
            return;
        }
        List plugins = valJson;
        for (Map plugin : plugins) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
            this.getModel().setValue(ENTRY_CLASS_NAME, plugin.get(PLUGIN_CLASS_NAME), rowIndex);
            if (plugin.get(PLUGIN_ENABLE_NAME) == null) {
                this.getModel().setValue(ENTRY_ENABLE_NAME, (Object)false, rowIndex);
            } else {
                this.getModel().setValue(ENTRY_ENABLE_NAME, plugin.get(PLUGIN_ENABLE_NAME), rowIndex);
            }
            this.getModel().setValue(ENTRY_DESCRIPTION_NAME, plugin.get(PLUGIN_DESCRIPTION_NAME), rowIndex);
            this.getModel().setValue(ENTRY_DISPLAYNAME_NAME, plugin.get(PLUGIN_DISPLAYNAME_NAME), rowIndex);
            this.getModel().setValue(ENTRY_TYPE_NAME, plugin.get(PLUGIN_TYPE_NAME), rowIndex);
            this.getModel().setValue(ENTRY_FPK_NAME, plugin.get(PLUGIN_FPK_NAME), rowIndex);
            this.getModel().setValue(ENTRY_BIZAPPID_NAME, plugin.get(PLUGIN_BIZAPPID_NAME), rowIndex);
        }
        int count = this.getModel().getEntryRowCount(ENTRY_KEY);
        if (count > 0) {
            return;
        }
        if (((List)list.get(0)).size() == 0) {
            return;
        }
        Map map = (Map)((List)list.get(0)).get(0);
        String string = reportPlugin = map.get("ReportPlugin") == null ? "" : (String)map.get("ReportPlugin");
        if (StringUtils.isNotBlank((CharSequence)reportPlugin)) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
            this.getModel().setValue(ENTRY_CLASS_NAME, (Object)reportPlugin, rowIndex);
            this.getModel().setValue(ENTRY_ENABLE_NAME, (Object)true, rowIndex);
            this.getModel().setValue(ENTRY_DESCRIPTION_NAME, (Object)reportPlugin, rowIndex);
            this.getModel().setValue(ENTRY_DISPLAYNAME_NAME, (Object)reportPlugin, rowIndex);
            this.getModel().setValue(ENTRY_TYPE_NAME, null, rowIndex);
            this.getModel().setValue(ENTRY_FPK_NAME, null, rowIndex);
            this.getModel().setValue(ENTRY_BIZAPPID_NAME, null, rowIndex);
            return;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String modelType = this.getModelType();
        if (Plugin.enableRegisterKingScript((String)modelType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_REGISTERTS});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_REGISTERTS});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BTN_REGISTER.equalsIgnoreCase(key)) {
            this.register();
        } else if (BTN_REGISTERTS.equalsIgnoreCase(key)) {
            this.registerTs();
        } else if (BTN_SELECTTS.equalsIgnoreCase(key)) {
            this.openPluginJavaScript(BTN_REGISTERJS, BTN_REGISTERTS);
        } else if (BTN_EDIT.equalsIgnoreCase(key)) {
            this.editPlugin();
        } else if (BTN_UNREGISTER.equalsIgnoreCase(key)) {
            this.unRegister();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        if (e.getActionId().equals(BTN_REGISTERJS)) {
            List plugins = (List)e.getReturnData();
            for (Map plugin : plugins) {
                List<Map<String, Object>> currents = this.getPluginsFromEntryEntity();
                boolean bExist = false;
                for (Map<String, Object> current : currents) {
                    if (!plugin.get(PLUGIN_CLASS_NAME).equals(current.get(PLUGIN_CLASS_NAME))) continue;
                    bExist = true;
                    break;
                }
                if (bExist) continue;
                this.addToModel(plugin);
            }
        } else if (e.getActionId().equals(BTN_REGISTER)) {
            Map plugin = (Map)e.getReturnData();
            int iTestType = 0;
            plugin.put(ROW_KEY_NAME, iTestType);
            this.addToModel(plugin);
        } else if (BTN_REGISTERTS.equalsIgnoreCase(e.getActionId())) {
            Map plugin = (Map)e.getReturnData();
            this.addToModel(plugin);
        } else if (BTN_EDIT.equals(e.getActionId())) {
            Map plugin = (Map)e.getReturnData();
            int rowKey = (Integer)plugin.get(ROW_KEY_NAME);
            this.getModel().setValue(ENTRY_CLASS_NAME, plugin.get(PLUGIN_CLASS_NAME), rowKey);
            this.getModel().setValue(ENTRY_ENABLE_NAME, plugin.get(PLUGIN_ENABLE_NAME), rowKey);
            this.getModel().setValue(ENTRY_DESCRIPTION_NAME, plugin.get(PLUGIN_DESCRIPTION_NAME), rowKey);
            this.getModel().setValue(ENTRY_DISPLAYNAME_NAME, plugin.get(PLUGIN_DISPLAYNAME_NAME), rowKey);
            this.getModel().setValue(ENTRY_TYPE_NAME, plugin.get(PLUGIN_TYPE_NAME), rowKey);
            this.getModel().setValue(ENTRY_FPK_NAME, plugin.get(PLUGIN_FPK_NAME), rowKey);
            this.getModel().setValue(ENTRY_BIZAPPID_NAME, plugin.get(PLUGIN_BIZAPPID_NAME), rowKey);
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey()) {
            case "ok": {
                this.closeAndreturnData();
                break;
            }
            case "exit": {
                this.getView().close();
                break;
            }
            case "vectorap": 
            case "labelap": {
                String url = "https://vip.kingdee.com/knowledge/specialDetail/218022218066869248?category=475348362024443392&id=339836302126892544&productLineId=29&lang=";
                String lang = "zh-CN";
                if (Lang.get() != Lang.zh_TW && Lang.get() != Lang.zh_CN) {
                    lang = "en-US";
                }
                url = url + lang;
                this.getView().openUrl(url);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (evt.getRow() < 0) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), ITEMS);
        int index = evt.getRow();
        this.setItemsEnable(index);
    }

    private void unRegister() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int entryRowKey = grid.getEntryState().getFocusRow();
        if (StringUtils.isNotBlank((Object)entryRowKey) && entryRowKey != -1) {
            this.getModel().deleteEntryRow(ENTRY_KEY, entryRowKey);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PluginsPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void setItemsEnable(int index) {
        if (index < 0) {
            return;
        }
        String modelType = this.getModelType();
        if (!Plugin.enableRegisterKingScript((String)modelType)) {
            Map<String, Object> currentPlugin = this.getCurrentPlugin(index);
            int type = 0;
            if (currentPlugin.get(PLUGIN_TYPE_NAME) != null) {
                type = (Integer)currentPlugin.get(PLUGIN_TYPE_NAME);
            }
            if (4 == type) {
                this.getView().setEnable(Boolean.valueOf(false), ITEMS);
            }
        }
    }

    private void addToModel(Map<String, Object> plugin) {
        plugin.put("_Type_", "Plugin");
        int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
        this.getModel().setValue(ENTRY_CLASS_NAME, plugin.get(PLUGIN_CLASS_NAME), rowIndex);
        this.getModel().setValue(ENTRY_ENABLE_NAME, plugin.get(PLUGIN_ENABLE_NAME), rowIndex);
        this.getModel().setValue(ENTRY_DESCRIPTION_NAME, plugin.get(PLUGIN_DESCRIPTION_NAME), rowIndex);
        this.getModel().setValue(ENTRY_DISPLAYNAME_NAME, plugin.get(PLUGIN_DISPLAYNAME_NAME), rowIndex);
        this.getModel().setValue(ENTRY_TYPE_NAME, plugin.get(PLUGIN_TYPE_NAME), rowIndex);
        this.getModel().setValue(ENTRY_FPK_NAME, plugin.get(PLUGIN_FPK_NAME), rowIndex);
        this.getModel().setValue(ENTRY_BIZAPPID_NAME, plugin.get(PLUGIN_BIZAPPID_NAME), rowIndex);
        plugin.put(ROW_KEY_NAME, rowIndex);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        grid.clearEntryState();
    }

    private void closeAndreturnData() {
        List list = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        if (((List)list.get(0)).size() > 0) {
            String reportPlugin;
            Map map = (Map)((List)list.get(0)).get(0);
            String string = reportPlugin = map.get("ReportPlugin") == null ? "" : (String)map.get("ReportPlugin");
            if (StringUtils.isNotBlank((CharSequence)reportPlugin)) {
                CloseCallBack closeCallBack = this.getView().getFormShowParameter().getCloseCallBack();
                FormDesigner formDesigner = (FormDesigner)this.getView().getParentView().getControl(closeCallBack.getControlKey());
                String itemId = (String)this.getView().getFormShowParameter().getCustomParams().get(PARAM_ITEM_ID);
                String propertyName = "ReportPlugin";
                String value = "";
                String metaType = "formmeta";
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put(PARAM_ITEM_ID, itemId);
                map1.put(VALUE, value);
                map1.put("propertyName", propertyName);
                map1.put("metaType", metaType);
                formDesigner.setProperty(map1);
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
        HashMap para = new HashMap(16);
        para.put(PARAM_ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(PARAM_ITEM_ID));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        List<Map<String, Object>> plugins = this.getPluginsFromEntryEntity();
        para.put(VALUE, plugins);
        para.put("alias", "");
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private void editPlugin() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowKey = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_KEY) > 0 && rowKey >= 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            Map<String, Object> currentPlugin = this.getCurrentPlugin(rowKey);
            parameter.setCustomParam("isEdit", (Object)"isEdit");
            parameter.setCustomParam("rowKey", (Object)rowKey);
            parameter.setCustomParam("plugin", currentPlugin);
            parameter.setCustomParam("formnumber", (Object)this.getFormId());
            parameter.setCustomParam("plugins", this.getPluginsFromEntryEntity());
            int type = 0;
            if (currentPlugin.get(PLUGIN_TYPE_NAME) != null) {
                type = (Integer)currentPlugin.get(PLUGIN_TYPE_NAME);
            }
            switch (type) {
                case 4: {
                    if (!Plugin.enableRunKingScript()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5f00\u53d1\u5e73\u53f0\u672a\u542f\u7528\uff0c\u6682\u4e0d\u652f\u6301\u7f16\u8f91\u3002", (String)"PluginsPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    String id = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_ITEM_ID);
                    parameter.getOpenStyle().setShowType(ShowType.NewWindow);
                    parameter.setCustomParam("id", (Object)id);
                    parameter.setCustomParam("bizpagenumber", (Object)this.getFormId());
                    parameter.setCustomParam("bizPageId", (Object)this.getView().getFormShowParameter().getParentPageId());
                    parameter.setCustomParam("scripttypefilter", (Object)this.getScriptTypeFilter());
                    parameter.setFormId("ide_register_ts_plugin");
                    String serviceAppid = TSShowFormUtil.getTSEditerServiceAppid((String)((String)parameter.getCustomParam(ENTRY_BIZAPPID_NAME)), (String)((String)parameter.getCustomParam("bizpagenumber")));
                    parameter.setCustomParam("ServiceAppId", (Object)serviceAppid);
                    break;
                }
                default: {
                    parameter.setFormId("ide_registerplugin");
                }
            }
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_EDIT));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PluginsPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private Map<String, Object> getCurrentPlugin(int rowKey) {
        List<Map<String, Object>> plugins = this.getPluginsFromEntryEntity();
        return plugins.get(rowKey);
    }

    private List<Map<String, Object>> getPluginsFromEntryEntity() {
        ArrayList<Map<String, Object>> newPlugins = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
        int rowIndex = 0;
        for (DynamicObject obj : doc) {
            HashMap<String, Object> mapPlugin = new HashMap<String, Object>(16);
            mapPlugin.put(ROW_KEY_NAME, rowIndex++);
            mapPlugin.put(PLUGIN_ENABLE_NAME, obj.getBoolean(ENTRY_ENABLE_NAME));
            mapPlugin.put(PLUGIN_CLASS_NAME, obj.getString(ENTRY_CLASS_NAME));
            mapPlugin.put(PLUGIN_DESCRIPTION_NAME, obj.getString(ENTRY_DESCRIPTION_NAME));
            mapPlugin.put(PLUGIN_DISPLAYNAME_NAME, obj.getString(ENTRY_DISPLAYNAME_NAME));
            mapPlugin.put(PLUGIN_TYPE_NAME, obj.getInt(ENTRY_TYPE_NAME));
            mapPlugin.put(PLUGIN_FPK_NAME, obj.getString(ENTRY_FPK_NAME));
            mapPlugin.put(PLUGIN_BIZAPPID_NAME, obj.getString(ENTRY_BIZAPPID_NAME));
            newPlugins.add(mapPlugin);
        }
        return newPlugins;
    }

    private String getModelType() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if (StringUtils.isBlank((CharSequence)modelType) && StringUtils.isBlank((CharSequence)(modelType = (String)this.getView().getFormShowParameter().getCustomParam("formModelType")))) {
            PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
            modelType = propertyEditHelper.getModelType(this.getView());
        }
        return modelType;
    }

    private void register() {
        if (!this.check()) {
            return;
        }
        this.openPluginJavaClass(BTN_REGISTER);
    }

    private boolean check() {
        int count = this.getModel().getEntryRowCount(ENTRY_KEY);
        if (count >= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u63d2\u4ef6\u6709\u4e14\u53ea\u80fd\u6ce8\u518c\u4e00\u4e2a\u3002", (String)"ReportRegisterPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void openPluginJavaClass(String sCallBackFlag) {
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put("formId", "ide_registerplugin");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.setCustomParam("id", this.getView().getFormShowParameter().getCustomParam(PARAM_ITEM_ID));
        showParameter.setCustomParam("plugins", this.getPluginsFromEntryEntity());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sCallBackFlag));
        this.getView().showForm(showParameter);
    }

    private void registerTs() {
        if (!this.check()) {
            return;
        }
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParams().get(ENTRY_BIZAPPID_NAME);
        String id = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_ITEM_ID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.setFormId("ide_register_kingscript");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_REGISTERTS));
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam("bizpagenumber", (Object)this.getFormId());
        parameter.setCustomParam("bizPageId", (Object)this.getView().getFormShowParameter().getParentPageId());
        parameter.setCustomParam("modelType", (Object)modelType);
        parameter.setCustomParam("scripttypefilter", (Object)this.getScriptTypeFilter());
        parameter.setCustomParam("fromProFormDesigner", this.getView().getFormShowParameter().getCustomParam("fromProFormDesigner"));
        parameter.setCustomParam("isPC", this.getView().getFormShowParameter().getCustomParam("isPC"));
        parameter.setCustomParam("formApType", this.getView().getFormShowParameter().getCustomParam("_Type_"));
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            parameter.setCustomParam(ENTRY_BIZAPPID_NAME, (Object)bizAppId);
        }
        parameter.setCustomParam(VALUE, (Object)SerializationUtils.toJsonString(this.getPluginsFromEntryEntity()));
        this.getView().showForm(parameter);
    }

    private void openPluginJavaScript(String sCallBackFlag, String type) {
        if (!this.check()) {
            return;
        }
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        String scriptTypeFilter = this.getScriptTypeFilter();
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParams().get(ENTRY_BIZAPPID_NAME);
        String engineType = BTN_REGISTERTS.equals(type) ? "1" : "0";
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.getLocaleString((String)"\u9009\u62e9\u811a\u672c", (String)"PluginsPlugin_10", (String)BOS_DESIGNER_PLUGIN).getLocaleValue());
        parameter.setFormId("ide_register_ks_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sCallBackFlag));
        parameter.setCustomParam("bizpagenumber", (Object)this.getFormId());
        parameter.setCustomParam("bizPageId", (Object)this.getView().getFormShowParameter().getParentPageId());
        parameter.setCustomParam("engineType", (Object)engineType);
        if ("1".equals(engineType)) {
            parameter.setCustomParam("modelType", (Object)modelType);
        }
        parameter.setCustomParam("scripttypefilter", (Object)scriptTypeFilter);
        parameter.setCustomParam("fromProFormDesigner", this.getView().getFormShowParameter().getCustomParam("fromProFormDesigner"));
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            parameter.setCustomParam(ENTRY_BIZAPPID_NAME, (Object)bizAppId);
        }
        parameter.setCustomParam(VALUE, (Object)SerializationUtils.toJsonString(this.getPluginsFromEntryEntity()));
        parameter.setCustomParam("scriptmulti", (Object)false);
        this.getView().showForm(parameter);
    }

    private String getFormId() {
        String formId = null;
        PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
        IFormView designerView = propertyEditHelper.getDesignFormView(this.getView());
        if (designerView != null) {
            formId = (String)designerView.getFormShowParameter().getCustomParam("number");
        }
        if (StringUtils.isBlank(formId)) {
            formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        }
        if (StringUtils.isBlank(formId)) {
            formId = this.getView().getFormShowParameter().getParentFormId();
        }
        return formId;
    }

    private String getScriptTypeFilter() {
        return "ReportQueryPlugin";
    }
}

