/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.designer.property.report.ReportDesignerTool;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.util.JSONUtils;

public class SelectedFilterFieldEdit
extends AbstractFormPlugin
implements IBizRuleEditor {
    private static final String ALL_FIELD_GRID = "allfieldgrid";
    private static final String ALL_FIELD_KEY = "allfieldkey";
    private static final String ALL_FIELD = "allfield";
    private static final String SELECT_FIELD_GRID = "selectfieldgrid";
    private static final String SELECT_FIELD_KEY = "selectfieldkey";
    private static final String SELECT_FIELD = "selectfield";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnright", "btnleft", "btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if ("btnright".equals(key)) {
            EntryGrid allfieldgrid = (EntryGrid)this.getView().getControl(ALL_FIELD_GRID);
            IDataModel model = this.getModel();
            int[] selectRowIndexs = allfieldgrid.getEntryState().getSelectedRows();
            if (selectRowIndexs.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fc7\u6ee4\u5b57\u6bb5\u3002", (String)"SelectedFilterFieldEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
                return;
            }
            for (int rowIndex : selectRowIndexs) {
                Object fieldKey = model.getValue(ALL_FIELD_KEY, rowIndex);
                Object field = model.getValue(ALL_FIELD, rowIndex);
                int rowInd = model.createNewEntryRow(SELECT_FIELD_GRID);
                model.setValue(SELECT_FIELD_KEY, fieldKey, rowInd);
                model.setValue(SELECT_FIELD, field, rowInd);
            }
            model.deleteEntryRows(ALL_FIELD_GRID, selectRowIndexs);
        } else if ("btnleft".equals(key)) {
            EntryGrid selectfieldgrid = (EntryGrid)this.getView().getControl(SELECT_FIELD_GRID);
            IDataModel model = this.getModel();
            int[] selectRowIndexs = selectfieldgrid.getEntryState().getSelectedRows();
            if (selectRowIndexs.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u663e\u793a\u5b57\u6bb5\u3002", (String)"SelectedFilterFieldEdit_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
                return;
            }
            for (int rowIndex : selectRowIndexs) {
                Object fieldKey = model.getValue(SELECT_FIELD_KEY, rowIndex);
                Object field = model.getValue(SELECT_FIELD, rowIndex);
                int rowInd = model.createNewEntryRow(ALL_FIELD_GRID);
                model.setValue(ALL_FIELD_KEY, fieldKey, rowInd);
                model.setValue(ALL_FIELD, field, rowInd);
            }
            model.deleteEntryRows(SELECT_FIELD_GRID, selectRowIndexs);
        } else if ("btnok".equals(key)) {
            this.returnData();
        } else {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        List ctx = (List)showParam.getCustomParam("context");
        FormMetadata meta = FormMetadataUtil.getFormMetadata((List)ctx.get(0));
        meta.createIndex();
        List<ComboItem> filterFields = ReportDesignerTool.getFilterFieldItems(meta);
        try {
            Object value = showParam.getCustomParam("value");
            List selectedFields = null;
            if (!StringUtils.isBlank((Object)value)) {
                selectedFields = (List)JSONUtils.cast((String)((String)value), ArrayList.class, (Class[])new Class[]{String.class});
            }
            IDataModel model = this.getModel();
            for (ComboItem item : filterFields) {
                int rowIndex;
                if (selectedFields == null || !selectedFields.contains(item.getValue())) {
                    rowIndex = model.createNewEntryRow(ALL_FIELD_GRID);
                    model.setValue(ALL_FIELD_KEY, (Object)item.getValue(), rowIndex);
                    model.setValue(ALL_FIELD, (Object)item.getCaption(), rowIndex);
                    continue;
                }
                rowIndex = model.createNewEntryRow(SELECT_FIELD_GRID);
                model.setValue(SELECT_FIELD_KEY, (Object)item.getValue(), rowIndex);
                model.setValue(SELECT_FIELD, (Object)item.getCaption(), rowIndex);
            }
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void returnData() {
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        DynamicObjectCollection objColl = this.getModel().getEntryEntity(SELECT_FIELD_GRID);
        ArrayList<String> vals = new ArrayList<String>();
        for (DynamicObject obj : objColl) {
            vals.add(obj.getString(SELECT_FIELD_KEY));
        }
        try {
            para.put("value", JSONUtils.toString(vals));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public String getOutConfig() {
        return null;
    }
}

