/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.designer.property.report.DSEdit;
import kd.bos.designer.property.report.DSEditHelper;
import kd.bos.designer.property.report.DSField;
import kd.bos.designer.property.report.DSTypeEdit;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.JSONUtils;

public class SortDSEdit
extends DSEdit {
    private static final String SELECTENTRY = "selectentry";
    private static final String SORTENTRY = "orderentry";
    private static final String QUERY_FIELD = "queryfield";
    private static final String FIELD_KEY = "fieldKey";
    private static final String FIELD_NAME = "fieldname";
    private static final String DISPLAY_NAME = "displayname";
    private static final String NUMBER = "number";

    public void initialize() {
        super.initialize();
        this.addListener();
        this.initDSCombo();
    }

    protected void addListener() {
        this.addItemClickListeners(new String[]{"selectbar", "sortbar"});
        EntryGrid grid = (EntryGrid)this.getControl(SELECTENTRY);
        grid.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent evt) {
                String fieldKey = evt.getFieldKey();
                if (fieldKey.equals(SortDSEdit.QUERY_FIELD)) {
                    SortDSEdit.this.showSelectEdit(fieldKey, evt.getRow());
                }
            }

            public void cellDoubleClick(CellClickEvent ev) {
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("importsf".equals(key) || "importof".equals(key)) {
            this.importField(key);
        } else if ("addnew".equals(key)) {
            this.getModel().createNewEntryRow(SELECTENTRY);
        } else if ("deletesf".equals(key)) {
            this.deleteRow(SELECTENTRY);
        } else if ("deleteof".equals(key)) {
            this.deleteRow(SORTENTRY);
        }
    }

    @Override
    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String data = (String)showParameter.getCustomParam("dsdata");
        MainEntityType entityType = this.getModel().getDataEntityType();
        if (data != null) {
            DynamicObject obj = DSEditHelper.toDynamicObject(data, entityType);
            BusinessDataReader.loadRefence((Object[])new DynamicObject[]{obj}, (IDataEntityType)entityType);
            e.setDataEntity((Object)obj);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (!"ide_sortds".equals(evt.getActionId()) || !(evt.getReturnData() instanceof Map)) {
            return;
        }
        Map ret = (Map)evt.getReturnData();
        if (ret.get("SortDS") instanceof List) {
            String key = (String)ret.get("funckey");
            List fieldList = (List)ret.get("SortDS");
            if ("importsf".equals(key)) {
                this.importSelectFileds(fieldList);
            } else if ("importof".equals(key)) {
                this.importOrderFileds(fieldList);
            }
        } else if (((String)ret.get(FIELD_KEY)).equals(QUERY_FIELD)) {
            int rowIndex = (Integer)ret.get("rowIndex");
            String fieldKey = (String)ret.get(FIELD_KEY);
            String value = (String)ret.get("value");
            this.getModel().setValue(fieldKey, (Object)value, rowIndex);
        }
    }

    private void importSelectFileds(List<DSField> fieldList) {
        IDataModel model = this.getModel();
        for (DSField field : fieldList) {
            int rowIndex = model.createNewEntryRow(SELECTENTRY);
            model.setValue(QUERY_FIELD, (Object)field.getFieldKey(), rowIndex);
            model.setValue(FIELD_NAME, (Object)field.getFieldKey(), rowIndex);
            model.setValue(DISPLAY_NAME, (Object)field.getFieldName(), rowIndex);
            model.setValue("datatype", (Object)field.getDataType(), rowIndex);
        }
    }

    private void importOrderFileds(List<DSField> fieldList) {
        IDataModel model = this.getModel();
        for (DSField field : fieldList) {
            int rowIndex = model.createNewEntryRow(SORTENTRY);
            model.setValue("orderfield", (Object)field.getFieldKey(), rowIndex);
            model.setValue("orderfieldname", (Object)field.getFieldName(), rowIndex);
        }
    }

    private void initDSCombo() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List dsList = (List)parameter.getCustomParam("ds");
        ComboEdit dsEdit = (ComboEdit)this.getControl("ds");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (Map ds : dsList) {
            ComboItem it = new ComboItem();
            it.setValue((String)ds.get(NUMBER));
            it.setCaption(new LocaleString((String)ds.get("name")));
            items.add(it);
        }
        dsEdit.setComboItems(items);
    }

    private void importField(String key) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List dsList = (List)showParameter.getCustomParam("ds");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_selectfield");
        parameter.setCustomParam("dsType", (Object)"4");
        parameter.setCustomParam("funckey", (Object)key);
        IDataModel model = this.getModel();
        Object sortDS = model.getValue("ds");
        for (Map ds : dsList) {
            String dsnumber = (String)ds.get(NUMBER);
            if (!dsnumber.equals(sortDS)) continue;
            parameter.setCustomParam("data", ds.get("data"));
            parameter.setCustomParam("type", ds.get("type"));
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }

    private void deleteRow(String entry) {
        IDataModel model = this.getModel();
        EntryGrid dsentry = (EntryGrid)this.getControl(entry);
        int[] rowIndexs = dsentry.getEntryState().getSelectedRows();
        if (rowIndexs != null && rowIndexs.length > 0) {
            model.deleteEntryRows(entry, rowIndexs);
        }
    }

    private void showSelectEdit(String fieldKey, int rowIndex) {
        IDataModel model = this.getModel();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_fieldedit");
        parameter.setCustomParam("rowIndex", (Object)rowIndex);
        parameter.setCustomParam(FIELD_KEY, (Object)fieldKey);
        parameter.setCustomParam("value", model.getValue(fieldKey, rowIndex));
        try {
            String dsNumber = (String)model.getValue("ds");
            Map<String, String> ds = this.getDS(dsNumber);
            TreeNode root = this.buildTree(ds);
            parameter.setCustomParam("treeNode", (Object)JSONUtils.toString((Object)root));
            TreeNode currDS = this.buildCurrDSFieldTree();
            parameter.setCustomParam("currDS", (Object)JSONUtils.toString((Object)currDS));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
            this.getView().showForm(parameter);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private Map<String, String> getDS(String dsNumber) {
        if (dsNumber == null) {
            return new HashMap<String, String>();
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List dsList = (List)showParameter.getCustomParam("ds");
        for (Map ds : dsList) {
            if (!((String)ds.get(NUMBER)).equals(dsNumber)) continue;
            return ds;
        }
        return new HashMap<String, String>();
    }

    private TreeNode buildTree(Map<String, String> ds) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)DSTypeEdit.getEntityId(ds.get("type")));
        DynamicObject data = DSEditHelper.toDynamicObject(ds.get("data"), type);
        DynamicObjectCollection selectEntry = data.getDynamicObjectCollection(SELECTENTRY);
        TreeNode dsNode = new TreeNode();
        dsNode.setId(data.getString(NUMBER));
        dsNode.setText(data.getString("name"));
        dsNode.setIsOpened(true);
        for (DynamicObject sel : selectEntry) {
            TreeNode node = new TreeNode();
            node.setId(sel.getString(FIELD_NAME));
            node.setText(sel.getString(DISPLAY_NAME));
            node.setParentid(dsNode.getId());
            dsNode.addChild(node);
        }
        return dsNode;
    }

    private TreeNode buildCurrDSFieldTree() {
        IDataModel model = this.getModel();
        DynamicObjectCollection fields = model.getEntryEntity(SELECTENTRY);
        TreeNode thisNode = new TreeNode();
        thisNode.setId((String)model.getValue(NUMBER));
        thisNode.setText((String)model.getValue("name"));
        for (DynamicObject f : fields) {
            TreeNode node = new TreeNode();
            node.setId(f.getString(FIELD_NAME));
            node.setText(f.getString(DISPLAY_NAME));
            node.setParentid(thisNode.getId());
            thisNode.addChild(node);
        }
        thisNode.setIsOpened(true);
        return thisNode;
    }
}

