/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.designer.property.report.DSEdit;
import kd.bos.designer.property.report.DSEditHelper;
import kd.bos.designer.property.report.DSEntity;
import kd.bos.designer.property.report.DSField;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class UnionDSEdit
extends DSEdit {
    private static final String SELECTEDDSROWINDEX = "currSelecteddsRowIndex";
    private static final String SELECTENTRY = "selectentry";
    private static final String SORTENTRY = "orderentry";
    private static final String DSENTRY = "dsentry";
    private static final String IMPORT_SF = "importsf";
    private static final String IMPORT_OF = "importof";
    private static final String QUERY_FIELD = "queryfield";
    private static final String FUNC_KEY = "funckey";
    private static final String FIELD_KEY = "fieldKey";
    private static final String ROW_INDEX = "rowIndex";
    private static final String VALUE = "value";
    private static final String TREE_NODE = "treeNode";
    private static final String FIELD_NAME = "fieldname";
    private static final String DS_DATA = "dsdata";
    private static final String NUMBER = "number";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"selectbar", "sortbar", "dsopp"});
        this.initSelectEntryGrid();
        this.initDSEntryGrid();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (IMPORT_SF.equals(key)) {
            this.importSelectField();
        } else if (IMPORT_OF.equals(key)) {
            this.importSortField();
        } else if ("addnew".equals(key)) {
            this.getModel().createNewEntryRow(SELECTENTRY);
        } else if ("delete".equals(key)) {
            this.deleteRow(SELECTENTRY);
        } else if ("addnewds".equals(key)) {
            this.getModel().createNewEntryRow(DSENTRY);
        } else if ("deleteds".equals(key)) {
            this.deleteRow(DSENTRY);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        if (model.getEntryRowCount(DSENTRY) > 0) {
            this.loadDSData(model, 0);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        if (model.getEntryRowCount(DSENTRY) > 0) {
            EntryGrid dsGrid = (EntryGrid)this.getControl(DSENTRY);
            dsGrid.selectRows(0);
            this.getPageCache().put(SELECTEDDSROWINDEX, "0");
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        IDataModel model = this.getModel();
        String currSelecteddsRowIndex = this.getPageCache().get(SELECTEDDSROWINDEX);
        if (!StringUtils.isEmpty((String)currSelecteddsRowIndex)) {
            int selectedRowIndex = Integer.parseInt(currSelecteddsRowIndex);
            this.saveDSData(model, selectedRowIndex);
        }
        int rowCount = model.getEntryRowCount(SELECTENTRY);
        for (int i = 0; i < rowCount; ++i) {
            model.setValue(QUERY_FIELD, null, i);
        }
        super.beforeClosed(e);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (!"ide_unionds".equals(evt.getActionId()) || !(evt.getReturnData() instanceof Map)) {
            return;
        }
        Map ret = (Map)evt.getReturnData();
        String key = (String)ret.get(FUNC_KEY);
        if (IMPORT_SF.equals(key)) {
            this.importQueryDS((List)ret.get("ds"));
        } else if (IMPORT_OF.equals(key)) {
            List ds = (List)ret.get("ds");
            if (ds != null && !ds.isEmpty()) {
                this.importOrderFileds((DSEntity)ds.get(0));
            }
        } else if (QUERY_FIELD.equals(ret.get(FIELD_KEY)) || "condition".equals(ret.get(FIELD_KEY))) {
            int rowIndex = (Integer)ret.get(ROW_INDEX);
            String fieldKey = (String)ret.get(FIELD_KEY);
            String value = (String)ret.get(VALUE);
            this.getModel().setValue(fieldKey, (Object)value, rowIndex);
        }
    }

    private void initSelectEntryGrid() {
        EntryGrid sgrid = (EntryGrid)this.getControl(SELECTENTRY);
        sgrid.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent evt) {
                String fieldKey = evt.getFieldKey();
                if (fieldKey.equals(UnionDSEdit.QUERY_FIELD)) {
                    UnionDSEdit.this.showSelectEdit(fieldKey, evt.getRow());
                }
            }

            public void cellDoubleClick(CellClickEvent ev) {
            }
        });
    }

    private void initDSEntryGrid() {
        EntryGrid dsGrid = (EntryGrid)this.getControl(DSENTRY);
        for (Control ctrl : dsGrid.getItems()) {
            if (!ctrl.getKey().equals("ds")) continue;
            ComboEdit editor = (ComboEdit)ctrl;
            editor.setComboItems(this.getDSList());
        }
        this.addDSEntryRowClickListener(dsGrid);
        this.addDSEntryCellClickListener(dsGrid);
    }

    private void addDSEntryRowClickListener(EntryGrid dsGrid) {
        dsGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                IDataModel model = UnionDSEdit.this.getModel();
                String currSelecteddsRowIndex = UnionDSEdit.this.getPageCache().get(UnionDSEdit.SELECTEDDSROWINDEX);
                if (!StringUtils.isEmpty((String)currSelecteddsRowIndex)) {
                    int selectedRowIndex = Integer.parseInt(currSelecteddsRowIndex);
                    UnionDSEdit.this.saveDSData(model, selectedRowIndex);
                }
                int rowIndex = evt.getRow();
                UnionDSEdit.this.loadDSData(model, rowIndex);
                UnionDSEdit.this.getPageCache().put(UnionDSEdit.SELECTEDDSROWINDEX, rowIndex + "");
            }
        });
    }

    private void addDSEntryCellClickListener(EntryGrid dsGrid) {
        dsGrid.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent e) {
                String fieldKey = e.getFieldKey();
                int row = e.getRow();
                if (row >= 0 && "condition".equals(fieldKey)) {
                    UnionDSEdit.this.showDSCondEdit(fieldKey, row);
                }
            }

            public void cellDoubleClick(CellClickEvent arg0) {
            }
        });
    }

    private void showDSCondEdit(String fieldKey, int rowIndex) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_formula");
        parameter.setCustomParam(FIELD_KEY, (Object)fieldKey);
        parameter.setCustomParam(ROW_INDEX, (Object)rowIndex);
        parameter.setCustomParam(VALUE, this.getModel().getValue(fieldKey, rowIndex));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("hideRootNode", (Object)Boolean.TRUE.toString());
        parameter.setCustomParam(TREE_NODE, this.getView().getFormShowParameter().getCustomParam("filterFieldTree"));
        Object metaType = this.getView().getFormShowParameter().getCustomParams().get("metaType");
        parameter.setCustomParam("metaType", metaType);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }

    private void saveDSData(IDataModel model, int selectedRowIndex) {
        DynamicObjectCollection dsEntryColl = model.getEntryEntity(SELECTENTRY);
        HashMap<String, String> data = new HashMap<String, String>(16);
        for (DynamicObject obj : dsEntryColl) {
            String fieldName = obj.getString(FIELD_NAME);
            data.put(fieldName, obj.getString(QUERY_FIELD));
        }
        try {
            if (model.getEntryRowCount(DSENTRY) > 0) {
                model.setValue(DS_DATA, (Object)JSONUtils.toString(data), selectedRowIndex);
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private void loadDSData(IDataModel model, int rowIndex) {
        String dsData = (String)model.getValue(DS_DATA, rowIndex);
        Map ndsEntry = null;
        if (!StringUtils.isEmpty((String)dsData)) {
            try {
                ndsEntry = (Map)JSONUtils.cast((String)dsData, HashMap.class);
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        int rowCount = model.getEntryRowCount(SELECTENTRY);
        for (int i = 0; i < rowCount; ++i) {
            String queryfield = null;
            if (ndsEntry != null) {
                String fieldName = (String)model.getValue(FIELD_NAME, i);
                queryfield = (String)ndsEntry.get(fieldName);
            }
            model.setValue(QUERY_FIELD, queryfield, i);
        }
    }

    private void showSelectEdit(String fieldKey, int rowIndex) {
        EntryGrid sgrid = (EntryGrid)this.getControl(DSENTRY);
        int index = sgrid.getEntryState().getFocusRow();
        if (index == -1) {
            return;
        }
        IDataModel model = this.getModel();
        try {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_formula");
            parameter.setCustomParam(ROW_INDEX, (Object)rowIndex);
            parameter.setCustomParam(FIELD_KEY, (Object)fieldKey);
            parameter.setCustomParam(VALUE, model.getValue(fieldKey, rowIndex));
            String dsNumber = (String)model.getValue("ds", index);
            TreeNode root = DSEditHelper.getFieldTree(this.getView(), dsNumber);
            parameter.setCustomParam(TREE_NODE, (Object)JSONUtils.toString((Object)root));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
            this.getView().showForm(parameter);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private TreeNode buildCurrDSFieldTree() {
        IDataModel model = this.getModel();
        DynamicObjectCollection fields = model.getEntryEntity(SELECTENTRY);
        TreeNode thisNode = new TreeNode();
        thisNode.setId((String)model.getValue(NUMBER));
        thisNode.setText((String)model.getValue("name"));
        for (DynamicObject f : fields) {
            TreeNode node = new TreeNode();
            node.setId(f.getString(FIELD_NAME));
            node.setText(f.getString("displayname"));
            node.setParentid(thisNode.getId());
            thisNode.addChild(node);
        }
        thisNode.setIsOpened(true);
        return thisNode;
    }

    private void importSelectField() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_selectfield");
        parameter.setCustomParam("dsType", (Object)"3");
        parameter.setCustomParam(FUNC_KEY, (Object)IMPORT_SF);
        List dsList = (List)showParameter.getCustomParam("ds");
        ArrayList<Map> dss = new ArrayList<Map>();
        EntryGrid dsGrid = (EntryGrid)this.getControl(DSENTRY);
        int currRow = dsGrid.getEntryState().getFocusRow();
        String dsNumber = (String)this.getModel().getValue("ds", currRow);
        for (Map ds : dsList) {
            if (!((String)ds.get(NUMBER)).equals(dsNumber)) continue;
            dss.add(ds);
            break;
        }
        parameter.setCustomParam("ds", dss);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }

    private List<ComboItem> getDSList() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List dsList = (List)showParameter.getCustomParam("ds");
        String data = (String)showParameter.getCustomParam(DS_DATA);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (!StringUtils.isEmpty((String)data)) {
            DynamicObject obj = DSEditHelper.toDynamicObject(data, this.getModel().getDataEntityType());
            String number = obj.getString(NUMBER);
            for (Map ds : dsList) {
                if (((String)ds.get(NUMBER)).equals(number)) continue;
                ComboItem item = new ComboItem();
                item.setValue((String)ds.get(NUMBER));
                item.setCaption(new LocaleString((String)ds.get("name")));
                items.add(item);
            }
        }
        return items;
    }

    private void importSortField() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_selectfield");
        parameter.setCustomParam("dsType", (Object)"3");
        parameter.setCustomParam(FUNC_KEY, (Object)IMPORT_OF);
        try {
            parameter.setCustomParam(TREE_NODE, (Object)JSONUtils.toString((Object)this.buildCurrDSFieldTree()));
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
        this.getView().showForm(parameter);
    }

    private void deleteRow(String entry) {
        IDataModel model = this.getModel();
        EntryGrid dsentry = (EntryGrid)this.getControl(entry);
        int[] rowIndexs = dsentry.getEntryState().getSelectedRows();
        if (rowIndexs != null && rowIndexs.length > 0 && model.getEntryRowCount(entry) > 0) {
            model.deleteEntryRows(entry, rowIndexs);
        }
    }

    private void importQueryDS(List<DSField> fieldList) {
        if (fieldList.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(SELECTENTRY);
        for (DSField field : fieldList) {
            int rowIndex;
            boolean exist = false;
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                String fieldName = (String)model.getValue(FIELD_NAME, rowIndex);
                if (!fieldName.equals(field.getFieldKey())) continue;
                exist = true;
                break;
            }
            if (!exist) {
                rowIndex = model.createNewEntryRow(SELECTENTRY);
                model.setValue(FIELD_NAME, (Object)field.getFieldKey(), rowIndex);
                model.setValue("displayname", (Object)field.getFieldName(), rowIndex);
                model.setValue("datatype", (Object)field.getDataType(), rowIndex);
            }
            model.setValue(QUERY_FIELD, (Object)field.getFieldKey(), rowIndex);
        }
    }

    private void importOrderFileds(DSEntity ds) {
        IDataModel model = this.getModel();
        for (DSField field : ds.getFields()) {
            int rowIndex = model.createNewEntryRow(SORTENTRY);
            model.setValue("orderfield", (Object)field.getFieldKey(), rowIndex);
            model.setValue("orderfieldname", (Object)field.getFieldName(), rowIndex);
        }
    }
}

