/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.validrule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.decode.DecodeHandlerFactory;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.func.FuncSettingHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.validation.AbstractValidationParamPlugin;
import kd.bos.metadata.entity.validation.ConditionValidation;

public class ValidateOptPlugin
extends AbstractValidationParamPlugin<ConditionValidation>
implements TreeNodeClickListener,
ClickListener {
    static final String KEY_TREENODE = "ffieldtree";
    static final String KEY_EXPRESSIONTEXT = "fexpression";
    static final String KEY_BTNFUNCTION = "btnfunction";
    static final String KEY_ENTITYKEY = "entitykey";
    static final String KEY_EXPRESSION = "fexpression";
    static final String KEY_TRUETHROW = "ftruethrow";
    static final String KEY_KEYWORD = "fkeyword";
    static final String KEY_MESSAGE = "fmessage";
    static final String ENTITY_AUTO = "@auto";
    static final String ENTITY_BILLHEAD = "billhead";
    private static final Map<String, String> KEYBOARD = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("btnplus", "+");
            this.put("btnminus", "-");
            this.put("btnmultiply", "*");
            this.put("btndivide", "/");
            this.put("btnequal", "=");
            this.put("btnlessthan", "<");
            this.put("btnlessequal", "<=");
            this.put("btnleftbracket", "(");
            this.put("btngreatethan", ">");
            this.put("btngreateequal", ">=");
            this.put("btnnotequal", "<>");
            this.put("btnrightbracket", ")");
            this.put("btnand", "AND");
            this.put("btnin", "IN");
            this.put("btnnotin", "NOT IN");
            this.put("btnnot", "NOT");
            this.put("btnlike", "LIKE");
            this.put("btnnotlike", "NOT LIKE");
            this.put("btnor", "OR");
        }
    };
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void initialize() {
        TreeView fieldTree = (TreeView)this.getView().getControl("FFieldTree");
        fieldTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Button btn = (Button)this.getView().getControl("BtnPlus");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnMinus");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnMultiply");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnDivide");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnEqual");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnLessThan");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnLessEqual");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnLeftBracket");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnGreateThan");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnGreateEqual");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnNotEqual");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnRightBracket");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnAnd");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnIn");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnNotIn");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnNot");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnLike");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnNotLike");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnOr");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnClr");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("BtnBackspace");
        btn.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{KEY_BTNFUNCTION});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeView tree = (TreeView)this.getControl(KEY_TREENODE);
        TreeNode root = this.buildFieldTree();
        this.handleMuliBasedata(root);
        tree.addNode(root);
        this.fillEntityKeyItems();
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        DecodeHandlerFactory.sendValidatorEncodingElements((String)"fexpression", (IClientViewProxy)clientViewProxy);
    }

    public void click(EventObject evt) {
        String key;
        IDataModel model = this.getModel();
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnclr": {
                model.setValue("fexpression", (Object)"");
                FormulaEditHelper.setCursorIndex(this.getView(), "fexpression", 0);
                break;
            }
            case "btnbackspace": {
                FormulaEditHelper.backSpaceExpression(this.getView(), key, "fexpression");
                break;
            }
            case "btnfunction": {
                this.showFuncSetting();
                break;
            }
            default: {
                FormulaEditHelper.insertExpression(this.getView(), key, "fexpression", KEYBOARD.get(key));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)KEY_BTNFUNCTION)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            this.receiveFuncSetting((String)closedCallBackEvent.getReturnData());
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (StringUtils.isNotBlank((Object)evt.getParentNodeId())) {
            TreeNode root = this.loadCacheTreeNode();
            TreeNode currNode = root.getTreeNode((String)evt.getNodeId(), Integer.MAX_VALUE);
            Control source = (Control)evt.getSource();
            FormulaEditHelper.insertExpression(this.getView(), source.getKey(), "fexpression", currNode.getId());
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent arg0) {
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String type = this.getView().getFormShowParameter().getFormConfig().getKdEncoding();
        e.setValue((Object)DecodeHandlerFactory.getDecodeHandler((String)type).decode(e.getValue().toString()));
        super.beforeFieldPostBack(e);
    }

    public boolean checkValidation(StringBuilder msgBuilder) {
        if (StringUtils.isNotBlank((Object)this.getModel().getValue("fexpression"))) {
            return true;
        }
        msgBuilder.append(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ValidateOptPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        return false;
    }

    protected void returnValidation(ConditionValidation v) {
        IDataModel model = this.getModel();
        v.setExpression(model.getValue("fexpression"));
        v.setTrueThrow(model.getValue(KEY_TRUETHROW));
        String messge = (String)model.getValue(KEY_MESSAGE);
        if (v.getMessage() == null) {
            v.setMessage(new LocaleString(Lang.get().toString(), messge));
        } else {
            v.getMessage().setItem(Lang.get().toString(), (Object)messge);
        }
        String entityKey = this.getEntityKey();
        if (StringUtils.equals((CharSequence)entityKey, (CharSequence)ENTITY_AUTO)) {
            v.setEntityKey(null);
        } else {
            v.setEntityKey(entityKey);
        }
    }

    protected void showValidation(ConditionValidation v) {
        IDataModel model = this.getModel();
        model.setValue("fexpression", (Object)v.getExpression());
        model.setValue(KEY_TRUETHROW, (Object)v.isTrueThrow());
        model.setValue(KEY_MESSAGE, v.getMessage() == null ? null : v.getMessage().toString());
        this.setEntityKey(StringUtils.isBlank((CharSequence)v.getEntityKey()) ? ENTITY_AUTO : v.getEntityKey());
    }

    protected ConditionValidation getNewValidation() {
        return new ConditionValidation();
    }

    protected IDataEntityType getValidateElementType() {
        return DataEntityType.getDataEntityType(ConditionValidation.class);
    }

    private void showFuncSetting() {
        FunctionTypes functionTypes = FunctionTypes.get();
        TreeNode root = this.loadCacheTreeNode();
        List entityItems = this.getDesignItems();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_BTNFUNCTION);
        FuncSettingHelper.show((FunctionTypes)functionTypes, (List)entityItems, (TreeNode)root, null, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void receiveFuncSetting(String funcSetting) {
        if (StringUtils.isBlank((CharSequence)funcSetting)) {
            return;
        }
        FormulaEditHelper.insertExpression(this.getView(), KEY_BTNFUNCTION, "fexpression", funcSetting);
    }

    private String getEntityKey() {
        if (this.getModel().getProperty(KEY_ENTITYKEY) == null) {
            return ENTITY_AUTO;
        }
        return (String)this.getModel().getValue(KEY_ENTITYKEY);
    }

    private void setEntityKey(String entityKey) {
        if (this.getModel().getProperty(KEY_ENTITYKEY) == null) {
            return;
        }
        this.getModel().setValue(KEY_ENTITYKEY, (Object)entityKey);
    }

    private void fillEntityKeyItems() {
        if (this.getModel().getProperty(KEY_ENTITYKEY) == null) {
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem autoItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8", (String)"ValidateOptPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), ENTITY_AUTO);
        items.add(autoItem);
        List entityItems = this.getDesignItems();
        EntityMetadata metadata = EntityMetadataUtil.getEntityMetadata((List)entityItems);
        for (Entity entity : metadata.getEntitys()) {
            if (entity instanceof MainEntity) {
                ComboItem headItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ValidateOptPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), ENTITY_BILLHEAD);
                items.add(headItem);
                continue;
            }
            ComboItem entryItem = new ComboItem(entity.getName(), entity.getKey());
            items.add(entryItem);
        }
        ComboEdit edit = (ComboEdit)this.getView().getControl(KEY_ENTITYKEY);
        edit.setComboItems(items);
    }

    private void handleMuliBasedata(TreeNode root) {
        ArrayList<String> ids = new ArrayList<String>(10);
        this.findIdNode(root, ids);
        for (String id : ids) {
            root.deleteChildNode(id);
        }
    }

    private void findIdNode(TreeNode root, List<String> ids) {
        List childrenNode = root.getChildren();
        if (!CollectionUtils.isEmpty((Collection)childrenNode)) {
            if ("MulBasedataField".equals(root.getType())) {
                for (TreeNode treeNode : childrenNode) {
                    String IdStr = treeNode.getId();
                    String[] nameStr = IdStr.split("\\.");
                    if (!"id".equals(nameStr[1])) continue;
                    ids.add(IdStr);
                }
            }
            for (TreeNode treeNode : childrenNode) {
                this.findIdNode(treeNode, ids);
            }
        }
    }
}

