/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.CityProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.report.queryds.ReportFilterField;
import kd.bos.entity.report.queryds.ReportFilterFieldConfig;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BillTypeField;
import kd.bos.metadata.entity.businessfield.CityField;
import kd.bos.metadata.entity.businessfield.CurrencyField;
import kd.bos.metadata.entity.businessfield.ItemClassField;
import kd.bos.metadata.entity.businessfield.MaterielField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.PriceField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.businessfield.UnitField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.report.QueryDataSource;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;

public class FilterFieldConfigPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_CONTROL_KEY = "fieldcontrolkey";
    private static final String FIELD_CONTROL_KEY_NAME = "fieldcontrolkeyname";
    private static final String COMPARE_TYPE_ID = "comparetypeid";
    private static final String DATASOURCE_ID = "datasourceid";
    private static final String FILTER_FIELD = "filterfield";
    private static final String COMPARE_TYPE_NAME = "comparetypename";
    private static final String DATASOURCE_NAME = "datasourcename";
    private static final String FILTER_FIELD_NAME = "filterfieldname";
    private static final String BTN_OK = "btnok";
    private static final String CONTEXT = "context";
    private static final String ROW_INDEX = "rowIndex";
    private static final String SELECT_ID = "selectId";
    private static final String SELECT_VALUE = "selectValue";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String IDE_RPT_COMBO = "ide_rpt_combo";
    private static final String COMBO_ITEMS = "comboItems";
    private List<ComboItem> dataSourceList = new ArrayList<ComboItem>();
    private List<ComboItem> controlKeylist = new ArrayList<ComboItem>();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, COMPARE_TYPE_NAME, DATASOURCE_NAME, FILTER_FIELD_NAME});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.returnData();
                break;
            }
            case "comparetypename": {
                this.showCompareTypeForm(evt);
                break;
            }
            case "datasourcename": {
                this.showDataSourceForm(evt);
                break;
            }
            case "filterfieldname": {
                this.showDataSourceFieldForm(evt);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        String controlKey = e.getProperty().getName();
        boolean hasChangeData = changeData != null && changeData.length > 0;
        IDataModel model = this.getModel();
        if (DATASOURCE_NAME.equals(controlKey) && hasChangeData) {
            int rowIndex = changeData[0].getRowIndex();
            model.setValue(FILTER_FIELD, null, rowIndex);
            model.setValue(FILTER_FIELD_NAME, null, rowIndex);
        } else if (FILTER_FIELD_NAME.equals(controlKey) && hasChangeData) {
            for (ChangeData row : changeData) {
                if (!StringUtils.isBlank((Object)row.getNewValue())) continue;
                model.setValue(FILTER_FIELD, null, row.getRowIndex());
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParam("value");
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context == null || context.size() < 3) {
            return;
        }
        List list = (List)context.get(2);
        this.initDataSourceCombo(list);
        if (this.dataSourceList.isEmpty()) {
            return;
        }
        FormMetadata formMetadata = FormMetadataUtil.getFormMetadata((List)context.get(0));
        EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata((List)((List)context.get(1)));
        this.initfilterFieldControls(formMetadata);
        IDataModel model = this.getModel();
        if (value == null) {
            for (int i = 0; i < this.controlKeylist.size(); ++i) {
                Object fieldProp;
                ComboItem item = this.controlKeylist.get(i);
                String key = item.getId();
                if (entityMetadata.getFieldByKey(key) instanceof RadioField || (fieldProp = this.getFieldProp(key, entityMetadata)) instanceof FlexProp) continue;
                int rowIndex = model.createNewEntryRow(ENTRY_ENTITY);
                model.setValue(FIELD_CONTROL_KEY_NAME, (Object)item.getCaption(), rowIndex);
                model.setValue(FIELD_CONTROL_KEY, (Object)key, rowIndex);
                this.initDefaultCompareType(key, rowIndex, fieldProp);
                if (this.dataSourceList == null || this.dataSourceList.size() <= 0) continue;
                model.setValue(DATASOURCE_NAME, (Object)this.dataSourceList.get(0).getCaption(), rowIndex);
                model.setValue(DATASOURCE_ID, (Object)this.dataSourceList.get(0).getId(), rowIndex);
                this.initDefaultDataSourceField(this.dataSourceList.get(0).getId(), rowIndex, key, entityMetadata);
            }
        } else {
            ReportFilterFieldConfig reportFilterFieldConfig = this.deSerializeReportFilterFieldConfig(value.toString());
            for (int i = 0; i < this.controlKeylist.size(); ++i) {
                Object fieldProp;
                ComboItem item = this.controlKeylist.get(i);
                String key = item.getId();
                if (entityMetadata.getFieldByKey(key) instanceof RadioField || (fieldProp = this.getFieldProp(key, entityMetadata)) instanceof FlexProp) continue;
                int rowIndex = model.createNewEntryRow(ENTRY_ENTITY);
                model.setValue(FIELD_CONTROL_KEY_NAME, (Object)item.getCaption(), rowIndex);
                model.setValue(FIELD_CONTROL_KEY, (Object)key, rowIndex);
                boolean isNewControlKey = true;
                for (int j = 0; j < reportFilterFieldConfig.getReportFilterFields().size(); ++j) {
                    ReportFilterField reportFilterField = (ReportFilterField)reportFilterFieldConfig.getReportFilterFields().get(j);
                    if (!key.equals(reportFilterField.getKey())) continue;
                    isNewControlKey = false;
                    boolean isExsit = this.isExsit(reportFilterField, key, entityMetadata);
                    if (!isExsit) break;
                    model.setValue(COMPARE_TYPE_ID, (Object)reportFilterField.getCompareTypeId(), rowIndex);
                    model.setValue(COMPARE_TYPE_NAME, (Object)reportFilterField.getCompareTypeCaption(), rowIndex);
                    model.setValue(DATASOURCE_ID, (Object)reportFilterField.getDataSourceId(), rowIndex);
                    model.setValue(DATASOURCE_NAME, (Object)reportFilterField.getDataSourceCaption(), rowIndex);
                    model.setValue(FILTER_FIELD, (Object)reportFilterField.getFieldName(), rowIndex);
                    model.setValue(FILTER_FIELD_NAME, (Object)reportFilterField.getFieldCaption(), rowIndex);
                    break;
                }
                if (!isNewControlKey) continue;
                this.initDefaultCompareType(key, rowIndex, fieldProp);
                if (this.dataSourceList == null || this.dataSourceList.size() <= 0) continue;
                model.setValue(DATASOURCE_NAME, (Object)this.dataSourceList.get(0).getCaption(), rowIndex);
                model.setValue(DATASOURCE_ID, (Object)this.dataSourceList.get(0).getId(), rowIndex);
                this.initDefaultDataSourceField(this.dataSourceList.get(0).getId(), rowIndex, key, entityMetadata);
            }
        }
    }

    private boolean isExsit(ReportFilterField reportFilterField, String key, EntityMetadata entityMetadata) {
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context == null || context.size() < 3) {
            return false;
        }
        long count = 0L;
        Object fieldProp = this.getFieldProp(key, entityMetadata);
        if (fieldProp instanceof IFieldHandle) {
            String compareGroupId = ((IFieldHandle)fieldProp).getCompareGroupID();
            List compareTypes = FilterMetadata.get().getCompareTypes(compareGroupId);
            count = compareTypes.stream().filter(c -> c.getId().equals(reportFilterField.getCompareTypeId())).count();
            if (count == 0L) {
                return false;
            }
        }
        if ((count = this.dataSourceList.stream().filter(s -> s.getId().equals(reportFilterField.getDataSourceId())).count()) == 0L) {
            return false;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)reportFilterField.getDataSourceId());
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        ArrayList<IDataEntityProperty> allProperties = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty dtProp : properties) {
            this.addProperty(dtProp, allProperties);
        }
        for (IDataEntityProperty dtProp : allProperties) {
            String filedName = dtProp.getName();
            if (dtProp.getParent() instanceof EntryType) {
                filedName = dtProp.getParent().getName() + "." + dtProp.getName();
            }
            if (!filedName.equals(reportFilterField.getFieldName())) continue;
            return true;
        }
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            int rowIndex = (Integer)map.get(ROW_INDEX);
            IDataModel model = this.getModel();
            if (closedCallBackEvent.getActionId().equalsIgnoreCase("comparetypecloseback")) {
                model.setValue(COMPARE_TYPE_ID, map.get(SELECT_ID), rowIndex);
                model.setValue(COMPARE_TYPE_NAME, map.get(SELECT_VALUE), rowIndex);
            } else if (closedCallBackEvent.getActionId().equalsIgnoreCase("datasourcecloseback")) {
                model.setValue(DATASOURCE_ID, map.get(SELECT_ID), rowIndex);
                model.setValue(DATASOURCE_NAME, map.get(SELECT_VALUE), rowIndex);
            } else if (closedCallBackEvent.getActionId().equalsIgnoreCase("datasourcefieldcloseback")) {
                model.setValue(FILTER_FIELD, map.get(SELECT_ID), rowIndex);
                model.setValue(FILTER_FIELD_NAME, map.get(SELECT_VALUE), rowIndex);
            }
        }
    }

    private void showDataSourceFieldForm(EventObject evt) {
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context == null || context.size() < 3) {
            return;
        }
        List list = (List)context.get(1);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        Object controlKeyValue = this.getModel().getValue(FIELD_CONTROL_KEY, rowIndex);
        Object dataSourceId = this.getModel().getValue(DATASOURCE_ID, rowIndex);
        if (dataSourceId == null || "".equals(dataSourceId.toString().trim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"FilterFieldConfigPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object filterFieldId = this.getModel().getValue(FILTER_FIELD, rowIndex);
        Object filterFieldName = this.getModel().getValue(FILTER_FIELD_NAME, rowIndex);
        TextEdit edit = (TextEdit)evt.getSource();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(IDE_RPT_COMBO);
        parameter.setCustomParam("type", (Object)edit.getKey());
        parameter.setCustomParam(SELECT_ID, filterFieldId);
        parameter.setCustomParam(SELECT_VALUE, filterFieldName);
        parameter.setCustomParam(ROW_INDEX, (Object)rowIndex);
        parameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u5b57\u6bb5\u9009\u62e9", (String)"FilterFieldConfigPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        Object fieldProp = this.getFieldProp(controlKeyValue.toString(), list);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)dataSourceId.toString());
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        ArrayList<ComboItem> dataSourceFieldList = new ArrayList<ComboItem>();
        ArrayList<IDataEntityProperty> allProperties = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty dtProp : properties) {
            this.addProperty(dtProp, allProperties);
        }
        for (IDataEntityProperty dtProp : allProperties) {
            this.loadDataSourceField(fieldProp, dtProp, dataSourceFieldList);
        }
        if (!dataSourceFieldList.isEmpty()) {
            parameter.setCustomParam(COMBO_ITEMS, (Object)SerializationUtils.serializeToBase64(dataSourceFieldList));
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "datasourcefieldcloseback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void loadDataSourceField(Object fieldProp, IDataEntityProperty dtProp, List<ComboItem> dataSourceFieldList) {
        if (fieldProp != null && fieldProp.getClass().isAssignableFrom(dtProp.getClass())) {
            ComboItem item = new ComboItem();
            item.setCaption(dtProp.getDisplayName());
            String filedName = dtProp.getName();
            if (dtProp.getParent() instanceof EntryType) {
                filedName = dtProp.getParent().getName() + "." + dtProp.getName();
            }
            item.setId(filedName);
            dataSourceFieldList.add(item);
        }
    }

    private void showDataSourceForm(EventObject evt) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        Object dataSourceId = this.getModel().getValue(DATASOURCE_ID, rowIndex);
        Object dataSourceName = this.getModel().getValue(DATASOURCE_NAME, rowIndex);
        TextEdit edit = (TextEdit)evt.getSource();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(IDE_RPT_COMBO);
        parameter.setCustomParam("type", (Object)edit.getKey());
        parameter.setCustomParam(SELECT_ID, dataSourceId);
        parameter.setCustomParam(SELECT_VALUE, dataSourceName);
        parameter.setCustomParam(ROW_INDEX, (Object)rowIndex);
        parameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u9009\u62e9", (String)"FilterFieldConfigPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        parameter.setCustomParam(COMBO_ITEMS, (Object)this.getPageCache().get("dataSourceList"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "datasourcecloseback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void showCompareTypeForm(EventObject evt) {
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context == null || context.size() < 3) {
            return;
        }
        List list = (List)context.get(1);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        Object controlKeyValue = this.getModel().getValue(FIELD_CONTROL_KEY, rowIndex);
        Object compareTypeId = this.getModel().getValue(COMPARE_TYPE_ID, rowIndex);
        Object compareTypeName = this.getModel().getValue(COMPARE_TYPE_NAME, rowIndex);
        TextEdit edit = (TextEdit)evt.getSource();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(IDE_RPT_COMBO);
        parameter.setCustomParam("type", (Object)edit.getKey());
        parameter.setCustomParam(SELECT_ID, compareTypeId);
        parameter.setCustomParam(SELECT_VALUE, compareTypeName);
        parameter.setCustomParam(ROW_INDEX, (Object)rowIndex);
        parameter.setCaption(ResManager.loadKDString((String)"\u6bd4\u8f83\u7b26\u9009\u62e9", (String)"FilterFieldConfigPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        Object fieldProp = this.getFieldProp(controlKeyValue.toString(), list);
        if (fieldProp instanceof IFieldHandle) {
            String compareGroupId = ((IFieldHandle)fieldProp).getCompareGroupID();
            List compareTypeList = FilterMetadata.get().getCompareTypes(compareGroupId);
            parameter.setCustomParam(COMBO_ITEMS, (Object)SerializationUtils.serializeToBase64((Object)compareTypeList));
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "comparetypecloseback");
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void returnData() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(ENTRY_ENTITY);
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        ReportFilterFieldConfig reportFilterFieldConfig = new ReportFilterFieldConfig();
        ArrayList<ReportFilterField> reportFilterFields = new ArrayList<ReportFilterField>(rowCount);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            String fieldKey = (String)model.getValue(FIELD_CONTROL_KEY, rowIndex);
            String filterField = (String)model.getValue(FILTER_FIELD, rowIndex);
            String compareTypeId = (String)model.getValue(COMPARE_TYPE_ID, rowIndex);
            String dataSourceId = (String)model.getValue(DATASOURCE_ID, rowIndex);
            String keyCaption = (String)model.getValue(FIELD_CONTROL_KEY_NAME, rowIndex);
            String fieldCaption = (String)model.getValue(FILTER_FIELD_NAME, rowIndex);
            String compareTypeCaption = (String)model.getValue(COMPARE_TYPE_NAME, rowIndex);
            String dataSourceCaption = (String)model.getValue(DATASOURCE_NAME, rowIndex);
            ReportFilterField reportFilterField = new ReportFilterField();
            reportFilterField.setDataSourceId(dataSourceId);
            reportFilterField.setFieldName(filterField);
            reportFilterField.setKey(fieldKey);
            reportFilterField.setCompareTypeId(compareTypeId);
            reportFilterField.setKeyCaption(keyCaption);
            reportFilterField.setFieldCaption(fieldCaption);
            reportFilterField.setDataSourceCaption(dataSourceCaption);
            reportFilterField.setCompareTypeCaption(compareTypeCaption);
            reportFilterFields.add(reportFilterField);
        }
        reportFilterFieldConfig.setReportFilterFields(reportFilterFields);
        para.put("value", this.serializeReportFilterFieldConfig(reportFilterFieldConfig));
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private List<IDataEntityType> getDataEntityType() {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(ReportFilterField.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ReportFilterFieldConfig.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(QueryDataSource.class));
        return dataEntityTypes;
    }

    private Map<String, Object> serializeReportFilterFieldConfig(ReportFilterFieldConfig reportFilterFieldConfig) {
        List<IDataEntityType> dataEntityTypes = this.getDataEntityType();
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return dcJsonSerializer.serializeToMap((Object)reportFilterFieldConfig, null);
    }

    private ReportFilterFieldConfig deSerializeReportFilterFieldConfig(String jsonString) {
        List<IDataEntityType> dataEntityTypes = this.getDataEntityType();
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return (ReportFilterFieldConfig)dcJsonSerializer.deserializeFromString(jsonString, null);
    }

    private void initfilterFieldControls(FormMetadata formMetadata) {
        ComboItem item;
        ControlAp control;
        int i;
        List controlAps = formMetadata.getItems();
        ArrayList<String> ids = new ArrayList<String>();
        for (ControlAp control2 : controlAps) {
            if (!StringUtils.equals((CharSequence)"reportcommfilterpanelap", (CharSequence)control2.getKey()) && !StringUtils.equals((CharSequence)"reportmorefilterpanelap", (CharSequence)control2.getKey())) continue;
            ids.add(control2.getId());
        }
        if (ids.isEmpty()) {
            return;
        }
        ArrayList<String> firstIds = new ArrayList<String>();
        for (int i2 = 0; i2 < controlAps.size(); ++i2) {
            ControlAp control3 = (ControlAp)controlAps.get(i2);
            if (ids.isEmpty() || !ids.contains(control3.getParentId())) continue;
            if (control3 instanceof FieldAp) {
                ComboItem item2 = new ComboItem();
                item2.setId(control3.getKey());
                item2.setCaption(control3.getName());
                this.controlKeylist.add(item2);
                continue;
            }
            firstIds.add(control3.getId());
        }
        if (firstIds.isEmpty()) {
            return;
        }
        ArrayList<String> secondIds = new ArrayList<String>();
        for (i = 0; i < controlAps.size(); ++i) {
            control = (ControlAp)controlAps.get(i);
            if (firstIds.isEmpty() || !firstIds.contains(control.getParentId())) continue;
            if (control instanceof FieldAp) {
                item = new ComboItem();
                item.setId(control.getKey());
                item.setCaption(control.getName());
                this.controlKeylist.add(item);
                continue;
            }
            secondIds.add(control.getId());
        }
        if (secondIds.isEmpty()) {
            return;
        }
        for (i = 0; i < controlAps.size(); ++i) {
            control = (ControlAp)controlAps.get(i);
            if (secondIds.isEmpty() || !secondIds.contains(control.getParentId()) || !(control instanceof FieldAp)) continue;
            item = new ComboItem();
            item.setId(control.getKey());
            item.setCaption(control.getName());
            this.controlKeylist.add(item);
        }
    }

    private void initDefaultCompareType(String key, int rowIndex, Object fieldProp) {
        IDataModel model = this.getModel();
        String defaultCompareTypeId = "";
        String compareGroupId = "";
        if (fieldProp instanceof IFieldHandle) {
            defaultCompareTypeId = ((IFieldHandle)fieldProp).getDefaultCompareTypeId();
            compareGroupId = ((IFieldHandle)fieldProp).getCompareGroupID();
            CompareType compareType = FilterMetadata.get().getCompareType(compareGroupId, defaultCompareTypeId);
            if (compareType != null) {
                model.setValue(COMPARE_TYPE_NAME, (Object)compareType.getName(), rowIndex);
                model.setValue(COMPARE_TYPE_ID, (Object)compareType.getId(), rowIndex);
            }
        }
    }

    private void initDataSourceCombo(List<Map<String, Object>> list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                QueryDataSource queryDataSource;
                Map<String, Object> map = list.get(i);
                if (map == null || map.get("QueryDataSource") == null || (queryDataSource = this.deSerializeQueryDataSource(map.get("QueryDataSource").toString())) == null || queryDataSource.getDataSourceId() == null) continue;
                String dataSourceId = queryDataSource.getDataSourceId();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)dataSourceId);
                ComboItem comboItem = new ComboItem();
                comboItem.setId(dataSourceId);
                comboItem.setValue(dataSourceId);
                comboItem.setCaption(dataEntityType.getDisplayName());
                this.dataSourceList.add(comboItem);
            }
            this.getPageCache().put("dataSourceList", SerializationUtils.serializeToBase64(this.dataSourceList));
        }
    }

    private QueryDataSource deSerializeQueryDataSource(String jsonString) {
        List<IDataEntityType> dataEntityTypes = this.getDataEntityType();
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return (QueryDataSource)dcJsonSerializer.deserializeFromString(jsonString, null);
    }

    private void initDefaultDataSourceField(String dataSourceId, int rowIndex, String key, EntityMetadata entityMetadata) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)dataSourceId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        ArrayList<IDataEntityProperty> allProperties = new ArrayList<IDataEntityProperty>();
        for (IDataEntityProperty dtProp : properties) {
            this.addProperty(dtProp, allProperties);
        }
        for (IDataEntityProperty prop : allProperties) {
            if (prop == null) continue;
            IDataModel model = this.getModel();
            Object fieldProp = this.getFieldProp(key, entityMetadata);
            if (fieldProp != null && this.isKnownFieldType(fieldProp)) {
                if (!fieldProp.getClass().equals(prop.getClass())) continue;
                String filedName = prop.getName();
                if (prop.getParent() instanceof EntryType) {
                    filedName = prop.getParent().getName() + "." + prop.getName();
                }
                model.setValue(FILTER_FIELD, (Object)filedName, rowIndex);
                model.setValue(FILTER_FIELD_NAME, (Object)prop.getDisplayName(), rowIndex);
                return;
            }
            if (fieldProp == null || !fieldProp.getClass().isAssignableFrom(prop.getClass())) continue;
            String filedName = prop.getName();
            if (prop.getParent() instanceof EntryType) {
                filedName = prop.getParent().getName() + "." + prop.getName();
            }
            model.setValue(FILTER_FIELD, (Object)filedName, rowIndex);
            model.setValue(FILTER_FIELD_NAME, (Object)prop.getDisplayName(), rowIndex);
            return;
        }
    }

    private boolean isKnownFieldType(Object fieldProp) {
        if (fieldProp instanceof CurrencyProp) {
            return true;
        }
        if (fieldProp instanceof BillTypeProp) {
            return true;
        }
        if (fieldProp instanceof AssistantProp) {
            return true;
        }
        if (fieldProp instanceof MaterielProp) {
            return true;
        }
        if (fieldProp instanceof UnitProp) {
            return true;
        }
        if (fieldProp instanceof PriceProp) {
            return true;
        }
        if (fieldProp instanceof QtyProp) {
            return true;
        }
        if (fieldProp instanceof AmountProp) {
            return true;
        }
        if (fieldProp instanceof AdminDivisionProp) {
            return true;
        }
        if (fieldProp instanceof OrgProp) {
            return true;
        }
        return fieldProp instanceof CityProp;
    }

    private void addProperty(IDataEntityProperty dtProp, List<IDataEntityProperty> allProperties) {
        if (dtProp instanceof EntryProp) {
            EntryProp prop = (EntryProp)dtProp;
            DynamicObjectType entryType = prop.getDynamicCollectionItemPropertyType();
            DataEntityPropertyCollection entryProperties = entryType.getProperties();
            for (IDataEntityProperty entryProp : entryProperties) {
                this.addProperty(entryProp, allProperties);
            }
        } else if (!"isGroupNode".equals(dtProp.getName())) {
            allProperties.add(dtProp);
        }
    }

    private Object getFieldProp(String key, List<Map<String, Object>> list) {
        if (list != null) {
            EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata(list);
            return this.getFieldProp(key, entityMetadata);
        }
        return null;
    }

    private Object getFieldProp(String key, EntityMetadata entityMetadata) {
        if (entityMetadata != null) {
            List entityItems = entityMetadata.getItems();
            for (EntityItem item : entityItems) {
                if (key == null || !StringUtils.equals((CharSequence)key, (CharSequence)item.getKey())) continue;
                try {
                    Class<?> clazz = item.getClass();
                    Method method = EntityItem.class.getDeclaredMethod("createDynamicProperty", new Class[0]);
                    method.setAccessible(true);
                    Object obj = clazz.newInstance();
                    if (obj instanceof CurrencyField) {
                        return new CurrencyProp();
                    }
                    if (obj instanceof BillTypeField) {
                        return new BillTypeProp();
                    }
                    if (obj instanceof AssistantField) {
                        return new AssistantProp();
                    }
                    if (obj instanceof MaterielField) {
                        return new MaterielProp();
                    }
                    if (obj instanceof UnitField) {
                        return new UnitProp();
                    }
                    if (obj instanceof PriceField) {
                        return new PriceProp();
                    }
                    if (obj instanceof QtyField) {
                        return new QtyProp();
                    }
                    if (obj instanceof AmountField) {
                        return new AmountProp();
                    }
                    if (obj instanceof AdminDivisionField) {
                        return new AdminDivisionProp();
                    }
                    if (obj instanceof OrgField) {
                        return new OrgProp();
                    }
                    if (obj instanceof CityField) {
                        return new CityProp();
                    }
                    if (obj instanceof ItemClassField) {
                        return new ItemClassProp();
                    }
                    if (obj instanceof BasedataField) {
                        return new BasedataProp();
                    }
                    if (obj instanceof MulBasedataField) {
                        return new MulBasedataProp();
                    }
                    return method.invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
                }
            }
        }
        return null;
    }
}

