/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.query;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class QueryConditionSelectFieldList
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener {
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String SELECT_FIELD_NUMBER = "selectFieldNumber";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_TreeView = "tv_fields";
    private static final String SELECT_FIELD_VALUE = "selectfieldvalue";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        String oldSelectFieldValue = (String)this.getView().getFormShowParameter().getCustomParam(SELECT_FIELD_VALUE);
        this.getModel().setValue(SELECT_FIELD_VALUE, (Object)oldSelectFieldValue);
        this.getView().updateView(SELECT_FIELD_VALUE);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            this.addTreeRootNode();
        }
        int rowIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowindex");
        if (rowIndex == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SELECT_FIELD_VALUE});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = (String)this.getModel().getValue(SELECT_FIELD_VALUE);
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String entityAlias = (String)this.getView().getFormShowParameter().getCustomParam("entityalias");
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        String currNodeValue = (String)e.getNodeId();
        this.getModel().setValue(SELECT_FIELD_VALUE, (Object)currNodeValue);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        this.getView().returnDataToParent((Object)currNodeId);
        this.getView().close();
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds != null) {
            checkedNodeIds.remove("0");
        }
    }

    private void fillTreeNodes(String strJson) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(rootNode);
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"QueryConditionSelectFieldList_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(root);
    }
}

