/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.query.ModelType;
import kd.bos.designer.query.OpenParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.domainmodel.DomainModelType;

class QueryConfigFormHelper {
    public static final String BOS_MOBILEPREVIEW = "bos_mobilepreview";
    public static final String FORM_ID = "formId";
    public static final String PARAM_FORM = "form";
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_CONTEXT = "context";
    public static final String PARAM_ITEM = "item";
    public static final String PARAM_ITEM_ID = "itemId";
    public static final String PARAM_MODEL_TYPE = "modelType";
    public static final String PARAM_META_TYPE = "metaType";
    public static final String PARAM_PROPERTY_NAME = "propertyName";
    public static final String PARAM_DESIGNER_MODEL_TYPE = "designermodeltype";
    public static final String PARAM_PROPERTY_EDIT = "propertyEdit";
    public static final String PREFIX_MOB = "Mob";
    public static final String PARAM_DESIGNER_PAGEID = "designerPageId";
    private static final String PERMISSION_ITEMS = "PermissionItems";

    private QueryConfigFormHelper() {
    }

    private static String getEditEntityId(Map<String, Object> formmetaMap) {
        String queryEntityId = (String)formmetaMap.get("EntityId");
        QueryEntityType dataEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityTypeById((String)queryEntityId);
        String editEntityNum = dataEntityType.getEditEntityName();
        MetadataReader metadataReader = new MetadataReader();
        return metadataReader.loadIdByNumber(editEntityNum, MetaCategory.Entity);
    }

    static List<Map<String, Object>> getOperationsConfigContext(String queryFormId, List<?> permissionItemsList) {
        Map queryDesingerMatadataMap = MetadataDao.loadDesignerMetadata((String)queryFormId);
        Map formmetaMap = (Map)queryDesingerMatadataMap.get("formmeta");
        String editEntityId = QueryConfigFormHelper.getEditEntityId(formmetaMap);
        List<Map<String, Object>> editParamList = QueryConfigFormHelper.getEditParamList(editEntityId);
        List operationsList = (List)editParamList.get(0).get("Operations");
        editParamList.get(0).put("Operations", operationsList);
        List queryDesingerParamList = (List)((HashMap)queryDesingerMatadataMap.get("entitymeta")).get("Items");
        HashMap metadataItemMap = (HashMap)editParamList.get(0);
        if (permissionItemsList.isEmpty()) {
            metadataItemMap.put(PERMISSION_ITEMS, (List)((Map)queryDesingerParamList.get(0)).get(PERMISSION_ITEMS));
        } else {
            metadataItemMap.put(PERMISSION_ITEMS, permissionItemsList);
        }
        return editParamList;
    }

    static List<Map<String, Object>> getEditParamList(String editEntityId) {
        return QueryConfigFormHelper.getEditParamList(editEntityId, Lang.get().getLocale().toString());
    }

    static List<Map<String, Object>> getEditParamList(String editEntityId, String lang) {
        Map editDesignerMatadataMap = MetadataDao.loadDesignerMetadata((String)editEntityId, (String)lang);
        return (List)((HashMap)editDesignerMatadataMap.get("entitymeta")).get("Items");
    }

    static FormShowParameter createFormShowParameter(OpenParameter openParameter, IFormPlugin plugin, String closeCallBackActionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("selectaction", (Object)"FieldEdit");
        StyleCss css = new StyleCss();
        css.setWidth(openParameter.getWidth() + "px");
        css.setHeight(openParameter.getHeight() + "px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setShowTitle(false);
        showParameter.setFormId(openParameter.getFormId());
        showParameter.setParentFormId(openParameter.getParentFormId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (openParameter.getModelType() == ModelType.List) {
            showParameter = new ListShowParameter();
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            listShowParameter.setBillFormId(openParameter.getFormId());
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)openParameter.getFormId());
            showParameter.setFormId(formConfig.getF7ListFormId());
            listShowParameter.setLookUp(true);
            listShowParameter.setMultiSelect(false);
            showParameter.setFormId(formConfig.getListFormId());
        }
        showParameter.setCustomParam(PARAM_ITEM_ID, (Object)openParameter.getItemId());
        showParameter.setCustomParam(PARAM_DESIGNER_PAGEID, (Object)openParameter.getPageId());
        showParameter.setCustomParam(PARAM_MODEL_TYPE, (Object)openParameter.getModelType());
        showParameter.setCustomParam(PARAM_META_TYPE, (Object)openParameter.getMetaType());
        showParameter.setCustomParam(PARAM_PROPERTY_NAME, (Object)openParameter.getPropertyName());
        showParameter.setCustomParam(PARAM_VALUE, openParameter.getValue());
        showParameter.setCustomParam(PARAM_CONTEXT, openParameter.getContext());
        showParameter.setCustomParam("bizappid", (Object)openParameter.getAppId());
        if (StringUtils.isNotEmpty((CharSequence)openParameter.getDesignModelType())) {
            showParameter.setClientParam(PARAM_MODEL_TYPE, (Object)openParameter.getDesignModelType());
            showParameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
        }
        CloseCallBack closeCallBack = new CloseCallBack(plugin, closeCallBackActionId);
        closeCallBack.setControlKey(openParameter.getControlKey());
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }
}

