/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.query;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.dao.GitSaveMetadata;
import kd.bos.designer.query.OpenParameter;
import kd.bos.designer.query.QueryConfigFormHelper;
import kd.bos.designer.query.QueryDynSourceValid;
import kd.bos.designer.query.QueryEntityParseHelper;
import kd.bos.designer.query.QueryEntityTreeBuildParameter;
import kd.bos.designer.query.QueryEntityTreeNode;
import kd.bos.designer.query.QueryMetadataHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QueryPlugInField;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySortField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.mulentities.expr.QSExpr;
import kd.bos.entity.mulentities.expr.QSIdentifierExpr;
import kd.bos.entity.mulentities.expr.QSPropExpr;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.report.QueryDataSource;
import kd.bos.metadata.perm.PermissionControl;
import kd.bos.metadata.perm.PermissionDimension;
import kd.bos.metadata.perm.PermissionItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public class QueryDynSourcePlugIn
extends AbstractBasePlugIn
implements TabSelectListener,
CellClickListener,
RowClickEventListener {
    public static final Log logger = LogFactory.getLog(QueryDynSourcePlugIn.class);
    public static final String BASEDATA_ID = "_id";
    public static final String IDE_OPERATIONSELECT = "ide_operationselect";
    public static final String OPERATIONS_CONTROL_VAL = "operations_control_val";
    public static final String PERMISSION_CONTROL_VAL = "permission_control_val";
    public static final String PERMISSION_FIELD_VAL = "permission_field_val";
    public static final String SELECTFIELDENTITYNUMBER = "selectfieldentitynumber";
    private static final String IDE_PERMITEMSEDIT = "ide_permitemsedit";
    private static final String BOS_DEVP_EXTAPPEXTPAGE = "bos_devp_extappextpage";
    public static final String QUERY_DYN_SOURCE_PLUG_IN_CACHE = "QueryDynSourcePlugInCache";
    public static final String QUERY_QUERYPLUGIN_ENTRY = "querypluginentry";
    public static final String QUERY_ENTITY_ENTRY = "queryentityentry";
    public static final String QUERY_RELATION_ENTRY = "queryrelationenrtry";
    public static final String QUERY_RELATION_CONDITION_ENTRY = "queryrelaconditionentry";
    public static final String QUERY_CONDITION_ENTRY = "queryconditionentry";
    public static final String QUERY_SELECT_FIELDS_ENTRY = "queryselectfieldsentry";
    public static final String SELECT_FIELD_ALIAS = "selectfieldalias";
    public static final String QUERY_SORT_FIELDS_ENTRY = "querysortfieldentry";
    public static final String PARENT_ENTITY_NUMBER = "parententitynumber";
    public static final String PARENT_ENTITY_ALIAS = "parententityalias";
    public static final String CHILD_ENTITY_NUMBER = "childentitynumber";
    public static final String CHILD_ENTITY_ALIAS = "childentityalias";
    public static final String CONDITION_FIELD = "conditionfield";
    public static final String CONDITION_VALUE = "conditionvalue";
    public static final String MAIN_ENTITY_NAME = "mainentityname";
    public static final String MAIN_ENTITY_ALIAS = "mainentityalias";
    public static final String RELATION_CHILD_ENTITY_PROP = "relachildentityprop";
    public static final String RELATION_CHILD_ENTITY_PROPDISNAME = "relachilddisplayname";
    public static final String RELATION_CONDITION_TYPE = "relaconditiontype";
    public static final String RELATION_PARENT_ENTITY_PROP = "relaparententityprop";
    public static final String RELATION_PARENT_ENTITY_PROPDISNAME = "relaparentdisplayname";
    public static final String PAGE_QUERY_FIELD_MODIFY_VAL_F7 = "cts_queryfieldmodifyvalf7";
    public static final String COLUMN_ENTITY_NUMBER = "entitynumber";
    public static final String COLUMN_ENTITY_ALIAS = "entityalias";
    public static final String SPLIT_STRING_FLAG = ":";
    public static final String QUERYSOURCE_JOIN_RELATION_ID = "querysourcejoinrelationid";
    public static final String QS_CONDITION_ROW_ID = "qsconditionrowid";
    private static final String COPY_EXIST_DATASOURCE = "copyexistdatasource";
    private static final String BAR_SAVE = "barsave";
    private static final String BAR_PERMSET = "barpermset";
    private static final String BAR_OPERATIONS_SET = "baroperationsset";
    private static final String QUERY_ENTITY_ID = "queryEntityId";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String BIZ_APP_ID = "bizappid";
    private static final String BAR_EXTEND = "barextend";
    private static final String PARENT_ID = "parentid";
    private static final String GROUP = "group";
    private static final String CURRENT_UNIT_ID = "currentUnitId";
    private static final String CURRENT_BIZ_APP_ID = "currentBizAppId";
    private static final String QUERY_ENTITY_NUMBER = "queryEntityNumber";
    private static final String NUMBER = "number";
    private static final String VALUE = "value";
    private static final String BTN_IMPORT_ENTITY = "btnimportentity";
    private static final String BTN_SORT_FIELD_IMPORT = "btnsortfieldimport";
    private static final String BTN_QUERY_FIELD_IMPORT = "btnqueryfieldimport";
    private static final String EDIT_ENTITY_ALIAS_NAME = "editentityaliasname";
    private static final String ROW_INDEX = "rowindex";
    private static final String ENTITY_NAME = "entityname";
    private static final String COMBINATION_TYPE = "combinationtype";
    private static final String QUERY_DYN_SOURCE_PLUG_IN_9 = "QueryDynSourcePlugIn_9";
    private static final String PARENT_FIELD = "parentField";
    private static final String ENABLE_IMPORT = "enableimport";
    private static final String INHERIT_PATH = "inheritpath";
    private static final String DEV_TYPE = "devtype";
    private static final String MASTER_ID = "masterid";
    private static final String TYPE = "_Type_";
    private static final String SELECT_FIELD_ENTITY_NAME = "selectfieldentityname";
    private static final String QUERY_SELECT_FIELDS_ENTRY_ID = "queryselectfieldsentryid";
    private static final String SELECT_FIELD_DISPLAY_NAME = "selectfielddisplayname";
    private HashMap<String, List<QueryCondition>> queryDataMap = new HashMap();
    IBizAppServiceHelp iBizAppServiceHelp = new IBizAppServiceHelp(){

        @Override
        public List<AppFunctionPacketElement> getAllAppFunctionPacketsByAppID(String appID) {
            return BizAppServiceHelp.getAllAppFunctionPacketsByAppID((String)appID);
        }
    };
    IMetadataDao iMetadataDao = new IMetadataDao(){

        @Override
        public AbstractMetadata readMeta(String id, MetaCategory category) {
            return MetadataDao.readMeta((String)id, (MetaCategory)category);
        }
    };
    IQueryEntityParseHelper iQueryEntityParseHelper = new IQueryEntityParseHelper(){

        @Override
        public IDataEntityProperty getFieldProperty(QuerySelectField querySelectField, DataEntityPropertyCollection properties, QueryEntity rootEntiry) {
            return QueryEntityParseHelper.getFieldProperty(querySelectField, properties, rootEntiry);
        }

        @Override
        public TreeNode buildBillTreeNodes(QueryEntityTreeBuildParameter parameter, boolean isShowId, String val) {
            return QueryEntityParseHelper.buildBillTreeNodes(parameter, isShowId, val);
        }
    };
    IQueryDynSourceValid iQueryDynSourceValid = new IQueryDynSourceValid(){

        @Override
        public List<String> pageInfoChecker(IDataModel dataModel, IPageCache pageCache) {
            return QueryDynSourceValid.pageInfoChecker(dataModel, pageCache);
        }
    };
    IQueryServiceHelper iQueryServiceHelper = new IQueryServiceHelper(){

        @Override
        public boolean exists(String entityName, QFilter[] qFilters) {
            return QueryServiceHelper.exists((String)entityName, (QFilter[])qFilters);
        }
    };
    IQueryConfigFormHelper iQueryConfigFormHelper = new IQueryConfigFormHelper(){

        @Override
        public List<Map<String, Object>> getOperationsConfigContext(String queryFormId, List<?> permissionItemsList) {
            return QueryConfigFormHelper.getOperationsConfigContext(queryFormId, permissionItemsList);
        }
    };
    IShowFormHelper iShowFormHelper = new IShowFormHelper(){

        @Override
        public ListShowParameter createShowListForm(String formId, boolean isMultiSelect, int f7Style, boolean isLookUP) {
            return ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect, (int)f7Style, (boolean)isLookUP);
        }
    };
    IQueryMetadataHelper iQueryMetadataHelper = new IQueryMetadataHelper(){

        @Override
        public String saveQueryMetadata(QueryDynSourcePlugIn plugIn, IDataModel dataModel) {
            QueryMetadataHelper queryMetadataHelper = new QueryMetadataHelper();
            return queryMetadataHelper.saveQueryMetadata(plugIn, dataModel);
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarentity"});
        this.addItemClickListeners(new String[]{"advcontoolbarrelation"});
        this.addItemClickListeners(new String[]{"advcontoolbarrelationdata"});
        this.addItemClickListeners(new String[]{"advcontoolbarcondition"});
        this.addItemClickListeners(new String[]{"advcontoolbarselectfield"});
        this.addItemClickListeners(new String[]{"advcontoolbarplugin"});
        this.addItemClickListeners(new String[]{"advcontoolbarsortfield"});
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{BAR_SAVE, "barcancel", BAR_PERMSET, BAR_OPERATIONS_SET, COPY_EXIST_DATASOURCE, RELATION_CHILD_ENTITY_PROP, RELATION_CHILD_ENTITY_PROPDISNAME, RELATION_PARENT_ENTITY_PROP, RELATION_PARENT_ENTITY_PROPDISNAME});
        this.addItemClickListeners(new String[]{"toolbarap", CHILD_ENTITY_ALIAS});
        EntryGrid queryrelationenrtry = (EntryGrid)this.getControl(QUERY_RELATION_ENTRY);
        queryrelationenrtry.addCellClickListener((CellClickListener)this);
        queryrelationenrtry.addRowClickListener((RowClickEventListener)this);
        EntryGrid queryselectfieldsentry = (EntryGrid)this.getControl(QUERY_SELECT_FIELDS_ENTRY);
        queryselectfieldsentry.addCellClickListener((CellClickListener)this);
        queryselectfieldsentry.addRowClickListener((RowClickEventListener)this);
        EntryGrid queryConditionentry = (EntryGrid)this.getControl(QUERY_RELATION_CONDITION_ENTRY);
        queryConditionentry.addCellClickListener((CellClickListener)this);
        queryConditionentry.addRowClickListener((RowClickEventListener)this);
    }

    private String getQueryFormId() {
        if (this.getView().getFormShowParameter().getCustomParam(QUERY_ENTITY_ID) != null) {
            return (String)this.getView().getFormShowParameter().getCustomParam(QUERY_ENTITY_ID);
        }
        if (this.getView().getModel().getValue("id") != null && !"".equals(this.getView().getModel().getValue("id").toString())) {
            return (String)this.getView().getModel().getValue("id");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u67e5\u8be2\u914d\u7f6e\u3002", (String)"QueryDynSourcePlugIn_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
    }

    private OpenParameter createOpenParameter(String formId) {
        String pageId = this.getView().getPageId();
        String itemId = (String)this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID);
        String metaType = (String)this.getView().getFormShowParameter().getCustomParams().get(META_TYPE);
        String propertyName = (String)this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME);
        OpenParameter openParameter = new OpenParameter(formId, pageId, metaType, propertyName, itemId);
        openParameter.setAppId((String)this.getView().getFormShowParameter().getCustomParam(BIZ_APP_ID));
        return openParameter;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (BAR_SAVE.equals(itemKey)) {
            List<String> res = this.iQueryDynSourceValid.pageInfoChecker(this.getModel(), this.getPageCache());
            if (!res.isEmpty()) {
                StringBuilder message = new StringBuilder();
                for (String msg : res) {
                    message.append(msg).append("\r\n");
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25", (String)"QueryDynSourcePlugIn_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), message.toString(), MessageTypes.Default);
                evt.setCancel(true);
            }
        } else if (BAR_PERMSET.equals(itemKey)) {
            this.showPermissionSettingPage();
        } else if (BAR_EXTEND.equals(itemKey)) {
            String queryEntityId = this.getQueryFormId();
            AbstractMetadata formMetadata = this.iMetadataDao.readMeta(queryEntityId, MetaCategory.Form);
            String currentIsv = ISVService.getISVInfo().getId();
            if (!currentIsv.equals(formMetadata.getIsv())) {
                String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(CURRENT_BIZ_APP_ID);
                String countAppNumber = this.getParallelExtCountByIsv(bizAppId, "bos_devportal_bizapp", PARENT_ID);
                String countFormNumber = this.getParallelExtCountByIsv(queryEntityId, "bos_formmeta", PARENT_ID);
                if (!"0".equals(countFormNumber)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u67e5\u8be2\u5b9e\u4f53\u53ea\u5141\u8bb8\u6269\u5c55\u4e00\u6b21\u3002", (String)"QueryDynSourcePlugIn_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                if ("0".equals(countAppNumber)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u67e5\u8be2\u5b9e\u4f53\u6240\u5728\u7684\u5e94\u7528\u6ca1\u6709\u6269\u5c55\u5e94\u7528\uff0c\u8bf7\u5148\u53bb\u5f00\u53d1\u5e73\u53f0\u6269\u5c55\u5bf9\u5e94\u7684\u5e94\u7528\u3002", (String)"QueryDynSourcePlugIn_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                } else {
                    this.showExtendQueryEntityPage();
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5b9e\u4f53\u5f00\u53d1\u5546\u4e0e\u5f53\u524d\u5f00\u53d1\u5546\u4e3a\u540c\u4e00\u5f00\u53d1\u5546\uff0c\u4e0d\u652f\u6301\u518d\u6b21\u6269\u5c55\u3002", (String)"QueryDynSourcePlugIn_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        } else if (BAR_OPERATIONS_SET.equals(itemKey)) {
            String queryFormId;
            AbstractMetadata formMetadata;
            OpenParameter openParameter = this.createOpenParameter(IDE_OPERATIONSELECT);
            List permissionControlVals = new ArrayList();
            if (this.getPageCache().get(PERMISSION_CONTROL_VAL) != null) {
                permissionControlVals = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PERMISSION_CONTROL_VAL), List.class);
            }
            if ("2".equals((formMetadata = this.iMetadataDao.readMeta(queryFormId = this.getQueryFormId(), MetaCategory.Form)).getDevType())) {
                queryFormId = formMetadata.getParentId();
            }
            List<Map<String, Object>> operationsConfigContext = this.iQueryConfigFormHelper.getOperationsConfigContext(queryFormId, permissionControlVals);
            if (this.getPageCache().get(OPERATIONS_CONTROL_VAL) != null) {
                Map<String, Object> permissionControl = operationsConfigContext.get(0);
                permissionControl.put("Operations", SerializationUtils.fromJsonString((String)this.getPageCache().get(OPERATIONS_CONTROL_VAL), List.class));
            }
            openParameter.setContext(operationsConfigContext);
            FormShowParameter paramFormShowParameter = QueryConfigFormHelper.createFormShowParameter(openParameter, (IFormPlugin)this, IDE_OPERATIONSELECT);
            String queryEntityNumber = MetadataDao.getNumberById((String)this.getQueryFormId());
            paramFormShowParameter.setCustomParam("formId", (Object)queryEntityNumber);
            paramFormShowParameter.setShowTitle(true);
            this.getView().showForm(paramFormShowParameter);
        } else if (!kd.bos.util.StringUtils.isEmpty((String)this.getModel().getValue(PARENT_ID).toString())) {
            this.lockCurrentRowOfParentElements(evt);
        }
    }

    private String getParallelExtCountByIsv(String id, String formNumber, String parentId) {
        QFilter q = new QFilter(parentId, "=", (Object)id);
        q.and(new QFilter("type", "=", (Object)"2"));
        String currentIsv = ISVService.getISVInfo().getId();
        QFilter qIsv = new QFilter("isv", "=", (Object)currentIsv);
        if ("kingdee".equalsIgnoreCase(currentIsv)) {
            QFilter qIsvNull = new QFilter("isv", "is null", (Object)Boolean.TRUE);
            qIsvNull = qIsvNull.or(new QFilter("isv", "=", (Object)" "));
            qIsv = qIsv.or(qIsvNull);
        }
        QFilter[] filters = new QFilter[]{q, qIsv};
        String countNmuber = "0";
        if (this.iQueryServiceHelper.exists(formNumber, filters)) {
            countNmuber = "1";
        }
        return countNmuber;
    }

    private void lockCurrentRowOfParentElements(BeforeItemClickEvent evt) {
        boolean isParentConfig = false;
        if (this.getModel().getValue(PARENT_ID) != null) {
            String queryEntityId = (String)this.getModel().getValue("id");
            List<EntityMetadata> inheritMetaList = this.getInheritMetaList(queryEntityId);
            for (EntityMetadata metadata : inheritMetaList) {
                DynamicObject dynObj;
                QueryEntity queryEntity = (QueryEntity)metadata.getRootEntity();
                if ("btnentitydelete".equals(evt.getItemKey())) {
                    dynObj = this.getEntryCurrentSelectDynamicObject(QUERY_ENTITY_ENTRY);
                    isParentConfig = this.isParentEntityAlias(queryEntity, dynObj);
                } else if ("btnqueryrelationdelete".equals(evt.getItemKey())) {
                    dynObj = this.getEntryCurrentSelectDynamicObject(QUERY_RELATION_ENTRY);
                    isParentConfig = this.isParentJoinRelation(queryEntity, dynObj);
                } else if ("btnrelationdatadelete".equals(evt.getItemKey())) {
                    dynObj = this.getEntryCurrentSelectDynamicObject(QUERY_RELATION_CONDITION_ENTRY);
                    isParentConfig = dynObj == null ? false : this.isParentConditionRow(queryEntity, dynObj.getString(QS_CONDITION_ROW_ID));
                } else if ("btnqueryfielddelete".equals(evt.getItemKey())) {
                    dynObj = this.getEntryCurrentSelectDynamicObject(QUERY_SELECT_FIELDS_ENTRY);
                    isParentConfig = this.isParentSelectField(queryEntity, dynObj);
                }
                if (!isParentConfig) continue;
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u975e\u5f53\u524d\u5f00\u53d1\u5546\u7684\u914d\u7f6e\u4fe1\u606f\u3002", (String)"QueryDynSourcePlugIn_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        }
    }

    private void showExtendQueryEntityPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(BOS_DEVP_EXTAPPEXTPAGE);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Object currentUnitId = this.getModel().getValue(GROUP);
        this.getPageCache().put(CURRENT_UNIT_ID, currentUnitId == null ? "" : currentUnitId.toString());
        FormShowParameter curFormShowParameter = this.getView().getFormShowParameter();
        String currentBizAppId = (String)curFormShowParameter.getCustomParam(CURRENT_BIZ_APP_ID);
        String extAppId = this.getExtAppIdByAppId(currentBizAppId);
        showParameter.setCustomParam("extBizAppId", (Object)extAppId);
        showParameter.setCustomParam("oriBizunitId", currentUnitId);
        showParameter.setCustomParam("oriFormId", curFormShowParameter.getCustomParam(QUERY_ENTITY_ID));
        showParameter.setCustomParam("entityid", curFormShowParameter.getCustomParam(QUERY_ENTITY_ID));
        showParameter.setCustomParam("modelType", (Object)"QueryListModel");
        OrmLocaleValue localValue = (OrmLocaleValue)this.getModel().getValue("name");
        showParameter.setCustomParam("oriBizPageName", (Object)localValue.getLocaleValue());
        showParameter.setCustomParam("oriBizPageNumber", curFormShowParameter.getCustomParam(QUERY_ENTITY_NUMBER));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BOS_DEVP_EXTAPPEXTPAGE));
        this.getView().showForm(showParameter);
    }

    private String getExtAppIdByAppId(String bizAppId) {
        String extAppId = "";
        String sql = "select finheritpath,fid from t_meta_bizapp where fmasterid = ?";
        Object[] parameters = new SqlParameter[]{new SqlParameter(":FMASTERID", 12, (Object)bizAppId)};
        HashMap map = new HashMap(16);
        Map inheritPaths = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, rs -> {
            String[] inheritIdArray = null;
            try {
                while (rs.next()) {
                    String inheritPathStr = rs.getString(1);
                    inheritIdArray = inheritPathStr.split(",");
                    map.put(rs.getString(2), inheritIdArray);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return map;
        });
        if (inheritPaths != null && !inheritPaths.isEmpty()) {
            String id = null;
            int count = 0;
            for (Map.Entry m : inheritPaths.entrySet()) {
                if (((String[])m.getValue()).length <= count) continue;
                count = ((String[])m.getValue()).length;
                id = (String)m.getKey();
            }
            extAppId = id;
        }
        return extAppId;
    }

    private void showPermissionSettingPage() {
        FormShowParameter showParameter = new FormShowParameter();
        FormShowParameter curViewShowParam = this.getView().getFormShowParameter();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (curViewShowParam.getCustomParam(QUERY_ENTITY_ID) != null) {
            paramMap.put("Id", curViewShowParam.getCustomParam(QUERY_ENTITY_ID));
            paramMap.put("Key", curViewShowParam.getCustomParam(QUERY_ENTITY_NUMBER));
            paramMap.put("Name", curViewShowParam.getCustomParam(QUERY_ENTITY_NUMBER));
        } else if (this.getView().getModel().getValue("id") != null && !"".equals(this.getView().getModel().getValue("id").toString())) {
            paramMap.put("Id", this.getView().getModel().getValue("id"));
            paramMap.put("Key", this.getView().getModel().getValue(NUMBER));
            paramMap.put("Name", this.getView().getModel().getValue("name"));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u67e5\u8be2\u914d\u7f6e\u3002", (String)"QueryDynSourcePlugIn_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        showParameter.setFormId(IDE_PERMITEMSEDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList contextList = new ArrayList();
        ArrayList<HashMap<String, Object>> entityInfoList = new ArrayList<HashMap<String, Object>>();
        paramMap.put("_TYPE_", "QueryEntity");
        if (this.getPageCache().get("PermissionControl") != null) {
            Map permissionControlMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("PermissionControl"), Map.class);
            paramMap.put("PermissionControl", permissionControlMap.get(VALUE));
        }
        if (this.getPageCache().get("PermissionDimension") != null) {
            Map permissionDimensionMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("PermissionDimension"), Map.class);
            paramMap.put("PermissionDimension", permissionDimensionMap.get(VALUE));
        }
        entityInfoList.add(paramMap);
        if (this.getPageCache().get(PERMISSION_FIELD_VAL) != null) {
            List querySelectFieldList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PERMISSION_FIELD_VAL), List.class);
            entityInfoList.addAll(querySelectFieldList);
            contextList.add(entityInfoList);
        }
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("context", contextList);
        if (this.getPageCache().get(PERMISSION_CONTROL_VAL) != null) {
            contextMap.put(VALUE, SerializationUtils.fromJsonString((String)this.getPageCache().get(PERMISSION_CONTROL_VAL), List.class));
        }
        showParameter.setCustomParams(contextMap);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IDE_PERMITEMSEDIT));
        this.getView().showForm(showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (COPY_EXIST_DATASOURCE.equals(itemKey)) {
            ListShowParameter showParameter = this.iShowFormHelper.createShowListForm("cts_querydynsourcelist", false, 0, true);
            showParameter.setCustomParam("modeltype", (Object)"QueryListModel");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, COPY_EXIST_DATASOURCE));
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            DynamicObjectCollection dynColl;
            if (BAR_SAVE.equals(itemKey)) {
                String id = this.iQueryMetadataHelper.saveQueryMetadata(this, this.getModel());
                String type = (String)this.getModel().getValue("dstype");
                this.clearAllData();
                this.setDataFromEntityMetaCache(id);
                if ("ReportList".equals(type)) {
                    this.returnDataToReportPage();
                }
                this.saveMetadataToRepository(this.getModel(), id);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"QueryDynSourcePlugIn_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            if (BTN_IMPORT_ENTITY.equals(itemKey)) {
                ListShowParameter showParameter = this.iShowFormHelper.createShowListForm("bos_entityobject", true, 0, true);
                showParameter.setCustomParam("modeltype", (Object)"BaseFormModel,BillFormModel,BalanceModel");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_IMPORT_ENTITY));
                this.getView().showForm((FormShowParameter)showParameter);
            } else if ("btnentitydelete".equals(itemKey)) {
                dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
                if (dynColl.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QueryDynSourcePlugIn_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.deleteEntryRow(QUERY_ENTITY_ENTRY);
            }
            dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
            if (dynColl == null || dynColl.size() != 0 && ((DynamicObject)dynColl.get(0)).getString(COLUMN_ENTITY_NUMBER) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QueryDynSourcePlugIn_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            this.queryEntryButtonEvents(itemKey);
        }
    }

    private void queryEntryButtonEvents(String itemKey) {
        List<QueryEntityTreeNode> queryEntityList;
        if ("btnqueryrelationaddnew".equals(itemKey)) {
            this.getModel().createNewEntryRow(QUERY_RELATION_ENTRY);
        } else if ("btnqueryrelationdelete".equals(itemKey)) {
            this.deleteEntryRow(QUERY_RELATION_ENTRY);
        }
        if ("btnrelationdataaddnew".equals(itemKey)) {
            this.getModel().createNewEntryRow(QUERY_RELATION_CONDITION_ENTRY);
        } else if ("btnrelationdatadelete".equals(itemKey)) {
            this.deleteEntryRow(QUERY_RELATION_CONDITION_ENTRY);
        }
        if (BTN_SORT_FIELD_IMPORT.equals(itemKey)) {
            queryEntityList = this.getQueryEntityConditionRelation();
            this.importQuerySortField(queryEntityList);
        } else if ("btnsortfielddelete".equals(itemKey)) {
            this.deleteEntryRow(QUERY_SORT_FIELDS_ENTRY);
        }
        if ("btnconditionaddnew".equals(itemKey)) {
            this.getModel().createNewEntryRow(QUERY_CONDITION_ENTRY);
        } else if ("btnconditiondelete".equals(itemKey)) {
            this.deleteEntryRow(QUERY_CONDITION_ENTRY);
        }
        if (BTN_QUERY_FIELD_IMPORT.equals(itemKey)) {
            queryEntityList = this.getQueryEntityConditionRelation();
            this.importQuerySelectField(queryEntityList);
        }
        if ("btnpluginaddnew".equals(itemKey)) {
            this.getModel().createNewEntryRow(QUERY_QUERYPLUGIN_ENTRY);
        } else if ("btnplugindelete".equals(itemKey)) {
            this.deleteEntryRow(QUERY_QUERYPLUGIN_ENTRY);
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)evt.getSource();
            if (RELATION_CHILD_ENTITY_PROP.equals(textEdit.getKey()) || RELATION_CHILD_ENTITY_PROPDISNAME.equals(textEdit.getKey())) {
                DynamicObject dynRelationObject = this.getEntryCurrentSelectDynamicObject(QUERY_RELATION_ENTRY);
                if (dynRelationObject == null) {
                    return;
                }
                String childEntityAlias = dynRelationObject.getString(CHILD_ENTITY_ALIAS);
                if (childEntityAlias == null) {
                    return;
                }
                DynamicObject dynRelaCondtionObject = this.getEntryCurrentSelectDynamicObject(QUERY_RELATION_CONDITION_ENTRY);
                if (dynRelaCondtionObject == null) {
                    return;
                }
                String childEntityProp = dynRelaCondtionObject.getString(RELATION_CHILD_ENTITY_PROP);
                String childEntityNumber = this.getEntityNumberByAlias(childEntityAlias);
                if (kd.bos.util.StringUtils.isEmpty((String)childEntityNumber)) {
                    return;
                }
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)childEntityNumber);
                TreeNode childEntityFieldTreeNode = this.buildTreeNodesByEntityType(dt);
                this.showQueryFieldModifyValForm(childEntityFieldTreeNode, childEntityNumber, childEntityAlias, RELATION_CHILD_ENTITY_PROP, childEntityProp);
            } else if (RELATION_PARENT_ENTITY_PROP.equals(textEdit.getKey()) || RELATION_PARENT_ENTITY_PROPDISNAME.equals(textEdit.getKey())) {
                DynamicObject dynRelationObject = this.getEntryCurrentSelectDynamicObject(QUERY_RELATION_ENTRY);
                if (dynRelationObject == null) {
                    return;
                }
                String parentEntityAlias = dynRelationObject.getString(PARENT_ENTITY_ALIAS);
                String childEntityAlias = dynRelationObject.getString(CHILD_ENTITY_ALIAS);
                if (parentEntityAlias == null || childEntityAlias == null) {
                    return;
                }
                DynamicObject dynRelaCondtionObject = this.getEntryCurrentSelectDynamicObject(QUERY_RELATION_CONDITION_ENTRY);
                if (dynRelaCondtionObject == null) {
                    return;
                }
                String parentEntityProp = dynRelaCondtionObject.getString(RELATION_PARENT_ENTITY_PROP);
                String parentEntityNumber = this.getEntityNumberByAlias(parentEntityAlias);
                String childEntityNumber = this.getEntityNumberByAlias(childEntityAlias);
                if (kd.bos.util.StringUtils.isEmpty((String)parentEntityNumber) || kd.bos.util.StringUtils.isEmpty((String)childEntityNumber)) {
                    return;
                }
                MainEntityType childDT = EntityMetadataCache.getDataEntityType((String)childEntityNumber);
                MainEntityType parentDT = EntityMetadataCache.getDataEntityType((String)parentEntityNumber);
                TreeNode childEntityFieldTreeNode = this.buildTreeNodesByEntityType(childDT);
                childEntityFieldTreeNode.setExpend(false);
                childEntityFieldTreeNode.setIsOpened(false);
                TreeNode parentEntityFieldTreeNode = this.buildTreeNodesByEntityType(parentDT);
                parentEntityFieldTreeNode.addChild(childEntityFieldTreeNode);
                this.showQueryFieldModifyValForm(parentEntityFieldTreeNode, parentEntityNumber, parentEntityAlias, RELATION_PARENT_ENTITY_PROP, parentEntityProp);
            }
        }
    }

    private TreeNode buildTreeNodesByEntityType(MainEntityType mainEntityType) {
        QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter(mainEntityType);
        parameter.setIncludePKField(true);
        TreeNode EntityFieldTreeNode = this.iQueryEntityParseHelper.buildBillTreeNodes(parameter, true, ".id");
        return EntityFieldTreeNode;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        String controlKey = e.getProperty().getName();
        if (COLUMN_ENTITY_NUMBER.equals(controlKey)) {
            if (changeData != null && changeData.length > 0) {
                for (int i = 0; i < changeData.length; ++i) {
                    DynamicObject newEntityDynObj = (DynamicObject)changeData[i].getNewValue();
                    String entityNumber = (String)newEntityDynObj.get(NUMBER);
                    int rowIndex = this.getModel().getEntryCurrentRowIndex(QUERY_ENTITY_ENTRY);
                    this.getModel().setValue(COLUMN_ENTITY_ALIAS, (Object)entityNumber, rowIndex);
                }
            }
        } else if (RELATION_PARENT_ENTITY_PROP.equals(controlKey) || RELATION_CHILD_ENTITY_PROP.equals(controlKey) || RELATION_CONDITION_TYPE.equals(controlKey)) {
            this.putRelInCacheData();
        } else if (MAIN_ENTITY_NAME.equals(controlKey)) {
            if (changeData != null && changeData.length > 0) {
                DynamicObject newDynObj = (DynamicObject)changeData[0].getNewValue();
                DynamicObject oldDynObj = (DynamicObject)changeData[0].getOldValue();
                if (newDynObj != null) {
                    this.getModel().setValue(MAIN_ENTITY_ALIAS, (Object)newDynObj.getString(NUMBER));
                    this.getModel().setValue(EDIT_ENTITY_ALIAS_NAME, (Object)newDynObj.getString(NUMBER));
                    this.getView().updateView(MAIN_ENTITY_ALIAS);
                    if (oldDynObj != null && !oldDynObj.getString(NUMBER).equals(newDynObj.getString(NUMBER))) {
                        this.clearAllData();
                    }
                } else {
                    this.getModel().setValue(MAIN_ENTITY_ALIAS, null);
                }
            }
        } else if (MAIN_ENTITY_ALIAS.equals(controlKey) || COLUMN_ENTITY_ALIAS.equals(controlKey)) {
            if (changeData != null && changeData.length > 0) {
                String alias = (String)changeData[0].getOldValue();
                this.cleanChangeAliasData(alias);
                this.assembleQueryEntityCombo();
            }
        } else if (PARENT_ENTITY_ALIAS.equals(controlKey) || CHILD_ENTITY_ALIAS.equals(controlKey)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData(QUERY_RELATION_CONDITION_ENTRY);
        }
    }

    private void saveMetadataToRepository(IDataModel dataModel, String id) {
        Object currentApp = dataModel.getValue("currentappid");
        String currentAppId = "";
        if (currentApp != null) {
            currentAppId = currentApp.toString();
        }
        try {
            GitSaveMetadata saveMetadata = new GitSaveMetadata();
            String gitSessionId = this.getPageCache().get("gitSessionId");
            saveMetadata.saveMetadataToRepository(gitSessionId, currentAppId, id, "page");
        }
        catch (Exception e) {
            logger.info("git save metadata error", (Object)e);
        }
    }

    private void cleanChangeAliasData(String oldAlias) {
        Boolean delSelectedFieldFlag = this.deleteSelectFieldsEntryRows(oldAlias);
        Boolean delRelatedEntityflag = this.deleteRelationEntryRows(oldAlias);
        if (delRelatedEntityflag.booleanValue()) {
            String notice = ResManager.loadKDString((String)"\u5b9e\u4f53\u522b\u540d\u5df2\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8fde\u63a5\u5173\u7cfb", (String)"QueryDynSourcePlugIn_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            notice = delSelectedFieldFlag != false ? String.format(ResManager.loadKDString((String)"%s\u548c\u67e5\u8be2\u5b57\u6bb5\u3002", (String)"QueryDynSourcePlugIn_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), notice) : String.format("%s\u3002", notice);
            this.getView().showErrorNotification(notice);
            this.setDatatoConditionEntry();
        }
    }

    private DynamicObject getEntryCurrentSelectDynamicObject(String entryPropNumber) {
        DynamicObject dynObject = null;
        if (!kd.bos.util.StringUtils.isEmpty((String)entryPropNumber)) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(entryPropNumber);
            int selectRowIndex = this.getModel().getEntryCurrentRowIndex(entryPropNumber);
            if (selectRowIndex >= 0 && dynColl.size() > 0) {
                dynObject = (DynamicObject)dynColl.get(selectRowIndex);
            }
        }
        return dynObject;
    }

    private void showQueryFieldModifyValForm(TreeNode entityFieldTreeNode, String entityNumber, String entityAlias, String actionId, String selectFieldValue) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(PAGE_QUERY_FIELD_MODIFY_VAL_F7);
        String nodesJson = SerializationUtils.toJsonString((Object)entityFieldTreeNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put(COLUMN_ENTITY_ALIAS, entityAlias);
        showParameter.getCustomParams().put(COLUMN_ENTITY_NUMBER, entityNumber);
        showParameter.getCustomParams().put("selectfieldvalue", selectFieldValue);
        if (RELATION_CHILD_ENTITY_PROP.equals(actionId)) {
            showParameter.getCustomParams().put(ROW_INDEX, this.getModel().getEntryCurrentRowIndex(QUERY_RELATION_CONDITION_ENTRY));
        } else if (RELATION_PARENT_ENTITY_PROP.equals(actionId)) {
            showParameter.getCustomParams().put(ROW_INDEX, 0);
        } else {
            showParameter.getCustomParams().put(ROW_INDEX, -1);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showQuerySelectFieldForm(TreeNode entityFieldTreeNode, String isMultiSelect, String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cts_queryfieldf7");
        String nodesJson = SerializationUtils.toJsonString((Object)entityFieldTreeNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("ismulti", isMultiSelect);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equalsIgnoreCase(RELATION_CHILD_ENTITY_PROP) || closedCallBackEvent.getActionId().equalsIgnoreCase(RELATION_PARENT_ENTITY_PROP)) {
            int flag;
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_RELATION_CONDITION_ENTRY);
            int selectRowIndex = this.getModel().getEntryCurrentRowIndex(QUERY_RELATION_CONDITION_ENTRY);
            int n = flag = closedCallBackEvent.getActionId().equalsIgnoreCase(RELATION_CHILD_ENTITY_PROP) ? 1 : 2;
            if (selectRowIndex >= 0) {
                DynamicObject dynObject = (DynamicObject)dynColl.get(selectRowIndex);
                String selectFieldNumber = (String)closedCallBackEvent.getReturnData();
                if (!kd.bos.util.StringUtils.isEmpty((String)selectFieldNumber)) {
                    String selectFieldDisplayName = "";
                    if (flag == 2) {
                        DynamicObject entryCurrentSelectDynamicObject = this.getEntryCurrentSelectDynamicObject(QUERY_RELATION_ENTRY);
                        String mainEntityAlias = entryCurrentSelectDynamicObject == null ? null : entryCurrentSelectDynamicObject.get(PARENT_ENTITY_ALIAS).toString();
                        String mainEntityName = this.getEntityNumberByAlias(mainEntityAlias);
                        if (mainEntityName != null && selectFieldNumber.startsWith(mainEntityName)) {
                            selectFieldNumber = selectFieldNumber.substring(mainEntityName.length() + 1);
                            selectFieldDisplayName = this.assembleRelPropDisplayName(selectFieldNumber, 2);
                        } else {
                            selectFieldDisplayName = this.assembleRelPropDisplayName(selectFieldNumber, 1);
                        }
                    } else {
                        selectFieldDisplayName = this.assembleRelPropDisplayName(selectFieldNumber, 1);
                    }
                    if (flag == 1) {
                        dynObject.set(RELATION_CHILD_ENTITY_PROP, (Object)selectFieldNumber);
                        dynObject.set(RELATION_CHILD_ENTITY_PROPDISNAME, (Object)selectFieldDisplayName);
                    } else {
                        dynObject.set(RELATION_PARENT_ENTITY_PROP, (Object)selectFieldNumber);
                        dynObject.set(RELATION_PARENT_ENTITY_PROPDISNAME, (Object)selectFieldDisplayName);
                    }
                    this.getView().updateView(QUERY_RELATION_CONDITION_ENTRY);
                    this.putRelInCacheData();
                }
            }
        } else if (closedCallBackEvent.getActionId().equalsIgnoreCase(BTN_IMPORT_ENTITY)) {
            this.setImportEntry(closedCallBackEvent);
        } else if (closedCallBackEvent.getActionId().equalsIgnoreCase(BTN_QUERY_FIELD_IMPORT)) {
            String returnFieldNames = (String)closedCallBackEvent.getReturnData();
            if (kd.bos.util.StringUtils.isEmpty((String)returnFieldNames)) {
                return;
            }
            this.setQueryFields(returnFieldNames);
        } else if (CONDITION_FIELD.equals(closedCallBackEvent.getActionId())) {
            String returnFieldNames = (String)closedCallBackEvent.getReturnData();
            if (kd.bos.util.StringUtils.isEmpty((String)returnFieldNames)) {
                return;
            }
            DynamicObject dynObj = this.getDynamicObjectOfSelectedEntry(QUERY_CONDITION_ENTRY);
            if (dynObj == null) {
                throw new KDException(BosErrorCode.systemError, new Object[0]);
            }
            dynObj.set(CONDITION_FIELD, (Object)returnFieldNames);
            this.getView().updateView(QUERY_CONDITION_ENTRY);
        } else if (CONDITION_VALUE.equals(closedCallBackEvent.getActionId())) {
            String returnFieldNames = (String)closedCallBackEvent.getReturnData();
            if (kd.bos.util.StringUtils.isEmpty((String)returnFieldNames)) {
                return;
            }
            DynamicObject dynObj = this.getDynamicObjectOfSelectedEntry(QUERY_CONDITION_ENTRY);
            if (dynObj == null) {
                throw new KDException(BosErrorCode.systemError, new Object[0]);
            }
            dynObj.set(CONDITION_VALUE, (Object)returnFieldNames);
            this.getView().updateView(QUERY_CONDITION_ENTRY);
        } else if (closedCallBackEvent.getActionId().equalsIgnoreCase(BTN_SORT_FIELD_IMPORT)) {
            String returnFieldNames = (String)closedCallBackEvent.getReturnData();
            if (kd.bos.util.StringUtils.isEmpty((String)returnFieldNames)) {
                return;
            }
            this.setSortField(returnFieldNames);
        } else if (closedCallBackEvent.getActionId().equalsIgnoreCase(COPY_EXIST_DATASOURCE)) {
            ListSelectedRowCollection selectRowColl = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (selectRowColl != null && !selectRowColl.isEmpty()) {
                for (ListSelectedRow selectRow : selectRowColl) {
                    Object id = selectRow.getPrimaryKeyValue();
                    if (id == null || "".equals(id)) continue;
                    this.clearAllData();
                    this.setDataFromEntityMetaCacheByDataSourceId(id.toString());
                }
            }
        } else if (closedCallBackEvent.getActionId().equalsIgnoreCase(IDE_PERMITEMSEDIT)) {
            Map permSetMap = (Map)closedCallBackEvent.getReturnData();
            if (permSetMap != null) {
                this.getPageCache().put(PERMISSION_CONTROL_VAL, SerializationUtils.toJsonString(permSetMap.get(VALUE)));
            }
        } else if (closedCallBackEvent.getActionId().equalsIgnoreCase(BOS_DEVP_EXTAPPEXTPAGE)) {
            this.openExtendQueryEntity(closedCallBackEvent);
        } else if (closedCallBackEvent.getActionId().equalsIgnoreCase(IDE_OPERATIONSELECT) && closedCallBackEvent.getReturnData() != null) {
            List operationSelectListMap = (List)closedCallBackEvent.getReturnData();
            Map operations = (Map)((Map)operationSelectListMap.get(0)).get("operations");
            this.getPageCache().put(OPERATIONS_CONTROL_VAL, SerializationUtils.toJsonString(operations.get(VALUE)));
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map param = e.getParam();
        if ("gitmsg".equals(e.getName())) {
            if (StringUtils.isNotBlank((Object)param)) {
                String gitSessionId = (String)param.get("actonResult");
                this.getPageCache().put("gitSessionId", gitSessionId);
            } else {
                this.getPageCache().put("gitSessionId", "");
            }
        }
    }

    private void openExtendQueryEntity(ClosedCallBackEvent closedCallBackEvent) {
        Map dataMap = (Map)closedCallBackEvent.getReturnData();
        if (dataMap == null) {
            return;
        }
        Boolean isSuccess = (Boolean)dataMap.get("success");
        if (isSuccess.booleanValue()) {
            JSONObject jsonObject = (JSONObject)dataMap.get("data");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cts_querydynsource");
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String queryEntityId = (String)jsonObject.get((Object)"bizpageid");
            String queryEntityNumber = MetadataDao.getNumberById((String)queryEntityId);
            showParameter.setCustomParam(QUERY_ENTITY_NUMBER, (Object)queryEntityNumber);
            showParameter.setCustomParam(QUERY_ENTITY_ID, (Object)queryEntityId);
            showParameter.setCustomParam(CURRENT_BIZ_APP_ID, jsonObject.get((Object)BIZ_APP_ID));
            showParameter.setCustomParam(CURRENT_UNIT_ID, (Object)this.getPageCache().get(CURRENT_UNIT_ID));
            this.getView().getParentView().showForm(showParameter);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        } else {
            this.getView().showErrorNotification((String)dataMap.get("message"));
        }
    }

    private void clearAllData() {
        this.getPageCache().put(QUERY_DYN_SOURCE_PLUG_IN_CACHE, null);
        if (this.getModel().getEntryRowCount(QUERY_ENTITY_ENTRY) > 0) {
            this.getModel().deleteEntryData(QUERY_ENTITY_ENTRY);
        }
        if (this.getModel().getEntryRowCount(QUERY_RELATION_ENTRY) > 0) {
            this.getModel().deleteEntryData(QUERY_RELATION_ENTRY);
        }
        if (this.getModel().getEntryRowCount(QUERY_RELATION_CONDITION_ENTRY) > 0) {
            this.getModel().deleteEntryData(QUERY_RELATION_CONDITION_ENTRY);
        }
        if (this.getModel().getEntryRowCount(QUERY_CONDITION_ENTRY) > 0) {
            this.getModel().deleteEntryData(QUERY_CONDITION_ENTRY);
        }
        if (this.getModel().getEntryRowCount(QUERY_SORT_FIELDS_ENTRY) > 0) {
            this.getModel().deleteEntryData(QUERY_SORT_FIELDS_ENTRY);
        }
        if (this.getModel().getEntryRowCount(QUERY_SELECT_FIELDS_ENTRY) > 0) {
            this.getModel().deleteEntryData(QUERY_SELECT_FIELDS_ENTRY);
        }
        if (this.getModel().getEntryRowCount(QUERY_QUERYPLUGIN_ENTRY) > 0) {
            this.getModel().deleteEntryData(QUERY_QUERYPLUGIN_ENTRY);
        }
    }

    private String assembleRelPropDisplayName(String propName, int flag) {
        String entityAlias = "";
        entityAlias = flag == 1 ? this.getCurrentSelectedChildEntityAlias() : this.getCurrentSelectedParentEntityAlias();
        String entityNumber = this.getEntityNumberByAlias(entityAlias);
        ILocaleString entityName = this.getEntityNameByAlias(entityAlias);
        String propDisplayName = propName;
        String[] propNames = kd.bos.util.StringUtils.split((String)propName, (boolean)true, (char[])new char[]{'.'});
        if (flag == 1 && propNames.length > 1 && (propNames[0].equals(entityAlias) || propNames[0].equals(entityNumber))) {
            String displayName = this.findPorpDisplayName(entityNumber, entityName, propName);
            propDisplayName = displayName + "(" + propName + ")";
        } else if (flag == 2) {
            String displayName = this.findPorpDisplayName(entityNumber, entityName, propName);
            displayName = displayName.substring(QueryDynSourcePlugIn.getSafeString(entityName).length() + 1);
            propDisplayName = displayName + "(" + propName + ")";
        }
        return propDisplayName;
    }

    private String findPorpDisplayName(String entityNumber, ILocaleString entityName, String propName) {
        String displayName = "";
        String[] propNames = kd.bos.util.StringUtils.split((String)propName, (boolean)true, (char[])new char[]{'.'});
        String fieldValue = null;
        String fieldBaseData = "";
        if (propNames.length == 0) {
            fieldValue = propName;
        } else if (propNames.length == 3) {
            fieldBaseData = propNames[propNames.length - 2];
            fieldValue = propNames[propNames.length - 1];
        } else if (propNames.length == 4) {
            fieldBaseData = propNames[propNames.length - 3];
            fieldValue = propNames[propNames.length - 2] + "." + propNames[propNames.length - 1];
        } else {
            fieldValue = propNames[propNames.length - 1];
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        String baseName = "";
        for (IDataEntityProperty dtProp : properties) {
            if (dtProp.getName().equals(fieldBaseData)) {
                baseName = dtProp.getDisplayName() != null ? dtProp.getDisplayName().toString() : dtProp.getAlias();
                displayName = this.findPropertity(fieldValue, dtProp);
                break;
            }
            if (!dtProp.getName().equals(fieldValue)) continue;
            if (dtProp.getDisplayName() != null) {
                displayName = dtProp.getDisplayName().toString();
                continue;
            }
            displayName = dtProp.getAlias();
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)baseName)) {
            displayName = baseName + "." + displayName;
        }
        displayName = QueryDynSourcePlugIn.getSafeString(entityName) + "." + displayName;
        return displayName;
    }

    private void setDataFromEntityMetaCacheByDataSourceId(String dataSourceId) {
        this.setDataFromEntityMetaCache(dataSourceId);
        this.getModel().setValue("name", (Object)(this.getModel().getValue("name").toString() + "_rpt"));
        this.getModel().setValue(NUMBER, (Object)(this.getModel().getValue(NUMBER) + "_rpt"));
    }

    private void setImportEntry(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectRowColl = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (selectRowColl != null) {
            Map bosEntityobject = BusinessDataReader.loadFromCache((Object[])selectRowColl.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"bos_entityobject", Arrays.asList(NUMBER, "name")), (boolean)false);
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(ENTITY_NAME, new Object[0]);
            vs.addField(COLUMN_ENTITY_NUMBER, new Object[0]);
            vs.addField(COLUMN_ENTITY_ALIAS, new Object[0]);
            for (ListSelectedRow selectRow : selectRowColl) {
                DynamicObject dynamicObject = (DynamicObject)bosEntityobject.get(selectRow.getPrimaryKeyValue());
                if (dynamicObject == null) continue;
                ILocaleString name = dynamicObject.getLocaleString("name");
                String number = dynamicObject.getString(NUMBER);
                vs.addRow(new Object[]{name, number, number});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(QUERY_ENTITY_ENTRY, vs);
        }
    }

    private void setSortField(String fields) {
        String[] FieldNames = fields.split(",");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("sortfieldalias", new Object[0]);
        vs.addField("sortfieldname", new Object[0]);
        vs.addField("sorttype", new Object[0]);
        DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
        for (int i = 0; i < FieldNames.length; ++i) {
            String fullFieldName = FieldNames[i];
            String[] fieldName = fullFieldName.split("\\.");
            String entityAlias = null;
            String entityNumber = null;
            String sortFieldName = "";
            String sortFiedlAlias = "";
            if (fieldName.length > 1) {
                entityAlias = fieldName[fieldName.length - 2];
                entityNumber = this.getEntityNumberByAlias(dynColl, entityAlias);
            }
            if (entityNumber == null) {
                entityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS);
                entityNumber = this.getEntityNumberByAlias(dynColl, entityAlias);
            }
            String fieldValue = null;
            fieldValue = fieldName.length == 0 ? fullFieldName : fieldName[fieldName.length - 1];
            sortFiedlAlias = fullFieldName;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty dtProp : properties) {
                if (!dtProp.getName().equals(fieldValue)) continue;
                if (dtProp.getDisplayName() != null) {
                    sortFieldName = dtProp.getDisplayName().toString();
                    break;
                }
                sortFieldName = dtProp.getAlias();
                break;
            }
            vs.addRow(new Object[]{sortFiedlAlias, sortFieldName, "asc"});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(QUERY_SORT_FIELDS_ENTRY, vs);
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    private List<String> getEntityPropList(String entityNumber, String entityAlias) {
        ArrayList<String> entityPropList = new ArrayList<String>();
        if (!kd.bos.util.StringUtils.isEmpty((String)entityNumber)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty dtProp : properties) {
                if (dtProp instanceof LongProp && ((LongProp)dtProp).isRefId()) continue;
                if (dtProp instanceof EntryProp) {
                    EntryProp entryProp = (EntryProp)dtProp;
                    IDataEntityType entryEntitytype = entryProp.getItemType();
                    DataEntityPropertyCollection entryProperties = entryEntitytype.getProperties();
                    for (IDataEntityProperty entryDtProp : entryProperties) {
                        if (entryDtProp.getName().endsWith(BASEDATA_ID) && entryDtProp instanceof LongProp) continue;
                        entityPropList.add(this.assembleEntityPropName(entityAlias, entryDtProp, dtProp.getName()));
                    }
                    continue;
                }
                entityPropList.add(this.assembleEntityPropName(entityAlias, dtProp, null));
            }
        }
        return entityPropList;
    }

    private String assembleEntityPropName(String subentityalias, IDataEntityProperty dtProp, String entryPropName) {
        String mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS);
        if (!kd.bos.util.StringUtils.isEmpty((String)mainEntityAlias) && mainEntityAlias.equals(subentityalias)) {
            if (kd.bos.util.StringUtils.isEmpty((String)entryPropName)) {
                return dtProp.getName();
            }
            return entryPropName + "." + dtProp.getName();
        }
        if (kd.bos.util.StringUtils.isEmpty((String)entryPropName)) {
            return subentityalias + "." + dtProp.getName();
        }
        return subentityalias + "." + entryPropName + "." + dtProp.getName();
    }

    private List<String> getEntityPropDidplayNameList(String entityNumber, String entityAlias) {
        ArrayList<String> entityPropList = new ArrayList<String>();
        if (!kd.bos.util.StringUtils.isEmpty((String)entityNumber)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty dtProp : properties) {
                if (dtProp instanceof EntryProp) {
                    EntryProp entryProp = (EntryProp)dtProp;
                    IDataEntityType entryEntitytype = entryProp.getItemType();
                    DataEntityPropertyCollection entryProperties = entryEntitytype.getProperties();
                    for (IDataEntityProperty entryDtProp : entryProperties) {
                        if (entryDtProp.getName().endsWith(BASEDATA_ID) && entryDtProp instanceof LongProp) continue;
                        entityPropList.add(this.assembleEntityPropDisplayName(entityAlias, entryDtProp, this.getEntityNameByAlias(entityAlias), dtProp.getDisplayName().getLocaleValue()));
                    }
                    continue;
                }
                entityPropList.add(this.assembleEntityPropDisplayName(entityAlias, dtProp, this.getEntityNameByAlias(entityAlias), null));
            }
        }
        return entityPropList;
    }

    private String assembleEntityPropDisplayName(String subentityalias, IDataEntityProperty dtProp, ILocaleString subEntityDisplayName, String entryPropDisplayName) {
        String mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS);
        String displayName = "";
        displayName = dtProp.getDisplayName() == null || kd.bos.util.StringUtils.isEmpty((String)dtProp.getDisplayName().toString()) ? dtProp.getName() : dtProp.getDisplayName().toString();
        if (!kd.bos.util.StringUtils.isEmpty((String)mainEntityAlias) && mainEntityAlias.equals(subentityalias)) {
            if (kd.bos.util.StringUtils.isEmpty((String)entryPropDisplayName)) {
                return displayName;
            }
            return entryPropDisplayName + "." + displayName;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)entryPropDisplayName)) {
            return QueryDynSourcePlugIn.getSafeString(subEntityDisplayName) + "." + displayName;
        }
        return QueryDynSourcePlugIn.getSafeString(subEntityDisplayName) + "." + entryPropDisplayName + "." + displayName;
    }

    public void cellClick(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (PARENT_ENTITY_ALIAS.equals(fieldKey) || COMBINATION_TYPE.equals(fieldKey) || CHILD_ENTITY_ALIAS.equals(fieldKey) || QUERY_RELATION_ENTRY.equals(entryGrid.getEntryKey()) && "0".equals(fieldKey)) {
            this.refreshConditionEntry();
        } else if (CONDITION_FIELD.equals(fieldKey)) {
            List<QueryEntityTreeNode> queryEntityList = this.getQueryEntityConditionRelation();
            DynamicObject mainEntityDynObj = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME);
            if (mainEntityDynObj != null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)mainEntityDynObj.getString(NUMBER));
                QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter(dt, queryEntityList);
                parameter.setIncludePKField(true);
                TreeNode entityFieldTreeNode = this.iQueryEntityParseHelper.buildBillTreeNodes(parameter, true, "");
                this.showQuerySelectFieldForm(entityFieldTreeNode, "false", CONDITION_FIELD);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u5b9e\u4f53\u3002", (String)"QueryDynSourcePlugIn_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (String)QUERY_DYN_SOURCE_PLUG_IN_9, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        } else if (CONDITION_VALUE.equals(fieldKey)) {
            List<QueryEntityTreeNode> queryEntityList = this.getQueryEntityConditionRelation();
            DynamicObject mainEntityDynObj = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME);
            if (mainEntityDynObj != null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)mainEntityDynObj.getString(NUMBER));
                QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter(dt, queryEntityList);
                parameter.setIncludePKField(true);
                TreeNode entityFieldTreeNode = QueryEntityParseHelper.buildBillTreeNodes(parameter, true, "");
                DynamicObject dynObj = this.getDynamicObjectOfSelectedEntry(QUERY_CONDITION_ENTRY);
                if (dynObj == null) {
                    throw new KDException(BosErrorCode.systemError, new Object[0]);
                }
                String conditionChildEntityField = dynObj.getString(CONDITION_VALUE);
                this.showQueryFieldModifyValForm(entityFieldTreeNode, null, null, CONDITION_VALUE, conditionChildEntityField);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u5b9e\u4f53\u3002", (String)"QueryDynSourcePlugIn_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (String)QUERY_DYN_SOURCE_PLUG_IN_9, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        } else if (RELATION_PARENT_ENTITY_PROP.equals(fieldKey) || RELATION_CONDITION_TYPE.equals(fieldKey) || RELATION_CHILD_ENTITY_PROP.equals(fieldKey)) {
            this.lockNotCurrentIsvQueryConditionElements();
        }
    }

    private void setDatatoConditionEntry() {
        this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{RELATION_CONDITION_TYPE});
        DynamicObjectCollection conditionDynColl = this.getModel().getEntryEntity(QUERY_RELATION_CONDITION_ENTRY);
        String currentParentEntityAlias = this.getCurrentSelectedParentEntityAlias();
        String currentChildEntityAlias = this.getCurrentSelectedChildEntityAlias();
        if (kd.bos.util.StringUtils.isEmpty((String)currentParentEntityAlias) || kd.bos.util.StringUtils.isEmpty((String)currentChildEntityAlias)) {
            return;
        }
        String pageCacheData = this.getPageCache().get(QUERY_DYN_SOURCE_PLUG_IN_CACHE);
        if (pageCacheData != null) {
            HashMap queryDataMap = (HashMap)SerializationUtils.fromJsonString((String)pageCacheData, Map.class);
            List conditionList = (List)queryDataMap.get(currentParentEntityAlias + SPLIT_STRING_FLAG + currentChildEntityAlias);
            if (conditionList != null) {
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField(QS_CONDITION_ROW_ID, new Object[0]);
                vs.addField(RELATION_PARENT_ENTITY_PROP, new Object[0]);
                vs.addField(RELATION_PARENT_ENTITY_PROPDISNAME, new Object[0]);
                vs.addField(RELATION_CONDITION_TYPE, new Object[0]);
                vs.addField(RELATION_CHILD_ENTITY_PROP, new Object[0]);
                vs.addField(RELATION_CHILD_ENTITY_PROPDISNAME, new Object[0]);
                this.clearDynamicObjectCollectionData(conditionDynColl);
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
                Iterator iterator = conditionList.iterator();
                while (iterator.hasNext()) {
                    LinkedHashMap stringStringLinkedHashMap;
                    LinkedHashMap joinCondMap = stringStringLinkedHashMap = (LinkedHashMap)iterator.next();
                    String childEntityNumber = this.getEntityNumberByAlias(entryEntity, currentChildEntityAlias);
                    String parentPropDisName = "";
                    parentPropDisName = ((String)joinCondMap.get(PARENT_FIELD)).startsWith(childEntityNumber) ? this.assembleRelPropDisplayName((String)joinCondMap.get(PARENT_FIELD), 1) : this.assembleRelPropDisplayName((String)joinCondMap.get(PARENT_FIELD), 2);
                    String childPropDisName = this.assembleRelPropDisplayName((String)joinCondMap.get("childField"), 1);
                    vs.addRow(new Object[]{joinCondMap.get("id"), joinCondMap.get(PARENT_FIELD), parentPropDisName, joinCondMap.get("conditionField"), joinCondMap.get("childField"), childPropDisName});
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.deleteEntryData(QUERY_RELATION_CONDITION_ENTRY);
                model.batchCreateNewEntryRow(QUERY_RELATION_CONDITION_ENTRY, vs);
            } else {
                this.clearDynamicObjectCollectionData(conditionDynColl);
            }
        }
    }

    private DynamicObject getDynamicObjectOfSelectedEntry(String entryNumber) {
        DynamicObject dynObject = null;
        int selectRowIndex = this.getModel().getEntryCurrentRowIndex(entryNumber);
        DynamicObjectCollection dynColl = this.getModel().getEntryEntity(entryNumber);
        if (selectRowIndex >= 0) {
            dynObject = (DynamicObject)dynColl.get(selectRowIndex);
        }
        return dynObject;
    }

    private void clearDynamicObjectCollectionData(DynamicObjectCollection conditionDynColl) {
        for (DynamicObject dynObj : conditionDynColl) {
            dynObj.set(QS_CONDITION_ROW_ID, null);
            dynObj.set(RELATION_PARENT_ENTITY_PROP, null);
            dynObj.set(RELATION_CONDITION_TYPE, null);
            dynObj.set(RELATION_CHILD_ENTITY_PROP, null);
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String id = null;
        String type = (String)this.getView().getFormShowParameter().getCustomParam("dsType");
        if (kd.bos.util.StringUtils.isEmpty((String)type)) {
            type = "QueryList";
        }
        String currentBizAppId = (String)this.getView().getFormShowParameter().getCustomParam(CURRENT_BIZ_APP_ID);
        String currentUnitId = (String)this.getView().getFormShowParameter().getCustomParam(CURRENT_UNIT_ID);
        if ("ReportList".equals(type)) {
            QueryDataSource queryDataSource;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{COPY_EXIST_DATASOURCE});
            currentBizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APP_ID);
            if (this.getView().getFormShowParameter().getCustomParam(VALUE) != null && (queryDataSource = this.deSerializeQueryDataSource(this.getView().getFormShowParameter().getCustomParam(VALUE).toString())) != null && queryDataSource.getDataSourceId() != null) {
                id = queryDataSource.getDataSourceId();
                this.getModel().setValue("id", (Object)id);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{COPY_EXIST_DATASOURCE});
            id = (String)this.getView().getFormShowParameter().getCustomParam(QUERY_ENTITY_ID);
            this.getModel().setValue("id", (Object)id);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)id) && kd.bos.util.StringUtils.isEmpty((String)currentUnitId)) {
            Map<String, String> appMap = this.getBizAppMap(id);
            currentUnitId = appMap.get("unitId");
        }
        this.getModel().setValue("dstype", (Object)type);
        this.getModel().setValue("currentappid", (Object)currentBizAppId);
        this.getModel().setValue(GROUP, (Object)currentUnitId);
        this.getModel().setValue(ENABLE_IMPORT, (Object)false);
        List<AppFunctionPacketElement> appFunctionPacketElements = this.iBizAppServiceHelp.getAllAppFunctionPacketsByAppID(currentBizAppId);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        ComboItem selectedComboItem = null;
        for (AppFunctionPacketElement appFunctionPacketElement : appFunctionPacketElements) {
            ComboItem item = new ComboItem();
            item.setValue(appFunctionPacketElement.getId());
            item.setCaption(appFunctionPacketElement.getName());
            items.add(item);
            if (!appFunctionPacketElement.getId().equals(currentUnitId)) continue;
            selectedComboItem = item;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)id) && !items.isEmpty()) {
            selectedComboItem = (ComboItem)items.get(0);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(GROUP);
        comboEdit.setComboItems(items);
        if (selectedComboItem != null) {
            this.getModel().setValue(GROUP, (Object)selectedComboItem.getValue());
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)id)) {
            this.setDataFromEntityMetaCache(id);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{RELATION_PARENT_ENTITY_PROP});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{RELATION_CHILD_ENTITY_PROP});
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_EXTEND});
        }
    }

    public void afterBindData(EventObject e) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        boolean type = DevportalCommonUtil.isGitManageType();
        if (type) {
            clientViewProxy.getClientLocalStorage("gitmsg");
        }
    }

    private Map<String, String> getBizAppMap(String queryEntityId) {
        String sql = "select FBIZUNITID from t_meta_bizunitrelform  where FFORMID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FFORMID", 12, (Object)queryEntityId)};
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, String> bizUnitMap = new HashMap<String, String>();
            try {
                if (rs.next()) {
                    bizUnitMap.put("unitId", rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return bizUnitMap;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
    }

    private void setDataFromEntityMetaCache(String id) {
        try {
            QueryEntity queryEntity;
            EntityMetadata metadata = (EntityMetadata)this.iMetadataDao.readMeta(id, MetaCategory.Entity);
            this.getModel().setValue(INHERIT_PATH, (Object)metadata.getInheritPath());
            this.getModel().setValue(PARENT_ID, (Object)metadata.getParentId());
            this.getModel().setValue(DEV_TYPE, (Object)metadata.getDevType());
            this.getModel().setValue(MASTER_ID, (Object)metadata.getMasterId());
            if (metadata.getItems().size() > 1) {
                try {
                    Field declaredField = EntityMetadata.class.getDeclaredField("mapKeyItems");
                    declaredField.setAccessible(true);
                    Map mapKeyItems = (Map)declaredField.get(metadata);
                    queryEntity = (QueryEntity)mapKeyItems.get(metadata.getRootEntity().getKey());
                }
                catch (IllegalAccessException | NoSuchFieldException var2) {
                    throw new RuntimeException(var2);
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4fdd\u5b58\u5143\u6570\u636e\u3002", (String)"QueryDynSourcePlugIn_17", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else {
                queryEntity = (QueryEntity)metadata.getRootEntity();
            }
            this.setMainEntity(queryEntity);
            this.convertQuerySourceJoinEntity(queryEntity);
            this.setJoinEntity(queryEntity);
            this.setJoinRelation(queryEntity);
            this.setWhereConditions(queryEntity);
            this.setQuerySelectFields(queryEntity);
            this.setQuerySortFields(queryEntity);
            this.setQueryPlugInFields(queryEntity);
            this.setPermissionInfo(queryEntity);
            this.getModel().setValue(ENABLE_IMPORT, (Object)queryEntity.getBusinessControl().isEnableImport());
            String modelType = "DynamicFormModel";
            QueryMetadataHelper.assembleOperationLang(id, queryEntity.getEntityName(), queryEntity);
            MetadataSerializer template = new MetadataSerializer(modelType);
            Map serializeToMap = template.serializeToMap((Object)queryEntity);
            this.getPageCache().put(OPERATIONS_CONTROL_VAL, SerializationUtils.toJsonString(serializeToMap.get("Operations")));
            AbstractMetadata formMetadata = this.iMetadataDao.readMeta(id, MetaCategory.Form);
            String currentIsv = ISVService.getISVInfo().getId();
            if (!formMetadata.getIsv().equals(currentIsv)) {
                this.lockAllElements(true);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{BAR_EXTEND});
            } else {
                this.lockAllElements(false);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_EXTEND});
            }
            if (!kd.bos.util.StringUtils.isEmpty((String)metadata.getParentId())) {
                this.lockNotCurrentIsvElements(id);
            }
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)BosErrorCode.metaNotFound)) {
                this.getView().showErrorNotification(e.getMessage());
            }
            throw e;
        }
    }

    private void convertQuerySourceJoinEntity(QueryEntity queryEntity) {
        if (queryEntity.getJoinRelations().isEmpty()) {
            List joinEntityList = queryEntity.getJoinEntitys();
            for (JoinEntity joinEntity : joinEntityList) {
                QuerySourceJoinRelation rel = new QuerySourceJoinRelation();
                rel.setRelEntityNumber(joinEntity.getAlias());
                rel.setEntityNumber(queryEntity.getEntityName());
                rel.setJoinType("LeftJoin");
                QSConditionRow row = new QSConditionRow();
                row.setLeftItem((QSExpr)new QSPropExpr(queryEntity.getEntityName(), joinEntity.getFKProperty()));
                row.setCompareOp("=");
                row.setRightItem((QSExpr)new QSIdentifierExpr(joinEntity.getAlias() + "." + joinEntity.getProperty()));
                rel.addCondition(row);
                queryEntity.addQuerySourceJoinRelation(rel);
            }
        }
    }

    private void setPermissionInfo(QueryEntity queryEntity) {
        this.setPermissionControl(queryEntity);
        this.setPermissionDimension(queryEntity);
        this.setPermissionItems(queryEntity);
        this.setQueryEntityPropForPermission(queryEntity);
    }

    private void setQueryEntityPropForPermission(QueryEntity queryEntity) {
        String entityId = queryEntity.getId();
        IPageCache pageCache = this.getPageCache();
        if ("2".equals(this.getModel().getValue(DEV_TYPE))) {
            entityId = this.getModel().getValue(PARENT_ID).toString();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)entityId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        List querySelectFieldList = queryEntity.getSelectFields();
        ArrayList queryFieldList = new ArrayList();
        for (QuerySelectField querySelectField : querySelectFieldList) {
            IDataEntityProperty selectFieldProp = this.iQueryEntityParseHelper.getFieldProperty(querySelectField, properties, queryEntity);
            if (selectFieldProp == null) continue;
            HashMap<String, String> fieldInfoMap = new HashMap<String, String>();
            fieldInfoMap.put(TYPE, this.getMappingFieldName(selectFieldProp.getClass().getName()));
            fieldInfoMap.put("Name", querySelectField.getDisplayName());
            fieldInfoMap.put("Key", querySelectField.getAlias());
            fieldInfoMap.put("Id", querySelectField.getId());
            queryFieldList.add(fieldInfoMap);
        }
        pageCache.put(PERMISSION_FIELD_VAL, SerializationUtils.toJsonString(queryFieldList));
    }

    private void setPermissionItems(QueryEntity queryEntity) {
        IPageCache pageCache = this.getPageCache();
        ArrayList permItemList = new ArrayList();
        List permissionItems = queryEntity.getPermissionItems();
        if (permissionItems != null) {
            for (PermissionItem permItem : permissionItems) {
                HashMap<String, String> permItemMap = new HashMap<String, String>();
                permItemMap.put("Id", permItem.getId());
                permItemMap.put("ItemId", permItem.getItemId());
                permItemMap.put("Index", permItem.getIndex());
                permItemList.add(permItemMap);
            }
        }
        pageCache.put(PERMISSION_CONTROL_VAL, SerializationUtils.toJsonString(permItemList));
    }

    private void setPermissionDimension(QueryEntity queryEntity) {
        IPageCache pageCache = this.getPageCache();
        PermissionDimension permissionDimension = queryEntity.getPermissionDimension();
        if (permissionDimension != null) {
            HashMap<String, String> permDimensionMap = new HashMap<String, String>();
            permDimensionMap.put(TYPE, "PermissionDimension");
            permDimensionMap.put("Key", "PermissionDimension");
            permDimensionMap.put("DimensionControl", permissionDimension.getDimension());
            permDimensionMap.put("DataDimensionField", permissionDimension.getDataDimensionField());
            permDimensionMap.put("DataDimension", permissionDimension.getDataDimension());
            permDimensionMap.put("DataAssistDimensionField", permissionDimension.getDataAssistDimensionField());
            permDimensionMap.put("DataAssistDimension", permissionDimension.getDataAssistDimension());
            permDimensionMap.put("PublishApps", permissionDimension.getPublishApps());
            HashMap<String, HashMap<String, String>> permDimensionValMap = new HashMap<String, HashMap<String, String>>();
            permDimensionValMap.put(VALUE, permDimensionMap);
            pageCache.put("PermissionDimension", SerializationUtils.toJsonString(permDimensionValMap));
        }
    }

    private void setPermissionControl(QueryEntity queryEntity) {
        IPageCache pageCache = this.getPageCache();
        PermissionControl permissionControl = queryEntity.getPermissionControl();
        if (permissionControl != null) {
            HashMap<String, String> permControlMap = new HashMap<String, String>();
            permControlMap.put(TYPE, "PermissionControl");
            permControlMap.put("Key", "PermissionControl");
            permControlMap.put("ControlFunction", String.valueOf(permissionControl.isControlFunction()));
            permControlMap.put("ForbidDataPerm", String.valueOf(permissionControl.isForbidDataPerm()));
            permControlMap.put("AnonymousUserControl", String.valueOf(permissionControl.isAnonymousUserControl()));
            HashMap<String, HashMap<String, String>> permControlValMap = new HashMap<String, HashMap<String, String>>();
            permControlValMap.put(VALUE, permControlMap);
            pageCache.put("PermissionControl", SerializationUtils.toJsonString(permControlValMap));
        }
    }

    private String getMappingFieldName(String propClassName) {
        String fieldTypeName = "";
        if (propClassName.endsWith("Prop")) {
            String propName = propClassName.substring(propClassName.lastIndexOf(".") + 1);
            fieldTypeName = propName.substring(0, propName.indexOf("Prop")) + "Field";
        }
        return fieldTypeName;
    }

    private void setQueryPlugInFields(QueryEntity queryEntity) {
        List queryPlugInFields = queryEntity.getQueryPlugInFields();
        if (queryPlugInFields.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("pluginname", new Object[0]);
            vs.addField("pluginstatus", new Object[0]);
            int size = queryPlugInFields.size();
            for (int i = 0; i < size; ++i) {
                QueryPlugInField queryPlugInField = (QueryPlugInField)queryPlugInFields.get(i);
                vs.addRow(new Object[]{queryPlugInField.getPluginName(), queryPlugInField.getPluginStatus()});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(QUERY_QUERYPLUGIN_ENTRY, vs);
        }
    }

    private void setWhereConditions(QueryEntity queryEntity) {
        List whereConditions = queryEntity.getWhereConditions();
        if (whereConditions.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(CONDITION_FIELD, new Object[0]);
            vs.addField("conditiontype", new Object[0]);
            vs.addField(CONDITION_VALUE, new Object[0]);
            vs.addField("conditionlogiccondition", new Object[0]);
            int size = whereConditions.size();
            for (int i = 0; i < size; ++i) {
                QSConditionRow conditionRow = (QSConditionRow)whereConditions.get(i);
                vs.addRow(new Object[]{conditionRow.getLeftItem(), conditionRow.getCompareOp(), conditionRow.getRightItem(), conditionRow.getRightParenthesis()});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(QUERY_CONDITION_ENTRY, vs);
        }
    }

    private void setQuerySortFields(QueryEntity queryEntity) {
        List selectFields = queryEntity.getQuerySortFields();
        if (selectFields.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("sortfieldalias", new Object[0]);
            vs.addField("sortfieldname", new Object[0]);
            vs.addField("sorttype", new Object[0]);
            int size = selectFields.size();
            for (int i = 0; i < size; ++i) {
                QuerySortField sortField = (QuerySortField)selectFields.get(i);
                vs.addRow(new Object[]{sortField.getAlias(), sortField.getDisplayName(), sortField.getSortType()});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(QUERY_SORT_FIELDS_ENTRY, vs);
        }
    }

    private void setQuerySelectFields(QueryEntity queryEntity) {
        List selectFields = queryEntity.getSelectFields();
        if (selectFields.size() > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(SELECT_FIELD_ENTITY_NAME, new Object[0]);
            vs.addField(SELECTFIELDENTITYNUMBER, new Object[0]);
            vs.addField(QUERY_SELECT_FIELDS_ENTRY_ID, new Object[0]);
            vs.addField(SELECT_FIELD_ALIAS, new Object[0]);
            vs.addField(SELECT_FIELD_DISPLAY_NAME, new Object[0]);
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
            for (QuerySelectField selectField : selectFields) {
                String entityAlias = this.getEntityAliasByFieldName(dynColl, selectField.getAlias());
                ILocaleString entityName = this.getEntityNameByAlias(dynColl, entityAlias);
                vs.addRow(new Object[]{entityName, entityAlias, selectField.getId(), selectField.getAlias(), selectField.getLocaleDisplayName()});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow(QUERY_SELECT_FIELDS_ENTRY, vs);
        }
    }

    private String getEntityAliasByFieldName(DynamicObjectCollection dynColl, String fieldName) {
        String[] fieldNames = fieldName.split("\\.");
        String entityAlias = null;
        DynamicObject dynObj = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME);
        String mainEntityAlias = dynObj == null ? "" : dynObj.getString(NUMBER);
        entityAlias = fieldNames.length > 1 ? fieldNames[0] : mainEntityAlias;
        ILocaleString entityNameByAlias = this.getEntityNameByAlias(dynColl, entityAlias);
        if (kd.bos.util.StringUtils.isBlank((String)QueryDynSourcePlugIn.getSafeString(entityNameByAlias))) {
            entityAlias = mainEntityAlias;
        }
        return entityAlias;
    }

    private void setMainEntity(QueryEntity queryEntity) {
        LocaleString queryEntityName = queryEntity.getName();
        String entityName = queryEntity.getEntityName();
        String entityAlias = queryEntity.getEntityAlias();
        this.getModel().setValue("name", (Object)queryEntityName);
        this.getModel().setValue(NUMBER, (Object)queryEntity.getKey());
        this.getModel().setValue(MAIN_ENTITY_NAME, (Object)entityName);
        this.getModel().setValue(MAIN_ENTITY_ALIAS, (Object)entityAlias);
        this.getModel().setValue(EDIT_ENTITY_ALIAS_NAME, (Object)queryEntity.getEditEntityAliasName());
    }

    private void setJoinEntity(QueryEntity queryEntity) {
        List joinEntities = queryEntity.getJoinEntitys();
        String entityName = queryEntity.getEntityName();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(ENTITY_NAME, new Object[0]);
        vs.addField(COLUMN_ENTITY_NUMBER, new Object[0]);
        vs.addField(COLUMN_ENTITY_ALIAS, new Object[0]);
        TableValueSetter vsRel = new TableValueSetter(new String[0]);
        vsRel.addField(QUERYSOURCE_JOIN_RELATION_ID, new Object[0]);
        vsRel.addField(PARENT_ENTITY_ALIAS, new Object[0]);
        vsRel.addField(CHILD_ENTITY_ALIAS, new Object[0]);
        vsRel.addField(COMBINATION_TYPE, new Object[0]);
        for (Object joinEntity : joinEntities) {
            String joinAlias = joinEntity.getAlias();
            String joinEntityName = joinEntity.getEntityName();
            LocaleString joinName = joinEntity.getLocaleDisplayName();
            vs.addRow(new Object[]{joinName, joinEntityName, joinAlias});
        }
        List querySourceJoinRelaList = queryEntity.getJoinRelations();
        for (QuerySourceJoinRelation querySourceJoinRela : querySourceJoinRelaList) {
            vsRel.addRow(new Object[]{querySourceJoinRela.getId(), querySourceJoinRela.getEntityNumber(), querySourceJoinRela.getRelEntityNumber(), querySourceJoinRela.getJoinType()});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(QUERY_ENTITY_ENTRY, vs);
        model.batchCreateNewEntryRow(QUERY_RELATION_ENTRY, vsRel);
    }

    private void setJoinRelation(QueryEntity queryEntity) {
        List querySourceJoinRelations = queryEntity.getJoinRelations();
        for (QuerySourceJoinRelation rel : querySourceJoinRelations) {
            String entityNumber = rel.getEntityNumber();
            String relEntityNumber = rel.getRelEntityNumber();
            List qsConditionRows = rel.getCondition();
            ArrayList<QueryCondition> conditionList = new ArrayList<QueryCondition>(10);
            for (QSConditionRow row : qsConditionRows) {
                QSPropExpr qsl;
                String leftItem = "";
                if (row.getLeftItem() instanceof QSPropExpr) {
                    qsl = (QSPropExpr)row.getLeftItem();
                    leftItem = qsl.getPropName();
                } else {
                    qsl = (QSIdentifierExpr)row.getLeftItem();
                    leftItem = qsl.getExpr();
                }
                QSIdentifierExpr qsr = (QSIdentifierExpr)row.getRightItem();
                String rightItem = qsr.getExpr();
                String compareOp = row.getCompareOp();
                QueryCondition condition = new QueryCondition(row.getId(), leftItem, compareOp, rightItem);
                conditionList.add(condition);
            }
            if (conditionList.size() == 0) continue;
            this.putRelInCacheData(entityNumber, relEntityNumber, conditionList);
        }
    }

    private void putRelInCacheData() {
        String currentParentEntityAlias = this.getCurrentSelectedParentEntityAlias();
        String currentChildEntityAlias = this.getCurrentSelectedChildEntityAlias();
        DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_RELATION_CONDITION_ENTRY);
        ArrayList<QueryCondition> conditionList = new ArrayList<QueryCondition>();
        for (DynamicObject dynObj : dynColl) {
            String qsconditionrowid = dynObj.getString(QS_CONDITION_ROW_ID);
            String parententityprop = dynObj.getString(RELATION_PARENT_ENTITY_PROP);
            String conditiontype = dynObj.getString(RELATION_CONDITION_TYPE);
            String childentityprop = dynObj.getString(RELATION_CHILD_ENTITY_PROP);
            if (parententityprop == null || conditiontype == null || childentityprop == null) continue;
            QueryCondition condition = new QueryCondition(qsconditionrowid, parententityprop, conditiontype, childentityprop);
            conditionList.add(condition);
        }
        String pageCacheData = this.getPageCache().get(QUERY_DYN_SOURCE_PLUG_IN_CACHE);
        if (pageCacheData != null) {
            LinkedHashMap queryDataMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)pageCacheData, Map.class);
            queryDataMap.put(currentParentEntityAlias + SPLIT_STRING_FLAG + currentChildEntityAlias, conditionList);
            this.getPageCache().put(QUERY_DYN_SOURCE_PLUG_IN_CACHE, SerializationUtils.toJsonString((Object)queryDataMap));
        } else {
            this.queryDataMap.put(currentParentEntityAlias + SPLIT_STRING_FLAG + currentChildEntityAlias, conditionList);
            this.getPageCache().put(QUERY_DYN_SOURCE_PLUG_IN_CACHE, SerializationUtils.toJsonString(this.queryDataMap));
        }
    }

    private void putRelInCacheData(String entityNumber, String relEntityNumber, List<QueryCondition> conditionList) {
        String pageCacheData = this.getPageCache().get(QUERY_DYN_SOURCE_PLUG_IN_CACHE);
        if (pageCacheData != null) {
            LinkedHashMap queryDataMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)pageCacheData, Map.class);
            List oldConditionList = (List)queryDataMap.get(entityNumber + SPLIT_STRING_FLAG + relEntityNumber);
            if (oldConditionList != null) {
                oldConditionList.addAll(conditionList);
                queryDataMap.put(entityNumber + SPLIT_STRING_FLAG + relEntityNumber, oldConditionList);
            } else {
                queryDataMap.put(entityNumber + SPLIT_STRING_FLAG + relEntityNumber, conditionList);
            }
            this.getPageCache().put(QUERY_DYN_SOURCE_PLUG_IN_CACHE, SerializationUtils.toJsonString((Object)queryDataMap));
        } else {
            this.queryDataMap.put(entityNumber + SPLIT_STRING_FLAG + relEntityNumber, conditionList);
            this.getPageCache().put(QUERY_DYN_SOURCE_PLUG_IN_CACHE, SerializationUtils.toJsonString(this.queryDataMap));
        }
    }

    private void setQueryFields(String fields) {
        String[] fieldNames = fields.split(",");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(SELECT_FIELD_ENTITY_NAME, new Object[0]);
        vs.addField(SELECT_FIELD_ALIAS, new Object[0]);
        vs.addField(SELECT_FIELD_DISPLAY_NAME, new Object[0]);
        vs.addField(SELECTFIELDENTITYNUMBER, new Object[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection dynamicObjectCollection = model.getEntityEntity(QUERY_SELECT_FIELDS_ENTRY);
        HashMap<String, MainEntityType> entityTypeMap = new HashMap<String, MainEntityType>(16);
        DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
        for (String fullFieldName : fieldNames) {
            FilterField filterField;
            String[] fieldName = fullFieldName.split("\\.");
            String entityAlias = null;
            String entityNumber = null;
            String fieldAlias = "";
            String displayName = "";
            AbstractMap.SimpleEntry<String, Boolean> displayNameEntry = new AbstractMap.SimpleEntry<String, Boolean>("", false);
            if (fieldName.length > 1) {
                entityAlias = fieldName[0];
                entityNumber = this.getEntityNumberByAlias(dynColl, entityAlias);
            }
            if (entityNumber == null) {
                entityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS);
                entityNumber = this.getEntityNumberByAlias(dynColl, entityAlias);
            }
            ILocaleString entityName = this.getEntityNameByAlias(dynColl, entityAlias);
            String entityFieldName = fullFieldName;
            boolean isMainEntityField = false;
            if (entityAlias != null) {
                if (fieldName.length == 1) continue;
                StringBuilder fieldValues = new StringBuilder(fieldName[1]);
                for (int cunt = 2; cunt < fieldName.length; ++cunt) {
                    fieldValues.append(".").append(fieldName[cunt]);
                }
                isMainEntityField = entityAlias.equals(this.getModel().getValue(MAIN_ENTITY_ALIAS));
                fieldAlias = isMainEntityField ? fieldValues.toString() : fullFieldName;
                entityFieldName = fieldValues.toString();
            }
            if (this.checkFieldExists(dynamicObjectCollection, fieldAlias)) continue;
            MainEntityType dataEntityType = (MainEntityType)entityTypeMap.get(entityNumber);
            if (dataEntityType == null) {
                dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                if (!(dataEntityType instanceof MainEntityType)) continue;
                entityTypeMap.put(entityNumber, dataEntityType);
            }
            if ((filterField = FilterField.create((MainEntityType)dataEntityType, (String)entityFieldName)) == null || filterField.getFieldProp() instanceof PKFieldProp && filterField.getFieldProp().getParent() instanceof EntryType) continue;
            displayName = !isMainEntityField ? QueryDynSourcePlugIn.getSafeString(entityName) + "." + filterField.getCaption() : filterField.getCaption().getLocaleValue();
            vs.addRow(new Object[]{entityName, fieldAlias, displayName, entityNumber});
        }
        model.batchCreateNewEntryRow(QUERY_SELECT_FIELDS_ENTRY, vs);
    }

    private boolean checkFieldExists(DynamicObjectCollection dynamicObjectCollection, String fieldAlias) {
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (!fieldAlias.equals(dynamicObject.get(SELECT_FIELD_ALIAS))) continue;
            return true;
        }
        return false;
    }

    private String findPropertity(String fieldValue, IDataEntityProperty dtProp) {
        String displayName = "";
        MainEntityType bdType2 = null;
        DataEntityPropertyCollection properties = null;
        if (dtProp instanceof IBasedataField) {
            IBasedataField bdProp2 = (IBasedataField)dtProp;
            bdType2 = (MainEntityType)bdProp2.getComplexType();
            properties = bdType2.getProperties();
        } else if (dtProp instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)dtProp;
            IDataEntityType entryEntitytype = entryProp.getItemType();
            properties = entryEntitytype.getProperties();
        }
        if (properties != null) {
            String[] fieldValueArray = fieldValue.split("\\.");
            String baseDataProp = fieldValueArray[0];
            for (IDataEntityProperty baseProp : properties) {
                if (fieldValueArray.length > 1 && baseProp instanceof IBasedataField && baseProp.getName().equals(baseDataProp)) {
                    String baseDataPropVal = fieldValueArray[1];
                    IBasedataField bdProp2 = (IBasedataField)baseProp;
                    bdType2 = (MainEntityType)bdProp2.getComplexType();
                    properties = bdType2.getProperties();
                    for (IDataEntityProperty endBaseProp : properties) {
                        if (!endBaseProp.getName().equals(baseDataPropVal)) continue;
                        displayName = bdProp2.getDisplayName() == null ? ((DynamicProperty)bdProp2).getAlias() : bdProp2.getDisplayName().toString();
                        String propDisplayName = endBaseProp.getDisplayName() == null ? endBaseProp.getAlias() : endBaseProp.getDisplayName().toString();
                        displayName = displayName + "." + propDisplayName;
                        return displayName;
                    }
                    continue;
                }
                if (!baseProp.getName().equals(fieldValue)) continue;
                if (baseProp.getDisplayName() != null) {
                    displayName = baseProp.getDisplayName().toString();
                    break;
                }
                displayName = baseProp.getAlias();
                break;
            }
        }
        return displayName;
    }

    private void importQuerySortField(List<QueryEntityTreeNode> queryEntityList) {
        DynamicObject mainEntityDynObj = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME);
        if (mainEntityDynObj != null) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)mainEntityDynObj.getString(NUMBER));
            QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter(dt, queryEntityList);
            parameter.setIncludePKField(true);
            TreeNode entityFieldTreeNode = QueryEntityParseHelper.buildBillTreeNodes(parameter, false, "");
            this.showQuerySelectFieldForm(entityFieldTreeNode, "true", BTN_SORT_FIELD_IMPORT);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u5b9e\u4f53\u3002", (String)"QueryDynSourcePlugIn_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (String)QUERY_DYN_SOURCE_PLUG_IN_9, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void importQuerySelectField(List<QueryEntityTreeNode> queryEntityList) {
        DynamicObject mainEntityDynObj = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME);
        if (mainEntityDynObj != null) {
            DynamicObjectCollection queryEntryList = (DynamicObjectCollection)this.getModel().getValue(QUERY_RELATION_ENTRY);
            for (DynamicObject dynamicObject : queryEntryList) {
                if (!ObjectUtils.isEmpty((Object)dynamicObject.get(CHILD_ENTITY_ALIAS)) && !ObjectUtils.isEmpty((Object)dynamicObject.get(PARENT_ENTITY_ALIAS))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5207\u6362\u81f3\u201c\u5173\u7cfb\u201d\u9875\u7b7e\uff0c\u5b8c\u5584\u5b9e\u4f53\u5173\u8054\u8bbe\u7f6e\u3002", (String)"QueryDynSourcePlugIn_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)mainEntityDynObj.getString(NUMBER));
            QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter(dt, queryEntityList);
            parameter.setIncludePKField(true);
            TreeNode entityFieldTreeNode = QueryEntityParseHelper.buildBillTreeNodes(parameter, false, "");
            this.showQuerySelectFieldForm(entityFieldTreeNode, "true", BTN_QUERY_FIELD_IMPORT);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u5b9e\u4f53\u3002", (String)"QueryDynSourcePlugIn_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (String)QUERY_DYN_SOURCE_PLUG_IN_9, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void deleteEntryRow(String entryNumber) {
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex(entryNumber);
        if (model.getEntryRowCount(entryNumber) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6267\u884c\u6570\u636e\u3002", (String)"QueryDynSourcePlugIn_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (entryNumber.equals(QUERY_ENTITY_ENTRY)) {
            String entityAlias = ((DynamicObject)model.getEntryEntity(entryNumber).get(row)).getString(COLUMN_ENTITY_ALIAS);
            this.deleteSelectFieldsEntryRows(entityAlias);
            this.deleteRelationEntryRows(entityAlias);
            this.getModel().setEntryCurrentRowIndex(QUERY_RELATION_ENTRY, 0);
            this.refreshConditionEntry();
            this.putRelInCacheData();
            model.deleteEntryRow(entryNumber, row);
        } else if (entryNumber.equals(QUERY_RELATION_ENTRY)) {
            String entityAlias = ((DynamicObject)model.getEntryEntity(entryNumber).get(row)).getString(CHILD_ENTITY_ALIAS);
            this.deleteSelectFieldsEntryRows(entityAlias);
            model.deleteEntryRow(entryNumber, row);
            this.refreshConditionEntry();
            this.putRelInCacheData();
        } else {
            model.deleteEntryRow(entryNumber, row);
            this.putRelInCacheData();
        }
    }

    private boolean deleteRelationEntryRows(String entityAlias) {
        if (kd.bos.util.StringUtils.isEmpty((String)entityAlias)) {
            return false;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection dynColl = model.getEntryEntity(QUERY_RELATION_ENTRY);
        int count = 0;
        int row = 0;
        int[] rows = new int[dynColl.size()];
        for (DynamicObject dyc : dynColl) {
            String parentAlias = dyc.getString(PARENT_ENTITY_ALIAS);
            String childAlias = dyc.getString(CHILD_ENTITY_ALIAS);
            if (entityAlias.equals(parentAlias) || entityAlias.equals(childAlias)) {
                rows[count++] = row;
            }
            ++row;
        }
        if (count > 0) {
            rows = Arrays.copyOf(rows, count);
            model.deleteEntryRows(QUERY_RELATION_ENTRY, rows);
            return true;
        }
        return false;
    }

    private boolean deleteSelectFieldsEntryRows(String entityAlias) {
        if (kd.bos.util.StringUtils.isEmpty((String)entityAlias)) {
            return false;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection dynColl = model.getEntryEntity(QUERY_SELECT_FIELDS_ENTRY);
        int count = 0;
        int row = 0;
        int[] rows = new int[dynColl.size()];
        for (DynamicObject dyc : dynColl) {
            String fieldAlias = dyc.getString(SELECT_FIELD_ALIAS);
            if (fieldAlias.indexOf(entityAlias) == 0) {
                rows[count++] = row;
            }
            ++row;
        }
        if (count > 0) {
            rows = Arrays.copyOf(rows, count);
            model.deleteEntryRows(QUERY_SELECT_FIELDS_ENTRY, rows);
            return true;
        }
        return false;
    }

    private void refreshConditionEntry() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(QUERY_RELATION_CONDITION_ENTRY);
        this.setDatatoConditionEntry();
        this.lockNotCurrentIsvQueryConditionElements();
    }

    private void assembleQueryEntityCombo() {
        String currLCId = Lang.get().toString();
        DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS);
        ComboItem mainItem = new ComboItem();
        mainItem.setValue(mainEntityAlias);
        ILocaleString entityNameByAlias = this.getEntityNameByAlias(mainEntityAlias);
        mainItem.setCaption(new LocaleString(currLCId, QueryDynSourcePlugIn.getSafeString(entityNameByAlias) + "(" + mainEntityAlias + ")"));
        items.add(mainItem);
        int size = dynColl.size();
        for (int i = 0; i < size; ++i) {
            String entityAlias = ((DynamicObject)dynColl.get(i)).getString(COLUMN_ENTITY_ALIAS);
            String entityNumber = ((DynamicObject)dynColl.get(i)).getString(COLUMN_ENTITY_NUMBER);
            ILocaleString displayName = ((DynamicObject)dynColl.get(i)).getLocaleString(ENTITY_NAME);
            if (kd.bos.util.StringUtils.isEmpty((String)entityAlias) || kd.bos.util.StringUtils.isEmpty((String)entityNumber)) continue;
            ComboItem item = new ComboItem();
            item.setValue(entityAlias);
            item.setCaption(new LocaleString(currLCId, QueryDynSourcePlugIn.getSafeString(displayName) + "(" + entityAlias + ")"));
            items.add(item);
        }
        ComboEdit subEntityfieldEditor = (ComboEdit)this.getView().getControl(CHILD_ENTITY_ALIAS);
        subEntityfieldEditor.setComboItems(items);
        ComboEdit parentEntityfieldEditor = (ComboEdit)this.getView().getControl(PARENT_ENTITY_ALIAS);
        parentEntityfieldEditor.setComboItems(items);
    }

    @NotNull
    private static String getSafeString(ILocaleString entityNameByAlias) {
        if (entityNameByAlias == null) {
            return "";
        }
        if (entityNameByAlias.toString() == null) {
            return "";
        }
        return entityNameByAlias.toString();
    }

    private String getCurrentSelectedChildEntityAlias() {
        DynamicObject dynObject = this.getEntryCurrentSelectDynamicObject(QUERY_RELATION_ENTRY);
        if (dynObject == null) {
            return "";
        }
        String childEntityAlias = dynObject.getString(CHILD_ENTITY_ALIAS);
        return childEntityAlias;
    }

    private String getCurrentSelectedParentEntityAlias() {
        DynamicObject dynObject = this.getEntryCurrentSelectDynamicObject(QUERY_RELATION_ENTRY);
        if (dynObject == null) {
            return "";
        }
        String parentEntityAlias = dynObject.getString(PARENT_ENTITY_ALIAS);
        return parentEntityAlias;
    }

    private String getEntityNumberByAlias(String entityAlias) {
        DynamicObject mainEntity;
        String mainEntityAlias;
        String entityNumber = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)entityAlias)) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString(COLUMN_ENTITY_ALIAS);
                if (!entityAlias.equals(curEntityAlias)) continue;
                entityNumber = dynObj.getString(COLUMN_ENTITY_NUMBER);
                break;
            }
        }
        if (entityNumber == null && entityAlias != null && entityAlias.equals(mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS)) && (mainEntity = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME)) != null) {
            entityNumber = mainEntity.getString(NUMBER);
        }
        return entityNumber;
    }

    private String getEntityNumberByAlias(DynamicObjectCollection dynColl, String entityAlias) {
        DynamicObject mainEntity;
        String mainEntityAlias;
        String entityNumber = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)entityAlias)) {
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString(COLUMN_ENTITY_ALIAS);
                if (!entityAlias.equals(curEntityAlias)) continue;
                entityNumber = dynObj.getString(COLUMN_ENTITY_NUMBER);
                break;
            }
        }
        if (entityNumber == null && entityAlias != null && entityAlias.equals(mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS)) && (mainEntity = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME)) != null) {
            entityNumber = mainEntity.getString(NUMBER);
        }
        return entityNumber;
    }

    private ILocaleString getEntityNameByAlias(String entityAlias) {
        DynamicObject mainEntity;
        String mainEntityAlias;
        ILocaleString entityName = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)entityAlias)) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString(COLUMN_ENTITY_ALIAS);
                if (!entityAlias.equals(curEntityAlias)) continue;
                entityName = dynObj.getLocaleString(ENTITY_NAME);
                break;
            }
        }
        if (entityName == null && entityAlias.equals(mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS)) && (mainEntity = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME)) != null) {
            entityName = mainEntity.getLocaleString("name");
        }
        return entityName;
    }

    private ILocaleString getEntityNameByAlias(DynamicObjectCollection dynColl, String entityAlias) {
        DynamicObject mainEntity;
        String mainEntityAlias;
        ILocaleString entityName = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)entityAlias)) {
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString(COLUMN_ENTITY_ALIAS);
                if (!entityAlias.equals(curEntityAlias)) continue;
                entityName = dynObj.getLocaleString(ENTITY_NAME);
                break;
            }
        }
        if (entityName == null && entityAlias.equals(mainEntityAlias = (String)this.getModel().getValue(MAIN_ENTITY_ALIAS)) && (mainEntity = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME)) != null) {
            entityName = mainEntity.getLocaleString("name");
        }
        return entityName;
    }

    public void tabSelected(TabSelectEvent evt) {
        String currentTab = evt.getTabKey();
        if ("tabqueryrelation".equals(currentTab)) {
            this.assembleQueryEntityCombo();
            EntryGrid entryGrid = (EntryGrid)this.getControl(QUERY_RELATION_ENTRY);
            entryGrid.focusCell(0, PARENT_ENTITY_ALIAS);
            this.getModel().setEntryCurrentRowIndex(QUERY_RELATION_ENTRY, 0);
            this.setDatatoConditionEntry();
            this.lockNotCurrentIsvQueryConditionElements();
        }
    }

    private List<QueryEntityTreeNode> getQueryEntityConditionRelation() {
        DynamicObjectCollection dynColl = this.getModel().getEntryEntity(QUERY_RELATION_ENTRY);
        QueryEntityTreeNode mainEntityNode = new QueryEntityTreeNode();
        mainEntityNode.setEntityAlias(this.getModel().getValue(MAIN_ENTITY_ALIAS).toString());
        DynamicObject mainEntity = (DynamicObject)this.getModel().getValue(MAIN_ENTITY_NAME);
        if (mainEntity == null) {
            return null;
        }
        mainEntityNode.setEntityNumber(mainEntity.getString(NUMBER));
        ArrayList<QueryEntityTreeNode> list = new ArrayList<QueryEntityTreeNode>();
        list.add(mainEntityNode);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
        for (DynamicObject dynObj : dynColl) {
            if (dynObj.getString(PARENT_ENTITY_ALIAS) == null) continue;
            QueryEntityTreeNode parentNode = new QueryEntityTreeNode();
            parentNode.setEntityAlias(dynObj.getString(PARENT_ENTITY_ALIAS));
            parentNode.setEntityNumber(this.getEntityNumberByAlias(entryEntity, dynObj.getString(PARENT_ENTITY_ALIAS)));
            if (!this.isContainEntityTreeNode(list, parentNode)) {
                this.addChildQueryEntityToParentQuery(dynObj, parentNode);
                list.add(parentNode);
                continue;
            }
            for (QueryEntityTreeNode entityTreeNode : list) {
                if (!entityTreeNode.getEntityAlias().equals(parentNode.getEntityAlias())) continue;
                this.addChildQueryEntityToParentQuery(dynObj, entityTreeNode);
            }
        }
        return list;
    }

    private void addChildQueryEntityToParentQuery(DynamicObject dynObj, QueryEntityTreeNode parentNode) {
        QueryEntityTreeNode childNode = new QueryEntityTreeNode();
        childNode.setEntityAlias(dynObj.getString(CHILD_ENTITY_ALIAS));
        childNode.setEntityNumber(this.getEntityNumberByAlias(dynObj.getString(CHILD_ENTITY_ALIAS)));
        childNode.setParent(parentNode);
        if (parentNode.getChildList() == null) {
            ArrayList<QueryEntityTreeNode> childList = new ArrayList<QueryEntityTreeNode>();
            parentNode.setChildList(childList);
        }
        parentNode.getChildList().add(childNode);
    }

    private boolean isContainEntityTreeNode(List<QueryEntityTreeNode> entityNodeList, QueryEntityTreeNode currentNode) {
        boolean isContain = false;
        for (QueryEntityTreeNode childNode : entityNodeList) {
            if (!currentNode.getEntityAlias().equals(childNode.getEntityAlias())) continue;
            isContain = true;
            break;
        }
        return isContain;
    }

    private void returnDataToReportPage() {
        HashMap para = new HashMap();
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
        QueryDataSource queryDataSource = new QueryDataSource();
        queryDataSource.setDataSourceId((String)this.getModel().getValue("id"));
        queryDataSource.setDataSourceName(this.getModel().getValue("name").toString());
        para.put(VALUE, this.serializeQueryDataSource(queryDataSource));
        para.put("alias", this.getModel().getValue("name").toString());
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private Map<String, Object> serializeQueryDataSource(QueryDataSource queryDataSource) {
        List<IDataEntityType> dataEntityTypes = this.getDataEntityType();
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return dcJsonSerializer.serializeToMap((Object)queryDataSource, null);
    }

    private List<IDataEntityType> getDataEntityType() {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(QueryDataSource.class));
        return dataEntityTypes;
    }

    private QueryDataSource deSerializeQueryDataSource(String jsonString) {
        List<IDataEntityType> dataEntityTypes = this.getDataEntityType();
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return (QueryDataSource)dcJsonSerializer.deserializeFromString(jsonString, null);
    }

    private void lockAllElements(boolean lock) {
        this.getView().setVisible(Boolean.valueOf(!lock), new String[]{BAR_SAVE, BAR_PERMSET, BAR_OPERATIONS_SET});
        this.getView().setEnable(Boolean.valueOf(!lock), new String[]{NUMBER, "name", MAIN_ENTITY_NAME, MAIN_ENTITY_ALIAS, EDIT_ENTITY_ALIAS_NAME, PARENT_ID, DEV_TYPE, INHERIT_PATH, MASTER_ID, "id", GROUP, ENABLE_IMPORT});
        this.getView().setEnable(Boolean.valueOf(!lock), new String[]{QUERY_QUERYPLUGIN_ENTRY, QUERY_ENTITY_ENTRY, QUERY_RELATION_ENTRY, QUERY_RELATION_CONDITION_ENTRY, QUERY_CONDITION_ENTRY, QUERY_SELECT_FIELDS_ENTRY, QUERY_SORT_FIELDS_ENTRY});
        this.getView().setVisible(Boolean.valueOf(!lock), new String[]{"advcontoolbarentity", "advcontoolbarrelation", "advcontoolbarrelationdata", "advcontoolbarcondition", "advcontoolbarselectfield", "advcontoolbarplugin", "advcontoolbarsortfield"});
    }

    private void lockNotCurrentIsvElements(String id) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{NUMBER, "name", MAIN_ENTITY_NAME, MAIN_ENTITY_ALIAS, EDIT_ENTITY_ALIAS_NAME, PARENT_ID, DEV_TYPE, INHERIT_PATH, MASTER_ID, "id", GROUP, ENABLE_IMPORT});
        List<EntityMetadata> entityMetadataList = this.getInheritMetaList(id);
        for (EntityMetadata metadata : entityMetadataList) {
            DynamicObject dyObj;
            int i;
            QueryEntity queryEntity = (QueryEntity)metadata.getRootEntity();
            DynamicObjectCollection rowData = this.getModel().getEntryEntity(QUERY_ENTITY_ENTRY);
            int size = rowData.size();
            for (i = 0; i < size; ++i) {
                dyObj = (DynamicObject)rowData.get(i);
                boolean isParentEntityAlias = this.isParentEntityAlias(queryEntity, dyObj);
                if (!isParentEntityAlias) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{COLUMN_ENTITY_ALIAS});
            }
            rowData = this.getModel().getEntryEntity(QUERY_RELATION_ENTRY);
            size = rowData.size();
            for (i = 0; i < size; ++i) {
                dyObj = (DynamicObject)rowData.get(i);
                boolean isParentJoinRela = this.isParentJoinRelation(queryEntity, dyObj);
                if (!isParentJoinRela) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{QUERYSOURCE_JOIN_RELATION_ID, PARENT_ENTITY_ALIAS, COMBINATION_TYPE, CHILD_ENTITY_ALIAS});
            }
            rowData = this.getModel().getEntryEntity(QUERY_SELECT_FIELDS_ENTRY);
            size = rowData.size();
            for (i = 0; i < size; ++i) {
                dyObj = (DynamicObject)rowData.get(i);
                boolean isParentSelectField = this.isParentSelectField(queryEntity, dyObj);
                if (!isParentSelectField) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{QUERY_SELECT_FIELDS_ENTRY_ID, SELECT_FIELD_ENTITY_NAME, SELECT_FIELD_ALIAS, SELECTFIELDENTITYNUMBER, SELECT_FIELD_ALIAS, SELECT_FIELD_DISPLAY_NAME});
            }
        }
    }

    private boolean isParentSelectField(QueryEntity queryEntity, DynamicObject dyObj) {
        if (dyObj == null) {
            return false;
        }
        List querySelectFieldList = queryEntity.getSelectFields();
        boolean isParentSelectField = false;
        for (QuerySelectField selectField : querySelectFieldList) {
            if (!selectField.getId().equals(dyObj.getString(QUERY_SELECT_FIELDS_ENTRY_ID))) continue;
            isParentSelectField = true;
            break;
        }
        return isParentSelectField;
    }

    private boolean isParentJoinRelation(QueryEntity queryEntity, DynamicObject dyObj) {
        if (dyObj == null) {
            return false;
        }
        List joinRelaList = queryEntity.getJoinRelations();
        boolean isParentJoinRela = false;
        for (QuerySourceJoinRelation joinRela : joinRelaList) {
            if (!joinRela.getId().equals(dyObj.getString(QUERYSOURCE_JOIN_RELATION_ID))) continue;
            isParentJoinRela = true;
            break;
        }
        return isParentJoinRela;
    }

    private boolean isParentEntityAlias(QueryEntity queryEntity, DynamicObject dyObj) {
        if (dyObj == null) {
            return false;
        }
        List joinEntityList = queryEntity.getJoinEntitys();
        boolean isParentEntityAlias = false;
        for (JoinEntity joinEntity : joinEntityList) {
            if (!joinEntity.getAlias().equals(dyObj.getString(COLUMN_ENTITY_ALIAS))) continue;
            isParentEntityAlias = true;
            break;
        }
        return isParentEntityAlias;
    }

    private void lockNotCurrentIsvQueryConditionElements() {
        if (!kd.bos.util.StringUtils.isEmpty((String)this.getModel().getValue(PARENT_ID).toString())) {
            String queryEntityId = (String)this.getModel().getValue("id");
            List<EntityMetadata> inheritMetaList = this.getInheritMetaList(queryEntityId);
            DynamicObjectCollection dynObjColl = this.getModel().getEntryEntity(QUERY_RELATION_CONDITION_ENTRY);
            int size = dynObjColl.size();
            for (int i = 0; i < size; ++i) {
                String qsConditionRowId = ((DynamicObject)dynObjColl.get(i)).getString(QS_CONDITION_ROW_ID);
                if (kd.bos.util.StringUtils.isEmpty((String)qsConditionRowId)) continue;
                for (EntityMetadata metadata : inheritMetaList) {
                    QueryEntity queryEntity = (QueryEntity)metadata.getRootEntity();
                    boolean isParentCondition = this.isParentConditionRow(queryEntity, qsConditionRowId);
                    if (!isParentCondition) continue;
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{QS_CONDITION_ROW_ID, RELATION_PARENT_ENTITY_PROP, RELATION_PARENT_ENTITY_PROPDISNAME, RELATION_CHILD_ENTITY_PROPDISNAME, RELATION_CHILD_ENTITY_PROP});
                }
            }
        }
    }

    private boolean isParentConditionRow(QueryEntity queryEntity, String qsConditionRowId) {
        List joinRelaList = queryEntity.getJoinRelations();
        boolean isParentCondition = false;
        block0: for (QuerySourceJoinRelation joinRela : joinRelaList) {
            List qsConditionList = joinRela.getCondition();
            for (QSConditionRow qSConditionRow : qsConditionList) {
                if (!qSConditionRow.getId().equals(qsConditionRowId)) continue;
                isParentCondition = true;
                continue block0;
            }
        }
        return isParentCondition;
    }

    private List<EntityMetadata> getInheritMetaList(String queryEntityId) {
        String[] inheritIdArray = this.getInheritIdArray(queryEntityId);
        ArrayList<EntityMetadata> inheritMeataList = new ArrayList<EntityMetadata>(10);
        for (int j = 0; j < inheritIdArray.length; ++j) {
            EntityMetadata metadata = (EntityMetadata)this.iMetadataDao.readMeta(inheritIdArray[j], MetaCategory.Entity);
            inheritMeataList.add(metadata);
        }
        return inheritMeataList;
    }

    private String[] getInheritIdArray(String queryEntityId) {
        String sql = "select finheritpath from t_meta_formdesign where FID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)queryEntityId)};
        ResultSetHandler callBackHanlder = rs -> {
            String[] inheritIdArray = null;
            try {
                if (rs.next()) {
                    String inheritPathStr = rs.getString(1);
                    inheritIdArray = inheritPathStr.split(",");
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return inheritIdArray;
        };
        return (String[])DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
    }

    class QueryCondition
    implements Serializable {
        private static final long serialVersionUID = -4598536842661975247L;
        private String id = null;
        private String parentField = null;
        private String conditionField = null;
        private String childField = null;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentField() {
            return this.parentField;
        }

        public void setParentField(String parentField) {
            this.parentField = parentField;
        }

        public String getConditionField() {
            return this.conditionField;
        }

        public void setConditionField(String conditionField) {
            this.conditionField = conditionField;
        }

        public String getChildField() {
            return this.childField;
        }

        public void setChildField(String childField) {
            this.childField = childField;
        }

        public QueryCondition(String id, String parentField, String conditionField, String childField) {
            this.id = id;
            this.parentField = parentField;
            this.conditionField = conditionField;
            this.childField = childField;
        }
    }

    static interface IQueryMetadataHelper {
        public String saveQueryMetadata(QueryDynSourcePlugIn var1, IDataModel var2);
    }

    static interface IShowFormHelper {
        public ListShowParameter createShowListForm(String var1, boolean var2, int var3, boolean var4);
    }

    static interface IQueryConfigFormHelper {
        public List<Map<String, Object>> getOperationsConfigContext(String var1, List<?> var2);
    }

    static interface IQueryServiceHelper {
        public boolean exists(String var1, QFilter[] var2);
    }

    static interface IQueryDynSourceValid {
        public List<String> pageInfoChecker(IDataModel var1, IPageCache var2);
    }

    static interface IQueryEntityParseHelper {
        public IDataEntityProperty getFieldProperty(QuerySelectField var1, DataEntityPropertyCollection var2, QueryEntity var3);

        public TreeNode buildBillTreeNodes(QueryEntityTreeBuildParameter var1, boolean var2, String var3);
    }

    static interface IMetadataDao {
        public AbstractMetadata readMeta(String var1, MetaCategory var2);
    }

    static interface IBizAppServiceHelp {
        public List<AppFunctionPacketElement> getAllAppFunctionPacketsByAppID(String var1);
    }
}

