/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.query;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.regex.Pattern;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class QueryDynSourceValid {
    private static final String NUMBER_REGEX = "[a-zA-Z0-9_]*";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public static List<String> pageInfoChecker(IDataModel dataModel, IPageCache pageCache) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> aliasRes = QueryDynSourceValid.entityAliasChecker(dataModel);
        List<String> bracketsRes = QueryDynSourceValid.checkAllEntityBrackets(dataModel);
        List<String> fieldsRes = QueryDynSourceValid.checkEntityFields(dataModel);
        List<String> pluginRes = QueryDynSourceValid.pluginChecker(dataModel);
        List<String> numberRes = QueryDynSourceValid.numberChecker((String)dataModel.getValue("number"), dataModel);
        List<String> relationRes = QueryDynSourceValid.relationChecker(dataModel, pageCache);
        result.addAll(aliasRes);
        result.addAll(bracketsRes);
        result.addAll(fieldsRes);
        result.addAll(pluginRes);
        result.addAll(numberRes);
        result.addAll(relationRes);
        return result;
    }

    public static List<String> checkAllEntityBrackets(IDataModel dataModel) {
        ArrayList<String> bracketsRes = new ArrayList<String>();
        bracketsRes.addAll(QueryDynSourceValid.bracketsChecker(dataModel, "queryrelaconditionentry", ResManager.loadKDString((String)"\u5b9e\u4f53\u5173\u8054\u6761\u4ef6\u5206\u5f55", (String)"QueryDynSourceValid_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "relaleftparenthesis", "relarightparenthesis"));
        bracketsRes.addAll(QueryDynSourceValid.bracketsChecker(dataModel, "queryconditionentry", ResManager.loadKDString((String)"\u5173\u8054\u6761\u4ef6\u5b9e\u4f53\u5206\u5f55", (String)"QueryDynSourceValid_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "conditionleftparenthesis", "conditionrightparenthesis"));
        return bracketsRes;
    }

    public static List<String> checkEntityFields(IDataModel dataModel) {
        ArrayList<String> fieldRes = new ArrayList<String>();
        fieldRes.addAll(QueryDynSourceValid.combinationFieldChecker(dataModel, "queryrelaconditionentry", ResManager.loadKDString((String)"\u5b9e\u4f53\u5173\u8054\u6761\u4ef6\u5206\u5f55", (String)"QueryDynSourceValid_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "relaparententityprop", "relaconditiontype", "relachildentityprop"));
        fieldRes.addAll(QueryDynSourceValid.combinationFieldChecker(dataModel, "queryconditionentry", ResManager.loadKDString((String)"\u5173\u8054\u6761\u4ef6\u5b9e\u4f53\u5206\u5f55", (String)"QueryDynSourceValid_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "conditionfield", "conditiontype", "conditionvalue"));
        fieldRes.addAll(QueryDynSourceValid.singleFieldChecker(dataModel, "querysortfieldentry", ResManager.loadKDString((String)"\u6392\u5e8f\u5b57\u6bb5\u5206\u5f55", (String)"QueryDynSourceValid_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "sortfieldalias"));
        fieldRes.addAll(QueryDynSourceValid.singleFieldChecker(dataModel, "queryselectfieldsentry", ResManager.loadKDString((String)"\u67e5\u8be2\u5b57\u6bb5\u9009\u62e9\u5206\u5f55", (String)"QueryDynSourceValid_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "selectfieldalias"));
        return fieldRes;
    }

    public static List<String> entityAliasChecker(IDataModel dataModel) {
        DynamicObject dyc;
        String entityAlias;
        ArrayList<String> res = new ArrayList<String>();
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        String mainEntityAlias = (String)dataModel.getValue("mainentityalias");
        aliasMap.put(mainEntityAlias, mainEntityAlias);
        DynamicObjectCollection dynColl = dataModel.getEntryEntity("queryentityentry");
        Iterator iterator = dynColl.iterator();
        while (iterator.hasNext() && !StringUtils.isEmpty((String)(entityAlias = (dyc = (DynamicObject)iterator.next()).getString("entityalias")))) {
            int countBefore = aliasMap.size();
            aliasMap.put(entityAlias, entityAlias);
            int countAfter = aliasMap.size();
            if (countAfter != countBefore) continue;
            res.add(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u522b\u540d\u91cd\u590d\u3002", (String)"QueryDynSourceValid_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityAlias));
        }
        String editAlias = (String)dataModel.getValue("editentityaliasname");
        int countBefore = aliasMap.size();
        aliasMap.put(editAlias, editAlias);
        int countAfter = aliasMap.size();
        if (countAfter != countBefore) {
            res.add(ResManager.loadKDString((String)"\u7f16\u8f91\u5b9e\u4f53\u7684\u522b\u540d\u5fc5\u987b\u662f\u5b58\u5728\u5b9e\u4f53\u7684\u522b\u540d\u3002", (String)"QueryDynSourceValid_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        return res;
    }

    public static List<String> bracketsChecker(IDataModel dataModel, String entityNumber, String entityName, String left, String right) {
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder brackets = new StringBuilder();
        Stack<Character> stack = new Stack<Character>();
        DynamicObjectCollection dynColl = dataModel.getEntryEntity(entityNumber);
        for (DynamicObject dyc : dynColl) {
            if (dyc.getString(left) != null) {
                brackets.append(dyc.getString(left));
            }
            if (dyc.getString(right) == null) continue;
            brackets.append(dyc.getString(right));
        }
        for (int i = 0; i < brackets.length(); ++i) {
            char bracket = brackets.charAt(i);
            if (bracket == '(') {
                stack.push(Character.valueOf(bracket));
                continue;
            }
            if (bracket != ')') continue;
            if (stack.isEmpty()) {
                res.add(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u62ec\u53f7\u4e0d\u5339\u914d\u3002", (String)"QueryDynSourceValid_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityName));
                break;
            }
            stack.pop();
        }
        if (res.size() == 0 && !stack.isEmpty()) {
            res.add(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u62ec\u53f7\u4e0d\u5339\u914d\u3002", (String)"QueryDynSourceValid_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityName));
        }
        return res;
    }

    public static List<String> combinationFieldChecker(IDataModel dataModel, String entityNumber, String entityName, String ... fields) {
        ArrayList<String> res = new ArrayList<String>();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        DynamicObjectCollection dynColl = dataModel.getEntryEntity(entityNumber);
        for (DynamicObject dyc : dynColl) {
            StringBuilder val = new StringBuilder();
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                if (dyc.getString(field) == null || " ".equals(dyc.getString(field))) continue;
                val.append(dyc.getString(field));
            }
            if (StringUtils.isEmpty((String)val.toString())) continue;
            int countBefore = fieldMap.size();
            fieldMap.put(val.toString(), val.toString());
            int countAfter = fieldMap.size();
            if (countAfter != countBefore) continue;
            res.add(String.format(ResManager.loadKDString((String)"%s\u6709\u91cd\u590d\u6761\u4ef6\u3002", (String)"QueryDynSourceValid_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityName));
        }
        return res;
    }

    public static List<String> singleFieldChecker(IDataModel dataModel, String entityNumber, String entityName, String field) {
        ArrayList<String> res = new ArrayList<String>();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        DynamicObjectCollection dynColl = dataModel.getEntryEntity(entityNumber);
        for (DynamicObject dyc : dynColl) {
            String val = dyc.getString(field);
            if (StringUtils.isEmpty((String)val)) continue;
            int countBefore = fieldMap.size();
            fieldMap.put(val, val);
            int countAfter = fieldMap.size();
            if (countAfter != countBefore) continue;
            res.add(String.format(ResManager.loadKDString((String)"%s\u91cd\u590d\u5b57\u6bb5/\u522b\u540d\u3002", (String)"QueryDynSourceValid_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), entityName));
            break;
        }
        return res;
    }

    public static List<String> pluginChecker(IDataModel dataModel) {
        ArrayList<String> res = new ArrayList<String>();
        DynamicObjectCollection dynColl = dataModel.getEntryEntity("querypluginentry");
        for (DynamicObject dyc : dynColl) {
            String plugin = dyc.getString("pluginname");
            boolean enable = dyc.getBoolean("pluginstatus");
            if (!enable || !StringUtils.isEmpty((String)plugin)) continue;
            res.add(ResManager.loadKDString((String)"\u63d2\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryDynSourceValid_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            break;
        }
        return res;
    }

    public static List<String> numberChecker(String number, IDataModel dataModel) {
        ArrayList<String> res = new ArrayList<String>();
        String sql = String.format("select 1 from %s where FNUMBER = ? AND FID != ?", "T_META_ENTITYDESIGN");
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)number), new SqlParameter(":FID", 12, dataModel.getValue("id"))};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getInt(1) > 0;
                }
                return false;
            }
        };
        boolean numberRes = (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
        if (numberRes) {
            res.add(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d", (String)"QueryDynSourceValid_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        } else if (!number.matches(NUMBER_REGEX)) {
            res.add(ResManager.loadKDString((String)"\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u3002", (String)"QueryDynSourceValid_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        return res;
    }

    public static List<String> relationChecker(IDataModel dataModel, IPageCache pageCache) {
        ArrayList<String> res = new ArrayList<String>();
        DynamicObjectCollection dynColl = dataModel.getEntryEntity("queryrelationenrtry");
        for (DynamicObject dyc : dynColl) {
            String parentAlias = dyc.getString("parententityalias");
            String childAlias = dyc.getString("childentityalias");
            String pageCacheData = pageCache.get("QueryDynSourcePlugInCache");
            if (pageCacheData != null) {
                HashMap queryDataMap = (HashMap)SerializationUtils.fromJsonString((String)pageCacheData, Map.class);
                List conditionList = (List)queryDataMap.get(parentAlias + ":" + childAlias);
                if (conditionList == null || conditionList.size() <= 0) {
                    res.add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u3001\u201c%2$s\u201d\u3001\u201c%3$s\u201d\u672a\u8bbe\u7f6e\u5173\u8054\u6761\u4ef6\u3002", (String)"QueryDynSourceValid_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), parentAlias, ":", childAlias));
                    continue;
                }
                int size = conditionList.size();
                for (int i = 0; i < size; ++i) {
                    LinkedHashMap joinCondMap = (LinkedHashMap)conditionList.get(i);
                    String parentField = (String)joinCondMap.get("parentField");
                    String childField = (String)joinCondMap.get("childField");
                    String[] parentPropNames = StringUtils.split((String)parentField, (boolean)true, (char[])new char[]{'.'});
                    String[] childPropNames = StringUtils.split((String)childField, (boolean)true, (char[])new char[]{'.'});
                    if (parentPropNames.length > 3 || childPropNames.length > 3) {
                        res.add(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5173\u8054\u6761\u4ef6\u7b2c%s\u884c\uff1a\u5173\u8054\u5c5e\u6027\u5c42\u7ea7\u8d85\u8fc73\u5c42\uff0c\u4e0d\u5141\u8bb8\u5173\u8054\u3002", (String)"QueryDynSourceValid_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                    }
                    if (QueryDynSourceValid.checkFieldProp(parentField, parentAlias, childField, childAlias, dataModel, i, res, (String)joinCondMap.get("conditionField"))) continue;
                    if (i == 0) {
                        res.add(ResManager.loadKDString((String)"\u5b9e\u4f53\u5173\u8054\u6761\u4ef6\u7b2c1\u884c\uff1a\u5173\u8054\u5c5e\u6027\u53ea\u652f\u6301id\u6216\u8005\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u5b57\u6bb5\u3002", (String)"QueryDynSourceValid_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                        continue;
                    }
                    res.add(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5173\u8054\u6761\u4ef6\u7b2c%s\u884c\uff1a\u5173\u8054\u5c5e\u6027\u7c7b\u578b\u4e0e\u503c\u4e0d\u5339\u914d\u3002", (String)"QueryDynSourceValid_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                }
                continue;
            }
            res.add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u3001\u201c%2$s\u201d\u3001\u201c%3$s\u201d\u672a\u8bbe\u7f6e\u5173\u8054\u6761\u4ef6\u3002", (String)"QueryDynSourceValid_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), parentAlias, ":", childAlias));
        }
        return res;
    }

    private static boolean checkFieldProp(String parentField, String parentAlias, String childField, String childAlias, IDataModel dataModel, int line, List<String> message, String conditionField) {
        String childentityNumber = QueryDynSourceValid.getEntityNumberByAlias(childAlias, dataModel);
        Optional<String> first = Arrays.stream(parentField.split("\\.")).findFirst();
        if (first.isPresent() && first.get().equals(childentityNumber)) {
            parentAlias = childAlias;
        }
        IDataEntityProperty parentProp = QueryDynSourceValid.getFieldProp(parentField, parentAlias, dataModel);
        IDataEntityProperty childProp = QueryDynSourceValid.getFieldProp(childField, childAlias, dataModel);
        if (line == 0 && QueryDynSourceValid.enableFieldProp(parentProp) && QueryDynSourceValid.enableFieldProp(childProp)) {
            return true;
        }
        if (line > 0) {
            if (Objects.nonNull(parentProp) && Objects.nonNull(childProp) && parentProp.getPropertyType().equals(childProp.getPropertyType())) {
                return true;
            }
            if (Objects.nonNull(parentProp) && Objects.isNull(childProp)) {
                if ((conditionField.equals("like") || conditionField.equals("not like")) && !parentProp.getPropertyType().equals(String.class) && !parentProp.getPropertyType().getSimpleName().endsWith("String")) {
                    message.add(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5173\u8054\u6761\u4ef6\u7b2c%s\u884c\uff1a\u975e\u5b57\u7b26\u4e32\u7c7b\u578b\u4e0d\u80fd\u4f7f\u7528\u5305\u542b\u6761\u4ef6", (String)"QueryDynSourceValid_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), line + 1));
                }
                return QueryDynSourceValid.validateProperty(parentProp, childField);
            }
            return false;
        }
        return false;
    }

    private static boolean validateProperty(IDataEntityProperty parentProp, String childField) {
        String[] childFieldValues = StringUtils.split((String)childField, (boolean)true, (char[])new char[]{','});
        for (int i = 0; i < childFieldValues.length; ++i) {
            for (ValidateType validateType : ValidateType.values()) {
                if (validateType.getValidateName().equals(parentProp.getPropertyType())) {
                    return ValidateType.validate(validateType, childFieldValues[i]);
                }
                if (!parentProp.getPropertyType().equals(DynamicObject.class) || !(parentProp instanceof BasedataProp)) continue;
                BasedataProp parentBasedataProp = (BasedataProp)parentProp;
                if (parentBasedataProp.getRefIdProp().getPropertyType().getSimpleName().equalsIgnoreCase("long")) {
                    return Pattern.matches(ValidateType.LONG_TYPE.getValidateRules(), childFieldValues[i]);
                }
                return !Pattern.matches(ValidateType.STRING_TYPE.getValidateRules(), childFieldValues[i]);
            }
        }
        return true;
    }

    private static <T> boolean enableFieldProp(T t) {
        return t instanceof BasedataProp || t instanceof LongProp || t instanceof BigIntProp || t instanceof TextProp || t instanceof VarcharProp;
    }

    private static IDataEntityProperty getFieldProp(String field, String fieldAlias, IDataModel dataModel) {
        String[] propNames = StringUtils.split((String)field, (boolean)true, (char[])new char[]{'.'});
        String fieldValue = null;
        fieldValue = propNames.length == 0 ? field : propNames[propNames.length - 1];
        String entityNumber = QueryDynSourceValid.getEntityNumberByAlias(fieldAlias, dataModel);
        if (StringUtils.isEmpty((String)entityNumber)) {
            return null;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty dtProp : properties) {
            if (dtProp instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)dtProp;
                IDataEntityType entryEntitytype = entryProp.getItemType();
                DataEntityPropertyCollection entryProperties = entryEntitytype.getProperties();
                for (IDataEntityProperty entryDtProp : entryProperties) {
                    if (entryDtProp.getName().equals(fieldValue)) {
                        return entryDtProp;
                    }
                    if (!dtProp.getName().equals(fieldValue)) continue;
                    return dtProp;
                }
                continue;
            }
            if (!dtProp.getName().equals(fieldValue)) continue;
            return dtProp;
        }
        return null;
    }

    private static String getEntityNumberByAlias(String entityAlias, IDataModel dataModel) {
        DynamicObject mainEntity;
        String mainEntityAlias;
        String entityNumber = null;
        if (!StringUtils.isEmpty((String)entityAlias)) {
            DynamicObjectCollection dynColl = dataModel.getEntryEntity("queryentityentry");
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString("entityalias");
                if (!entityAlias.equals(curEntityAlias)) continue;
                entityNumber = dynObj.getString("entitynumber");
                break;
            }
        }
        if (entityNumber == null && entityAlias != null && (mainEntityAlias = (String)dataModel.getValue("mainentityalias")) != null && entityAlias.equals(mainEntityAlias) && (mainEntity = (DynamicObject)dataModel.getValue("mainentityname")) != null) {
            entityNumber = mainEntity.getString("number");
        }
        return entityNumber;
    }

    private static enum ValidateType {
        DATE_TYPE("\\d\\d\\d\\d-\\d\\d-\\d\\d*", Date.class),
        BIG_DECIMAL_TYPE("^[0-9]+(.[0-9]{2})?$", BigDecimal.class),
        INTEGER_TYPE("^-?\\d+$", Integer.class),
        LONG_TYPE("^-?\\d+$", Long.class),
        I_LOCALE_STRING_TYPE("", ILocaleString.class),
        STRING_TYPE("\\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|;|\\+)", String.class);

        private Class<?> validateName;
        private String validateRules;

        private ValidateType(String validateRules, Class<?> validateName) {
            this.validateName = validateName;
            this.validateRules = validateRules;
        }

        public Class<?> getValidateName() {
            return this.validateName;
        }

        private void setValidateName(Class<?> validateName) {
            this.validateName = validateName;
        }

        public String getValidateRules() {
            return this.validateRules;
        }

        private void setValidateRules(String validateRules) {
            this.validateRules = validateRules;
        }

        public static boolean validate(ValidateType validateType, String childField) {
            if (validateType.validateName.equals(String.class) || validateType.validateName.equals(ILocaleString.class)) {
                if (!childField.endsWith("'") || !childField.startsWith("'")) {
                    return false;
                }
                return !Pattern.matches(STRING_TYPE.getValidateRules(), childField);
            }
            return Pattern.matches(validateType.validateRules, childField);
        }
    }
}

