/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.designer.query.QueryConfigFormHelper;
import kd.bos.designer.query.QueryDynSourcePlugIn;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QueryPlugInField;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySortField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.mulentities.expr.QSExpr;
import kd.bos.entity.mulentities.expr.QSIdentifierExpr;
import kd.bos.entity.mulentities.expr.QSPropExpr;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.operate.OperationTypes;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IPageCache;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.BusinessControl;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.ReportQueryEntity;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ToolbarAp;
import kd.bos.metadata.perm.PermissionControl;
import kd.bos.metadata.perm.PermissionDimension;
import kd.bos.metadata.perm.PermissionItem;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class QueryMetadataHelper {
    private static final String EXPORTLISTBYSELECTFIELDS = "exportlistbyselectfields";
    public static final String ENTITY_SPLIST_PLAG = ".";
    public static final String ISV_KINGDEE = "kingdee";
    private static final String MODIFY = "modify";
    private static final String DELETE = "delete";
    private static final String SUBMIT = "submit";
    private static final String AUDIT = "audit";
    private static final String UN_AUDIT = "unaudit";
    private static final String REFRESH = "refresh";
    private static final String UN_SUBMIT = "unsubmit";
    private static final String DISABLE = "disable";
    private static final String ENABLE = "enable";
    private static final String EXPORT_LIST = "exportlist";
    private static final String IMPORT_DATA = "importdata";
    private static final String PRINT_PREVIEW = "printpreview";
    private static final String PRINT_SETTING = "printsetting";
    private static final String CLOSE = "close";
    private static final String[] INNER_OPERATION_KEYS = new String[]{"new", "copy", "modify", "delete", "submit", "audit", "unaudit", "refresh", "unsubmit", "disable", "enable", "exportlist", "importdata", "printpreview", "printsetting", "close", "save", "submitandnew", "exportlistbyselectfields", "view", "first", "previous", "next", "last"};
    private static final String MAIN_ENTITY_NAME = "mainentityname";
    private static final String NUMBER = "number";
    private static final String PARENT_ID = "parentid";
    private static final String REPORT_LIST = "ReportList";
    private static final String DS_TYPE = "dstype";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String MAIN_ENTITY_ALIAS = "mainentityalias";
    private static final String OPERATIONS = "Operations";
    private static final String ANONYMOUS_USER_CONTROL = "AnonymousUserControl";
    private static final String CONTROL_FUNCTION = "ControlFunction";
    private static final String FORBID_DATA_PERM = "ForbidDataPerm";
    private static final String SELECT_FIELD_ALIAS = "selectfieldalias";
    private static final String ZH_CN = "zh_CN";
    private static Log log = LogFactory.getLog(QueryMetadataHelper.class);

    private static String getParallelInheritCountByIsv(String appId, String formNumber, String parentId, String type) {
        String currentIsv = ISVService.getISVInfo().getId();
        QFilter qParentFilter = new QFilter(parentId, "=", (Object)appId);
        qParentFilter.or("id", "=", (Object)appId);
        qParentFilter.and("type", "=", (Object)type);
        QFilter qIsv = new QFilter("isv", "=", (Object)currentIsv);
        if (ISV_KINGDEE.equalsIgnoreCase(currentIsv)) {
            QFilter qIsvNull = new QFilter("isv", "is null", (Object)Boolean.TRUE);
            qIsvNull = qIsvNull.or("isv", "=", (Object)" ");
            qIsv = qIsv.or(qIsvNull);
        }
        QFilter[] filters = new QFilter[]{qParentFilter, qIsv};
        String countNmuber = "0";
        if (QueryServiceHelper.exists((String)formNumber, (QFilter[])filters)) {
            countNmuber = "1";
        }
        return countNmuber;
    }

    private void validate(IDataModel dataModel) {
        if (StringUtils.isBlank((String)dataModel.getValue(NUMBER).toString())) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryMetadataHelper_17", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))});
        }
        if (StringUtils.isBlank((String)dataModel.getValue("name").toString())) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryMetadataHelper_18", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))});
        }
        if (StringUtils.isBlank((String)dataModel.getValue("mainentityname_id").toString())) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"\u4e3b\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryMetadataHelper_19", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))});
        }
        if (StringUtils.isBlank((String)dataModel.getValue(MAIN_ENTITY_ALIAS).toString())) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"\u4e3b\u5b9e\u4f53\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryMetadataHelper_20", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))});
        }
        if (StringUtils.isBlank((String)dataModel.getValue("editentityaliasname").toString())) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9e\u4f53\u522b\u540d\u3002", (String)"QueryMetadataHelper_21", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String saveQueryMetadata(QueryDynSourcePlugIn plugIn, IDataModel dataModel) {
        this.validate(dataModel);
        try (TXHandle h = TX.required();){
            String newId;
            FormMetadata formMeta;
            IFormTemplate template;
            String modelType;
            Object queryEntity;
            EntityMetadata entityMeta;
            String currentAppId;
            block26: {
                String id;
                block25: {
                    String countNumber;
                    currentAppId = this.getCurrentAppId(dataModel);
                    String currentIsv = ISVService.getISVInfo().getId();
                    DynamicObject mainEntity = (DynamicObject)dataModel.getValue(MAIN_ENTITY_NAME);
                    String mainEntityId = MetadataDao.getIdByNumber((String)mainEntity.getString(NUMBER), (MetaCategory)MetaCategory.Entity);
                    AbstractMetadata formMetadata = MetadataDao.readMeta((String)mainEntityId, (MetaCategory)MetaCategory.Form);
                    if (!formMetadata.getIsv().equals(currentIsv) && "0".equals(countNumber = QueryMetadataHelper.getParallelInheritCountByIsv(currentAppId, "bos_devportal_bizapp", PARENT_ID, "2"))) {
                        String extAppId = DBServiceHelper.genStringId();
                        BizAppServiceHelp.createExtAppMetadata((String)currentAppId, (String)extAppId);
                        currentAppId = extAppId;
                    }
                    id = (String)plugIn.getView().getModel().getValue("id");
                    entityMeta = null;
                    queryEntity = null;
                    queryEntity = REPORT_LIST.equals(dataModel.getValue(DS_TYPE)) ? new ReportQueryEntity() : new QueryEntity();
                    modelType = "QueryListModel";
                    template = FormTemplateFactory.createTemplate(modelType);
                    if (!StringUtils.isEmpty((String)id)) break block25;
                    if (REPORT_LIST.equals(dataModel.getValue(DS_TYPE))) {
                        modelType = "ReportQueryListModel";
                    }
                    formMeta = template.getFormMetadata();
                    newId = DB.genStringId((String)(REPORT_LIST.equals(dataModel.getValue(DS_TYPE)) ? "ReportQueryListModel" : "QueryListModel"));
                    formMeta.setId(newId);
                    formMeta.setMasterId(dataModel.getValue("masterid").toString());
                    formMeta.setParentId(dataModel.getValue(PARENT_ID).toString());
                    formMeta.setInheritPath(dataModel.getValue("inheritpath").toString());
                    formMeta.setDevType(dataModel.getValue("devtype").toString());
                    formMeta.setIsv(currentIsv);
                    formMeta.setBizappId(currentAppId);
                    formMeta.setEntityId(formMeta.getId());
                    formMeta.setModelType(modelType);
                    ControlAp toolbarApObj = formMeta.getItem("_toolbar_");
                    if (toolbarApObj != null) {
                        ToolbarAp toolbarAp = (ToolbarAp)toolbarApObj;
                        if (toolbarAp.getItems().isEmpty()) {
                            List<BarItemAp> createBarItems = QueryMetadataHelper.createBarItems("_toolbar_");
                            for (BarItemAp barItemAp : createBarItems) {
                                formMeta.getItems().add(barItemAp);
                            }
                            break block26;
                        } else if (StringUtils.isNotEmpty((String)formMeta.getParentId())) {
                            toolbarAp.getItems().clear();
                        }
                    }
                    break block26;
                }
                newId = id;
                formMeta = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
                EntityMetadata abstractMetadata = (EntityMetadata)MetadataDao.readMeta((String)(!"".equals(dataModel.getValue(PARENT_ID)) ? dataModel.getValue(PARENT_ID).toString() : id), (MetaCategory)MetaCategory.Entity);
                if (abstractMetadata != null) {
                    queryEntity.setPkId(abstractMetadata.getRootEntity().getPkId());
                }
            }
            String key = dataModel.getValue(NUMBER).toString();
            formMeta.setKey(key);
            OrmLocaleValue name = (OrmLocaleValue)dataModel.getValue("name");
            formMeta.setName(LocaleString.fromMap((Map)name));
            this.assembleQueryEntity(plugIn, dataModel, (QueryEntity)queryEntity);
            entityMeta = this.assembleEntityMetadata(formMeta.getId(), template.getEntityMetadata(), (QueryEntity)queryEntity, dataModel, currentAppId);
            entityMeta.setMasterId(dataModel.getValue("masterid").toString());
            entityMeta.setParentId(dataModel.getValue(PARENT_ID).toString());
            entityMeta.setInheritPath(dataModel.getValue("inheritpath").toString());
            entityMeta.setDevType(dataModel.getValue("devtype").toString());
            String envRegion = DevportalCommonUtil.genEnvRegion();
            formMeta.setEnvRegion(envRegion);
            entityMeta.setEnvRegion(envRegion);
            formMeta.bindEntityMetadata(entityMeta);
            BusinessControl businessControl = new BusinessControl();
            Boolean enableImport = (Boolean)dataModel.getValue("enableimport");
            businessControl.setEnableImport(enableImport.booleanValue());
            queryEntity.setBusinessControl(businessControl);
            MetadataWriter writer = new MetadataWriter(modelType);
            Map saveResult = writer.save(new AbstractMetadata[]{entityMeta, formMeta});
            boolean isSuccess = (Boolean)saveResult.get("success");
            if (isSuccess) {
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
                dObject.set("bizapp", (Object)currentAppId);
                dObject.set("bizunit", dataModel.getValue("group"));
                dObject.set("form", (Object)newId);
                DeleteServiceHelper.delete((String)"bos_devportal_unitrelform", (QFilter[])new QFilter[]{new QFilter("form", "=", (Object)newId)});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
                plugIn.getView().getModel().setValue("id", (Object)newId);
            }
            String string = newId;
            return string;
        }
        catch (KDException e) {
            throw e;
        }
        catch (OrmException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("Error:%s.", e.getMessage())});
        }
    }

    private EntityMetadata assembleEntityMetadata(String formMetaId, EntityMetadata entityMeta, QueryEntity queryEntity, IDataModel dataModel, String currentAppId) {
        if (!entityMeta.getItems().isEmpty()) {
            entityMeta.getItems().clear();
        }
        entityMeta.getItems().add(queryEntity);
        entityMeta.setId(formMetaId);
        String key = dataModel.getValue(NUMBER).toString();
        entityMeta.setKey(key);
        OrmLocaleValue name = (OrmLocaleValue)dataModel.getValue("name");
        entityMeta.setName(LocaleString.fromMap((Map)name));
        entityMeta.getRootEntity().setKey(key);
        entityMeta.setBizappId(currentAppId);
        DynamicObject bizAppDynObj = BusinessDataServiceHelper.loadSingle((Object)currentAppId, (String)"bos_devportal_bizapp", (String)"industry,dbroute");
        if (bizAppDynObj == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format("Error:%s", ResManager.loadKDString((String)"bizappid\u4e3a\u7a7a\u3002", (String)"QueryMetadataHelper_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]))});
        }
        String dbRoute = bizAppDynObj.getString("dbroute");
        entityMeta.getRootEntity().setdbRoute(dbRoute);
        return entityMeta;
    }

    private QueryEntity assembleQueryEntity(QueryDynSourcePlugIn plugIn, IDataModel dataModel, QueryEntity queryEntity) {
        DynamicObject mainEntityDynObj = (DynamicObject)dataModel.getValue(MAIN_ENTITY_NAME);
        String mainEntityName = mainEntityDynObj.getString(NUMBER);
        queryEntity.setEntityName(mainEntityName);
        String mainEntityAlias = (String)dataModel.getValue(MAIN_ENTITY_ALIAS);
        queryEntity.setIncludeFieldNames(this.getQueryFields(dataModel, mainEntityName));
        queryEntity.setEditEntityAliasName((String)dataModel.getValue("editentityaliasname"));
        queryEntity.setEntityAlias(mainEntityAlias);
        DynamicObjectCollection dynColl = dataModel.getEntryEntity("queryrelationenrtry");
        for (DynamicObject dynObj : dynColl) {
            JoinEntity joinEntity = this.assembleJoinEntity(dynObj, dataModel);
            if (joinEntity == null) continue;
            queryEntity.getJoinEntitys().add(joinEntity);
            String pageCacheData = plugIn.getPageCache().get("QueryDynSourcePlugInCache");
            if (pageCacheData == null) continue;
            String childEntityAlias = dynObj.getString("childentityalias");
            LinkedHashMap queryDataMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)pageCacheData, Map.class);
            List queryConditions = (List)queryDataMap.get(mainEntityAlias + ":" + childEntityAlias);
            int cunt = 0;
            QuerySourceJoinRelation rel = new QuerySourceJoinRelation();
            rel.setId(dynObj.getString("querysourcejoinrelationid"));
            rel.setRelEntityNumber(childEntityAlias);
            rel.setEntityNumber(mainEntityName);
            rel.setJoinType(dynObj.getString("combinationtype"));
            if (queryConditions == null) continue;
            for (LinkedHashMap joinCondMap : queryConditions) {
                String qSConditionRowId = (String)joinCondMap.get("qsconditionrowid");
                String parentField = (String)joinCondMap.get("parentField");
                String conditionField = (String)joinCondMap.get("conditionField");
                String childField = (String)joinCondMap.get("childField");
                if (cunt == 0) {
                    joinEntity.setProperty(this.getSubEntityPropertyString(childField));
                    joinEntity.setFKProperty(parentField);
                    ++cunt;
                }
                QSConditionRow row = new QSConditionRow();
                row.setId(qSConditionRowId);
                row.setLeftItem((QSExpr)new QSIdentifierExpr(parentField));
                row.setCompareOp(conditionField);
                row.setRightItem((QSExpr)new QSIdentifierExpr(childField));
                row.setLogicOp("and");
                rel.addCondition(row);
            }
            queryEntity.addQuerySourceJoinRelation(rel);
        }
        this.assembleWhereCondition(dataModel, queryEntity, mainEntityName);
        this.assembleSelectFields(dataModel, queryEntity);
        this.assembleSortFields(dataModel, queryEntity);
        this.assembleQueryPlugInFields(dataModel, queryEntity);
        this.assemblePermissionSetting(plugIn, queryEntity);
        this.assembleOperationsSetting(plugIn, queryEntity, mainEntityName);
        return queryEntity;
    }

    private void assembleOperationsSetting(QueryDynSourcePlugIn plugIn, QueryEntity queryEntity, String mainEntityName) {
        ArrayList<Map> operationListMap;
        IPageCache pageCache = plugIn.getPageCache();
        List curPermList = plugIn.getPageCache().get("permission_control_val") != null ? (List)SerializationUtils.fromJsonString((String)plugIn.getPageCache().get("permission_control_val"), List.class) : new ArrayList();
        String queryFormId = MetadataDao.getIdByNumber((String)mainEntityName, (MetaCategory)MetaCategory.Form);
        if (pageCache.get("operations_control_val") != null) {
            operationListMap = (ArrayList<Map>)SerializationUtils.fromJsonString((String)pageCache.get("operations_control_val"), List.class);
        } else {
            List<Map<String, Object>> editParamList = QueryConfigFormHelper.getEditParamList(queryFormId);
            operationListMap = new ArrayList<Map>();
            List entityOperationList = (List)editParamList.get(0).get(OPERATIONS);
            List permissionItemsList = (List)editParamList.get(0).get("PermissionItems");
            if (entityOperationList != null) {
                List<String> innerOperationKeysList = Arrays.asList(INNER_OPERATION_KEYS);
                ArrayList<String> innerPermissionKeysList = new ArrayList<String>();
                for (Map operation : entityOperationList) {
                    if (!innerOperationKeysList.contains(operation.get("OperationType"))) continue;
                    operationListMap.add(operation);
                    innerPermissionKeysList.add((String)operation.get("PermissionItemId"));
                }
                if (permissionItemsList != null) {
                    for (Map permMap : permissionItemsList) {
                        if (!innerPermissionKeysList.contains(permMap.get("ItemId"))) continue;
                        curPermList.add(permMap);
                    }
                }
            }
        }
        HashMap<String, Object> formMeta = new HashMap<String, Object>();
        formMeta.put(OPERATIONS, operationListMap);
        formMeta.put("PermissionItems", curPermList);
        formMeta.put("_Type_", "MainEntity");
        String modelType = "DynamicFormModel";
        MetadataSerializer template = new MetadataSerializer(modelType);
        MainEntity mainEntity = (MainEntity)template.deserializeFromMap(formMeta, null);
        queryEntity.getOperations().clear();
        queryEntity.getOperations().addAll(mainEntity.getOperations());
        queryEntity.getPermissionItems().addAll(mainEntity.getPermissionItems());
        String id = (String)plugIn.getView().getModel().getValue("id");
        QueryMetadataHelper.assembleOperationLang(id, mainEntityName, queryEntity);
    }

    public static void assembleOperationLang(String id, String mainEntityName, QueryEntity queryEntity) {
        if (queryEntity.getOperations().isEmpty()) {
            return;
        }
        HashMap<String, LocaleString> oldOperationNameMap = new HashMap<String, LocaleString>();
        if (StringUtils.isNotEmpty((String)id)) {
            try {
                EntityMetadata oldMeta = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
                QueryEntity oldQueryEntity = (QueryEntity)oldMeta.getRootEntity();
                for (Operation operation : oldQueryEntity.getOperations()) {
                    oldOperationNameMap.put(operation.getKey(), operation.getName());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        HashMap<String, LocaleString> queryFormOperationNameMap = new HashMap<String, LocaleString>();
        try {
            String queryFormId = MetadataDao.getIdByNumber((String)mainEntityName, (MetaCategory)MetaCategory.Form);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)queryFormId, (MetaCategory)MetaCategory.Entity);
            List entityOperationList = entityMetadata.getRootEntity().getOperations();
            if (null != entityOperationList) {
                Iterator iterator = entityOperationList.iterator();
                while (iterator.hasNext()) {
                    Operation operation = (Operation)iterator.next();
                    String key = operation.getKey();
                    LocaleString localeString = operation.getName();
                    if (localeString == null) continue;
                    queryFormOperationNameMap.put(key, localeString);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        OperationTypes types = OperationTypeCache.loadAll();
        HashMap<String, LocaleString> defaultNameMap = new HashMap<String, LocaleString>(16);
        for (OperationType type : types.getOpTypes()) {
            defaultNameMap.put(type.getId(), type.getName());
        }
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        List languages = service.getEnabledLang();
        for (Operation operation : queryEntity.getOperations()) {
            String key = operation.getKey();
            LocaleString name = operation.getName();
            name = null == name ? (LocaleString)oldOperationNameMap.get(key) : name;
            name = null == name ? (LocaleString)queryFormOperationNameMap.get(key) : name;
            LocaleString localeString = name = null == name ? (LocaleString)defaultNameMap.get(key) : name;
            if (null == name) continue;
            for (EnabledLang lang : languages) {
                String number = lang.getNumber();
                String tName = (String)name.get((Object)number);
                if (null == tName && oldOperationNameMap.containsKey(key)) {
                    tName = (String)((LocaleString)oldOperationNameMap.get(key)).get((Object)number);
                }
                if (null == tName && queryFormOperationNameMap.containsKey(key)) {
                    tName = (String)((LocaleString)queryFormOperationNameMap.get(key)).get((Object)number);
                }
                if (null == tName && defaultNameMap.containsKey(key)) {
                    tName = (String)((LocaleString)defaultNameMap.get(operation.getOperationType())).get((Object)number);
                }
                name.put(number, (Object)tName);
            }
        }
    }

    private void assemblePermissionSetting(QueryDynSourcePlugIn plugIn, QueryEntity queryEntity) {
        Map permissionDimensionMap;
        Map permissionDimensionValMap;
        Map permissionControlMap;
        Map permissionControlValMap;
        IPageCache pageCache = plugIn.getPageCache();
        if (pageCache.get("PermissionControl") != null && (permissionControlValMap = (Map)(permissionControlMap = (Map)SerializationUtils.fromJsonString((String)pageCache.get("PermissionControl"), Map.class)).get("value")) != null) {
            PermissionControl permissionControl = new PermissionControl();
            permissionControl.setForbidDataPerm(Boolean.parseBoolean(String.valueOf(permissionControlValMap.get(FORBID_DATA_PERM))));
            permissionControl.setAnonymousUserControl(Boolean.parseBoolean(String.valueOf(permissionControlValMap.get(ANONYMOUS_USER_CONTROL))));
            if (permissionControlValMap.get(CONTROL_FUNCTION) instanceof String) {
                permissionControl.setControlFunction("true".equals((String)permissionControlValMap.get(CONTROL_FUNCTION)));
            } else {
                permissionControl.setControlFunction((Boolean)permissionControlValMap.get(CONTROL_FUNCTION) == true);
            }
            if (permissionControlValMap.get("Id") != null) {
                permissionControl.setId(permissionControlValMap.get("Id").toString());
            }
            queryEntity.setPermissionControl(permissionControl);
        }
        if (pageCache.get("PermissionDimension") != null && (permissionDimensionValMap = (Map)(permissionDimensionMap = (Map)SerializationUtils.fromJsonString((String)pageCache.get("PermissionDimension"), Map.class)).get("value")) != null) {
            PermissionDimension permissionDimension = new PermissionDimension();
            permissionDimension.setDimension((String)permissionDimensionValMap.get("DimensionControl"));
            permissionDimension.setDataDimension((String)permissionDimensionValMap.get("DataDimension"));
            permissionDimension.setDataDimensionField((String)permissionDimensionValMap.get("DataDimensionField"));
            permissionDimension.setDataAssistDimension((String)permissionDimensionValMap.get("DataAssistDimension"));
            permissionDimension.setDataAssistDimensionField((String)permissionDimensionValMap.get("DataAssistDimensionField"));
            permissionDimension.setPublishApps((String)permissionDimensionValMap.get("PublishApps"));
            permissionDimension.setId((String)permissionDimensionValMap.get("Id"));
            queryEntity.setPermissionDimension(permissionDimension);
            if ("DIM_ORG".equals(permissionDimensionValMap.get("DimensionControl"))) {
                queryEntity.setMainOrg((String)permissionDimensionValMap.get("DataDimensionField"));
            }
        }
        List permissionItemList = queryEntity.getPermissionItems();
        if (plugIn.getPageCache().get("permission_control_val") != null) {
            List curPermList = (List)SerializationUtils.fromJsonString((String)plugIn.getPageCache().get("permission_control_val"), List.class);
            for (Map permMap : curPermList) {
                PermissionItem permissionItem = new PermissionItem();
                permissionItem.setId((String)permMap.get("Id"));
                permissionItem.setItemId((String)permMap.get("ItemId"));
                permissionItem.setIndex(String.valueOf(permMap.get("Index")));
                permissionItemList.add(permissionItem);
            }
        }
    }

    private void assembleQueryPlugInFields(IDataModel dataModel, QueryEntity queryEntity) {
        DynamicObjectCollection queryPlugInFieldColl = dataModel.getEntryEntity("querypluginentry");
        ArrayList<QueryPlugInField> queryPlugInFieldList = new ArrayList<QueryPlugInField>();
        for (DynamicObject dynObj : queryPlugInFieldColl) {
            if (StringUtils.isEmpty((String)dynObj.getString("pluginname"))) continue;
            QueryPlugInField queryPlugInField = new QueryPlugInField();
            queryPlugInField.setPluginName(dynObj.getString("pluginname"));
            queryPlugInField.setPluginStatus(dynObj.getString("pluginstatus"));
            queryPlugInFieldList.add(queryPlugInField);
        }
        queryEntity.setQueryPlugInFields(queryPlugInFieldList);
    }

    private void assembleSortFields(IDataModel dataModel, QueryEntity queryEntity) {
        DynamicObjectCollection sortFieldColl = dataModel.getEntryEntity("querysortfieldentry");
        ArrayList<QuerySortField> sortFieldList = new ArrayList<QuerySortField>();
        for (DynamicObject dynObj : sortFieldColl) {
            if (StringUtils.isEmpty((String)dynObj.getString("sortfieldalias"))) continue;
            QuerySortField querySortField = new QuerySortField();
            querySortField.setAlias(dynObj.getString("sortfieldalias"));
            querySortField.setDisplayName(dynObj.getString("sortfieldname"));
            querySortField.setSortType(dynObj.getString("sorttype") == null ? "asc" : dynObj.getString("sorttype"));
            sortFieldList.add(querySortField);
        }
        queryEntity.setQuerySortFields(sortFieldList);
    }

    private void assembleSelectFields(IDataModel dataModel, QueryEntity queryEntity) {
        DynamicObjectCollection selectFieldColl = dataModel.getEntryEntity("queryselectfieldsentry");
        ArrayList<QuerySelectField> selectFieldList = new ArrayList<QuerySelectField>();
        DynamicProperty displayNameProp = selectFieldColl.getDynamicObjectType().getProperty("selectfielddisplayname");
        boolean isLocaleDisplayName = displayNameProp instanceof MuliLangTextProp;
        for (DynamicObject dynObj : selectFieldColl) {
            if (StringUtils.isEmpty((String)dynObj.getString(SELECT_FIELD_ALIAS))) continue;
            QuerySelectField querySelectField = new QuerySelectField();
            querySelectField.setId(dynObj.getString("queryselectfieldsentryid"));
            querySelectField.setAlias(dynObj.getString(SELECT_FIELD_ALIAS));
            if (isLocaleDisplayName) {
                querySelectField.setLocaleDisplayName(LocaleString.fromMap((Map)dynObj.getLocaleString("selectfielddisplayname")));
            } else {
                querySelectField.setDisplayName(dynObj.getString("selectfielddisplayname"));
            }
            selectFieldList.add(querySelectField);
        }
        queryEntity.setSelectFields(selectFieldList);
    }

    private void assembleWhereCondition(IDataModel dataModel, QueryEntity queryEntity, String mainEntityName) {
        DynamicObjectCollection whereConditionColl = dataModel.getEntryEntity("queryconditionentry");
        for (DynamicObject dynObj : whereConditionColl) {
            if (StringUtils.isEmpty((String)dynObj.getString("conditionfield"))) continue;
            QSConditionRow conditionRow = new QSConditionRow();
            String conditionField = dynObj.getString("conditionfield");
            String[] entityProps = conditionField.split("\\.");
            if (entityProps.length == 2) {
                conditionRow.setLeftItem((QSExpr)new QSPropExpr(entityProps[0], entityProps[1]));
            } else {
                conditionRow.setLeftItem((QSExpr)new QSPropExpr(mainEntityName, entityProps[0]));
            }
            conditionRow.setCompareOp(dynObj.getString("conditiontype"));
            conditionRow.setRightItem((QSExpr)new QSIdentifierExpr(dynObj.getString("conditionvalue")));
            conditionRow.setRightParenthesis(dynObj.getString("conditionlogiccondition"));
            queryEntity.addWhereCondition(conditionRow);
        }
    }

    private String getSubEntityPropertyString(String childField) {
        return childField.substring(childField.indexOf(ENTITY_SPLIST_PLAG) + 1);
    }

    private JoinEntity assembleJoinEntity(DynamicObject dynObj, IDataModel dataModel) {
        String childEntityNumber = dynObj.getString("childentitynumber");
        String parentEntityAlias = dynObj.getString("parententityalias");
        String childEntityAlias = dynObj.getString("childentityalias");
        if (childEntityAlias == null) {
            return null;
        }
        String mainEntityAlias = (String)dataModel.getValue(MAIN_ENTITY_ALIAS);
        if (!mainEntityAlias.equals(parentEntityAlias)) {
            return null;
        }
        childEntityNumber = this.getEntityNumberByAlias(childEntityAlias, dataModel);
        LocaleString childEntityName = this.getEntityNameByAlias(childEntityAlias, dataModel);
        JoinEntity joinEntity = new JoinEntity();
        joinEntity.setAlias(childEntityAlias);
        joinEntity.setEntityName(childEntityNumber);
        joinEntity.setMultiRow(true);
        joinEntity.setLocaleDisplayName(childEntityName);
        joinEntity.setIncludeFieldNames(this.getQueryFields(dataModel, childEntityNumber));
        return joinEntity;
    }

    private String getCurrentAppId(IDataModel dataModel) {
        Object currentApp = dataModel.getValue("currentappid");
        String currentAppId = "";
        if (currentApp != null) {
            currentAppId = currentApp.toString();
        }
        return currentAppId;
    }

    private String getQueryFields(IDataModel dataModel, String queryEntityNumber) {
        String queryFields = "";
        DynamicObjectCollection entityDynColl = dataModel.getEntryEntity("queryselectfieldsentry");
        for (DynamicObject entityObj : entityDynColl) {
            String entityNumber = entityObj.getString("selectfieldentitynumber");
            if (queryEntityNumber == null || !queryEntityNumber.equals(entityNumber)) continue;
            String field = entityObj.getString(SELECT_FIELD_ALIAS);
            int len = queryFields.length();
            if (len > 0) {
                queryFields = queryFields + "," + field;
                continue;
            }
            queryFields = field;
        }
        return queryFields;
    }

    private String getEntityNumberByAlias(String entityAlias, IDataModel model) {
        String mainEntityAlias;
        String entityNumber = null;
        if (!StringUtils.isEmpty((String)entityAlias)) {
            DynamicObjectCollection dynColl = model.getEntryEntity("queryentityentry");
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString("entityalias");
                if (!entityAlias.equals(curEntityAlias)) continue;
                entityNumber = dynObj.getString("entitynumber");
                break;
            }
        }
        if (entityNumber == null && entityAlias.equals(mainEntityAlias = (String)model.getValue(MAIN_ENTITY_ALIAS))) {
            DynamicObject mainEntity = (DynamicObject)model.getValue(MAIN_ENTITY_NAME);
            entityNumber = mainEntity.getString(NUMBER);
        }
        return entityNumber;
    }

    private LocaleString getEntityNameByAlias(String entityAlias, IDataModel model) {
        String mainEntityAlias;
        LocaleString entityName = null;
        if (!StringUtils.isEmpty((String)entityAlias)) {
            DynamicObjectCollection dynColl = model.getEntryEntity("queryentityentry");
            DynamicProperty displayNameProp = dynColl.getDynamicObjectType().getProperty("entityname");
            boolean isLocaleDisplayName = displayNameProp instanceof MuliLangTextProp;
            for (DynamicObject dynObj : dynColl) {
                String curEntityAlias = dynObj.getString("entityalias");
                if (!entityAlias.equals(curEntityAlias)) continue;
                if (isLocaleDisplayName) {
                    entityName = LocaleString.fromMap((Map)dynObj.getLocaleString("entityname"));
                    break;
                }
                entityName = new LocaleString(dynObj.getString("entityname"));
                break;
            }
        }
        if (entityName == null && entityAlias.equals(mainEntityAlias = (String)model.getValue(MAIN_ENTITY_ALIAS))) {
            DynamicObject mainEntity = (DynamicObject)model.getValue(MAIN_ENTITY_NAME);
            entityName = LocaleString.fromMap((Map)mainEntity.getLocaleString("name"));
        }
        return entityName;
    }

    public static List<BarItemAp> createBarItems(String parentId) {
        ArrayList<BarItemAp> barItemAps = new ArrayList<BarItemAp>();
        BarItemAp barItemAp = new BarItemAp();
        barItemAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u65b0\u589e", (String)"QueryMetadataHelper_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        barItemAp.setId(DBServiceHelper.genStringId());
        barItemAp.setKey("new");
        barItemAp.setOperationKey("new");
        barItemAp.setParentId(parentId);
        barItemAp.setIndex(1);
        barItemAps.add(barItemAp);
        barItemAp.getDropdownItems().add(new DropdownItem("copy", ResManager.loadKDString((String)"\u590d\u5236", (String)"QueryMetadataHelper_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u590d\u5236", (String)"QueryMetadataHelper_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "copy", ""));
        barItemAp = new BarItemAp();
        barItemAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u4fee\u6539", (String)"QueryMetadataHelper_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        barItemAp.setId(DBServiceHelper.genStringId());
        barItemAp.setKey(MODIFY);
        barItemAp.setOperationKey(MODIFY);
        barItemAp.setParentId(parentId);
        barItemAp.setIndex(1);
        barItemAps.add(barItemAp);
        barItemAp = new BarItemAp();
        barItemAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5220\u9664", (String)"QueryMetadataHelper_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        barItemAp.setId(DBServiceHelper.genStringId());
        barItemAp.setKey(DELETE);
        barItemAp.setOperationKey(DELETE);
        barItemAp.setParentId(parentId);
        barItemAp.setIndex(1);
        barItemAps.add(barItemAp);
        barItemAp = new BarItemAp();
        barItemAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"QueryMetadataHelper_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        barItemAp.setId(DBServiceHelper.genStringId());
        barItemAp.setKey(SUBMIT);
        barItemAp.setOperationKey(SUBMIT);
        barItemAp.setParentId(parentId);
        barItemAp.setIndex(1);
        barItemAps.add(barItemAp);
        barItemAp.getDropdownItems().add(new DropdownItem(UN_SUBMIT, ResManager.loadKDString((String)"\u64a4\u9500", (String)"QueryMetadataHelper_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u64a4\u9500", (String)"QueryMetadataHelper_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), UN_SUBMIT, ""));
        barItemAp = new BarItemAp();
        barItemAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5ba1\u6838", (String)"QueryMetadataHelper_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        barItemAp.setId(DBServiceHelper.genStringId());
        barItemAp.setKey(AUDIT);
        barItemAp.setOperationKey(AUDIT);
        barItemAp.setParentId(parentId);
        barItemAp.setIndex(1);
        barItemAps.add(barItemAp);
        barItemAp.getDropdownItems().add(new DropdownItem(UN_AUDIT, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"QueryMetadataHelper_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"QueryMetadataHelper_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), UN_AUDIT, ""));
        barItemAp = new BarItemAp();
        barItemAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u7981\u7528", (String)"QueryMetadataHelper_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        barItemAp.setId(DBServiceHelper.genStringId());
        barItemAp.setKey(DISABLE);
        barItemAp.setOperationKey(DISABLE);
        barItemAp.setParentId(parentId);
        barItemAp.setIndex(1);
        barItemAps.add(barItemAp);
        barItemAp.getDropdownItems().add(new DropdownItem(ENABLE, ResManager.loadKDString((String)"\u542f\u7528", (String)"QueryMetadataHelper_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u542f\u7528", (String)"QueryMetadataHelper_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ENABLE, ""));
        barItemAp = new BarItemAp();
        barItemAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u6309\u5217\u8868\u5bfc\u51fa", (String)"QueryMetadataHelper_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        barItemAp.setId(DBServiceHelper.genStringId());
        barItemAp.setKey(EXPORTLISTBYSELECTFIELDS);
        barItemAp.setOperationKey(EXPORTLISTBYSELECTFIELDS);
        barItemAp.setParentId(parentId);
        barItemAp.setIndex(1);
        barItemAps.add(barItemAp);
        barItemAp.getDropdownItems().add(new DropdownItem(IMPORT_DATA, ResManager.loadKDString((String)"\u5bfc\u5165", (String)"QueryMetadataHelper_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bfc\u5165", (String)"QueryMetadataHelper_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), IMPORT_DATA, ""));
        barItemAp = new BarItemAp();
        barItemAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u6253\u5370\u9884\u89c8", (String)"QueryMetadataHelper_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        barItemAp.setId(DBServiceHelper.genStringId());
        barItemAp.setKey(PRINT_PREVIEW);
        barItemAp.setOperationKey(PRINT_PREVIEW);
        barItemAp.setParentId(parentId);
        barItemAp.setIndex(1);
        barItemAps.add(barItemAp);
        barItemAp.getDropdownItems().add(new DropdownItem(PRINT_SETTING, ResManager.loadKDString((String)"\u6253\u5370\u8bbe\u7f6e", (String)"QueryMetadataHelper_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6253\u5370\u8bbe\u7f6e", (String)"QueryMetadataHelper_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), PRINT_SETTING, ""));
        barItemAp = new BarItemAp();
        barItemAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5237\u65b0", (String)"QueryMetadataHelper_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        barItemAp.setId(DBServiceHelper.genStringId());
        barItemAp.setKey(REFRESH);
        barItemAp.setOperationKey(REFRESH);
        barItemAp.setParentId(parentId);
        barItemAp.setIndex(1);
        barItemAps.add(barItemAp);
        barItemAp = new BarItemAp();
        barItemAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u9000\u51fa", (String)"QueryMetadataHelper_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        barItemAp.setId(DBServiceHelper.genStringId());
        barItemAp.setKey(CLOSE);
        barItemAp.setOperationKey(CLOSE);
        barItemAp.setParentId(parentId);
        barItemAp.setIndex(1);
        barItemAps.add(barItemAp);
        return barItemAps;
    }
}

