/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.query;

import com.alibaba.fastjson.JSONArray;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.AdminAppResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class QueryTreeListPlugin
extends StandardTreeListPlugin
implements RowClickEventListener,
ClickListener {
    private static Log log = LogFactory.getLog(QueryTreeListPlugin.class);
    protected static final String BILLISTAP = "billlistap";
    protected static final String BTNOK = "btnok";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String NUMBER = "number";
    private static final String MODEL_TYPE = "modeltype";
    private static final String APP_ID = "bizappid";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void initialize() {
        super.initialize();
        ((ListView)this.getView()).setNeedRefreshTree(false);
    }

    public void initializeTree(EventObject e) {
        this.intiTree();
    }

    public void initTreeToolbar(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn = (Button)this.getControl(BTNOK);
        if (btn != null) {
            btn.addClickListener((ClickListener)this);
        }
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{BTN_EDIT, BTN_DEL});
        }
    }

    public Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ListSelectedRow lsr = ((ListView)this.getView()).getCurrentSelectedRowInfo();
        if (lsr == null) {
            return null;
        }
        QFilter filter = new QFilter("dentityid", "=", lsr.getPrimaryKeyValue());
        DynamicObject doj = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"id, dentityid, number, name", (QFilter[])new QFilter[]{filter});
        ret.put("id", doj.get("dentityid"));
        ret.put(NUMBER, doj.get(NUMBER));
        ret.put("name", doj.get("name"));
        return ret;
    }

    protected QFilter getModelFilter(String nodeId) {
        QFilter qFilter = null;
        ORM orm = ORM.create();
        boolean isCloud = orm.exists("bos_devportal_bizcloud", (Object)nodeId);
        if (nodeId.equals("-1")) {
            qFilter = null;
        } else if (isCloud) {
            JSONArray units = this.getUnitIdsByCloudId(nodeId);
            qFilter = new QFilter(APP_ID, "in", (Object)units);
        } else {
            HashSet<String> appIds = new HashSet<String>();
            appIds.add(nodeId);
            Set<String> extendAppIds = this.getExtendAppIds(appIds);
            appIds.addAll(extendAppIds);
            qFilter = new QFilter(APP_ID, "in", appIds);
        }
        return qFilter;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent nodeEvent) {
        super.buildTreeListFilter(nodeEvent);
        String nodeId = nodeEvent.getNodeId().toString();
        QFilter qFilter = this.getModelFilter(nodeId);
        QFilter modelFilter = new QFilter(MODEL_TYPE, "in", (Object)this.getModelFilterContent());
        if (qFilter != null) {
            nodeEvent.addQFilter(modelFilter.and(qFilter));
        } else {
            nodeEvent.addQFilter(modelFilter);
        }
        nodeEvent.setCancel(true);
    }

    public void beforeClick(BeforeClickEvent evt) {
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            String type = (String)this.getView().getFormShowParameter().getCustomParam("selectaction");
            if (type != null) {
                if (BTNOK.equalsIgnoreCase(btn.getKey()) && type.equals("FieldEdit")) {
                    this.returnData();
                } else if (BTNOK.equalsIgnoreCase(btn.getKey()) && type.equals("doOpenParent")) {
                    this.getView().returnDataToParent(this.getCurrentSelector());
                    this.getView().close();
                }
            } else {
                BillList billList = (BillList)this.getView().getControl(BILLISTAP);
                this.getView().returnDataToParent((Object)billList.getSelectedRows());
                this.getView().close();
            }
            evt.setCancel(true);
        } else {
            super.beforeClick(evt);
        }
    }

    protected void returnData() {
        Object oldId;
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null && !ObjectUtils.nullSafeEquals(oldId = this.getView().getFormShowParameter().getCustomParams().get("value"), (Object)row.get(NUMBER))) {
            ArrayList paras = new ArrayList();
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", row.get("id"));
            para.put("alias", row.get("name").toString());
            paras.add(para);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }

    private void intiTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"QueryTreeListPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        Map<String, ILocaleString> appNameMap = QueryTreeListPlugin.getAppNameMap();
        this.getPageCache().put("appNameMap", SerializationUtils.toJsonString(appNameMap));
        Iterator<TreeNode> cloudIterator = cloudNodes.iterator();
        Set<String> disabledAppIds = this.getDisabledAppIds();
        AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId(), (boolean)true);
        log.debug("Appid is diabled : {}, needAdminAppRange : {}, rangeApp size : {}", new Object[]{disabledAppIds, adminAppResult.needAdminAppRange(), adminAppResult.getAppIds() == null ? "null" : Integer.valueOf(adminAppResult.getAppIds().size())});
        ArrayList<String> cloudIds = new ArrayList<String>(cloudNodes.size());
        for (TreeNode cloudNode : cloudNodes) {
            cloudIds.add(cloudNode.getId());
        }
        Map<String, List<TreeNode>> appMapNodes = this.getAppNodes(cloudIds, disabledAppIds, adminAppResult, appNameMap);
        while (cloudIterator.hasNext()) {
            TreeNode cloudNode;
            cloudNode = cloudIterator.next();
            List<TreeNode> groupNodes = appMapNodes.get(cloudNode.getId());
            if (groupNodes == null || groupNodes.isEmpty()) {
                cloudIterator.remove();
                continue;
            }
            this.addChildNode(cloudNode, groupNodes);
        }
        root.addChildren(cloudNodes);
        this.getPageCache().put("treenodecache", SerializationUtils.toJsonString((Object)root));
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    private List<TreeNode> getCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            DynamicObject cloudObject = BizCloudServiceHelp.getBizCloudByAppID((String)refAppId);
            TreeNode node = new TreeNode("-1", cloudObject.getString("id"), cloudObject.getLocaleString("name").getLocaleValue());
            cloudNode.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
            Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
            log.debug("Cloud is diabled : {}", (Object)disabledCloudIds);
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (disabledCloudIds.contains(dynamicObject.getString("id"))) continue;
                TreeNode node = new TreeNode();
                node.setId(dynamicObject.getString("id"));
                node.setText(dynamicObject.getString("name"));
                node.setParentid("-1");
                cloudNode.add(node);
            }
        }
        return cloudNode;
    }

    private Map<String, List<TreeNode>> getAppNodes(List<String> cloudIds, Set<String> disabledAppIds, AdminAppResult adminAppResult, Map<String, ILocaleString> appNameMap) {
        HashMap<String, List<TreeNode>> appNodeMap = new HashMap<String, List<TreeNode>>(cloudIds.size());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            AppMetadata refAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)refAppId, (boolean)false);
            String refAppName = refAppMeta.getName().getLocaleValue();
            for (String cloudId : cloudIds) {
                QueryTreeListPlugin.putAppNode(appNodeMap, cloudId, new TreeNode(cloudId, refAppId, refAppName));
            }
        } else {
            DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID(cloudIds);
            dynamicObjects = this.getMergeAppCollection(dynamicObjects, appNameMap);
            for (DynamicObject dynamicObject : dynamicObjects) {
                boolean adminNotCharge;
                String appId = dynamicObject.getString("id");
                boolean bl = adminNotCharge = adminAppResult.needAdminAppRange() && (adminAppResult.getAppIds() == null || !adminAppResult.getAppIds().contains(appId));
                if (disabledAppIds.contains(appId) || adminNotCharge) continue;
                TreeNode node = new TreeNode();
                String masterId = dynamicObject.getString("masterid");
                node.setId(appId);
                node.setText(dynamicObject.getString("name"));
                node.setParentid(dynamicObject.getString("bizcloud"));
                node.setData((Object)masterId);
                QueryTreeListPlugin.putAppNode(appNodeMap, dynamicObject.getString("bizcloud"), node);
            }
        }
        return appNodeMap;
    }

    private static void putAppNode(Map<String, List<TreeNode>> appNodeMap, String cloudId, TreeNode node) {
        List<TreeNode> appNodes = appNodeMap.get(cloudId);
        if (appNodes == null) {
            appNodes = new ArrayList<TreeNode>();
        }
        appNodes.add(node);
        appNodeMap.put(cloudId, appNodes);
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    public void refreshNode(RefreshNodeEvent e) {
        List<TreeNode> childNodes = this.getChildNodes(e.getNodeId());
        e.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(Object parentId) {
        List<TreeNode> cloudNodes = null;
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            cloudNodes = this.getCloudNodes();
            Map<String, ILocaleString> appNameMap = QueryTreeListPlugin.getAppNameMap();
            Iterator<TreeNode> cloudIterator = cloudNodes.iterator();
            Set<String> disabledAppIds = this.getDisabledAppIds();
            AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId(), (boolean)true);
            log.debug("Appid is diabled : {}, needAdminAppRange : {}, rangeApp size : {}", new Object[]{disabledAppIds, adminAppResult.needAdminAppRange(), adminAppResult.getAppIds() == null ? "null" : Integer.valueOf(adminAppResult.getAppIds().size())});
            ArrayList<String> cloudIds = new ArrayList<String>(cloudNodes.size());
            for (TreeNode cloudNode : cloudNodes) {
                cloudIds.add(cloudNode.getId());
            }
            Map<String, List<TreeNode>> appMapNodes = this.getAppNodes(cloudIds, disabledAppIds, adminAppResult, appNameMap);
            while (cloudIterator.hasNext()) {
                TreeNode cloudNode;
                cloudNode = cloudIterator.next();
                List<TreeNode> groupNodes = appMapNodes.get(cloudNode.getId());
                if (groupNodes == null || groupNodes.isEmpty()) {
                    cloudIterator.remove();
                    continue;
                }
                this.addChildNode(cloudNode, groupNodes);
            }
        } else {
            TreeNode node = this.getTreeModel().getRoot().getTreeNode((String)parentId, 20);
            if (node != null) {
                return node.getChildren();
            }
        }
        return cloudNodes;
    }

    protected JSONArray getModelFilterContent() {
        JSONArray modelFilterContent = new JSONArray();
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(MODEL_TYPE);
        if (modelType != null && !"".equals(modelType)) {
            String[] modelTypes = modelType.split(",");
            for (int i = 0; i < modelTypes.length; ++i) {
                modelFilterContent.add((Object)modelTypes[i]);
            }
        } else {
            modelFilterContent.add((Object)"QueryListModel");
        }
        return modelFilterContent;
    }

    protected JSONArray getUnitIdsByCloudId(String bizCloudId) {
        JSONArray unitIds = new JSONArray();
        DynamicObjectCollection dynObjColl = this.getBizCloudDynamicObjectCollectionByCloudId(bizCloudId);
        for (int i = 0; i < dynObjColl.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynObjColl.get(i);
            String bizAppId = dynamicObject.getString("id");
            unitIds.add((Object)bizAppId);
        }
        return unitIds;
    }

    private DynamicObjectCollection getBizCloudDynamicObjectCollectionByCloudId(String id) {
        QFilter q = new QFilter("bizcloud", "=", (Object)id);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id";
        DynamicObjectCollection dynObjColl = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)selectFields, (QFilter[])filters);
        return dynObjColl;
    }

    private DynamicObjectCollection getBizCloudDynamicObjectCollectionByAPPId(String id) {
        QFilter q = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id";
        DynamicObjectCollection dynObjColl = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)selectFields, (QFilter[])filters);
        return dynObjColl;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        if (evt.getSource() instanceof Refresh && StringUtils.equals((CharSequence)"refresh", (CharSequence)((Refresh)evt.getSource()).getOperateKey())) {
            String focusId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
            this.getTreeModel().refreshNode((Object)"-1");
            TreeNode root = this.getTreeModel().getRoot();
            this.getTreeListView().getTreeView().deleteAllNodes();
            this.getTreeListView().getTreeView().addNode(root);
            TreeNode focusNode = root.getTreeNode(focusId, 20);
            if (focusNode == null) {
                focusNode = root;
            }
            focusNode.setExpend(true);
            this.getTreeListView().getTreeView().focusNode(focusNode);
            this.getTreeListView().refreshTreeNode(focusNode.getId(), true);
            evt.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter modelFilter = new QFilter(MODEL_TYPE, "in", (Object)this.getModelFilterContent());
        ArrayList<QFilter> customQFilters = new ArrayList<QFilter>();
        customQFilters.add(modelFilter);
        AdminAppResult adminAppResult = PermissionServiceHelper.getAdminApps((Long)RequestContext.get().getCurrUserId(), (boolean)true);
        if (adminAppResult.needAdminAppRange()) {
            List adminAppIds = adminAppResult.getAppIds();
            if (!CollectionUtils.isEmpty((Collection)adminAppIds)) {
                Set<String> extendAppIds = this.getExtendAppIds();
                if (!extendAppIds.isEmpty()) {
                    adminAppIds.removeAll(extendAppIds);
                }
                QFilter adminAppFilter = new QFilter(APP_ID, "in", (Object)adminAppIds);
                customQFilters.add(adminAppFilter);
            } else {
                QFilter adminFilter = new QFilter(APP_ID, "in", Collections.emptyList());
                customQFilters.add(adminFilter);
            }
        } else {
            Set<String> disableObjIds = this.getDisabledAppIds();
            QFilter filter = new QFilter(APP_ID, "not in", disableObjIds);
            customQFilters.add(filter);
        }
        e.setCustomQFilters(customQFilters);
    }

    private Set<String> getExtendAppIds() {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        return this.getExtendAppIds(disabledAppIds);
    }

    private Set<String> getDisabledAppIds() {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        Set<String> extendAppIds = this.getExtendAppIds(disabledAppIds);
        disabledAppIds.addAll(extendAppIds);
        return disabledAppIds;
    }

    private Set<String> getExtendAppIds(Set<String> bizAppId) {
        String selectFields = "id";
        QFilter[] filters = new QFilter[]{new QFilter("masterid", "in", bizAppId)};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)selectFields, (QFilter[])filters);
        HashSet<String> extendAppIds = new HashSet<String>();
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String id = dynamicObject.getString("id");
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                extendAppIds.add(id);
            }
        }
        return extendAppIds;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("tblnew".equals(evt.getItemKey())) {
            Object currentNodeObj = this.getTreeModel().getCurrentNodeId();
            if (currentNodeObj != null) {
                String nodeId = currentNodeObj.toString();
                DynamicObjectCollection dynColl = this.getBizCloudDynamicObjectCollectionByAPPId(nodeId);
                if (dynColl.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5de6\u6811\u4e1a\u52a1\u4e91\u4e0b\u7684\u5e94\u7528\u8282\u70b9\u3002", (String)"QueryTreeListPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u4e91\u4e0b\u7684\u5e94\u7528\u8282\u70b9\u3002", (String)"QueryTreeListPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if ("tbldel".equals(evt.getItemKey()) && ((IListView)this.getView()).getSelectedRows().size() > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deleteQueryConfig", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"QueryTreeListPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Object currentNodeObj;
        if ("new".equals(afterDoOperationEventArgs.getOperateKey()) && (currentNodeObj = this.getTreeModel().getCurrentNodeId()) != null) {
            String nodeId = currentNodeObj.toString();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cts_querydynsource");
            showParameter.getCustomParams().put("currentBizAppId", nodeId);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tblnew"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if (arg0.getCallBackId().equals("deleteQueryConfig") && MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
            IListView listView = (IListView)this.getView();
            String id = (String)listView.getFocusRowPkId();
            Map resultMap = MetadataDao.delFormMetadata((String)id);
            if (!((Boolean)resultMap.get("success")).booleanValue()) {
                this.getView().showErrorNotification(resultMap.get("message").toString());
            } else {
                IListView iListView = (IListView)this.getView();
                iListView.refresh();
                iListView.clearSelection();
            }
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        IListView listView = (IListView)this.getView();
        if (!listView.getRootControl().getKey().endsWith("f7")) {
            evt.setCancel(true);
            String queryEntityId = (String)listView.getFocusRowPkId();
            this.openPage(queryEntityId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent arg0) {
        super.closedCallBack(arg0);
        this.refreshBillList();
    }

    public void refreshBillList() {
        BillList billList = (BillList)this.getControl(BILLISTAP);
        billList.getEntryState().setCurrentPageIndex(Integer.valueOf(0));
        billList.refresh();
    }

    private void openPage(String queryEntityId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cts_querydynsource");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String queryEntityNumber = MetadataDao.getNumberById((String)queryEntityId);
        showParameter.setCustomParam("queryEntityNumber", (Object)queryEntityNumber);
        showParameter.setCustomParam("queryEntityId", (Object)queryEntityId);
        Map<String, String> appMap = this.getBizAppMap(queryEntityId);
        showParameter.setCustomParam("currentBizAppId", (Object)appMap.get("appId"));
        showParameter.setCustomParam("currentUnitId", (Object)appMap.get("unitId"));
        this.getView().showForm(showParameter);
    }

    private Map<String, String> getBizAppMap(String queryEntityId) {
        String sql = "select a.FBIZAPPID,b.FBIZUNITID from t_meta_formdesign a left join t_meta_bizunitrelform b on a.FBIZAPPID = b.FBIZAPPID and a.fid = b.fformid where a.FID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)queryEntityId)};
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, String> bizUnitMap = new HashMap<String, String>();
            try {
                if (rs.next()) {
                    bizUnitMap.put("appId", rs.getString(1));
                    bizUnitMap.put("unitId", rs.getString(2));
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return bizUnitMap;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
    }

    private DynamicObjectCollection getMergeAppCollection(DynamicObjectCollection dynamicObjects, Map<String, ILocaleString> appNameMap) {
        String masterId;
        DynamicObjectCollection appCollection = new DynamicObjectCollection();
        HashSet<String> appExtends = new HashSet<String>();
        for (DynamicObject dynObj : dynamicObjects) {
            masterId = dynObj.getString("masterid");
            if (kd.bos.util.StringUtils.isEmpty((String)masterId)) continue;
            appExtends.add(masterId);
        }
        for (DynamicObject dynObj : dynamicObjects) {
            ILocaleString name;
            masterId = dynObj.getString("masterid");
            if (!kd.bos.util.StringUtils.isEmpty((String)masterId)) continue;
            String appId = dynObj.getString("id");
            String number = dynObj.getString(NUMBER);
            if (appExtends.contains(appId) && appNameMap != null && !appNameMap.isEmpty() && (name = appNameMap.get(number)) != null) {
                dynObj.set("name", (Object)name);
            }
            appCollection.add((Object)dynObj);
        }
        return appCollection;
    }

    private static Map<String, ILocaleString> getAppNameMap() {
        StringBuilder sb = new StringBuilder("select a.fappid ,b.fname, b.flocaleid from t_meta_appruntime a join t_meta_appruntime_l b on a.fappid = b.fappid ");
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, ILocaleString>>(){

            public Map<String, ILocaleString> handle(ResultSet rs) throws SQLException {
                HashMap<String, ILocaleString> map = new HashMap<String, ILocaleString>(16);
                while (rs.next()) {
                    String appId = rs.getString("fappid");
                    String name = rs.getString("fname");
                    if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                    String localeid = rs.getString("flocaleid");
                    ILocaleString localeString = (ILocaleString)map.get(appId);
                    if (localeString == null) {
                        localeString = new LocaleString();
                        map.put(appId, localeString);
                    }
                    localeString.put((Object)localeid, (Object)name);
                }
                return map;
            }
        });
    }
}

