/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.query;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ReportComboItemPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeClickListener {
    private static final String F_TARGET_PROPS = "ftargetprops";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String COMBO_ITEMS = "comboItems";
    private static final String FTNAME = "ftname";
    private static final String FT_DISPLAY_NAME = "ftdisplayname";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btnremove", "btnadd"});
        EntryGrid grid = (EntryGrid)this.getControl(F_TARGET_PROPS);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView fieldtree = (TreeView)this.getView().getControl("fieldtree");
        fieldtree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnremove".equals(key)) {
            this.delete();
        } else if ("btnok".equals(key)) {
            this.returnData();
        } else if ("btnadd".equals(key)) {
            this.add();
        }
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode childNode;
        int i;
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ReportComboItemPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl("FieldTree");
        tree.addNode(root);
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if ("comparetypename".equals(type)) {
            List compareTypeList = (List)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam(COMBO_ITEMS)));
            for (i = 0; i < compareTypeList.size(); ++i) {
                CompareType compareType = (CompareType)compareTypeList.get(i);
                childNode = new TreeNode("root", compareType.getId(), compareType.getName().getLocaleValue());
                root.addChild(childNode);
            }
        } else if (("datasourcename".equals(type) || "filterfieldname".equals(type)) && this.getView().getFormShowParameter().getCustomParam(COMBO_ITEMS) != null) {
            List dataSourceList = (List)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam(COMBO_ITEMS)));
            for (i = 0; i < dataSourceList.size(); ++i) {
                ComboItem comboItem = (ComboItem)dataSourceList.get(i);
                childNode = new TreeNode("root", comboItem.getId(), comboItem.getCaption() == null ? comboItem.getId() : comboItem.getCaption().getLocaleValue());
                root.addChild(childNode);
            }
        }
        tree.expand("root");
        this.getPageCache().put("FieldTree", SerializationUtils.toJsonString((Object)root));
        String selectId = (String)this.getView().getFormShowParameter().getCustomParam("selectId");
        String selectValue = (String)this.getView().getFormShowParameter().getCustomParam("selectValue");
        IDataModel model = this.getModel();
        if (selectId != null && !"".equals(selectId.trim())) {
            int rowindex = model.createNewEntryRow(F_TARGET_PROPS);
            model.setValue(FTNAME, (Object)selectId, rowindex);
            model.setValue(FT_DISPLAY_NAME, (Object)selectValue, rowindex);
        }
    }

    private void returnData() {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("rowIndex", this.getView().getFormShowParameter().getCustomParams().get("rowIndex"));
        para.put("type", this.getView().getFormShowParameter().getCustomParams().get("type"));
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(F_TARGET_PROPS);
        if (rowCount == 1) {
            para.put("selectId", model.getValue(FTNAME, 0));
            para.put("selectValue", model.getValue(FT_DISPLAY_NAME, 0));
        }
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(F_TARGET_PROPS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u884c\u3002", (String)"ReportComboItemPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryRows(F_TARGET_PROPS, rows);
    }

    private void add() {
        TreeView fieldtree = (TreeView)this.getView().getControl("fieldtree");
        List rows = fieldtree.getTreeState().getSelectedNodes();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u8282\u70b9\u3002", (String)"ReportComboItemPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        for (Map map : rows) {
            Object isParent = map.get("isParent");
            if (((Boolean)isParent).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6dfb\u52a0\u7684\u5177\u4f53\u884c\u4e1a\u3002", (String)"ReportComboItemPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            Object value = map.get("text");
            String key = (String)map.get("id");
            model.deleteEntryData(F_TARGET_PROPS);
            int rowInd = model.createNewEntryRow(F_TARGET_PROPS);
            model.setValue(FTNAME, (Object)key, rowInd);
            model.setValue(FT_DISPLAY_NAME, value, rowInd);
        }
    }
}

