/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.tree;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.designer.tree.IRuleTreeProcessor;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.cardentry.CardEntryViewAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.list.CardRowPanelAp;
import kd.bos.metadata.list.ListCardViewAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListColumnGroupAp;
import kd.bos.metadata.list.ListGridViewAp;

public class BillListRuleTreeProcessor
implements IRuleTreeProcessor {
    @Override
    public TreeNode initTree(IFormView view) {
        PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
        String controlId = propertyEditHelper.getItemId(view);
        List<Map<String, Object>> formContext = propertyEditHelper.getFormMeta(view);
        if (formContext == null) {
            return null;
        }
        FormMetadata formMetadata = FormMetadataUtil.getFormMetadata(formContext);
        formMetadata.createIndex();
        String rootId = formMetadata.getRootAp().getKey();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(rootId);
        if (formMetadata.getRootAp().getName() == null) {
            root.setText(rootId);
        } else {
            root.setText(formMetadata.getRootAp().getName().toString());
        }
        for (ControlAp control : formMetadata.getItems()) {
            Optional<ControlAp> op;
            if (!(control instanceof EntryAp) && !(control instanceof ListGridViewAp) && !(control instanceof ListCardViewAp) && !(control instanceof CardEntryViewAp)) continue;
            if (control instanceof ListCardViewAp) {
                op = ((ContainerAp)control).getItems().stream().filter(item -> item instanceof CardRowPanelAp).findFirst();
                if (!op.isPresent()) continue;
                control = op.get();
                for (ControlAp controlAp : ((ContainerAp)control).getItems()) {
                    if (!control.getId().equals(controlId) || !(controlAp instanceof ContainerAp) && !(controlAp instanceof FieldAp) && !(controlAp instanceof ListColumnAp)) continue;
                    if (controlAp instanceof ContainerAp) {
                        BillListRuleTreeProcessor.getContainer(root, (ContainerAp)controlAp);
                        continue;
                    }
                    BillListRuleTreeProcessor.addNode(controlAp, root);
                }
                continue;
            }
            if (control instanceof CardEntryViewAp) {
                op = ((ContainerAp)control).getItems().stream().filter(item -> item instanceof CardEntryRowAp).findFirst();
                if (!op.isPresent()) continue;
                control = op.get();
                for (ControlAp controlAp : ((ContainerAp)control).getItems()) {
                    if (!control.getId().equals(controlId) || !(controlAp instanceof ContainerAp) && !(controlAp instanceof FieldAp)) continue;
                    if (controlAp instanceof ContainerAp) {
                        BillListRuleTreeProcessor.getContainer(root, (ContainerAp)controlAp);
                        continue;
                    }
                    BillListRuleTreeProcessor.addNode(controlAp, root);
                }
                continue;
            }
            for (ControlAp controlAp : ((ContainerAp)control).getItems()) {
                if (!control.getId().equals(controlId) || !(controlAp instanceof FieldAp) && !(controlAp instanceof ListColumnAp) && !(controlAp instanceof ListColumnGroupAp)) continue;
                if (controlAp instanceof ContainerAp) {
                    TreeNode treeNode = new TreeNode();
                    treeNode.setId(controlAp.getKey());
                    treeNode.setText(controlAp.getName().toString());
                    treeNode.setParentid(control.getKey());
                    BillListRuleTreeProcessor.getContainer(treeNode, (ContainerAp)controlAp);
                    root.addChild(treeNode);
                    continue;
                }
                BillListRuleTreeProcessor.addNode(controlAp, root);
            }
        }
        return root;
    }

    private static void getContainer(TreeNode entryNode, ContainerAp<?> control) {
        for (ControlAp controlAp : control.getItems()) {
            if (controlAp instanceof FieldAp || controlAp instanceof ListColumnAp) {
                BillListRuleTreeProcessor.addNode(controlAp, entryNode);
                continue;
            }
            if (!(controlAp instanceof ContainerAp) || ((ContainerAp)controlAp).getItems().isEmpty()) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(controlAp.getKey());
            treeNode.setText(controlAp.getName().toString());
            treeNode.setParentid(control.getKey());
            BillListRuleTreeProcessor.getContainer(treeNode, (ContainerAp)controlAp);
            entryNode.addChild(treeNode);
        }
    }

    private static void addNode(ControlAp<?> controlAp, TreeNode root) {
        TreeNode fieldNode = new TreeNode();
        fieldNode.setParentid(root.getId());
        if (controlAp instanceof ListColumnAp) {
            ListColumnAp listColumnAp = (ListColumnAp)controlAp;
            fieldNode.setId(listColumnAp.getListFieldId());
            fieldNode.setText(controlAp.getName() == null ? "" : controlAp.getName() + "(" + listColumnAp.getListFieldId() + ")");
        } else {
            fieldNode.setId(controlAp.getKey());
            fieldNode.setText(controlAp.getName() == null ? "" : controlAp.getName() + "(" + controlAp.getKey() + ")");
        }
        root.addChild(fieldNode);
    }
}

