/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class BizAppTreeBuilder {
    private TreeNode rootNode;
    private Map<String, String> appMasterIds = new HashMap<String, String>();
    private Map<String, List<String>> appExtIds = new HashMap<String, List<String>>();
    private boolean runtime = true;

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(TreeNode rootNode) {
        this.rootNode = rootNode;
    }

    public Map<String, String> getAppMasterIds() {
        return this.appMasterIds;
    }

    public Map<String, List<String>> getAppExtIds() {
        return this.appExtIds;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public void setRuntime(boolean runtime) {
        this.runtime = runtime;
    }

    public TreeNode buildTree() {
        if (this.appMasterIds.isEmpty()) {
            this.buildAppMasterIdMap();
        }
        if (this.isRuntime()) {
            this.rootNode = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
            return this.rootNode;
        }
        this.rootNode = this.buildDesignTreeNodes();
        this.rootNode = this.megerExtApp(this.rootNode);
        return this.rootNode;
    }

    private TreeNode megerExtApp(TreeNode root) {
        List clouds = root.getChildren();
        if (clouds == null) {
            return root;
        }
        if (root.getChildren() == null || root.getChildren().isEmpty()) {
            return root;
        }
        for (TreeNode cloudNode : root.getChildren()) {
            if (cloudNode.getChildren() == null || cloudNode.getChildren().isEmpty()) continue;
            Iterator appIterator = cloudNode.getChildren().iterator();
            while (appIterator.hasNext()) {
                TreeNode appNode = (TreeNode)appIterator.next();
                String masterId = this.getAppMasterIds().get(appNode.getId());
                if (StringUtils.isBlank((CharSequence)masterId)) {
                    appIterator.remove();
                    continue;
                }
                if (StringUtils.equals((CharSequence)appNode.getId(), (CharSequence)masterId) || cloudNode.getChildPath(masterId).isEmpty()) continue;
                appIterator.remove();
            }
        }
        return root;
    }

    private void buildAppMasterIdMap() {
        this.appMasterIds = new HashMap<String, String>();
        this.appExtIds = new HashMap<String, List<String>>();
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : allApps) {
            String id;
            String type = app.getString("type");
            String masterId = id = app.getString("id");
            if (StringUtils.equals((CharSequence)"2", (CharSequence)type)) {
                masterId = app.getString("masterid");
            }
            this.appMasterIds.put(id, masterId);
            if (!this.appExtIds.containsKey(masterId)) {
                this.appExtIds.put(masterId, new ArrayList());
            }
            this.appExtIds.get(masterId).add(id);
        }
    }

    private TreeNode buildDesignTreeNodes() {
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"BizAppTreeBuilder_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(16);
        List<TreeNode> cloudNode4 = this.getCloudData();
        for (TreeNode node : cloudNode4) {
            allNodes.put(node.getId(), node);
        }
        List<TreeNode> appNode4 = this.getAppData();
        for (TreeNode node : appNode4) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode != null) {
                parentNode.addChild(node);
                continue;
            }
            root.addChild(node);
        }
        return root;
    }

    private List<TreeNode> getCloudData() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        DynamicObjectCollection clouds = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject cloud : clouds) {
            TreeNode node = new TreeNode();
            String nodeID = cloud.getString("id");
            node.setText(cloud.getString("name"));
            node.setParentid("0");
            node.setId(nodeID);
            cloudNode.add(node);
        }
        return cloudNode;
    }

    private List<TreeNode> getAppData() {
        ArrayList<TreeNode> appNode = new ArrayList<TreeNode>();
        DynamicObjectCollection apps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : apps) {
            TreeNode node = new TreeNode();
            String parentId = app.getString("bizcloud");
            String nodeID = app.getString("id");
            node.setId(nodeID);
            node.setParentid(parentId);
            node.setText(app.getString("name"));
            appNode.add(node);
        }
        return appNode;
    }
}

